/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BronKerboschCliqueFinder<V, E> {
    private final Graph<V, E> graph;
    private Collection<Set<V>> cliques;

    public BronKerboschCliqueFinder(Graph<V, E> graph) {
        this.graph = graph;
    }

    public Collection<Set<V>> getAllMaximalCliques() {
        this.cliques = new ArrayList<Set<V>>();
        ArrayList arrayList = new ArrayList();
        ArrayList<V> arrayList2 = new ArrayList<V>();
        ArrayList arrayList3 = new ArrayList();
        arrayList2.addAll(this.graph.vertexSet());
        this.findCliques(arrayList, arrayList2, arrayList3);
        return this.cliques;
    }

    public Collection<Set<V>> getBiggestMaximalCliques() {
        this.getAllMaximalCliques();
        int n = 0;
        ArrayList<Set<V>> arrayList = new ArrayList<Set<V>>();
        for (Set<V> set2 : this.cliques) {
            if (n >= set2.size()) continue;
            n = set2.size();
        }
        for (Set<V> set2 : this.cliques) {
            if (n != set2.size()) continue;
            arrayList.add(set2);
        }
        return arrayList;
    }

    private void findCliques(List<V> list, List<V> list2, List<V> list3) {
        ArrayList<V> arrayList = new ArrayList<V>(list2);
        if (!this.end(list2, list3)) {
            for (Object e2 : arrayList) {
                ArrayList<V> arrayList2 = new ArrayList<V>();
                ArrayList<V> arrayList3 = new ArrayList<V>();
                list.add(e2);
                list2.remove(e2);
                for (V v : list2) {
                    if (!this.graph.containsEdge(e2, v)) continue;
                    arrayList2.add(v);
                }
                for (V v : list3) {
                    if (!this.graph.containsEdge(e2, v)) continue;
                    arrayList3.add(v);
                }
                if (arrayList2.isEmpty() && arrayList3.isEmpty()) {
                    this.cliques.add(new HashSet<V>(list));
                } else {
                    this.findCliques(list, arrayList2, arrayList3);
                }
                list3.add(e2);
                list.remove(e2);
            }
        }
    }

    private boolean end(List<V> list, List<V> list2) {
        boolean bl = false;
        for (V v : list2) {
            int n = 0;
            for (V v2 : list) {
                if (!this.graph.containsEdge(v, v2)) continue;
                ++n;
            }
            if (n != list.size()) continue;
            bl = true;
        }
        return bl;
    }
}

