/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.traverse.DepthFirstIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleDetector<V, E> {
    DirectedGraph<V, E> graph;

    public CycleDetector(DirectedGraph<V, E> directedGraph) {
        this.graph = directedGraph;
    }

    public boolean detectCycles() {
        try {
            this.execute(null, null);
        }
        catch (CycleDetectedException cycleDetectedException) {
            return true;
        }
        return false;
    }

    public boolean detectCyclesContainingVertex(V v) {
        try {
            this.execute(null, v);
        }
        catch (CycleDetectedException cycleDetectedException) {
            return true;
        }
        return false;
    }

    public Set<V> findCycles() {
        StrongConnectivityInspector<V, E> strongConnectivityInspector = new StrongConnectivityInspector<V, E>(this.graph);
        List<Set<V>> list = strongConnectivityInspector.stronglyConnectedSets();
        HashSet<V> hashSet = new HashSet<V>();
        for (Set<V> set2 : list) {
            if (set2.size() > 1) {
                hashSet.addAll(set2);
                continue;
            }
            V v = set2.iterator().next();
            if (!this.graph.containsEdge(v, v)) continue;
            hashSet.add(v);
        }
        return hashSet;
    }

    public Set<V> findCyclesContainingVertex(V v) {
        HashSet hashSet = new HashSet();
        this.execute(hashSet, v);
        return hashSet;
    }

    private void execute(Set<V> set2, V v) {
        ProbeIterator probeIterator = new ProbeIterator(set2, v);
        while (probeIterator.hasNext()) {
            probeIterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProbeIterator
    extends DepthFirstIterator<V, E> {
        private List<V> path;
        private Set<V> cycleSet;
        private V root;

        ProbeIterator(Set<V> set2, V v) {
            super(CycleDetector.this.graph, v);
            this.root = v;
            this.cycleSet = set2;
            this.path = new ArrayList();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void encounterVertexAgain(V v, E e2) {
            int n;
            super.encounterVertexAgain(v, e2);
            if (this.root != null) {
                if (v == this.root) {
                    n = 0;
                } else {
                    if (this.cycleSet == null || !this.cycleSet.contains(v)) return;
                    n = 0;
                }
            } else {
                n = this.path.indexOf(v);
            }
            if (n <= -1) return;
            if (this.cycleSet == null) {
                throw new CycleDetectedException();
            }
            while (n < this.path.size()) {
                this.cycleSet.add(this.path.get(n));
                ++n;
            }
        }

        @Override
        protected V provideNextVertex() {
            Object v = super.provideNextVertex();
            for (int i = this.path.size() - 1; i >= 0 && !CycleDetector.this.graph.containsEdge(this.path.get(i), v); --i) {
                this.path.remove(i);
            }
            this.path.add(v);
            return v;
        }
    }

    private static class CycleDetectedException
    extends RuntimeException {
        private static final long serialVersionUID = 3834305137802950712L;

        private CycleDetectedException() {
        }
    }
}

