/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.ClosestFirstIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DijkstraShortestPath<V, E> {
    private List<E> edgeList;
    private double pathLength;

    public DijkstraShortestPath(Graph<V, E> graph, V v, V v2) {
        this(graph, v, v2, Double.POSITIVE_INFINITY);
    }

    public DijkstraShortestPath(Graph<V, E> graph, V v, V v2, double d) {
        if (!graph.containsVertex(v2)) {
            throw new IllegalArgumentException("graph must contain the end vertex");
        }
        ClosestFirstIterator<V, E> closestFirstIterator = new ClosestFirstIterator<V, E>(graph, v, d);
        while (closestFirstIterator.hasNext()) {
            Object v3 = closestFirstIterator.next();
            if (!v3.equals(v2)) continue;
            this.createEdgeList(graph, closestFirstIterator, v2);
            this.pathLength = closestFirstIterator.getShortestPathLength(v2);
            return;
        }
        this.edgeList = null;
        this.pathLength = Double.POSITIVE_INFINITY;
    }

    public List<E> getPathEdgeList() {
        return this.edgeList;
    }

    public double getPathLength() {
        return this.pathLength;
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V v, V v2) {
        DijkstraShortestPath<V, E> dijkstraShortestPath = new DijkstraShortestPath<V, E>(graph, v, v2);
        return dijkstraShortestPath.getPathEdgeList();
    }

    private void createEdgeList(Graph<V, E> graph, ClosestFirstIterator<V, E> closestFirstIterator, V v) {
        E e2;
        this.edgeList = new ArrayList();
        while ((e2 = closestFirstIterator.getSpanningTreeEdge(v)) != null) {
            this.edgeList.add(e2);
            v = Graphs.getOppositeVertex(graph, e2, v);
        }
        Collections.reverse(this.edgeList);
    }
}

