/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg.color;

import java.util.BitSet;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.experimental.alg.ExactAlgorithm;
import org.jgrapht.experimental.alg.IntArrayGraphAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrownBacktrackColoring<V, E>
extends IntArrayGraphAlgorithm<V, E>
implements ExactAlgorithm<Integer, V> {
    private int[] _color;
    private int[] _colorCount;
    private BitSet[] _allowedColors;
    private int _chi;

    public BrownBacktrackColoring(Graph<V, E> graph) {
        super(graph);
    }

    void recursiveColor(int n) {
        int n2;
        this._colorCount[n] = this._colorCount[n - 1];
        this._allowedColors[n].set(0, this._colorCount[n] + 1);
        for (n2 = 0; n2 < this._neighbors[n].length; ++n2) {
            int n3 = this._neighbors[n][n2];
            if (this._color[n3] <= 0) continue;
            this._allowedColors[n].clear(this._color[n3]);
        }
        for (n2 = 1; n2 <= this._colorCount[n] && this._colorCount[n] < this._chi; ++n2) {
            if (!this._allowedColors[n].get(n2)) continue;
            this._color[n] = n2;
            if (n < this._neighbors.length - 1) {
                this.recursiveColor(n + 1);
                continue;
            }
            this._chi = this._colorCount[n];
        }
        if (this._colorCount[n] + 1 < this._chi) {
            int n4 = n;
            this._colorCount[n4] = this._colorCount[n4] + 1;
            this._color[n] = this._colorCount[n];
            if (n < this._neighbors.length - 1) {
                this.recursiveColor(n + 1);
            } else {
                this._chi = this._colorCount[n];
            }
        }
        this._color[n] = 0;
    }

    @Override
    public Integer getResult(Map<V, Object> map2) {
        int n;
        this._chi = this._neighbors.length;
        this._color = new int[this._neighbors.length];
        this._color[0] = 1;
        this._colorCount = new int[this._neighbors.length];
        this._colorCount[0] = 1;
        this._allowedColors = new BitSet[this._neighbors.length];
        for (n = 0; n < this._neighbors.length; ++n) {
            this._allowedColors[n] = new BitSet(1);
        }
        this.recursiveColor(1);
        for (n = 0; n < this._vertices.size(); ++n) {
            map2.put(this._vertices.get(n), this._color[n]);
        }
        return this._chi;
    }
}

