/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphOrdering<V, E> {
    private Map<V, Integer> mapVertexToOrder;
    private Set<LabelsEdge> labelsEdgesSet;

    public GraphOrdering(Graph<V, E> graph) {
        this(graph, graph.vertexSet(), graph.edgeSet());
    }

    public GraphOrdering(Graph<V, E> graph, Set<V> set2, Set<E> set3) {
        this.init(graph, set2, set3);
    }

    private void init(Graph<V, E> graph, Set<V> set2, Set<E> set3) {
        this.mapVertexToOrder = new HashMap<V, Integer>(set2.size());
        int n = 0;
        for (Object object : set2) {
            this.mapVertexToOrder.put((Integer)object, new Integer(n));
            ++n;
        }
        this.labelsEdgesSet = new HashSet<LabelsEdge>(set3.size());
        for (Object object : set3) {
            V v = graph.getEdgeSource(object);
            Integer n2 = this.mapVertexToOrder.get(v);
            int n3 = n2;
            int n4 = this.mapVertexToOrder.get(graph.getEdgeTarget(object));
            LabelsEdge labelsEdge = new LabelsEdge(n3, n4);
            this.labelsEdgesSet.add(labelsEdge);
            if (!(graph instanceof UndirectedGraph)) continue;
            LabelsEdge labelsEdge2 = new LabelsEdge(n4, n3);
            this.labelsEdgesSet.add(labelsEdge2);
        }
    }

    public boolean equalsByEdgeOrder(GraphOrdering graphOrdering) {
        boolean bl = ((Object)this.getLabelsEdgesSet()).equals(graphOrdering.getLabelsEdgesSet());
        return bl;
    }

    public Set<LabelsEdge> getLabelsEdgesSet() {
        return this.labelsEdgesSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mapVertexToOrder=");
        Object[] objectArray = new Object[this.mapVertexToOrder.size()];
        Set<V> set2 = this.mapVertexToOrder.keySet();
        for (V v : set2) {
            Integer n = this.mapVertexToOrder.get(v);
            objectArray[n.intValue()] = v;
        }
        stringBuffer.append(Arrays.toString(objectArray));
        stringBuffer.append("labelsOrder=").append(this.labelsEdgesSet.toString());
        return stringBuffer.toString();
    }

    private class LabelsEdge {
        private int source;
        private int target;
        private int hashCode;

        public LabelsEdge(int n, int n2) {
            this.source = n;
            this.target = n2;
            this.hashCode = new String(this.source + "" + this.target).hashCode();
        }

        public boolean equals(Object object) {
            LabelsEdge labelsEdge = (LabelsEdge)object;
            return this.source == labelsEdge.source && this.target == labelsEdge.target;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.source + "->" + this.target;
        }
    }
}

