/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.permutation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.experimental.permutation.ArrayPermutationsIter;
import org.jgrapht.experimental.permutation.IntegerPermutationIter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionPermutationIter<E> {
    private ArrayPermutationsIter permOrder;
    private List<E> sourceArray;
    private int[] currPermutationArray;

    public CollectionPermutationIter(Set<E> set2) {
        this(new ArrayList<E>(set2), new IntegerPermutationIter(set2.size()));
    }

    public CollectionPermutationIter(List<E> list) {
        this(list, new IntegerPermutationIter(list.size()));
    }

    public CollectionPermutationIter(List<E> list, ArrayPermutationsIter arrayPermutationsIter) {
        this.permOrder = arrayPermutationsIter;
        this.sourceArray = list;
    }

    public boolean hasNext() {
        return this.permOrder.hasNextPermutaions();
    }

    public List<E> getNextArray() {
        List<E> list;
        if (this.permOrder.hasNextPermutaions()) {
            this.currPermutationArray = this.permOrder.nextPermutation();
            list = this.applyPermutation();
        } else {
            list = null;
        }
        return list;
    }

    private List<E> applyPermutation() {
        ArrayList<E> arrayList = new ArrayList<E>(this.sourceArray);
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.set(i, this.sourceArray.get(this.currPermutationArray[i]));
        }
        return arrayList;
    }

    public Set<E> getNextSet() {
        List<E> list = this.getNextArray();
        if (list == null) {
            return null;
        }
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>(list);
        return linkedHashSet;
    }

    public int[] getCurrentPermutationArray() {
        return this.currPermutationArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Permutation int[]=");
        stringBuffer.append(Arrays.toString(this.getCurrentPermutationArray()));
        List<E> list = this.applyPermutation();
        stringBuffer.append("\nPermutationSet Source Object[]=");
        stringBuffer.append(this.sourceArray.toString());
        stringBuffer.append("\nPermutationSet Result Object[]=");
        stringBuffer.append(list.toString());
        return stringBuffer.toString();
    }
}

