/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOTExporter<V, E> {
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeLabelProvider;

    public DOTExporter() {
        this(new IntegerNameProvider(), null, null);
    }

    public DOTExporter(VertexNameProvider<V> vertexNameProvider, VertexNameProvider<V> vertexNameProvider2, EdgeNameProvider<E> edgeNameProvider) {
        this.vertexIDProvider = vertexNameProvider;
        this.vertexLabelProvider = vertexNameProvider2;
        this.edgeLabelProvider = edgeNameProvider;
    }

    public void export(Writer writer2, Graph<V, E> graph) {
        String string2;
        PrintWriter printWriter = new PrintWriter(writer2);
        String string3 = "  ";
        if (graph instanceof DirectedGraph) {
            printWriter.println("digraph G {");
            string2 = " -> ";
        } else {
            printWriter.println("graph G {");
            string2 = " -- ";
        }
        for (Object object : graph.vertexSet()) {
            printWriter.print(string3 + this.vertexIDProvider.getVertexName(object));
            if (this.vertexLabelProvider != null) {
                printWriter.print(" [label = \"" + this.vertexLabelProvider.getVertexName(object) + "\"]");
            }
            printWriter.println(";");
        }
        for (Object object : graph.edgeSet()) {
            String string4 = this.vertexIDProvider.getVertexName(graph.getEdgeSource(object));
            String string5 = this.vertexIDProvider.getVertexName(graph.getEdgeTarget(object));
            printWriter.print(string3 + string4 + string2 + string5);
            if (this.edgeLabelProvider != null) {
                printWriter.print(" [label = \"" + this.edgeLabelProvider.getEdgeName(object) + "\"]");
            }
            printWriter.println(";");
        }
        printWriter.println("}");
        printWriter.flush();
    }
}

