/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmlExporter<V, E> {
    private static final String creator = "JGraphT GML Exporter";
    private static final String version = "1";
    private static final String delim = " ";
    private static final String tab1 = "\t";
    private static final String tab2 = "\t\t";
    public static final Integer PRINT_NO_LABELS = 1;
    public static final Integer PRINT_EDGE_LABELS = 2;
    public static final Integer PRINT_EDGE_VERTEX_LABELS = 3;
    public static final Integer PRINT_VERTEX_LABELS = 4;
    private Integer printLabels = PRINT_NO_LABELS;

    private String quoted(String string2) {
        return "\"" + string2 + "\"";
    }

    private void exportHeader(PrintWriter printWriter) {
        printWriter.println("Creator " + this.quoted(creator));
        printWriter.println("Version 1");
    }

    private void exportVertices(PrintWriter printWriter, VertexNameProvider<V> vertexNameProvider, Graph<V, E> graph) {
        for (V v : graph.vertexSet()) {
            printWriter.println("\tnode");
            printWriter.println("\t[");
            printWriter.println("\t\tid " + vertexNameProvider.getVertexName(v));
            if (this.printLabels == PRINT_VERTEX_LABELS || this.printLabels == PRINT_EDGE_VERTEX_LABELS) {
                printWriter.println("\t\tlabel " + this.quoted(v.toString()));
            }
            printWriter.println("\t]");
        }
    }

    private void exportEdges(PrintWriter printWriter, VertexNameProvider<V> vertexNameProvider, Graph<V, E> graph) {
        for (E e2 : graph.edgeSet()) {
            printWriter.println("\tedge");
            printWriter.println("\t[");
            String string2 = vertexNameProvider.getVertexName(graph.getEdgeSource(e2));
            printWriter.println("\t\tsource " + string2);
            String string3 = vertexNameProvider.getVertexName(graph.getEdgeTarget(e2));
            printWriter.println("\t\ttarget " + string3);
            if (this.printLabels == PRINT_EDGE_LABELS || this.printLabels == PRINT_EDGE_VERTEX_LABELS) {
                printWriter.println("\t\tlabel " + this.quoted(e2.toString()));
            }
            printWriter.println("\t]");
        }
    }

    private void export(Writer writer2, Graph<V, E> graph, boolean bl) {
        PrintWriter printWriter = new PrintWriter(writer2);
        IntegerNameProvider<V> integerNameProvider = new IntegerNameProvider<V>();
        for (V v : graph.vertexSet()) {
            integerNameProvider.getVertexName(v);
        }
        this.exportHeader(printWriter);
        printWriter.println("graph");
        printWriter.println("[");
        printWriter.println("\tlabel " + this.quoted(""));
        if (bl) {
            printWriter.println("\tdirected 1");
        } else {
            printWriter.println("\tdirected 0");
        }
        this.exportVertices(printWriter, integerNameProvider, graph);
        this.exportEdges(printWriter, integerNameProvider, graph);
        printWriter.println("]");
        printWriter.flush();
    }

    public void export(Writer writer2, UndirectedGraph<V, E> undirectedGraph) {
        this.export(writer2, undirectedGraph, false);
    }

    public void export(Writer writer2, DirectedGraph<V, E> directedGraph) {
        this.export(writer2, directedGraph, true);
    }

    public void setPrintLabels(Integer n) {
        if (n != PRINT_NO_LABELS && n != PRINT_EDGE_LABELS && n != PRINT_EDGE_VERTEX_LABELS && n != PRINT_VERTEX_LABELS) {
            throw new IllegalArgumentException("Non-supported parameter value: " + Integer.toString(n));
        }
        this.printLabels = n;
    }

    public Integer getPrintLabels() {
        return this.printLabels;
    }
}

