/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.IntrusiveEdge;
import org.jgrapht.util.ArrayUnenforcedSet;
import org.jgrapht.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseGraph<V, E>
extends AbstractGraph<V, E>
implements Graph<V, E>,
Cloneable,
Serializable {
    private static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    boolean allowingLoops;
    private EdgeFactory<V, E> edgeFactory;
    private EdgeSetFactory<V, E> edgeSetFactory;
    private Map<E, IntrusiveEdge> edgeMap;
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;
    private Specifics specifics;
    private boolean allowingMultipleEdges;
    private transient TypeUtil<V> vertexTypeDecl = null;

    public AbstractBaseGraph(EdgeFactory<V, E> edgeFactory, boolean bl, boolean bl2) {
        if (edgeFactory == null) {
            throw new NullPointerException();
        }
        this.edgeMap = new LinkedHashMap<E, IntrusiveEdge>();
        this.edgeFactory = edgeFactory;
        this.allowingLoops = bl2;
        this.allowingMultipleEdges = bl;
        this.specifics = this.createSpecifics();
        this.edgeSetFactory = new ArrayListFactory<V, E>();
    }

    @Override
    public Set<E> getAllEdges(V v, V v2) {
        return this.specifics.getAllEdges(v, v2);
    }

    public boolean isAllowingLoops() {
        return this.allowingLoops;
    }

    public boolean isAllowingMultipleEdges() {
        return this.allowingMultipleEdges;
    }

    @Override
    public E getEdge(V v, V v2) {
        return this.specifics.getEdge(v, v2);
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.edgeFactory;
    }

    public void setEdgeSetFactory(EdgeSetFactory<V, E> edgeSetFactory) {
        this.edgeSetFactory = edgeSetFactory;
    }

    @Override
    public E addEdge(V v, V v2) {
        this.assertVertexExist(v);
        this.assertVertexExist(v2);
        if (!this.allowingMultipleEdges && this.containsEdge(v, v2)) {
            return null;
        }
        if (!this.allowingLoops && v.equals(v2)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        E e2 = this.edgeFactory.createEdge(v, v2);
        if (this.containsEdge(e2)) {
            return null;
        }
        IntrusiveEdge intrusiveEdge = this.createIntrusiveEdge(e2, v, v2);
        this.edgeMap.put(e2, intrusiveEdge);
        this.specifics.addEdgeToTouchingVertices(e2);
        return e2;
    }

    @Override
    public boolean addEdge(V v, V v2, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(e2)) {
            return false;
        }
        this.assertVertexExist(v);
        this.assertVertexExist(v2);
        if (!this.allowingMultipleEdges && this.containsEdge(v, v2)) {
            return false;
        }
        if (!this.allowingLoops && v.equals(v2)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        IntrusiveEdge intrusiveEdge = this.createIntrusiveEdge(e2, v, v2);
        this.edgeMap.put(e2, intrusiveEdge);
        this.specifics.addEdgeToTouchingVertices(e2);
        return true;
    }

    private IntrusiveEdge createIntrusiveEdge(E e2, V v, V v2) {
        IntrusiveEdge intrusiveEdge = e2 instanceof IntrusiveEdge ? (IntrusiveEdge)e2 : new IntrusiveEdge();
        intrusiveEdge.source = v;
        intrusiveEdge.target = v2;
        return intrusiveEdge;
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (this.containsVertex(v)) {
            return false;
        }
        this.specifics.addVertex(v);
        return true;
    }

    @Override
    public V getEdgeSource(E e2) {
        return TypeUtil.uncheckedCast(this.getIntrusiveEdge(e2).source, this.vertexTypeDecl);
    }

    @Override
    public V getEdgeTarget(E e2) {
        return TypeUtil.uncheckedCast(this.getIntrusiveEdge(e2).target, this.vertexTypeDecl);
    }

    private IntrusiveEdge getIntrusiveEdge(E e2) {
        if (e2 instanceof IntrusiveEdge) {
            return (IntrusiveEdge)e2;
        }
        return this.edgeMap.get(e2);
    }

    public Object clone() {
        try {
            TypeUtil typeUtil = null;
            AbstractBaseGraph abstractBaseGraph = (AbstractBaseGraph)TypeUtil.uncheckedCast(super.clone(), typeUtil);
            abstractBaseGraph.edgeMap = new LinkedHashMap<E, IntrusiveEdge>();
            abstractBaseGraph.edgeFactory = this.edgeFactory;
            abstractBaseGraph.unmodifiableEdgeSet = null;
            abstractBaseGraph.unmodifiableVertexSet = null;
            abstractBaseGraph.specifics = abstractBaseGraph.createSpecifics();
            Graphs.addGraph(abstractBaseGraph, this);
            return abstractBaseGraph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.edgeMap.containsKey(e2);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.specifics.getVertexSet().contains(v);
    }

    public int degreeOf(V v) {
        return this.specifics.degreeOf(v);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeMap.keySet());
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V v) {
        return this.specifics.edgesOf(v);
    }

    public int inDegreeOf(V v) {
        return this.specifics.inDegreeOf(v);
    }

    public Set<E> incomingEdgesOf(V v) {
        return this.specifics.incomingEdgesOf(v);
    }

    public int outDegreeOf(V v) {
        return this.specifics.outDegreeOf(v);
    }

    public Set<E> outgoingEdgesOf(V v) {
        return this.specifics.outgoingEdgesOf(v);
    }

    @Override
    public E removeEdge(V v, V v2) {
        E e2 = this.getEdge(v, v2);
        if (e2 != null) {
            this.specifics.removeEdgeFromTouchingVertices(e2);
            this.edgeMap.remove(e2);
        }
        return e2;
    }

    @Override
    public boolean removeEdge(E e2) {
        if (this.containsEdge(e2)) {
            this.specifics.removeEdgeFromTouchingVertices(e2);
            this.edgeMap.remove(e2);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v)) {
            Set<E> set2 = this.edgesOf(v);
            this.removeAllEdges(new ArrayList<E>(set2));
            this.specifics.getVertexSet().remove(v);
            return true;
        }
        return false;
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.specifics.getVertexSet());
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public double getEdgeWeight(E e2) {
        if (e2 instanceof DefaultWeightedEdge) {
            return ((DefaultWeightedEdge)e2).weight;
        }
        return 1.0;
    }

    public void setEdgeWeight(E e2, double d) {
        assert (e2 instanceof DefaultWeightedEdge) : e2.getClass();
        ((DefaultWeightedEdge)e2).weight = d;
    }

    private Specifics createSpecifics() {
        if (this instanceof DirectedGraph) {
            return new DirectedSpecifics();
        }
        if (this instanceof UndirectedGraph) {
            return new UndirectedSpecifics();
        }
        throw new IllegalArgumentException("must be instance of either DirectedGraph or UndirectedGraph");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UndirectedSpecifics
    extends Specifics
    implements Serializable {
        private static final long serialVersionUID = 6494588405178655873L;
        private static final String NOT_IN_UNDIRECTED_GRAPH = "no such operation in an undirected graph";
        private Map<V, UndirectedEdgeContainer<V, E>> vertexMapUndirected;

        private UndirectedSpecifics() {
            this.vertexMapUndirected = new LinkedHashMap();
        }

        @Override
        public void addVertex(V v) {
            this.vertexMapUndirected.put(v, null);
        }

        @Override
        public Set<V> getVertexSet() {
            return this.vertexMapUndirected.keySet();
        }

        @Override
        public Set<E> getAllEdges(V v, V v2) {
            ArrayUnenforcedSet arrayUnenforcedSet = null;
            if (AbstractBaseGraph.this.containsVertex(v) && AbstractBaseGraph.this.containsVertex(v2)) {
                arrayUnenforcedSet = new ArrayUnenforcedSet();
                for (Object EE : this.getEdgeContainer(v).vertexEdges) {
                    boolean bl;
                    boolean bl2 = v.equals(AbstractBaseGraph.this.getEdgeSource(EE)) && v2.equals(AbstractBaseGraph.this.getEdgeTarget(EE));
                    boolean bl3 = bl = v.equals(AbstractBaseGraph.this.getEdgeTarget(EE)) && v2.equals(AbstractBaseGraph.this.getEdgeSource(EE));
                    if (!bl2 && !bl) continue;
                    arrayUnenforcedSet.add(EE);
                }
            }
            return arrayUnenforcedSet;
        }

        @Override
        public E getEdge(V v, V v2) {
            if (AbstractBaseGraph.this.containsVertex(v) && AbstractBaseGraph.this.containsVertex(v2)) {
                for (Object EE : this.getEdgeContainer(v).vertexEdges) {
                    boolean bl;
                    boolean bl2 = v.equals(AbstractBaseGraph.this.getEdgeSource(EE)) && v2.equals(AbstractBaseGraph.this.getEdgeTarget(EE));
                    boolean bl3 = bl = v.equals(AbstractBaseGraph.this.getEdgeTarget(EE)) && v2.equals(AbstractBaseGraph.this.getEdgeSource(EE));
                    if (!bl2 && !bl) continue;
                    return EE;
                }
            }
            return null;
        }

        @Override
        public void addEdgeToTouchingVertices(E e2) {
            Object v = AbstractBaseGraph.this.getEdgeSource(e2);
            Object v2 = AbstractBaseGraph.this.getEdgeTarget(e2);
            this.getEdgeContainer(v).addEdge(e2);
            if (v != v2) {
                this.getEdgeContainer(v2).addEdge(e2);
            }
        }

        @Override
        public int degreeOf(V v) {
            if (AbstractBaseGraph.this.allowingLoops) {
                int n = 0;
                Set set2 = this.getEdgeContainer(v).vertexEdges;
                for (Object EE : set2) {
                    if (AbstractBaseGraph.this.getEdgeSource(EE).equals(AbstractBaseGraph.this.getEdgeTarget(EE))) {
                        n += 2;
                        continue;
                    }
                    ++n;
                }
                return n;
            }
            return this.getEdgeContainer(v).edgeCount();
        }

        @Override
        public Set<E> edgesOf(V v) {
            return this.getEdgeContainer(v).getUnmodifiableVertexEdges();
        }

        @Override
        public int inDegreeOf(V v) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        @Override
        public Set<E> incomingEdgesOf(V v) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        @Override
        public int outDegreeOf(V v) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        @Override
        public Set<E> outgoingEdgesOf(V v) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        @Override
        public void removeEdgeFromTouchingVertices(E e2) {
            Object v = AbstractBaseGraph.this.getEdgeSource(e2);
            Object v2 = AbstractBaseGraph.this.getEdgeTarget(e2);
            this.getEdgeContainer(v).removeEdge(e2);
            if (v != v2) {
                this.getEdgeContainer(v2).removeEdge(e2);
            }
        }

        private UndirectedEdgeContainer<V, E> getEdgeContainer(V v) {
            AbstractBaseGraph.this.assertVertexExist(v);
            UndirectedEdgeContainer undirectedEdgeContainer = this.vertexMapUndirected.get(v);
            if (undirectedEdgeContainer == null) {
                undirectedEdgeContainer = new UndirectedEdgeContainer(AbstractBaseGraph.this.edgeSetFactory, v);
                this.vertexMapUndirected.put((UndirectedEdgeContainer)v, (UndirectedEdgeContainer)undirectedEdgeContainer);
            }
            return undirectedEdgeContainer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UndirectedEdgeContainer<VV, EE>
    implements Serializable {
        private static final long serialVersionUID = -6623207588411170010L;
        Set<EE> vertexEdges;
        private transient Set<EE> unmodifiableVertexEdges = null;

        UndirectedEdgeContainer(EdgeSetFactory<VV, EE> edgeSetFactory, VV VV) {
            this.vertexEdges = edgeSetFactory.createEdgeSet(VV);
        }

        public Set<EE> getUnmodifiableVertexEdges() {
            if (this.unmodifiableVertexEdges == null) {
                this.unmodifiableVertexEdges = Collections.unmodifiableSet(this.vertexEdges);
            }
            return this.unmodifiableVertexEdges;
        }

        public void addEdge(EE EE) {
            this.vertexEdges.add(EE);
        }

        public int edgeCount() {
            return this.vertexEdges.size();
        }

        public void removeEdge(EE EE) {
            this.vertexEdges.remove(EE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectedSpecifics
    extends Specifics
    implements Serializable {
        private static final long serialVersionUID = 8971725103718958232L;
        private static final String NOT_IN_DIRECTED_GRAPH = "no such operation in a directed graph";
        private Map<V, DirectedEdgeContainer<V, E>> vertexMapDirected;

        private DirectedSpecifics() {
            this.vertexMapDirected = new LinkedHashMap();
        }

        @Override
        public void addVertex(V v) {
            this.vertexMapDirected.put(v, null);
        }

        @Override
        public Set<V> getVertexSet() {
            return this.vertexMapDirected.keySet();
        }

        @Override
        public Set<E> getAllEdges(V v, V v2) {
            ArrayUnenforcedSet arrayUnenforcedSet = null;
            if (AbstractBaseGraph.this.containsVertex(v) && AbstractBaseGraph.this.containsVertex(v2)) {
                arrayUnenforcedSet = new ArrayUnenforcedSet();
                DirectedEdgeContainer directedEdgeContainer = this.getEdgeContainer(v);
                for (Object EE : directedEdgeContainer.outgoing) {
                    if (!AbstractBaseGraph.this.getEdgeTarget(EE).equals(v2)) continue;
                    arrayUnenforcedSet.add(EE);
                }
            }
            return arrayUnenforcedSet;
        }

        @Override
        public E getEdge(V v, V v2) {
            if (AbstractBaseGraph.this.containsVertex(v) && AbstractBaseGraph.this.containsVertex(v2)) {
                DirectedEdgeContainer directedEdgeContainer = this.getEdgeContainer(v);
                for (Object EE : directedEdgeContainer.outgoing) {
                    if (!AbstractBaseGraph.this.getEdgeTarget(EE).equals(v2)) continue;
                    return EE;
                }
            }
            return null;
        }

        @Override
        public void addEdgeToTouchingVertices(E e2) {
            Object v = AbstractBaseGraph.this.getEdgeSource(e2);
            Object v2 = AbstractBaseGraph.this.getEdgeTarget(e2);
            this.getEdgeContainer(v).addOutgoingEdge(e2);
            this.getEdgeContainer(v2).addIncomingEdge(e2);
        }

        @Override
        public int degreeOf(V v) {
            throw new UnsupportedOperationException(NOT_IN_DIRECTED_GRAPH);
        }

        @Override
        public Set<E> edgesOf(V v) {
            ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet(this.getEdgeContainer(v).incoming);
            arrayUnenforcedSet.addAll(this.getEdgeContainer(v).outgoing);
            if (AbstractBaseGraph.this.allowingLoops) {
                Set set2 = this.getAllEdges(v, v);
                int n = 0;
                while (n < arrayUnenforcedSet.size()) {
                    Object e2 = arrayUnenforcedSet.get(n);
                    if (set2.contains(e2)) {
                        arrayUnenforcedSet.remove(n);
                        set2.remove(e2);
                        continue;
                    }
                    ++n;
                }
            }
            return Collections.unmodifiableSet(arrayUnenforcedSet);
        }

        @Override
        public int inDegreeOf(V v) {
            return this.getEdgeContainer(v).incoming.size();
        }

        @Override
        public Set<E> incomingEdgesOf(V v) {
            return this.getEdgeContainer(v).getUnmodifiableIncomingEdges();
        }

        @Override
        public int outDegreeOf(V v) {
            return this.getEdgeContainer(v).outgoing.size();
        }

        @Override
        public Set<E> outgoingEdgesOf(V v) {
            return this.getEdgeContainer(v).getUnmodifiableOutgoingEdges();
        }

        @Override
        public void removeEdgeFromTouchingVertices(E e2) {
            Object v = AbstractBaseGraph.this.getEdgeSource(e2);
            Object v2 = AbstractBaseGraph.this.getEdgeTarget(e2);
            this.getEdgeContainer(v).removeOutgoingEdge(e2);
            this.getEdgeContainer(v2).removeIncomingEdge(e2);
        }

        private DirectedEdgeContainer<V, E> getEdgeContainer(V v) {
            AbstractBaseGraph.this.assertVertexExist(v);
            DirectedEdgeContainer directedEdgeContainer = this.vertexMapDirected.get(v);
            if (directedEdgeContainer == null) {
                directedEdgeContainer = new DirectedEdgeContainer(AbstractBaseGraph.this.edgeSetFactory, v);
                this.vertexMapDirected.put((DirectedEdgeContainer)v, (DirectedEdgeContainer)directedEdgeContainer);
            }
            return directedEdgeContainer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirectedEdgeContainer<VV, EE>
    implements Serializable {
        private static final long serialVersionUID = 7494242245729767106L;
        Set<EE> incoming;
        Set<EE> outgoing;
        private transient Set<EE> unmodifiableIncoming = null;
        private transient Set<EE> unmodifiableOutgoing = null;

        DirectedEdgeContainer(EdgeSetFactory<VV, EE> edgeSetFactory, VV VV) {
            this.incoming = edgeSetFactory.createEdgeSet(VV);
            this.outgoing = edgeSetFactory.createEdgeSet(VV);
        }

        public Set<EE> getUnmodifiableIncomingEdges() {
            if (this.unmodifiableIncoming == null) {
                this.unmodifiableIncoming = Collections.unmodifiableSet(this.incoming);
            }
            return this.unmodifiableIncoming;
        }

        public Set<EE> getUnmodifiableOutgoingEdges() {
            if (this.unmodifiableOutgoing == null) {
                this.unmodifiableOutgoing = Collections.unmodifiableSet(this.outgoing);
            }
            return this.unmodifiableOutgoing;
        }

        public void addIncomingEdge(EE EE) {
            this.incoming.add(EE);
        }

        public void addOutgoingEdge(EE EE) {
            this.outgoing.add(EE);
        }

        public void removeIncomingEdge(EE EE) {
            this.incoming.remove(EE);
        }

        public void removeOutgoingEdge(EE EE) {
            this.outgoing.remove(EE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayListFactory<VV, EE>
    implements EdgeSetFactory<VV, EE>,
    Serializable {
        private static final long serialVersionUID = 5936902837403445985L;

        private ArrayListFactory() {
        }

        @Override
        public Set<EE> createEdgeSet(VV VV) {
            return new ArrayUnenforcedSet(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Specifics
    implements Serializable {
        private Specifics() {
        }

        public abstract void addVertex(V var1);

        public abstract Set<V> getVertexSet();

        public abstract Set<E> getAllEdges(V var1, V var2);

        public abstract E getEdge(V var1, V var2);

        public abstract void addEdgeToTouchingVertices(E var1);

        public abstract int degreeOf(V var1);

        public abstract Set<E> edgesOf(V var1);

        public abstract int inDegreeOf(V var1);

        public abstract Set<E> incomingEdgesOf(V var1);

        public abstract int outDegreeOf(V var1);

        public abstract Set<E> outgoingEdgesOf(V var1);

        public abstract void removeEdgeFromTouchingVertices(E var1);
    }
}

