/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.GraphDelegator;
import org.jgrapht.util.ArrayUnenforcedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsUndirectedGraph<V, E>
extends GraphDelegator<V, E>
implements Serializable,
UndirectedGraph<V, E> {
    private static final long serialVersionUID = 3257845485078065462L;
    private static final String NO_EDGE_ADD = "this graph does not support edge addition";
    private static final String UNDIRECTED = "this graph only supports undirected operations";

    public AsUndirectedGraph(DirectedGraph<V, E> directedGraph) {
        super(directedGraph);
    }

    @Override
    public Set<E> getAllEdges(V v, V v2) {
        Set set2 = super.getAllEdges(v, v2);
        if (v.equals(v2)) {
            return set2;
        }
        Set set3 = super.getAllEdges(v2, v);
        ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet(set2.size() + set3.size());
        arrayUnenforcedSet.addAll(set2);
        arrayUnenforcedSet.addAll(set3);
        return arrayUnenforcedSet;
    }

    @Override
    public E getEdge(V v, V v2) {
        Object e2 = super.getEdge(v, v2);
        if (e2 != null) {
            return e2;
        }
        return super.getEdge(v2, v);
    }

    @Override
    public E addEdge(V v, V v2) {
        throw new UnsupportedOperationException(NO_EDGE_ADD);
    }

    @Override
    public boolean addEdge(V v, V v2, E e2) {
        throw new UnsupportedOperationException(NO_EDGE_ADD);
    }

    @Override
    public int degreeOf(V v) {
        return super.inDegreeOf(v) + super.outDegreeOf(v);
    }

    @Override
    public int inDegreeOf(V v) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public Set<E> incomingEdgesOf(V v) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public int outDegreeOf(V v) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public Set<E> outgoingEdgesOf(V v) {
        throw new UnsupportedOperationException(UNDIRECTED);
    }

    @Override
    public String toString() {
        return super.toStringFromSets(this.vertexSet(), this.edgeSet(), false);
    }
}

