/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.GraphDelegator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsWeightedGraph<V, E>
extends GraphDelegator<V, E>
implements Serializable,
WeightedGraph<V, E> {
    private static final long serialVersionUID = -716810639338971372L;
    protected final Map<E, Double> weightMap;
    private final boolean isWeightedGraph;

    public AsWeightedGraph(Graph<V, E> graph, Map<E, Double> map2) {
        super(graph);
        assert (map2 != null);
        this.weightMap = map2;
        this.isWeightedGraph = graph instanceof WeightedGraph;
    }

    @Override
    public void setEdgeWeight(E e2, double d) {
        if (this.isWeightedGraph) {
            super.setEdgeWeight(e2, d);
        }
        this.weightMap.put(e2, d);
    }

    @Override
    public double getEdgeWeight(E e2) {
        double d = this.weightMap.containsKey(e2) ? this.weightMap.get(e2).doubleValue() : super.getEdgeWeight(e2);
        return d;
    }
}

