/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.util.PrefetchIterator;
import org.jgrapht.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MaskEdgeSet<V, E>
extends AbstractSet<E> {
    private Set<E> edgeSet;
    private Graph<V, E> graph;
    private MaskFunctor<V, E> mask;
    private transient TypeUtil<E> edgeTypeDecl = null;
    private int size;

    public MaskEdgeSet(Graph<V, E> graph, Set<E> set2, MaskFunctor<V, E> maskFunctor) {
        this.graph = graph;
        this.edgeSet = set2;
        this.mask = maskFunctor;
        this.size = -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.edgeSet.contains(object) && !this.mask.isEdgeMasked(TypeUtil.uncheckedCast(object, this.edgeTypeDecl));
    }

    @Override
    public Iterator<E> iterator() {
        return new PrefetchIterator(new MaskEdgeSetNextElementFunctor());
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++this.size;
            }
        }
        return this.size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MaskEdgeSetNextElementFunctor
    implements PrefetchIterator.NextElementFunctor<E> {
        private Iterator<E> iter;

        public MaskEdgeSetNextElementFunctor() {
            this.iter = MaskEdgeSet.this.edgeSet.iterator();
        }

        @Override
        public E nextElement() throws NoSuchElementException {
            Object e2 = this.iter.next();
            while (this.isMasked(e2)) {
                e2 = this.iter.next();
            }
            return e2;
        }

        private boolean isMasked(E e2) {
            return MaskEdgeSet.this.mask.isEdgeMasked(e2) || MaskEdgeSet.this.mask.isVertexMasked(MaskEdgeSet.this.graph.getEdgeSource(e2)) || MaskEdgeSet.this.mask.isVertexMasked(MaskEdgeSet.this.graph.getEdgeTarget(e2));
        }
    }
}

