/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.Collection;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.MaskEdgeSet;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.graph.MaskVertexSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskSubgraph<V, E>
extends AbstractGraph<V, E> {
    private static final String UNMODIFIABLE = "this graph is unmodifiable";
    private Graph<V, E> base;
    private Set<E> edges;
    private MaskFunctor<V, E> mask;
    private Set<V> vertices;

    public MaskSubgraph(Graph<V, E> graph, MaskFunctor<V, E> maskFunctor) {
        this.base = graph;
        this.mask = maskFunctor;
        this.vertices = new MaskVertexSet<V, E>(graph.vertexSet(), maskFunctor);
        this.edges = new MaskEdgeSet<V, E>(graph, graph.edgeSet(), maskFunctor);
    }

    @Override
    public E addEdge(V v, V v2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean addEdge(V v, V v2, E e2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.edgeSet().contains(e2);
    }

    @Override
    public boolean containsVertex(V v) {
        return !this.mask.isVertexMasked(v) && this.base.containsVertex(v);
    }

    public int degreeOf(V v) {
        return this.edgesOf(v).size();
    }

    @Override
    public Set<E> edgeSet() {
        return this.edges;
    }

    @Override
    public Set<E> edgesOf(V v) {
        this.assertVertexExist(v);
        return new MaskEdgeSet<V, E>(this.base, this.base.edgesOf(v), this.mask);
    }

    @Override
    public Set<E> getAllEdges(V v, V v2) {
        Set<E> set2 = null;
        if (this.containsVertex(v) && this.containsVertex(v2)) {
            return new MaskEdgeSet<V, E>(this.base, this.base.getAllEdges(v, v2), this.mask);
        }
        return set2;
    }

    @Override
    public E getEdge(V v, V v2) {
        Set<E> set2 = this.getAllEdges(v, v2);
        if (set2 == null || set2.isEmpty()) {
            return null;
        }
        return set2.iterator().next();
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.base.getEdgeFactory();
    }

    @Override
    public V getEdgeSource(E e2) {
        assert (this.edgeSet().contains(e2));
        return this.base.getEdgeSource(e2);
    }

    @Override
    public V getEdgeTarget(E e2) {
        assert (this.edgeSet().contains(e2));
        return this.base.getEdgeTarget(e2);
    }

    @Override
    public double getEdgeWeight(E e2) {
        assert (this.edgeSet().contains(e2));
        return this.base.getEdgeWeight(e2);
    }

    public Set<E> incomingEdgesOf(V v) {
        this.assertVertexExist(v);
        return new MaskEdgeSet<V, E>(this.base, ((DirectedGraph)this.base).incomingEdgesOf(v), this.mask);
    }

    public int inDegreeOf(V v) {
        return this.incomingEdgesOf(v).size();
    }

    public int outDegreeOf(V v) {
        return this.outgoingEdgesOf(v).size();
    }

    public Set<E> outgoingEdgesOf(V v) {
        this.assertVertexExist(v);
        return new MaskEdgeSet<V, E>(this.base, ((DirectedGraph)this.base).outgoingEdgesOf(v), this.mask);
    }

    @Override
    public boolean removeAllEdges(Collection<? extends E> collection) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public Set<E> removeAllEdges(V v, V v2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeAllVertices(Collection<? extends V> collection) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeEdge(E e2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public E removeEdge(V v, V v2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public Set<V> vertexSet() {
        return this.vertices;
    }
}

