/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.util.ArrayUnenforcedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subgraph<V, E, G extends Graph<V, E>>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = 3208313055169665387L;
    private static final String NO_SUCH_EDGE_IN_BASE = "no such edge in base graph";
    private static final String NO_SUCH_VERTEX_IN_BASE = "no such vertex in base graph";
    Set<E> edgeSet = new LinkedHashSet();
    Set<V> vertexSet = new LinkedHashSet<V>();
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;
    private G base;
    private boolean isInduced = false;

    public Subgraph(G g, Set<V> set2, Set<E> set3) {
        this.base = g;
        if (set3 == null) {
            this.isInduced = true;
        }
        if (g instanceof ListenableGraph) {
            ((ListenableGraph)g).addGraphListener(new BaseGraphListener());
        }
        this.addVerticesUsingFilter(g.vertexSet(), set2);
        this.addEdgesUsingFilter(g.edgeSet(), set3);
    }

    public Subgraph(G g, Set<V> set2) {
        this(g, set2, null);
    }

    @Override
    public Set<E> getAllEdges(V v, V v2) {
        ArrayUnenforcedSet arrayUnenforcedSet = null;
        if (this.containsVertex(v) && this.containsVertex(v2)) {
            arrayUnenforcedSet = new ArrayUnenforcedSet();
            Set set2 = this.base.getAllEdges(v, v2);
            for (Object e2 : set2) {
                if (!this.edgeSet.contains(e2)) continue;
                arrayUnenforcedSet.add(e2);
            }
        }
        return arrayUnenforcedSet;
    }

    @Override
    public E getEdge(V v, V v2) {
        Set<E> set2 = this.getAllEdges(v, v2);
        if (set2 == null || set2.isEmpty()) {
            return null;
        }
        return set2.iterator().next();
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.base.getEdgeFactory();
    }

    @Override
    public E addEdge(V v, V v2) {
        this.assertVertexExist(v);
        this.assertVertexExist(v2);
        if (!this.base.containsEdge(v, v2)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        Set set2 = this.base.getAllEdges(v, v2);
        for (Object e2 : set2) {
            if (this.containsEdge(e2)) continue;
            this.edgeSet.add(e2);
            return e2;
        }
        return null;
    }

    @Override
    public boolean addEdge(V v, V v2, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsEdge(e2)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        this.assertVertexExist(v);
        this.assertVertexExist(v2);
        assert (this.base.getEdgeSource(e2) == v);
        assert (this.base.getEdgeTarget(e2) == v2);
        if (this.containsEdge(e2)) {
            return false;
        }
        this.edgeSet.add(e2);
        return true;
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsVertex(v)) {
            throw new IllegalArgumentException(NO_SUCH_VERTEX_IN_BASE);
        }
        if (this.containsVertex(v)) {
            return false;
        }
        this.vertexSet.add(v);
        return true;
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.edgeSet.contains(e2);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.vertexSet.contains(v);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeSet);
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V v) {
        this.assertVertexExist(v);
        ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet();
        Set set2 = this.base.edgesOf(v);
        for (Object e2 : set2) {
            if (!this.containsEdge(e2)) continue;
            arrayUnenforcedSet.add(e2);
        }
        return arrayUnenforcedSet;
    }

    @Override
    public boolean removeEdge(E e2) {
        return this.edgeSet.remove(e2);
    }

    @Override
    public E removeEdge(V v, V v2) {
        E e2 = this.getEdge(v, v2);
        return (E)(this.edgeSet.remove(e2) ? e2 : null);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v) && this.base.containsVertex(v)) {
            this.removeAllEdges(this.edgesOf(v));
        }
        return this.vertexSet.remove(v);
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.vertexSet);
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public V getEdgeSource(E e2) {
        return this.base.getEdgeSource(e2);
    }

    @Override
    public V getEdgeTarget(E e2) {
        return this.base.getEdgeTarget(e2);
    }

    private void addEdgesUsingFilter(Set<E> set2, Set<E> set3) {
        for (E e2 : set2) {
            boolean bl;
            Object v = this.base.getEdgeSource(e2);
            Object v2 = this.base.getEdgeTarget(e2);
            boolean bl2 = this.containsVertex(v) && this.containsVertex(v2);
            boolean bl3 = bl = set3 == null || set3.contains(e2);
            if (!bl2 || !bl) continue;
            this.addEdge(v, v2, e2);
        }
    }

    private void addVerticesUsingFilter(Set<V> set2, Set<V> set3) {
        for (V v : set2) {
            if (set3 != null && !set3.contains(v)) continue;
            this.addVertex(v);
        }
    }

    public G getBase() {
        return this.base;
    }

    @Override
    public double getEdgeWeight(E e2) {
        return this.base.getEdgeWeight(e2);
    }

    public void setEdgeWeight(E e2, double d) {
        ((WeightedGraph)this.base).setEdgeWeight(e2, d);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BaseGraphListener
    implements GraphListener<V, E>,
    Serializable {
        private static final long serialVersionUID = 4343535244243546391L;

        private BaseGraphListener() {
        }

        @Override
        public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
            if (Subgraph.this.isInduced) {
                Object e2 = graphEdgeChangeEvent.getEdge();
                Subgraph.this.addEdge(Subgraph.this.base.getEdgeSource(e2), Subgraph.this.base.getEdgeTarget(e2), e2);
            }
        }

        @Override
        public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
            Object e2 = graphEdgeChangeEvent.getEdge();
            Subgraph.this.removeEdge(e2);
        }

        @Override
        public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        }

        @Override
        public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
            Object v = graphVertexChangeEvent.getVertex();
            Subgraph.this.removeVertex(v);
        }
    }
}

