/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.jgrapht.DirectedGraph;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.ModifiableInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalOrderIterator<V, E>
extends CrossComponentIterator<V, E, Object> {
    private Queue<V> queue;
    private Map<V, ModifiableInteger> inDegreeMap;

    public TopologicalOrderIterator(DirectedGraph<V, E> directedGraph) {
        this(directedGraph, (V)new LinkedListQueue());
    }

    public TopologicalOrderIterator(DirectedGraph<V, E> directedGraph, Queue<V> queue) {
        this(directedGraph, queue, new HashMap());
    }

    private TopologicalOrderIterator(DirectedGraph<V, E> directedGraph, Queue<V> queue, Map<V, ModifiableInteger> map2) {
        this(directedGraph, TopologicalOrderIterator.initialize(directedGraph, queue, map2));
        this.queue = queue;
        this.inDegreeMap = map2;
        assert (!queue.isEmpty());
    }

    private TopologicalOrderIterator(DirectedGraph<V, E> directedGraph, V v) {
        super(directedGraph, v);
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        return this.queue.isEmpty();
    }

    @Override
    protected void encounterVertex(V v, E e2) {
        this.putSeenData(v, null);
        this.decrementInDegree(v);
    }

    @Override
    protected void encounterVertexAgain(V v, E e2) {
        this.decrementInDegree(v);
    }

    @Override
    protected V provideNextVertex() {
        return this.queue.remove();
    }

    private void decrementInDegree(V v) {
        ModifiableInteger modifiableInteger = this.inDegreeMap.get(v);
        if (modifiableInteger.value > 0) {
            --modifiableInteger.value;
            if (modifiableInteger.value == 0) {
                this.queue.offer(v);
            }
        }
    }

    private static <V, E> V initialize(DirectedGraph<V, E> directedGraph, Queue<V> queue, Map<V, ModifiableInteger> map2) {
        for (Object v : directedGraph.vertexSet()) {
            int n = directedGraph.inDegreeOf(v);
            map2.put((ModifiableInteger)v, new ModifiableInteger(n));
            if (n != 0) continue;
            queue.offer(v);
        }
        if (queue.isEmpty()) {
            return null;
        }
        return queue.peek();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedListQueue<T>
    extends LinkedList<T>
    implements Queue<T> {
        private static final long serialVersionUID = 4217659843476891334L;

        private LinkedListQueue() {
        }

        @Override
        public T element() {
            return (T)this.getFirst();
        }

        @Override
        public boolean offer(T t) {
            return this.add(t);
        }

        @Override
        public T peek() {
            if (this.isEmpty()) {
                return null;
            }
            return (T)this.getFirst();
        }

        @Override
        public T poll() {
            if (this.isEmpty()) {
                return null;
            }
            return (T)this.removeFirst();
        }

        @Override
        public T remove() {
            return (T)this.removeFirst();
        }
    }
}

