/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public abstract class AbstractMacroExpansionVisitor
implements OWLClassExpressionVisitorEx<OWLClassExpression>,
OWLDataVisitorEx<OWLDataRange>,
OWLAxiomVisitorEx<OWLAxiom> {
    final Logger log;
    final OWLDataFactory dataFactory;
    final Map<IRI, String> expandAssertionToMap;
    final Map<IRI, String> expandExpressionMap;

    protected AbstractMacroExpansionVisitor(OWLOntology inputOntology, Logger log) {
        OWLAnnotationValue v;
        this.log = log;
        this.dataFactory = inputOntology.getOWLOntologyManager().getOWLDataFactory();
        this.expandExpressionMap = new HashMap<IRI, String>();
        this.expandAssertionToMap = new HashMap<IRI, String>();
        OWLAnnotationProperty expandExpressionAP = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000424.getIRI());
        OWLAnnotationProperty expandAssertionAP = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000425.getIRI());
        for (OWLObjectProperty oWLObjectProperty : inputOntology.getObjectPropertiesInSignature()) {
            for (OWLAnnotation a : oWLObjectProperty.getAnnotations(inputOntology, expandExpressionAP)) {
                v = a.getValue();
                if (!(v instanceof OWLLiteral)) continue;
                String str2 = ((OWLLiteral)v).getLiteral();
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "mapping " + oWLObjectProperty + " to " + str2);
                }
                this.expandExpressionMap.put(oWLObjectProperty.getIRI(), str2);
            }
        }
        for (OWLAnnotationProperty oWLAnnotationProperty : inputOntology.getAnnotationPropertiesInSignature()) {
            for (OWLAnnotation a : oWLAnnotationProperty.getAnnotations(inputOntology, expandAssertionAP)) {
                v = a.getValue();
                if (!(v instanceof OWLLiteral)) continue;
                String str2 = ((OWLLiteral)v).getLiteral();
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "assertion mapping " + oWLAnnotationProperty + " to " + str2);
                }
                this.expandAssertionToMap.put(oWLAnnotationProperty.getIRI(), str2);
            }
        }
    }

    @Override
    public OWLClassExpression visit(OWLObjectIntersectionOf desc) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : desc.getOperands()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    @Override
    public OWLClassExpression visit(OWLObjectUnionOf desc) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : desc.getOperands()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    @Override
    public OWLClassExpression visit(OWLObjectComplementOf desc) {
        return this.dataFactory.getOWLObjectComplementOf(desc.getOperand().accept(this));
    }

    @Override
    public OWLClassExpression visit(OWLObjectSomeValuesFrom desc) {
        OWLClassExpression filler = (OWLClassExpression)desc.getFiller();
        OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)desc.getProperty();
        OWLClassExpression result = null;
        if (p instanceof OWLObjectProperty) {
            result = this.expandOWLObjSomeVal(filler, p);
        }
        if (result == null) {
            result = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), filler.accept(this));
        }
        return result;
    }

    protected abstract OWLClassExpression expandOWLObjSomeVal(OWLClassExpression var1, OWLObjectPropertyExpression var2);

    @Override
    public OWLClassExpression visit(OWLObjectHasValue desc) {
        OWLClassExpression result = null;
        OWLIndividual filler = (OWLIndividual)desc.getValue();
        OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)desc.getProperty();
        if (p instanceof OWLObjectProperty) {
            result = this.expandOWLObjHasVal(desc, filler, p);
        }
        if (result == null) {
            result = this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)desc.getProperty(), filler);
        }
        return result;
    }

    protected abstract OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue var1, OWLIndividual var2, OWLObjectPropertyExpression var3);

    @Override
    public OWLClassExpression visit(OWLObjectAllValuesFrom desc) {
        return ((OWLClassExpression)desc.getFiller()).accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLObjectMinCardinality desc) {
        OWLClassExpression filler = ((OWLClassExpression)desc.getFiller()).accept(this);
        return this.dataFactory.getOWLObjectMinCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLObjectExactCardinality desc) {
        return desc.asIntersectionOfMinMax().accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLObjectMaxCardinality desc) {
        OWLClassExpression filler = ((OWLClassExpression)desc.getFiller()).accept(this);
        return this.dataFactory.getOWLObjectMaxCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLDataSomeValuesFrom desc) {
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        return this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLDataAllValuesFrom desc) {
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        return this.dataFactory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLDataHasValue desc) {
        return desc.asSomeValuesFrom().accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLDataExactCardinality desc) {
        return desc.asIntersectionOfMinMax().accept(this);
    }

    @Override
    public OWLClassExpression visit(OWLDataMaxCardinality desc) {
        int card = desc.getCardinality();
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        return this.dataFactory.getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLClassExpression visit(OWLDataMinCardinality desc) {
        int card = desc.getCardinality();
        OWLDataRange filler = ((OWLDataRange)desc.getFiller()).accept(this);
        return this.dataFactory.getOWLDataMinCardinality(card, (OWLDataPropertyExpression)desc.getProperty(), filler);
    }

    @Override
    public OWLDataRange visit(OWLDataOneOf node2) {
        HashSet<OWLDataOneOf> oneOfs = new HashSet<OWLDataOneOf>();
        for (OWLLiteral lit : node2.getValues()) {
            oneOfs.add(this.dataFactory.getOWLDataOneOf(lit));
        }
        return this.dataFactory.getOWLDataUnionOf(oneOfs).accept(this);
    }

    @Override
    public OWLDataRange visit(OWLDataIntersectionOf node2) {
        HashSet<OWLDataRange> ops = new HashSet<OWLDataRange>();
        for (OWLDataRange op : node2.getOperands()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLDataIntersectionOf(ops);
    }

    @Override
    public OWLDataRange visit(OWLDataUnionOf node2) {
        HashSet<OWLDataRange> ops = new HashSet<OWLDataRange>();
        for (OWLDataRange op : node2.getOperands()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLDataUnionOf(ops);
    }

    @Override
    public OWLAxiom visit(OWLSubClassOfAxiom axiom) {
        return this.dataFactory.getOWLSubClassOfAxiom(axiom.getSubClass().accept(this), axiom.getSuperClass().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLDisjointClassesAxiom axiom) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLDisjointClassesAxiom(ops);
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyDomainAxiom axiom) {
        return this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getDomain().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), axiom.getDomain().accept(this));
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), ((OWLClassExpression)axiom.getRange()).accept(this));
    }

    @Override
    public OWLAxiom visit(OWLDisjointUnionAxiom axiom) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            descs.add(op.accept(this));
        }
        return this.dataFactory.getOWLDisjointUnionAxiom(axiom.getOWLClass(), descs);
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyRangeAxiom axiom) {
        return this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)axiom.getProperty(), ((OWLDataRange)axiom.getRange()).accept(this));
    }

    @Override
    public OWLAxiom visit(OWLClassAssertionAxiom axiom) {
        if (axiom.getClassExpression().isAnonymous()) {
            return this.dataFactory.getOWLClassAssertionAxiom(axiom.getClassExpression().accept(this), axiom.getIndividual());
        }
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEquivalentClassesAxiom axiom) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            ops.add(op.accept(this));
        }
        return this.dataFactory.getOWLEquivalentClassesAxiom(ops);
    }

    @Override
    public OWLClassExpression visit(OWLClass desc) {
        return desc;
    }

    @Override
    public OWLClassExpression visit(OWLObjectHasSelf desc) {
        return desc;
    }

    @Override
    public OWLClassExpression visit(OWLObjectOneOf desc) {
        return desc;
    }

    @Override
    public OWLDataRange visit(OWLDatatype node2) {
        return node2;
    }

    @Override
    public OWLDataRange visit(OWLDataComplementOf node2) {
        return node2;
    }

    @Override
    public OWLAxiom visit(OWLHasKeyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLDataRange visit(OWLDatatypeRestriction node2) {
        return node2;
    }

    @Override
    public OWLDataRange visit(OWLFacetRestriction node2) {
        return null;
    }

    @Override
    public OWLAxiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDifferentIndividualsAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointDataPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSubObjectPropertyOfAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDeclarationAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLAnnotationAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLFunctionalDataPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSubDataPropertyOfAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSameIndividualAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSubPropertyChainOfAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLInverseObjectPropertiesAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(SWRLRule rule) {
        return rule;
    }

    @Override
    public OWLAxiom visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLDatatypeDefinitionAxiom axiom) {
        return axiom;
    }

    @Override
    public OWLDataRange visit(OWLLiteral node2) {
        return null;
    }
}

