/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.obolibrary.obo2owl.OwlStringTools;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousClassExpression;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLAPIObo2Owl {
    private static Logger LOG = Logger.getLogger(OWLAPIObo2Owl.class.getName());
    public static final String IRI_PROP_isReversiblePropertyChain = "http://purl.obolibrary.org/obo/IAO_isReversiblePropertyChain";
    protected String defaultIDSpace = "";
    protected OWLOntologyManager manager;
    protected OWLOntology owlOntology;
    protected OWLDataFactory fac;
    protected OBODoc obodoc;
    protected final Map<String, String> idSpaceMap = new HashMap<String, String>();
    public static Map<String, IRI> annotationPropertyMap = OWLAPIObo2Owl.initAnnotationPropertyMap();
    protected final Set<OWLAnnotationProperty> apToDeclare = new HashSet<OWLAnnotationProperty>();
    protected final Map<String, OWLClass> clsToDeclar = new Hashtable<String, OWLClass>();
    protected final Map<String, OWLAnnotationProperty> typedefToAnnotationProperty = new Hashtable<String, OWLAnnotationProperty>();

    public OWLAPIObo2Owl(OWLOntologyManager manager) {
        this.init(manager);
    }

    protected void init(OWLOntologyManager m) {
        this.manager = m;
        this.fac = this.manager.getOWLDataFactory();
        this.idSpaceMap.clear();
        this.apToDeclare.clear();
        this.clsToDeclar.clear();
        this.typedefToAnnotationProperty.clear();
    }

    public static void convertURL(String iri, String outFile, OWLOntologyManager manager) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException, OBOFormatParserException {
        OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(manager);
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(new URL(iri));
        OWLOntology ontology = bridge.convert(obodoc);
        IRI outputStream = IRI.create(outFile);
        RDFXMLOntologyFormat format2 = new RDFXMLOntologyFormat();
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "saving to " + outputStream + " fmt=" + format2);
        }
        manager.saveOntology(ontology, (OWLOntologyFormat)format2, outputStream);
    }

    public static void convertURL(String iri, String outFile, String defaultOnt, OWLOntologyManager manager) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException, OBOFormatParserException {
        OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(manager);
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(new URL(iri));
        obodoc.addDefaultOntologyHeader(defaultOnt);
        OWLOntology ontology = bridge.convert(obodoc);
        IRI outputStream = IRI.create(outFile);
        RDFXMLOntologyFormat format2 = new RDFXMLOntologyFormat();
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "saving to " + outputStream + " fmt=" + format2);
        }
        manager.saveOntology(ontology, (OWLOntologyFormat)format2, outputStream);
    }

    protected static HashMap<String, IRI> initAnnotationPropertyMap() {
        HashMap<String, IRI> map2 = new HashMap<String, IRI>();
        map2.put(OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag(), OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
        map2.put(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag(), OWLRDFVocabulary.RDFS_LABEL.getIRI());
        map2.put(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag(), OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        for (Obo2OWLConstants.Obo2OWLVocabulary vac : Obo2OWLConstants.Obo2OWLVocabulary.values()) {
            map2.put(vac.getMappedTag(), vac.getIRI());
        }
        return map2;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    public OBODoc getObodoc() {
        return this.obodoc;
    }

    public void setObodoc(OBODoc obodoc) {
        this.obodoc = obodoc;
    }

    protected OWLOntology getOwlOntology() {
        return this.owlOntology;
    }

    protected void setOwlOntology(OWLOntology owlOntology) {
        this.owlOntology = owlOntology;
    }

    public OWLOntology convert(String oboFile) throws OWLOntologyCreationException {
        try {
            OBOFormatParser p = new OBOFormatParser();
            return this.convert(p.parse(oboFile));
        }
        catch (IOException ex) {
            throw new OWLOntologyCreationException("Error Occured while parsing OBO '" + oboFile + "'", ex);
        }
        catch (OBOFormatParserException ex) {
            throw new OWLOntologyCreationException("Syntax error occured while parsing OBO '" + oboFile + "'", ex);
        }
    }

    public OWLOntology convert(OBODoc doc2) throws OWLOntologyCreationException {
        this.obodoc = doc2;
        this.init(this.manager);
        return this.tr(this.manager.createOntology());
    }

    public OWLOntology convert(OBODoc doc2, OWLOntology in) throws OWLOntologyCreationException {
        this.obodoc = doc2;
        this.init(in.getOWLOntologyManager());
        return this.tr(in);
    }

    protected OWLOntology tr(OWLOntology in) throws OWLOntologyCreationException {
        this.owlOntology = in;
        Frame hf = this.obodoc.getHeaderFrame();
        Clause ontClause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY);
        if (ontClause != null) {
            String ontOboId;
            this.defaultIDSpace = ontOboId = (String)ontClause.getValue();
            IRI ontIRI = ontOboId.contains(":") ? IRI.create(ontOboId) : IRI.create("http://purl.obolibrary.org/obo/" + ontOboId + ".owl");
            Clause dvclause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION);
            if (dvclause != null) {
                String dv = dvclause.getValue().toString();
                IRI vIRI = IRI.create("http://purl.obolibrary.org/obo/" + ontOboId + "/" + dv + "/" + ontOboId + ".owl");
                OWLOntologyID oid = new OWLOntologyID(ontIRI, vIRI);
                if (!oid.equals(this.owlOntology.getOntologyID())) {
                    this.manager.applyChange(new SetOntologyID(this.owlOntology, oid));
                }
            } else if (this.owlOntology.getOntologyID() == null || !ontIRI.equals(this.owlOntology.getOntologyID().getOntologyIRI())) {
                this.manager.applyChange(new SetOntologyID(this.owlOntology, new OWLOntologyID(ontIRI)));
            }
        } else {
            this.defaultIDSpace = "TEMP";
            this.manager.applyChange(new SetOntologyID(this.owlOntology, new OWLOntologyID(IRI.create("http://purl.obolibrary.org/obo/" + this.defaultIDSpace))));
        }
        this.trHeaderFrame(hf);
        for (Frame f : this.obodoc.getTypedefFrames()) {
            this.trTypedefToAnnotationProperty(f);
        }
        for (Frame f : this.obodoc.getTypedefFrames()) {
            this.trTypedefFrame(f);
        }
        for (Frame f : this.obodoc.getTermFrames()) {
            this.trTermFrame(f);
        }
        for (Clause cl : hf.getClauses(OBOFormatConstants.OboFormatTag.TAG_IMPORT)) {
            String path2 = this.getURI(cl.getValue().toString());
            IRI importIRI = IRI.create(path2);
            this.manager.loadOntology(importIRI);
            AddImport ai = new AddImport(this.owlOntology, this.fac.getOWLImportsDeclaration(importIRI));
            this.manager.applyChange(ai);
        }
        this.postProcess(this.owlOntology);
        return this.owlOntology;
    }

    protected void postProcess(OWLOntology ontology) {
        IRI pIRI = null;
        for (OWLAnnotation ann : ontology.getAnnotations()) {
            if (!Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_LogicalDefinitionViewRelation.sameIRI(ann.getProperty())) continue;
            OWLAnnotationValue v = ann.getValue();
            if (v instanceof OWLLiteral) {
                String rel = ((OWLLiteral)v).getLiteral();
                pIRI = this.oboIdToIRI(rel);
                break;
            }
            pIRI = (IRI)v;
            break;
        }
        if (pIRI != null) {
            OWLObjectProperty vp = this.fac.getOWLObjectProperty(pIRI);
            HashSet<OWLEquivalentClassesAxiom> rmAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            HashSet<OWLEquivalentClassesAxiom> newAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            for (OWLEquivalentClassesAxiom eca : ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
                int numNamed = 0;
                HashSet<OWLClassExpression> xs = new HashSet<OWLClassExpression>();
                for (OWLClassExpression x : eca.getClassExpressions()) {
                    if (x instanceof OWLClass) {
                        xs.add(x);
                        ++numNamed;
                        continue;
                    }
                    xs.add(this.fac.getOWLObjectSomeValuesFrom(vp, x));
                }
                if (numNamed != true) continue;
                rmAxioms.add(eca);
                newAxioms.add(this.fac.getOWLEquivalentClassesAxiom(xs));
            }
            this.manager.removeAxioms(ontology, rmAxioms);
            this.manager.addAxioms(ontology, newAxioms);
        }
    }

    protected String getURI(String path2) {
        if (path2.startsWith("http://") || path2.startsWith("file:")) {
            return path2;
        }
        File f = new File(path2);
        return f.toURI().toString();
    }

    public void trHeaderFrame(Frame headerFrame) {
        for (String t : headerFrame.getTags()) {
            Collection<Clause> clauses;
            OWLAnnotationProperty parentAnnotProp;
            OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY || tag == OBOFormatConstants.OboFormatTag.TAG_IMPORT) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF) {
                parentAnnotProp = this.trTagToAnnotationProp(t);
                for (Clause clause : headerFrame.getClauses(t)) {
                    OWLAnnotationProperty childAnnotProp = this.trAnnotationProp(clause.getValue(String.class));
                    Set<OWLAnnotation> annotations = this.trAnnotations(clause);
                    this.add(this.fac.getOWLSubAnnotationPropertyOfAxiom(childAnnotProp, parentAnnotProp, annotations));
                    OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag());
                    this.add(this.fac.getOWLAnnotationAssertionAxiom(ap, childAnnotProp.getIRI(), this.trLiteral(clause.getValue2())));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF) {
                parentAnnotProp = this.trTagToAnnotationProp(t);
                for (Clause clause : headerFrame.getClauses(t)) {
                    Object[] values = clause.getValues().toArray();
                    OWLAnnotationProperty childAnnotProp = this.trAnnotationProp(values[0].toString());
                    IRI childIRI = childAnnotProp.getIRI();
                    Set<OWLAnnotation> annotations = this.trAnnotations(clause);
                    this.add(this.fac.getOWLSubAnnotationPropertyOfAxiom(childAnnotProp, parentAnnotProp, annotations));
                    OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag());
                    this.add(this.fac.getOWLAnnotationAssertionAxiom(ap, childIRI, this.trLiteral(values[1])));
                    if (values.length <= 2 || values[2].toString().length() <= 0) continue;
                    ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_SCOPE.getTag());
                    this.add(this.fac.getOWLAnnotationAssertionAxiom(ap, childIRI, this.trTagToAnnotationProp(values[2].toString()).getIRI()));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATE) {
                Clause clause = headerFrame.getClause(tag);
                Object value = clause.getValue();
                String dateString = null;
                if (value instanceof Date) {
                    dateString = OBOFormatConstants.headerDateFormat.get().format((Date)value);
                } else if (value instanceof String) {
                    dateString = (String)value;
                }
                if (dateString != null) {
                    this.addOntologyAnnotation(this.trTagToAnnotationProp(t), this.trLiteral(dateString), this.trAnnotations(clause));
                    continue;
                }
                LOG.log(Level.WARNING, "Cannot translate: " + clause);
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
                this.addPropertyValueHeaders(headerFrame.getClauses(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE));
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_REMARK) {
                clauses = headerFrame.getClauses(t);
                for (Clause clause : clauses) {
                    this.addOntologyAnnotation(this.fac.getRDFSComment(), this.trLiteral(clause.getValue()), this.trAnnotations(clause));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_IDSPACE) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS) {
                Collection<String> axiomStrings = headerFrame.getTagValues(tag, String.class);
                if (axiomStrings == null) continue;
                try {
                    for (String axiomString : axiomStrings) {
                        Set<OWLAxiom> axioms = OwlStringTools.translate(axiomString, this.manager);
                        if (axioms == null) continue;
                        this.manager.addAxioms(this.owlOntology, axioms);
                    }
                    continue;
                }
                catch (OwlStringTools.OwlStringException e2) {
                    throw new RuntimeException(e2);
                }
            }
            clauses = headerFrame.getClauses(t);
            for (Clause clause : clauses) {
                this.addOntologyAnnotation(this.trTagToAnnotationProp(t), this.trLiteral(clause.getValue()), this.trAnnotations(clause));
            }
        }
    }

    protected void addPropertyValueHeaders(Collection<Clause> clauses) {
        for (Clause clause : clauses) {
            Set<OWLAnnotation> annotations = this.trAnnotations(clause);
            Collection<Object> values = clause.getValues();
            Object v = clause.getValue();
            Object v2 = clause.getValue2();
            if (v == null) {
                LOG.log(Level.WARNING, "Cannot translate: " + clause);
                continue;
            }
            if (values.size() == 2) {
                OWLAnnotationProperty prop = this.trAnnotationProp((String)v);
                IRI value = this.trAnnotationProp(v2.toString()).getIRI();
                OWLAnnotation ontAnn = this.fac.getOWLAnnotation(prop, value, annotations);
                AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.owlOntology, ontAnn);
                this.apply(addAnn);
                continue;
            }
            if (values.size() == 3) {
                Iterator<Object> it = clause.getValues().iterator();
                it.next();
                it.next();
                String v3String = (String)it.next();
                IRI valueIRI = v3String.startsWith("xsd:") ? IRI.create((Object)((Object)Namespaces.XSD) + v3String.substring(4)) : IRI.create(v3String);
                OWLLiteral value = this.fac.getOWLLiteral((String)v2, OWL2Datatype.getDatatype(valueIRI));
                OWLAnnotationProperty prop = this.trAnnotationProp((String)v);
                OWLAnnotation ontAnn = this.fac.getOWLAnnotation(prop, value, annotations);
                AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.owlOntology, ontAnn);
                this.apply(addAnn);
                continue;
            }
            LOG.log(Level.WARNING, "Cannot translate: " + clause);
        }
    }

    protected void addOntologyAnnotation(OWLAnnotationProperty ap, OWLAnnotationValue v, Set<OWLAnnotation> annotations) {
        OWLAnnotation ontAnn = this.fac.getOWLAnnotation(ap, v, annotations);
        AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.owlOntology, ontAnn);
        this.apply(addAnn);
    }

    public OWLClassExpression trTermFrame(Frame termFrame) {
        OWLClass cls = this.trClass(termFrame.getId());
        this.add(this.fac.getOWLDeclarationAxiom(cls));
        for (String t : termFrame.getTags()) {
            Collection<Clause> clauses = termFrame.getClauses(t);
            Set<OWLAxiom> axioms = this.trTermFrameClauses(cls, clauses, t);
            if (axioms.isEmpty()) continue;
            this.add(axioms);
        }
        return cls;
    }

    public Set<OWLAxiom> trTermFrameClauses(OWLClass cls, Collection<Clause> clauses, String t) {
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (tag == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
            axioms.add(this.trIntersectionOf(cls, clauses));
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
            axioms.add(this.trUnionOf(cls, clauses));
        } else {
            for (Clause clause : clauses) {
                axioms.add(this.trTermClause(cls, t, clause));
            }
        }
        return axioms;
    }

    protected OWLNamedObject trTypedefToAnnotationProperty(Frame typedefFrame) {
        if (typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG) != null && ((Boolean)typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG)).booleanValue()) {
            String id2 = typedefFrame.getId();
            OWLAnnotationProperty p = this.trAnnotationProp(id2);
            this.add(this.fac.getOWLDeclarationAxiom(p));
            String xid = this.translateShorthandIdToExpandedId(id2);
            if (!id2.equals(xid)) {
                OWLAnnotationAssertionAxiom ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp("shorthand"), p.getIRI(), this.trLiteral(id2), new HashSet());
                this.add(ax);
            }
            this.typedefToAnnotationProperty.put(p.getIRI().toString(), p);
            for (String tag : typedefFrame.getTags()) {
                OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
                if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_A) continue;
                for (Clause clause : typedefFrame.getClauses(tag)) {
                    this.add(this.trGenericClause(p, tag, clause));
                }
            }
            return p;
        }
        return null;
    }

    public OWLNamedObject trTypedefFrame(Frame typedefFrame) {
        if (typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG) != null && ((Boolean)typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG)).booleanValue()) {
            return null;
        }
        String id2 = typedefFrame.getId();
        OWLObjectProperty p = this.trObjectProp(id2);
        this.add(this.fac.getOWLDeclarationAxiom(p));
        String xid = this.translateShorthandIdToExpandedId(id2);
        if (!xid.equals(id2)) {
            OWLAnnotationAssertionAxiom ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp("shorthand"), p.getIRI(), this.trLiteral(id2), new HashSet());
            this.add(ax);
        }
        for (String tag : typedefFrame.getTags()) {
            OWLAxiom axiom;
            Collection<Clause> clauses = typedefFrame.getClauses(tag);
            OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
            if (_tag == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
                axiom = this.trRelationIntersectionOf(id2, p, clauses);
                if (axiom == null) continue;
                this.add(axiom);
                continue;
            }
            if (_tag == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
                axiom = this.trRelationUnionOf(id2, p, clauses);
                if (axiom == null) continue;
                this.add(axiom);
                continue;
            }
            for (Clause clause : clauses) {
                this.add(this.trTypedefClause(p, tag, clause));
            }
        }
        return p;
    }

    protected OWLAxiom trRelationUnionOf(String id2, OWLProperty<?, ?> p, Collection<Clause> clauses) {
        LOG.log(Level.WARNING, "The relation union_of for " + id2 + " is currently non-translatable to OWL. Ignoring clauses: " + clauses);
        return null;
    }

    protected OWLAxiom trRelationIntersectionOf(String id2, OWLProperty<?, ?> p, Collection<Clause> clauses) {
        LOG.log(Level.WARNING, "The relation intersection_of for " + id2 + " is currently non-translatable to OWL. Ignoring clauses: " + clauses);
        return null;
    }

    protected OWLAxiom trUnionOf(OWLClass cls, Collection<Clause> clauses) {
        Set<? extends OWLAnnotation> annotations = this.trAnnotations(clauses);
        HashSet<OWLClassExpression> eSet = new HashSet<OWLClassExpression>();
        eSet.add(cls);
        HashSet<OWLClassExpression> iSet = new HashSet<OWLClassExpression>();
        for (Clause clause : clauses) {
            Collection<QualifierValue> qvs = clause.getQualifierValues();
            if (clause.getValues().size() == 1) {
                iSet.add(this.trClass(clause.getValue()));
                continue;
            }
            LOG.log(Level.SEVERE, "union_of n-ary slots not is standard - converting anyway");
            iSet.add(this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs));
        }
        eSet.add(this.fac.getOWLObjectUnionOf(iSet));
        if (annotations == null || annotations.size() == 0) {
            return this.fac.getOWLEquivalentClassesAxiom(eSet);
        }
        return this.fac.getOWLEquivalentClassesAxiom(eSet, annotations);
    }

    protected OWLAxiom trIntersectionOf(OWLClass cls, Collection<Clause> clauses) {
        Set<? extends OWLAnnotation> annotations = this.trAnnotations(clauses);
        HashSet<OWLClassExpression> eSet = new HashSet<OWLClassExpression>();
        eSet.add(cls);
        HashSet<OWLClassExpression> iSet = new HashSet<OWLClassExpression>();
        for (Clause clause : clauses) {
            Collection<QualifierValue> qvs = clause.getQualifierValues();
            if (clause.getValues().size() == 1) {
                iSet.add(this.trClass(clause.getValue()));
                continue;
            }
            iSet.add(this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs));
        }
        eSet.add(this.fac.getOWLObjectIntersectionOf(iSet));
        if (annotations == null || annotations.size() == 0) {
            return this.fac.getOWLEquivalentClassesAxiom(eSet);
        }
        return this.fac.getOWLEquivalentClassesAxiom(eSet, annotations);
    }

    protected void add(OWLAxiom axiom) {
        if (axiom == null) {
            LOG.log(Level.SEVERE, "no axiom");
            return;
        }
        this.add(Collections.singleton(axiom));
    }

    protected void add(Set<OWLAxiom> axioms) {
        if (axioms == null || axioms.isEmpty()) {
            LOG.log(Level.SEVERE, "no axiom");
            return;
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(axioms.size());
        for (OWLAxiom axiom : axioms) {
            AddAxiom addAx = new AddAxiom(this.owlOntology, axiom);
            changes.add(addAx);
        }
        this.apply(changes);
    }

    protected void apply(OWLOntologyChange change) {
        this.apply(Collections.singletonList(change));
    }

    protected void apply(List<OWLOntologyChange> changes) {
        try {
            this.manager.applyChanges(changes);
        }
        catch (Exception e2) {
            LOG.log(Level.SEVERE, "COULD NOT TRANSLATE AXIOM", e2);
        }
    }

    protected OWLAxiom trTermClause(OWLClass cls, String tag, Clause clause) {
        HashSet<OWLClass> cSet;
        OWLAxiom ax;
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
        OWLClassExpression clsx = cls;
        String gciRel = this.getQVString("gci_relation", qvs);
        if (gciRel != null && !gciRel.equals("")) {
            String gciFiller = this.getQVString("gci_filler", qvs);
            OWLClassExpression r = this.trRel(gciRel, gciFiller, new HashSet<QualifierValue>());
            clsx = this.fac.getOWLObjectIntersectionOf(cls, r);
        }
        if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            ax = this.fac.getOWLSubClassOfAxiom(clsx, this.trClass((String)clause.getValue()), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            IRI relId = this.oboIdToIRI((String)clause.getValue());
            OWLAnnotationProperty prop = this.typedefToAnnotationProperty.get(relId.toString());
            ax = prop != null ? this.fac.getOWLAnnotationAssertionAxiom(prop, cls.getIRI(), this.oboIdToIRI((String)clause.getValue2()), annotations) : this.fac.getOWLSubClassOfAxiom(clsx, this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            cSet = new HashSet<OWLClass>();
            cSet.add((OWLClass)clsx);
            cSet.add(this.trClass((String)clause.getValue()));
            ax = this.fac.getOWLDisjointClassesAxiom(cSet, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            cSet = new HashSet();
            cSet.add((OWLClass)clsx);
            cSet.add(this.trClass((String)clause.getValue()));
            ax = this.fac.getOWLEquivalentClassesAxiom(cSet, annotations);
        } else {
            return this.trGenericClause(cls, tag, clause);
        }
        return ax;
    }

    protected OWLAxiom trTypedefClause(OWLObjectProperty p, String tag, Clause clause) {
        OWLAxiom ax = null;
        Object v = clause.getValue();
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
        if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            ax = this.fac.getOWLSubObjectPropertyOfAxiom(p, this.trObjectProp((String)v), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            IRI relId = this.oboIdToIRI((String)clause.getValue());
            OWLAnnotationProperty metaProp = this.typedefToAnnotationProperty.get(relId.toString());
            ax = metaProp != null ? this.fac.getOWLAnnotationAssertionAxiom(metaProp, p.getIRI(), this.oboIdToIRI((String)clause.getValue2()), annotations) : null;
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLDisjointObjectPropertiesAxiom(cSet, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLInverseObjectPropertiesAxiom(p, this.trObjectProp((String)v), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLEquivalentObjectPropertiesAxiom(cSet, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_DOMAIN) {
            ax = this.fac.getOWLObjectPropertyDomainAxiom(p, this.trClass(v), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_RANGE) {
            ax = this.fac.getOWLObjectPropertyRangeAxiom(p, this.trClass(v), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER) {
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>(2);
            chain.add(p);
            chain.add(this.trObjectProp(v));
            ax = this.fac.getOWLSubPropertyChainOfAxiom(chain, p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN || _tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
            if (_tag == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
                OWLAnnotation ann = this.fac.getOWLAnnotation(this.trAnnotationProp(IRI_PROP_isReversiblePropertyChain), this.trLiteral("true"));
                annotations.add(ann);
            }
            Vector<OWLObjectPropertyExpression> chain = new Vector<OWLObjectPropertyExpression>();
            chain.add(this.trObjectProp(v));
            chain.add(this.trObjectProp(clause.getValue2()));
            ax = this.fac.getOWLSubPropertyChainOfAxiom(chain, p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLTransitiveObjectPropertyAxiom(p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLReflexiveObjectPropertyAxiom(p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLSymmetricObjectPropertyAxiom(p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_ASYMMETRIC && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLAsymmetricObjectPropertyAxiom(p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLFunctionalObjectPropertyAxiom(p, annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLInverseFunctionalObjectPropertyAxiom(p, annotations);
        } else {
            return this.trGenericClause(p, tag, clause);
        }
        return ax;
    }

    protected OWLAxiom trGenericClause(OWLNamedObject e2, String tag, Clause clause) {
        return this.trGenericClause(e2.getIRI(), tag, clause);
    }

    protected OWLAxiom trGenericClause(OWLAnnotationSubject sub, String tag, Clause clause) {
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        if (clause.getValue() == null) {
            LOG.log(Level.SEVERE, "Problem: " + clause);
        }
        OWLAnnotationAssertionAxiom ax = null;
        OBOFormatConstants.OboFormatTag _tag = OBOFormatConstants.getTag(tag);
        if (_tag == OBOFormatConstants.OboFormatTag.TAG_NAME) {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_DEF) {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_SUBSET) {
            Object v = clause.getValue();
            if (v == null) {
                LOG.log(Level.WARNING, "Cannot translate: " + clause);
            } else {
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trAnnotationProp(v.toString()).getIRI(), annotations);
            }
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
            Collection<Object> values = clause.getValues();
            Object v = clause.getValue();
            Object v2 = clause.getValue2();
            if (v == null) {
                LOG.log(Level.WARNING, "Cannot translate: " + clause);
            } else if (values.size() == 2) {
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trAnnotationProp((String)v), sub, this.trAnnotationProp(v2.toString()).getIRI(), annotations);
            } else if (values.size() == 3) {
                Iterator<Object> it = clause.getValues().iterator();
                it.next();
                it.next();
                String v3String = (String)it.next();
                IRI valueIRI = v3String.startsWith("xsd:") ? IRI.create((Object)((Object)Namespaces.XSD) + v3String.substring(4)) : IRI.create(v3String);
                OWLLiteral value = this.fac.getOWLLiteral((String)v2, OWL2Datatype.getDatatype(valueIRI));
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trAnnotationProp((String)v), sub, value, annotations);
            } else {
                LOG.log(Level.WARNING, "Cannot translate: " + clause);
            }
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
            String synType;
            Object[] values = clause.getValues().toArray();
            if (values.length > 1) {
                synType = values[1].toString();
                if (values.length > 2) {
                    OWLAnnotation ann = this.fac.getOWLAnnotation(this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_HAS_SYNONYM_TYPE.getTag()), this.trAnnotationProp(values[2].toString()).getIRI());
                    annotations.add(ann);
                }
            } else {
                LOG.log(Level.WARNING, "Assume 'RELATED'for missing scope in synonym clause: " + clause);
                synType = OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag();
            }
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trSynonymType(synType), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (_tag == OBOFormatConstants.OboFormatTag.TAG_XREF) {
            Xref xref = (Xref)clause.getValue();
            String xrefAnnotation = xref.getAnnotation();
            if (xrefAnnotation != null) {
                OWLAnnotation owlAnnotation = this.fac.getOWLAnnotation(this.fac.getRDFSLabel(), this.fac.getOWLLiteral(xrefAnnotation));
                annotations.add(owlAnnotation);
            }
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        }
        return ax;
    }

    protected OWLAnnotationProperty trSynonymType(String type2) {
        if (type2.equals(OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag()) || type2.equals(OBOFormatConstants.OboFormatTag.TAG_EXACT.getTag()) || type2.equals(OBOFormatConstants.OboFormatTag.TAG_NARROW.getTag()) || type2.equals(OBOFormatConstants.OboFormatTag.TAG_BROAD.getTag())) {
            return this.trTagToAnnotationProp(type2);
        }
        return this.trAnnotationProp(type2);
    }

    protected Set<OWLAnnotation> trAnnotations(Clause clause) {
        HashSet<OWLAnnotation> anns = new HashSet<OWLAnnotation>();
        this.trAnnotations(clause, anns);
        return anns;
    }

    protected void trAnnotations(Clause clause, Set<OWLAnnotation> anns) {
        Collection<QualifierValue> qvs;
        Collection<Xref> xrefs = clause.getXrefs();
        if (xrefs != null) {
            for (Xref x : xrefs) {
                if (x.getIdref() == null || x.getIdref().length() <= 0) continue;
                OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_XREF.getTag());
                OWLAnnotation ann = this.fac.getOWLAnnotation(ap, this.trLiteral(x));
                anns.add(ann);
            }
        }
        if ((qvs = clause.getQualifierValues()) != null) {
            for (QualifierValue qv : qvs) {
                String qTag = qv.getQualifier();
                if (qTag.equals("gci_relation") || qTag.equals("gci_filler") || qTag.equals("cardinality") || qTag.equals("minCardinality") || qTag.equals("maxCardinality") || qTag.equals("all_some") || qTag.equals("all_only")) continue;
                OWLAnnotationProperty ap = this.trTagToAnnotationProp(qTag);
                OWLAnnotation ann = this.fac.getOWLAnnotation(ap, this.trLiteral(qv.getValue()));
                anns.add(ann);
            }
        }
    }

    protected Set<? extends OWLAnnotation> trAnnotations(Collection<Clause> clauses) {
        if (clauses != null) {
            HashSet<OWLAnnotation> anns = new HashSet<OWLAnnotation>();
            for (Clause clause : clauses) {
                this.trAnnotations(clause, anns);
            }
            return anns;
        }
        return null;
    }

    public OWLClassExpression trRel(String relId, String classId, Collection<QualifierValue> quals) {
        OWLAnonymousClassExpression ex;
        Frame relFrame = this.obodoc.getTypedefFrame(relId);
        OWLObjectProperty pe = this.trObjectProp(relId);
        OWLClass ce = this.trClass(classId);
        Integer exact = this.getQVInt("cardinality", quals);
        Integer min2 = this.getQVInt("minCardinality", quals);
        Integer max2 = this.getQVInt("maxCardinality", quals);
        Boolean allSome = this.getQVBoolean("all_some", quals);
        Boolean allOnly = this.getQVBoolean("all_only", quals);
        if (ce instanceof OWLClass) {
            this.add(this.fac.getOWLDeclarationAxiom(ce));
        }
        if (exact != null && exact > 0) {
            ex = this.fac.getOWLObjectExactCardinality(exact, pe, ce);
        } else if (exact != null && exact == 0 || max2 != null && max2 == 0) {
            OWLObjectComplementOf ceCompl = this.fac.getOWLObjectComplementOf(ce);
            ex = this.fac.getOWLObjectAllValuesFrom(pe, ceCompl);
        } else {
            ex = max2 != null && min2 != null ? this.fac.getOWLObjectIntersectionOf(this.fac.getOWLObjectMinCardinality(min2, pe, ce), this.fac.getOWLObjectMaxCardinality(max2, pe, ce)) : (min2 != null ? this.fac.getOWLObjectMinCardinality(min2, pe, ce) : (max2 != null ? this.fac.getOWLObjectMaxCardinality(max2, pe, ce) : (allSome != null && allSome != false && allOnly != null && allOnly != false ? this.fac.getOWLObjectIntersectionOf(this.fac.getOWLObjectSomeValuesFrom(pe, ce), this.fac.getOWLObjectAllValuesFrom(pe, ce)) : (allOnly != null && allOnly != false ? this.fac.getOWLObjectAllValuesFrom(pe, ce) : (relFrame != null && relFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG) != null && (Boolean)relFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG) != false ? this.fac.getOWLObjectHasValue(pe, this.trIndividual(classId)) : this.fac.getOWLObjectSomeValuesFrom(pe, ce))))));
        }
        return ex;
    }

    protected String getQVString(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            Object v = qv.getValue();
            return (String)v;
        }
        return null;
    }

    protected Boolean getQVBoolean(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            Object v = qv.getValue();
            return Boolean.valueOf((String)v);
        }
        return null;
    }

    protected Integer getQVInt(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            Object v = qv.getValue();
            return Integer.valueOf((String)v);
        }
        return null;
    }

    protected OWLClass trClass(String classId) {
        IRI iri = this.oboIdToIRI(classId);
        return this.fac.getOWLClass(iri);
    }

    protected OWLClassExpression trClass(Object v) {
        return this.trClass((String)v);
    }

    protected String mapPropId(String id2) {
        Frame f = this.obodoc.getTypedefFrame(id2);
        if (f != null) {
            Collection<Xref> xrefs = f.getTagValues(OBOFormatConstants.OboFormatTag.TAG_XREF, Xref.class);
            for (Xref x : xrefs) {
                String xid = x.getIdref();
                if (!this.obodoc.isTreatXrefsAsEquivalent(this.getIdPrefix(xid))) continue;
                return xid;
            }
        }
        return id2;
    }

    protected String getIdPrefix(String x) {
        String[] parts = x.split(":", 2);
        return parts[0];
    }

    protected OWLIndividual trIndividual(String instId) {
        IRI iri = this.oboIdToIRI(instId);
        return this.fac.getOWLNamedIndividual(iri);
    }

    public static IRI trTagToIRI(String tag) {
        IRI iri = null;
        iri = annotationPropertyMap.containsKey(tag) ? annotationPropertyMap.get(tag) : IRI.create("http://www.geneontology.org/formats/oboInOwl#" + tag);
        return iri;
    }

    protected OWLAnnotationProperty trTagToAnnotationProp(String tag) {
        IRI iri = OWLAPIObo2Owl.trTagToIRI(tag);
        OWLAnnotationProperty ap = this.fac.getOWLAnnotationProperty(iri);
        if (!this.apToDeclare.contains(ap)) {
            this.apToDeclare.add(ap);
            this.add(this.fac.getOWLDeclarationAxiom(ap));
            Obo2OWLConstants.Obo2OWLVocabulary vocab = Obo2OWLConstants.getVocabularyObj(tag);
            if (vocab != null) {
                this.add(this.fac.getOWLAnnotationAssertionAxiom(this.fac.getRDFSLabel(), iri, this.trLiteral(vocab.getLabel())));
            }
        }
        return ap;
    }

    protected void addDeclaredAnnotationProperties(Collection<OWLAnnotationProperty> declaredProperties) {
        if (declaredProperties != null) {
            this.apToDeclare.addAll(declaredProperties);
        }
    }

    protected OWLAnnotationProperty trAnnotationProp(String relId) {
        IRI iri = this.oboIdToIRI(this.mapPropId(relId));
        return this.fac.getOWLAnnotationProperty(iri);
    }

    protected OWLObjectProperty trObjectProp(String relId) {
        IRI iri = this.oboIdToIRI(this.mapPropId(relId));
        return this.fac.getOWLObjectProperty(iri);
    }

    protected OWLObjectPropertyExpression trObjectProp(Object v) {
        IRI iri = this.oboIdToIRI(this.mapPropId((String)v));
        return this.fac.getOWLObjectProperty(iri);
    }

    protected OWLAnnotationValue trLiteral(Object value) {
        if (value instanceof Xref) {
            value = ((Xref)value).getIdref();
        } else {
            if (value instanceof Date) {
                String lexicalValue = Obo2OWLConstants.format((Date)value);
                return this.fac.getOWLLiteral(lexicalValue, OWL2Datatype.XSD_DATE_TIME);
            }
            if (value instanceof Boolean) {
                return this.fac.getOWLLiteral((Boolean)value);
            }
            if (!(value instanceof String)) {
                value = value.toString();
            }
        }
        return this.fac.getOWLLiteral((String)value);
    }

    public IRI oboIdToIRI(String id2) {
        String safeId;
        String localId;
        String db;
        String xid;
        if (id2.contains(" ")) {
            LOG.log(Level.SEVERE, "id contains space: \"" + id2 + "\"");
            return null;
        }
        if (id2.startsWith("http:")) {
            return IRI.create(id2);
        }
        if (id2.startsWith("https:")) {
            return IRI.create(id2);
        }
        if (id2.startsWith("ftp:")) {
            return IRI.create(id2);
        }
        if (id2.startsWith("urn:")) {
            return IRI.create(id2);
        }
        if (!id2.contains(":") && !(xid = this.translateShorthandIdToExpandedId(id2)).equals(id2)) {
            return this.oboIdToIRI(xid);
        }
        String[] idParts = id2.split(":", 2);
        if (idParts.length > 1) {
            db = idParts[0];
            localId = idParts[1];
            db = localId.contains("_") ? db + "#_" : db + "_";
        } else if (idParts.length == 0) {
            db = this.getDefaultIDSpace() + "#";
            localId = id2;
        } else {
            db = this.getDefaultIDSpace() + "#";
            localId = idParts[0];
        }
        String uriPrefix = "http://purl.obolibrary.org/obo/" + db;
        if (this.idSpaceMap.containsKey(db)) {
            uriPrefix = this.idSpaceMap.get(db);
        }
        try {
            safeId = URLEncoder.encode(localId, "US-ASCII");
        }
        catch (UnsupportedEncodingException e1) {
            return null;
        }
        if (safeId.contains(" ")) {
            safeId = safeId.replace(" ", "_");
        }
        IRI iri = null;
        try {
            iri = IRI.create(uriPrefix + safeId);
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
        return iri;
    }

    protected String translateShorthandIdToExpandedId(String id2) {
        if (id2.contains(":")) {
            return id2;
        }
        Frame tdf = this.obodoc.getTypedefFrame(id2);
        if (tdf == null) {
            return id2;
        }
        Collection<Xref> xrefs = tdf.getTagValues(OBOFormatConstants.OboFormatTag.TAG_XREF, Xref.class);
        String matchingExpandedId = null;
        for (Xref xref : xrefs) {
            String xid;
            if (xref == null || (xid = xref.getIdref()).equals(id2)) continue;
            if (matchingExpandedId == null) {
                matchingExpandedId = xid;
                continue;
            }
            if (!xid.startsWith("RO") && !xid.startsWith("BFO")) continue;
            matchingExpandedId = xid;
        }
        if (matchingExpandedId == null) {
            return id2;
        }
        return matchingExpandedId;
    }

    protected String getDefaultIDSpace() {
        return this.defaultIDSpace;
    }
}

