/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Set;
import org.coode.owlapi.functionalparser.OWLFunctionalSyntaxOWLParser;
import org.coode.owlapi.functionalrenderer.OWLFunctionalSyntaxRenderer;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class OwlStringTools {
    public static String translate(Set<OWLAxiom> axioms, OWLOntologyManager translationManager) throws OwlStringException {
        if (axioms == null || axioms.isEmpty()) {
            return null;
        }
        try {
            OWLOntology ontology = translationManager.createOntology();
            translationManager.addAxioms(ontology, axioms);
            OWLFunctionalSyntaxRenderer r = new OWLFunctionalSyntaxRenderer();
            StringWriter writer2 = new StringWriter();
            r.render(ontology, writer2);
            return ((Object)writer2).toString();
        }
        catch (OWLRendererException e2) {
            throw new OwlStringException(e2);
        }
        catch (OWLOntologyCreationException e3) {
            throw new OwlStringException(e3);
        }
    }

    public static Set<OWLAxiom> translate(String axioms, OWLOntologyManager translationManager) throws OwlStringException {
        if (axioms == null || axioms.isEmpty()) {
            return null;
        }
        try {
            OWLFunctionalSyntaxOWLParser p = new OWLFunctionalSyntaxOWLParser();
            StringDocumentSource documentSource = new StringDocumentSource(axioms);
            OWLOntology ontology = translationManager.createOntology();
            p.parse(documentSource, ontology);
            return ontology.getAxioms();
        }
        catch (UnloadableImportException e2) {
            throw new OwlStringException(e2);
        }
        catch (OWLOntologyCreationException e3) {
            throw new OwlStringException(e3);
        }
        catch (OWLParserException e4) {
            throw new OwlStringException(e4);
        }
        catch (IOException e5) {
            throw new OwlStringException(e5);
        }
    }

    public static class OwlStringException
    extends Exception {
        private static final long serialVersionUID = 5909865427436329918L;

        protected OwlStringException(Throwable cause) {
            super(cause);
        }
    }
}

