/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.FrameMergeException;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.InvalidXrefMapException;
import org.obolibrary.oboformat.parser.OBOFormatConstants;

public class XrefExpander {
    private static Logger LOG = Logger.getLogger(XrefExpander.class.getName());
    OBODoc sourceOBODoc;
    OBODoc targetOBODoc;
    String targetBase;
    Map<String, Rule> treatMap = new HashMap<String, Rule>();
    Map<String, OBODoc> targetDocMap = new HashMap<String, OBODoc>();

    public XrefExpander(OBODoc src) throws InvalidXrefMapException {
        this.sourceOBODoc = src;
        Frame shf = src.getHeaderFrame();
        String ontId = shf.getTagValue(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, String.class);
        String tgtOntId = ontId + "/xref_expansions";
        this.targetOBODoc = new OBODoc();
        Frame thf = new Frame(Frame.FrameType.HEADER);
        thf.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, tgtOntId));
        this.targetOBODoc.setHeaderFrame(thf);
        this.sourceOBODoc.addImportedOBODoc(this.targetOBODoc);
        this.setUp();
    }

    public XrefExpander(OBODoc src, String targetBase) throws InvalidXrefMapException {
        this.sourceOBODoc = src;
        this.targetBase = targetBase;
        this.setUp();
    }

    public XrefExpander(OBODoc src, OBODoc tgt) throws InvalidXrefMapException {
        this.sourceOBODoc = src;
        this.targetOBODoc = tgt;
        this.setUp();
    }

    public void setUp() throws InvalidXrefMapException {
        HashSet<String> relationsUsed = new HashSet<String>();
        HashMap<String, String> relationsUseByIdSpace = new HashMap<String, String>();
        for (Clause c : this.sourceOBODoc.getHeaderFrame().getClauses()) {
            Frame tdf;
            String v = c.getValue(String.class);
            if (v == null) {
                LOG.log(Level.SEVERE, "problem with header clause in xref expansion: " + c);
                continue;
            }
            String[] parts = v.split("\\s");
            String relation = null;
            String idSpace = parts[0];
            if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_EQUIVALENT.getTag())) {
                this.addRule(parts[0], new EquivalenceExpansion());
            } else if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_GENUS_DIFFERENTIA.getTag())) {
                this.addRule(idSpace, new GenusDifferentiaExpansion(parts[1], parts[2]));
                relationsUsed.add(parts[1]);
                relationsUseByIdSpace.put(idSpace, parts[1]);
                relation = parts[1];
            } else if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_REVERSE_GENUS_DIFFERENTIA.getTag())) {
                this.addRule(idSpace, new ReverseGenusDifferentiaExpansion(parts[1], parts[2]));
                relationsUsed.add(parts[1]);
                relationsUseByIdSpace.put(idSpace, parts[1]);
                relation = parts[1];
            } else if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_HAS_SUBCLASS.getTag())) {
                this.addRule(idSpace, new HasSubClassExpansion());
            } else if (c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_IS_A.getTag())) {
                this.addRule(idSpace, new IsaExpansion());
            } else {
                if (!c.getTag().equals(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_RELATIONSHIP.getTag())) continue;
                this.addRule(idSpace, new RelationshipExpansion(parts[1]));
                relationsUsed.add(parts[1]);
                relationsUseByIdSpace.put(idSpace, parts[1]);
                relation = parts[1];
            }
            if (this.targetBase == null) continue;
            OBODoc tgt = new OBODoc();
            Frame thf = new Frame(Frame.FrameType.HEADER);
            thf.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY, this.targetBase + "-" + idSpace.toLowerCase()));
            tgt.setHeaderFrame(thf);
            this.targetDocMap.put(idSpace, tgt);
            this.sourceOBODoc.addImportedOBODoc(tgt);
            if (relation == null || (tdf = this.sourceOBODoc.getTypedefFrame(relation)) == null) continue;
            try {
                tgt.addTypedefFrame(tdf);
            }
            catch (FrameMergeException e2) {
                e2.printStackTrace();
            }
        }
    }

    public OBODoc getTargetDoc(String idSpace) {
        if (this.targetOBODoc != null) {
            return this.targetOBODoc;
        }
        return this.targetDocMap.get(idSpace);
    }

    private void addRule(String db, Rule rule) throws InvalidXrefMapException {
        if (this.treatMap.containsKey(db)) {
            throw new InvalidXrefMapException(db);
        }
        rule.idSpace = db;
        this.treatMap.put(db, rule);
    }

    public void expandXrefs() {
        for (Frame f : this.sourceOBODoc.getTermFrames()) {
            String id2 = f.getTagValue(OBOFormatConstants.OboFormatTag.TAG_ID, String.class);
            Collection<Clause> clauses = f.getClauses(OBOFormatConstants.OboFormatTag.TAG_XREF);
            for (Clause c : clauses) {
                String xid;
                String s;
                Xref x = c.getValue(Xref.class);
                if (x == null || !this.treatMap.containsKey(s = this.getIDSpace(xid = x.getIdref()))) continue;
                this.treatMap.get(s).expand(f, id2, xid);
            }
        }
    }

    private String getIDSpace(String x) {
        String[] parts = x.split(":", 2);
        return parts[0];
    }

    public class RelationshipExpansion
    extends Rule {
        protected String rel;

        public RelationshipExpansion(String rel) {
            this.rel = rel;
        }

        @Override
        public void expand(Frame sf, String id2, String xRef) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP, this.rel);
            c.addValue(xRef);
            this.getTargetFrame(id2).addClause(c);
        }
    }

    public class IsaExpansion
    extends Rule {
        @Override
        public void expand(Frame sf, String id2, String xRef) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, xRef);
            this.getTargetFrame(id2).addClause(c);
        }
    }

    public class ReverseGenusDifferentiaExpansion
    extends Rule {
        protected String rel;
        protected String tgt;

        public ReverseGenusDifferentiaExpansion(String rel, String tgt) {
            this.rel = rel;
            this.tgt = tgt;
        }

        @Override
        public void expand(Frame sf, String id2, String xRef) {
            Clause gc = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF, id2);
            Clause dc = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF);
            dc.setValue(this.rel);
            dc.addValue(this.tgt);
            this.getTargetFrame(xRef).addClause(gc);
            this.getTargetFrame(xRef).addClause(dc);
        }
    }

    public class GenusDifferentiaExpansion
    extends Rule {
        protected String rel;
        protected String tgt;

        public GenusDifferentiaExpansion(String rel, String tgt) {
            this.rel = rel;
            this.tgt = tgt;
        }

        @Override
        public void expand(Frame sf, String id2, String xRef) {
            Clause gc = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF, xRef);
            Clause dc = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF);
            dc.setValue(this.rel);
            dc.addValue(this.tgt);
            this.getTargetFrame(id2).addClause(gc);
            this.getTargetFrame(id2).addClause(dc);
        }
    }

    public class HasSubClassExpansion
    extends Rule {
        @Override
        public void expand(Frame sf, String id2, String xRef) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, id2);
            this.getTargetFrame(xRef).addClause(c);
        }
    }

    public class EquivalenceExpansion
    extends Rule {
        @Override
        public void expand(Frame sf, String id2, String xRef) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO, xRef);
            sf.addClause(c);
        }
    }

    public abstract class Rule {
        protected String xref;
        public String idSpace;

        public abstract void expand(Frame var1, String var2, String var3);

        protected Frame getTargetFrame(String id2) {
            Frame f = XrefExpander.this.getTargetDoc(this.idSpace).getTermFrame(id2);
            if (f == null) {
                try {
                    f = new Frame();
                    f.setId(id2);
                    XrefExpander.this.getTargetDoc(this.idSpace).addTermFrame(f);
                }
                catch (FrameMergeException e2) {
                    e2.printStackTrace();
                }
            }
            return f;
        }
    }
}

