/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.owl;

import java.io.IOException;
import java.io.Writer;
import org.coode.owlapi.functionalrenderer.OWLObjectRenderer;
import org.obolibrary.owl.LabelFunctionalFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;

public class LabelFunctionalSyntaxOntologyStorer
extends AbstractOWLOntologyStorer {
    private static final long serialVersionUID = -6143049869068925168L;

    @Override
    public boolean canStoreOntology(OWLOntologyFormat ontologyFormat) {
        return ontologyFormat instanceof LabelFunctionalFormat;
    }

    @Override
    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer writer2, OWLOntologyFormat format2) throws OWLOntologyStorageException {
        try {
            OWLObjectRenderer renderer2 = new OWLObjectRenderer(ontology, writer2);
            renderer2.setPrefixManager(new LabelPrefixManager(ontology));
            ontology.accept(renderer2);
            writer2.flush();
        }
        catch (IOException e2) {
            throw new OWLOntologyStorageException(e2);
        }
    }

    @Override
    protected void storeOntology(OWLOntology ontology, Writer writer2, OWLOntologyFormat format2) throws OWLOntologyStorageException {
        this.storeOntology(ontology.getOWLOntologyManager(), ontology, writer2, format2);
    }

    static class LabelPrefixManager
    extends DefaultPrefixManager {
        private static final long serialVersionUID = 3814624420610086487L;
        private final OWLOntology ontology;

        LabelPrefixManager(OWLOntology ontology) {
            this.ontology = ontology;
        }

        @Override
        public String getPrefixIRI(IRI iri) {
            for (OWLAnnotationAssertionAxiom annotation : this.ontology.getAnnotationAssertionAxioms(iri)) {
                OWLAnnotationValue value;
                if (!annotation.getProperty().isLabel() || (value = annotation.getValue()) == null || !(value instanceof OWLLiteral)) continue;
                return "<" + ((OWLLiteral)value).getLiteral() + ">";
            }
            return super.getPrefixIRI(iri);
        }
    }
}

