/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Configuration;
import org.semanticweb.HermiT.EntailmentChecker;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.blocking.AncestorBlocking;
import org.semanticweb.HermiT.blocking.AnywhereBlocking;
import org.semanticweb.HermiT.blocking.AnywhereValidatedBlocking;
import org.semanticweb.HermiT.blocking.BlockingSignatureCache;
import org.semanticweb.HermiT.blocking.BlockingStrategy;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.blocking.PairWiseDirectBlockingChecker;
import org.semanticweb.HermiT.blocking.SingleDirectBlockingChecker;
import org.semanticweb.HermiT.blocking.ValidatedPairwiseDirectBlockingChecker;
import org.semanticweb.HermiT.blocking.ValidatedSingleDirectBlockingChecker;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.existentials.AbstractExpansionStrategy;
import org.semanticweb.HermiT.existentials.CreationOrderStrategy;
import org.semanticweb.HermiT.existentials.IndividualReuseStrategy;
import org.semanticweb.HermiT.hierarchy.ClassificationProgressMonitor;
import org.semanticweb.HermiT.hierarchy.DeterministicClassification;
import org.semanticweb.HermiT.hierarchy.Hierarchy;
import org.semanticweb.HermiT.hierarchy.HierarchyDumperFSS;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;
import org.semanticweb.HermiT.hierarchy.HierarchyPrinterFSS;
import org.semanticweb.HermiT.hierarchy.HierarchySearch;
import org.semanticweb.HermiT.hierarchy.InstanceManager;
import org.semanticweb.HermiT.hierarchy.QuasiOrderClassification;
import org.semanticweb.HermiT.hierarchy.QuasiOrderClassificationForRoles;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.monitor.TableauMonitorFork;
import org.semanticweb.HermiT.monitor.Timer;
import org.semanticweb.HermiT.monitor.TimerWithPause;
import org.semanticweb.HermiT.structural.BuiltInPropertyManager;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.HermiT.structural.OWLAxiomsExpressivity;
import org.semanticweb.HermiT.structural.OWLClausification;
import org.semanticweb.HermiT.structural.OWLNormalization;
import org.semanticweb.HermiT.structural.ObjectPropertyInclusionManager;
import org.semanticweb.HermiT.structural.ReducedABoxOnlyClausification;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reasoner
implements OWLReasoner {
    protected final OntologyChangeListener m_ontologyChangeListener = new OntologyChangeListener();
    protected final Configuration m_configuration;
    protected final OWLOntology m_rootOntology;
    protected final List<OWLOntologyChange> m_pendingChanges;
    protected final Collection<DescriptionGraph> m_descriptionGraphs;
    protected final InterruptFlag m_interruptFlag;
    protected ObjectPropertyInclusionManager m_objectPropertyInclusionManager;
    protected DLOntology m_dlOntology;
    protected Prefixes m_prefixes;
    protected Tableau m_tableau;
    protected Boolean m_isConsistent;
    protected Hierarchy<AtomicConcept> m_atomicConceptHierarchy;
    protected Hierarchy<Role> m_objectRoleHierarchy;
    protected Hierarchy<AtomicRole> m_dataRoleHierarchy;
    protected Map<Role, Set<HierarchyNode<AtomicConcept>>> m_directObjectRoleDomains;
    protected Map<Role, Set<HierarchyNode<AtomicConcept>>> m_directObjectRoleRanges;
    protected Map<AtomicRole, Set<HierarchyNode<AtomicConcept>>> m_directDataRoleDomains;
    protected Map<HierarchyNode<AtomicConcept>, Set<HierarchyNode<AtomicConcept>>> m_directDisjointClasses;
    protected InstanceManager m_instanceManager;

    public Reasoner(OWLOntology oWLOntology) {
        this(new Configuration(), oWLOntology, null);
    }

    public Reasoner(Configuration configuration, OWLOntology oWLOntology) {
        this(configuration, oWLOntology, null);
    }

    public Reasoner(Configuration configuration, OWLOntology oWLOntology, Collection<DescriptionGraph> collection) {
        this.m_configuration = configuration;
        this.m_rootOntology = oWLOntology;
        this.m_pendingChanges = new ArrayList<OWLOntologyChange>();
        this.m_rootOntology.getOWLOntologyManager().addOntologyChangeListener(this.m_ontologyChangeListener);
        this.m_descriptionGraphs = collection == null ? Collections.emptySet() : collection;
        this.m_interruptFlag = new InterruptFlag(configuration.individualTaskTimeout);
        this.m_directDisjointClasses = new HashMap<HierarchyNode<AtomicConcept>, Set<HierarchyNode<AtomicConcept>>>();
        this.loadOntology();
    }

    protected void loadOntology() {
        this.clearState();
        OWLClausification oWLClausification = new OWLClausification(this.m_configuration);
        Object[] objectArray = oWLClausification.preprocessAndClausify(this.m_rootOntology, this.m_descriptionGraphs);
        this.m_objectPropertyInclusionManager = (ObjectPropertyInclusionManager)objectArray[0];
        this.m_dlOntology = (DLOntology)objectArray[1];
        this.createPrefixes();
        this.m_tableau = Reasoner.createTableau(this.m_interruptFlag, this.m_configuration, this.m_dlOntology, null, this.m_prefixes);
        this.m_instanceManager = null;
    }

    protected void createPrefixes() {
        this.m_prefixes = new Prefixes();
        this.m_prefixes.declareSemanticWebPrefixes();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Individual serializable : this.m_dlOntology.getAllIndividuals()) {
            if (serializable.isAnonymous()) {
                this.addIRI(serializable.getIRI(), hashSet2);
                continue;
            }
            this.addIRI(serializable.getIRI(), hashSet);
        }
        this.m_prefixes.declareInternalPrefixes(hashSet, hashSet2);
        this.m_prefixes.declareDefaultPrefix(this.m_dlOntology.getOntologyIRI() + "#");
        OWLOntologyFormat oWLOntologyFormat = this.m_rootOntology.getOWLOntologyManager().getOntologyFormat(this.m_rootOntology);
        if (oWLOntologyFormat instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat prefixOWLOntologyFormat = (PrefixOWLOntologyFormat)oWLOntologyFormat;
            for (String string2 : prefixOWLOntologyFormat.getPrefixName2PrefixMap().keySet()) {
                String string3 = prefixOWLOntologyFormat.getPrefixName2PrefixMap().get(string2);
                if (this.m_prefixes.getPrefixName(string3) != null) continue;
                try {
                    this.m_prefixes.declarePrefix(string2, string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    protected void addIRI(String string2, Set<String> set2) {
        int n;
        if (!Prefixes.isInternalIRI(string2) && (n = string2.lastIndexOf(35)) != -1) {
            String string3 = string2.substring(0, n + 1);
            set2.add(string3);
        }
    }

    protected void finalize() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.m_rootOntology.getOWLOntologyManager().removeOntologyChangeListener(this.m_ontologyChangeListener);
        this.clearState();
        this.m_interruptFlag.dispose();
    }

    protected void clearState() {
        this.m_pendingChanges.clear();
        this.m_dlOntology = null;
        this.m_prefixes = null;
        this.m_tableau = null;
        this.m_isConsistent = null;
        this.m_atomicConceptHierarchy = null;
        this.m_objectRoleHierarchy = null;
        this.m_dataRoleHierarchy = null;
        this.m_directObjectRoleDomains = new HashMap<Role, Set<HierarchyNode<AtomicConcept>>>();
        this.m_directObjectRoleRanges = new HashMap<Role, Set<HierarchyNode<AtomicConcept>>>();
        this.m_directDataRoleDomains = new HashMap<AtomicRole, Set<HierarchyNode<AtomicConcept>>>();
        this.m_directDisjointClasses = new HashMap<HierarchyNode<AtomicConcept>, Set<HierarchyNode<AtomicConcept>>>();
        this.m_instanceManager = null;
    }

    @Override
    public void interrupt() {
        this.m_interruptFlag.interrupt();
    }

    public OWLDataFactory getDataFactory() {
        return this.m_rootOntology.getOWLOntologyManager().getOWLDataFactory();
    }

    @Override
    public String getReasonerName() {
        return this.getClass().getPackage().getImplementationTitle();
    }

    @Override
    public Version getReasonerVersion() {
        int n;
        String string2 = Reasoner.class.getPackage().getImplementationVersion();
        int[] nArray = new int[4];
        if (string2 != null) {
            String[] stringArray = string2.split("\\.");
            for (n = 0; n < stringArray.length; ++n) {
                nArray[n] = Integer.parseInt(stringArray[n]);
            }
        }
        while (n < nArray.length) {
            nArray[n] = 0;
            ++n;
        }
        return new Version(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    @Override
    public OWLOntology getRootOntology() {
        return this.m_rootOntology;
    }

    @Override
    public long getTimeOut() {
        return this.m_configuration.individualTaskTimeout;
    }

    @Override
    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.m_configuration.getIndividualNodeSetPolicy();
    }

    @Override
    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.m_configuration.getFreshEntityPolicy();
    }

    public Prefixes getPrefixes() {
        return this.m_prefixes;
    }

    public DLOntology getDLOntology() {
        return this.m_dlOntology;
    }

    public Configuration getConfiguration() {
        return this.m_configuration.clone();
    }

    @Override
    public BufferingMode getBufferingMode() {
        return this.m_configuration.bufferChanges ? BufferingMode.BUFFERING : BufferingMode.NON_BUFFERING;
    }

    @Override
    public Set<OWLAxiom> getPendingAxiomAdditions() {
        HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
        for (OWLOntologyChange oWLOntologyChange : this.m_pendingChanges) {
            if (!(oWLOntologyChange instanceof AddAxiom)) continue;
            hashSet.add(oWLOntologyChange.getAxiom());
        }
        return hashSet;
    }

    @Override
    public Set<OWLAxiom> getPendingAxiomRemovals() {
        HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
        for (OWLOntologyChange oWLOntologyChange : this.m_pendingChanges) {
            if (!(oWLOntologyChange instanceof RemoveAxiom)) continue;
            hashSet.add(oWLOntologyChange.getAxiom());
        }
        return hashSet;
    }

    @Override
    public List<OWLOntologyChange> getPendingChanges() {
        return this.m_pendingChanges;
    }

    @Override
    public void flush() {
        if (!this.m_pendingChanges.isEmpty()) {
            if (this.canProcessPendingChangesIncrementally()) {
                Set<OWLOntology> set2 = this.m_rootOntology.getImportsClosure();
                Set<Atom> set3 = this.m_dlOntology.getPositiveFacts();
                Set<Atom> set4 = this.m_dlOntology.getNegativeFacts();
                HashSet<Individual> hashSet = new HashSet<Individual>();
                Set<AtomicConcept> set5 = this.m_dlOntology.getAllAtomicConcepts();
                Set<AtomicRole> set6 = this.m_dlOntology.getAllAtomicObjectRoles();
                Set<AtomicRole> set7 = this.m_dlOntology.getAllAtomicDataRoles();
                ReducedABoxOnlyClausification reducedABoxOnlyClausification = new ReducedABoxOnlyClausification(this.m_configuration, this.getDataFactory(), set5, set6, set7);
                for (OWLOntologyChange object : this.m_pendingChanges) {
                    OWLAxiom oWLAxiom;
                    if (!set2.contains(object.getOntology()) || !(oWLAxiom = object.getAxiom()).isLogicalAxiom()) continue;
                    reducedABoxOnlyClausification.clausify((OWLIndividualAxiom)oWLAxiom);
                    if (object instanceof AddAxiom) {
                        set3.addAll(reducedABoxOnlyClausification.getPositiveFacts());
                        set4.addAll(reducedABoxOnlyClausification.getNegativeFacts());
                        continue;
                    }
                    set3.removeAll(reducedABoxOnlyClausification.getPositiveFacts());
                    set4.removeAll(reducedABoxOnlyClausification.getNegativeFacts());
                }
                for (Atom atom2 : set3) {
                    atom2.getIndividuals(hashSet);
                }
                for (Atom atom3 : set4) {
                    atom3.getIndividuals(hashSet);
                }
                this.m_dlOntology = new DLOntology(this.m_dlOntology.getOntologyIRI(), this.m_dlOntology.getDLClauses(), set3, set4, set5, set6, this.m_dlOntology.getAllComplexObjectRoles(), set7, this.m_dlOntology.getAllUnknownDatatypeRestrictions(), this.m_dlOntology.getDefinedDatatypeIRIs(), hashSet, this.m_dlOntology.hasInverseRoles(), this.m_dlOntology.hasAtMostRestrictions(), this.m_dlOntology.hasNominals(), this.m_dlOntology.hasDatatypes());
                this.m_tableau = new Tableau(this.m_interruptFlag, this.m_tableau.getTableauMonitor(), this.m_tableau.getExistentialsExpansionStrategy(), this.m_configuration.useDisjunctionLearning, this.m_dlOntology, null, this.m_configuration.parameters);
                this.m_instanceManager = null;
                this.m_isConsistent = null;
            } else {
                this.loadOntology();
            }
            this.m_pendingChanges.clear();
        }
    }

    public boolean canProcessPendingChangesIncrementally() {
        Set<OWLOntology> set2 = this.m_rootOntology.getImportsClosure();
        for (OWLOntologyChange oWLOntologyChange : this.m_pendingChanges) {
            OWLObject oWLObject;
            if (!set2.contains(oWLOntologyChange.getOntology())) continue;
            if (this.m_dlOntology.hasNominals() || !this.m_dlOntology.getAllDescriptionGraphs().isEmpty()) {
                return false;
            }
            if (!oWLOntologyChange.isAxiomChange()) {
                return false;
            }
            OWLAxiom oWLAxiom = oWLOntologyChange.getAxiom();
            if (oWLAxiom.isLogicalAxiom()) {
                if (oWLAxiom instanceof OWLClassAssertionAxiom) {
                    OWLObject oWLObject2;
                    OWLObject oWLObject3;
                    OWLObject oWLObject4;
                    oWLObject = (OWLClassAssertionAxiom)oWLAxiom;
                    OWLIndividual oWLIndividual = oWLObject.getIndividual();
                    if (!this.isDefined(oWLIndividual)) {
                        return false;
                    }
                    OWLClassExpression oWLClassExpression = oWLObject.getClassExpression();
                    if (oWLClassExpression instanceof OWLClass) {
                        if (this.isDefined((OWLClass)oWLClassExpression) || Prefixes.isInternalIRI(((OWLClass)oWLClassExpression).getIRI().toString())) continue;
                        return false;
                    }
                    if (oWLClassExpression instanceof OWLObjectHasSelf) {
                        oWLObject4 = ((OWLObjectPropertyExpression)((OWLObjectHasSelf)oWLClassExpression).getProperty()).getNamedProperty();
                        if (this.isDefined((OWLObjectProperty)oWLObject4) || Prefixes.isInternalIRI(oWLObject4.getIRI().toString())) continue;
                        return false;
                    }
                    if (oWLClassExpression instanceof OWLObjectHasValue) {
                        oWLObject4 = (OWLObjectHasValue)oWLClassExpression;
                        oWLObject3 = ((OWLObjectPropertyExpression)oWLObject4.getProperty()).getNamedProperty();
                        oWLObject2 = (OWLIndividual)oWLObject4.getValue();
                        if ((this.isDefined((OWLObjectProperty)oWLObject3) || Prefixes.isInternalIRI(oWLObject3.getIRI().toString())) && this.isDefined((OWLIndividual)oWLObject2)) continue;
                        return false;
                    }
                    if (oWLClassExpression instanceof OWLObjectComplementOf) {
                        oWLObject4 = ((OWLObjectComplementOf)oWLClassExpression).getOperand();
                        if (oWLObject4 instanceof OWLClass) {
                            oWLObject3 = (OWLClass)oWLObject4;
                            if (this.isDefined((OWLClass)oWLObject3) || Prefixes.isInternalIRI(oWLObject3.getIRI().toString())) continue;
                            return false;
                        }
                        if (oWLObject4 instanceof OWLObjectHasSelf) {
                            oWLObject3 = (OWLObjectHasSelf)oWLObject4;
                            oWLObject2 = ((OWLObjectPropertyExpression)oWLObject3.getProperty()).getNamedProperty();
                            if (this.isDefined((OWLObjectProperty)oWLObject2) || Prefixes.isInternalIRI(oWLObject2.getIRI().toString())) continue;
                            return false;
                        }
                        if (oWLObject4 instanceof OWLObjectHasValue) {
                            oWLObject3 = (OWLObjectHasValue)oWLObject4;
                            oWLObject2 = ((OWLObjectPropertyExpression)oWLObject3.getProperty()).getNamedProperty();
                            OWLIndividual oWLIndividual2 = (OWLIndividual)oWLObject3.getValue();
                            if ((this.isDefined((OWLObjectProperty)oWLObject2) || Prefixes.isInternalIRI(oWLObject2.getIRI().toString())) && this.isDefined(oWLIndividual2)) continue;
                            return false;
                        }
                        return false;
                    }
                    return false;
                }
                if (oWLAxiom instanceof OWLIndividualAxiom) continue;
                return false;
            }
            if (!(oWLAxiom instanceof OWLDeclarationAxiom)) continue;
            oWLObject = ((OWLDeclarationAxiom)oWLAxiom).getEntity();
            if (oWLObject.isOWLClass() && !this.isDefined((OWLClass)oWLObject) && !Prefixes.isInternalIRI(((OWLClass)oWLObject).getIRI().toString())) {
                return false;
            }
            if (oWLObject.isOWLObjectProperty() && !this.isDefined((OWLObjectProperty)oWLObject) && !Prefixes.isInternalIRI(((OWLObjectProperty)oWLObject).getIRI().toString())) {
                return false;
            }
            if (!oWLObject.isOWLDataProperty() || this.isDefined((OWLDataProperty)oWLObject) || Prefixes.isInternalIRI(((OWLDataProperty)oWLObject).getIRI().toString())) continue;
            return false;
        }
        return true;
    }

    public boolean isDefined(OWLClass oWLClass) {
        AtomicConcept atomicConcept = AtomicConcept.create(oWLClass.getIRI().toString());
        return this.m_dlOntology.containsAtomicConcept(atomicConcept) || AtomicConcept.THING.equals(atomicConcept) || AtomicConcept.NOTHING.equals(atomicConcept);
    }

    public boolean isDefined(OWLIndividual oWLIndividual) {
        Individual individual = oWLIndividual.isAnonymous() ? Individual.createAnonymous(((Object)oWLIndividual.asOWLAnonymousIndividual().getID()).toString()) : Individual.create(oWLIndividual.asOWLNamedIndividual().getIRI().toString());
        return this.m_dlOntology.containsIndividual(individual);
    }

    public boolean isDefined(OWLObjectProperty oWLObjectProperty) {
        AtomicRole atomicRole = AtomicRole.create(oWLObjectProperty.getIRI().toString());
        return this.m_dlOntology.containsObjectRole(atomicRole) || AtomicRole.TOP_OBJECT_ROLE.equals(oWLObjectProperty) || AtomicRole.BOTTOM_OBJECT_ROLE.equals(oWLObjectProperty);
    }

    public boolean isDefined(OWLDataProperty oWLDataProperty) {
        AtomicRole atomicRole = AtomicRole.create(oWLDataProperty.getIRI().toString());
        return this.m_dlOntology.containsDataRole(atomicRole) || AtomicRole.TOP_DATA_ROLE.equals(atomicRole) || AtomicRole.BOTTOM_DATA_ROLE.equals(atomicRole);
    }

    @Override
    public Set<InferenceType> getPrecomputableInferenceTypes() {
        HashSet<InferenceType> hashSet = new HashSet<InferenceType>();
        hashSet.add(InferenceType.CLASS_HIERARCHY);
        hashSet.add(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        hashSet.add(InferenceType.DATA_PROPERTY_HIERARCHY);
        hashSet.add(InferenceType.CLASS_ASSERTIONS);
        hashSet.add(InferenceType.OBJECT_PROPERTY_ASSERTIONS);
        hashSet.add(InferenceType.SAME_INDIVIDUAL);
        return hashSet;
    }

    @Override
    public boolean isPrecomputed(InferenceType inferenceType) {
        switch (inferenceType) {
            case CLASS_HIERARCHY: {
                return this.m_atomicConceptHierarchy != null;
            }
            case OBJECT_PROPERTY_HIERARCHY: {
                return this.m_objectRoleHierarchy != null;
            }
            case DATA_PROPERTY_HIERARCHY: {
                return this.m_dataRoleHierarchy != null;
            }
            case CLASS_ASSERTIONS: {
                return this.m_instanceManager != null && this.m_instanceManager.realizationCompleted();
            }
            case OBJECT_PROPERTY_ASSERTIONS: {
                return this.m_instanceManager != null && this.m_instanceManager.objectPropertyRealizationCompleted();
            }
            case SAME_INDIVIDUAL: {
                return this.m_instanceManager != null && this.m_instanceManager.sameAsIndividualsComputed();
            }
        }
        return false;
    }

    @Override
    public void precomputeInferences(InferenceType ... inferenceTypeArray) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.checkPreConditions(new OWLObject[0]);
        boolean bl = this.m_configuration.prepareReasonerInferences == null;
        HashSet<InferenceType> hashSet = new HashSet<InferenceType>(Arrays.asList(inferenceTypeArray));
        if (hashSet.contains((Object)InferenceType.CLASS_HIERARCHY) && (bl || this.m_configuration.prepareReasonerInferences.classClassificationRequired)) {
            this.classifyClasses();
        }
        if (hashSet.contains((Object)InferenceType.OBJECT_PROPERTY_HIERARCHY) && (bl || this.m_configuration.prepareReasonerInferences.objectPropertyClassificationRequired)) {
            this.classifyObjectProperties();
        }
        if (hashSet.contains((Object)InferenceType.DATA_PROPERTY_HIERARCHY) && (bl || this.m_configuration.prepareReasonerInferences.dataPropertyClassificationRequired)) {
            this.classifyDataProperties();
        }
        if (hashSet.contains((Object)InferenceType.CLASS_ASSERTIONS) && (bl || this.m_configuration.prepareReasonerInferences.realisationRequired)) {
            this.realise();
            if (this.m_configuration.individualNodeSetPolicy == IndividualNodeSetPolicy.BY_SAME_AS || this.m_configuration.prepareReasonerInferences != null && this.m_configuration.prepareReasonerInferences.sameAs) {
                this.precomputeSameAsEquivalenceClasses();
            }
        }
        if (hashSet.contains((Object)InferenceType.OBJECT_PROPERTY_ASSERTIONS) && (bl || this.m_configuration.prepareReasonerInferences.objectPropertyRealisationRequired)) {
            this.realiseObjectProperties();
        }
        if (hashSet.contains((Object)InferenceType.SAME_INDIVIDUAL) && (bl || this.m_configuration.prepareReasonerInferences.sameAs)) {
            this.precomputeSameAsEquivalenceClasses();
        }
    }

    protected void initialisePropertiesInstanceManager() {
        if (this.m_instanceManager == null || !this.m_instanceManager.arePropertiesInitialised()) {
            if (this.m_configuration.reasonerProgressMonitor != null) {
                this.m_configuration.reasonerProgressMonitor.reasonerTaskStarted("Initializing property instance data structures");
            }
            if (this.m_instanceManager == null) {
                this.m_instanceManager = new InstanceManager(this.m_interruptFlag, this, this.m_atomicConceptHierarchy, this.m_objectRoleHierarchy);
            }
            boolean bl = true;
            if (this.m_isConsistent != null && !this.m_isConsistent.booleanValue()) {
                this.m_instanceManager.setInconsistent();
            } else {
                int n = this.m_dlOntology.getDLClauses().size();
                int n2 = this.m_dlOntology.getAllComplexObjectRoles().size();
                if (this.m_dlOntology.hasInverseRoles()) {
                    n2 /= 2;
                }
                int n3 = this.m_dlOntology.getAllIndividuals().size();
                int n4 = 2 * n2 * n3 / 10000 + 1;
                int n5 = n2 * n3;
                int n6 = 5 * n2 * n3 / n4;
                int n7 = n5 / n4 + n + n3;
                int n8 = n3 + n2 * n3;
                int n9 = n5 + n4 * n6 + n4 * n7 + n8;
                int n10 = 0;
                int n11 = 0;
                OWLAxiom[] oWLAxiomArray = this.m_instanceManager.getAxiomsForReadingOffCompexProperties(this.getDataFactory(), this.m_configuration.reasonerProgressMonitor, n11, n9);
                n11 += n5 / n4;
                boolean bl2 = true;
                while (bl2) {
                    Tableau tableau = this.getTableau(oWLAxiomArray);
                    n11 += n6;
                    if (this.m_configuration.reasonerProgressMonitor != null) {
                        this.m_configuration.reasonerProgressMonitor.reasonerTaskProgressChanged(n11, n9);
                    }
                    bl = tableau.isSatisfiable(true, true, null, null, null, null, this.m_instanceManager.getNodesForIndividuals(), new ReasoningTaskDescription(false, "Initial consistency check plus reading-off known and possible class and property instances (individual " + n10 + " to " + this.m_instanceManager.getCurrentIndividualIndex() + ").", new Object[0]));
                    n11 += n7;
                    if (this.m_configuration.reasonerProgressMonitor != null) {
                        this.m_configuration.reasonerProgressMonitor.reasonerTaskProgressChanged(n11, n9);
                    }
                    if (!bl) {
                        this.m_instanceManager.setInconsistent();
                        break;
                    }
                    n11 = this.m_instanceManager.initializeKnowAndPossiblePropertyInstances(tableau, this.m_configuration.reasonerProgressMonitor, n10, n11, n9);
                    tableau.clearAdditionalDLOntology();
                    n10 = this.m_instanceManager.getCurrentIndividualIndex();
                    oWLAxiomArray = this.m_instanceManager.getAxiomsForReadingOffCompexProperties(this.getDataFactory(), this.m_configuration.reasonerProgressMonitor, n11, n9);
                    n11 += n5 / n4;
                    bl2 = oWLAxiomArray.length > 0;
                }
                if (this.m_isConsistent == null) {
                    this.m_isConsistent = bl;
                }
            }
            if (this.m_configuration.reasonerProgressMonitor != null) {
                this.m_configuration.reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
    }

    protected void initialiseClassInstanceManager() {
        if (this.m_instanceManager == null || !this.m_instanceManager.areClassesInitialised()) {
            if (this.m_configuration.reasonerProgressMonitor != null) {
                this.m_configuration.reasonerProgressMonitor.reasonerTaskStarted("Initializing class instance data structures");
            }
            if (this.m_instanceManager == null) {
                this.m_instanceManager = new InstanceManager(this.m_interruptFlag, this, this.m_atomicConceptHierarchy, this.m_objectRoleHierarchy);
            }
            boolean bl = true;
            if (this.m_isConsistent != null && !this.m_isConsistent.booleanValue()) {
                this.m_instanceManager.setInconsistent();
            } else {
                int n = this.m_dlOntology.getDLClauses().size();
                int n2 = this.m_dlOntology.getAllIndividuals().size();
                int n3 = n + n2;
                int n4 = n2;
                int n5 = n3 + n4;
                int n6 = 0;
                Tableau tableau = this.getTableau();
                bl = tableau.isSatisfiable(true, true, null, null, null, null, this.m_instanceManager.getNodesForIndividuals(), new ReasoningTaskDescription(false, "Initial tableau for reading-off known and possible class instances.", new Object[0]));
                n6 += n3;
                if (this.m_configuration.reasonerProgressMonitor != null) {
                    this.m_configuration.reasonerProgressMonitor.reasonerTaskProgressChanged(n6, n5);
                }
                if (!bl) {
                    this.m_instanceManager.setInconsistent();
                } else {
                    this.m_instanceManager.initializeKnowAndPossibleClassInstances(tableau, this.m_configuration.reasonerProgressMonitor, n6, n5);
                }
                if (this.m_isConsistent == null) {
                    this.m_isConsistent = bl;
                }
                tableau.clearAdditionalDLOntology();
            }
            if (this.m_configuration.reasonerProgressMonitor != null) {
                this.m_configuration.reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
    }

    @Override
    public boolean isConsistent() {
        this.flushChangesIfRequired();
        if (this.m_isConsistent == null) {
            this.m_isConsistent = this.getTableau().isSatisfiable(true, true, null, null, null, null, null, ReasoningTaskDescription.isABoxSatisfiable());
        }
        return this.m_isConsistent;
    }

    @Override
    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return true;
    }

    @Override
    public boolean isEntailed(OWLAxiom oWLAxiom) {
        this.checkPreConditions(oWLAxiom);
        if (!this.isConsistent()) {
            return true;
        }
        EntailmentChecker entailmentChecker = new EntailmentChecker(this, this.getDataFactory());
        return entailmentChecker.entails(oWLAxiom);
    }

    @Override
    public boolean isEntailed(Set<? extends OWLAxiom> set2) {
        this.checkPreConditions(set2.toArray(new OWLObject[0]));
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        EntailmentChecker entailmentChecker = new EntailmentChecker(this, this.getDataFactory());
        return entailmentChecker.entails(set2);
    }

    @Deprecated
    public void classify() {
        this.classifyClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classifyClasses() {
        this.checkPreConditions(new OWLObject[0]);
        if (this.m_atomicConceptHierarchy == null) {
            HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>();
            hashSet.add(AtomicConcept.THING);
            hashSet.add(AtomicConcept.NOTHING);
            for (AtomicConcept object : this.m_dlOntology.getAllAtomicConcepts()) {
                if (Prefixes.isInternalIRI(object.getIRI())) continue;
                hashSet.add(object);
            }
            if (!this.m_isConsistent.booleanValue()) {
                this.m_atomicConceptHierarchy = Hierarchy.emptyHierarchy(hashSet, AtomicConcept.THING, AtomicConcept.NOTHING);
            } else {
                try {
                    final int n = hashSet.size();
                    if (this.m_configuration.reasonerProgressMonitor != null) {
                        this.m_configuration.reasonerProgressMonitor.reasonerTaskStarted("Building the class hierarchy...");
                    }
                    ClassificationProgressMonitor classificationProgressMonitor = new ClassificationProgressMonitor(){
                        protected int m_processedConcepts = 0;

                        public void elementClassified(AtomicConcept atomicConcept) {
                            ++this.m_processedConcepts;
                            if (Reasoner.this.m_configuration.reasonerProgressMonitor != null) {
                                Reasoner.this.m_configuration.reasonerProgressMonitor.reasonerTaskProgressChanged(this.m_processedConcepts, n);
                            }
                        }
                    };
                    this.m_atomicConceptHierarchy = this.classifyAtomicConcepts(this.getTableau(), classificationProgressMonitor, AtomicConcept.THING, AtomicConcept.NOTHING, hashSet, this.m_configuration.forceQuasiOrderClassification);
                    if (this.m_instanceManager != null) {
                        this.m_instanceManager.setToClassifiedConceptHierarchy(this.m_atomicConceptHierarchy);
                    }
                }
                finally {
                    if (this.m_configuration.reasonerProgressMonitor != null) {
                        this.m_configuration.reasonerProgressMonitor.reasonerTaskStopped();
                    }
                }
            }
        }
    }

    @Override
    public Node<OWLClass> getTopClassNode() {
        this.classifyClasses();
        return this.atomicConceptHierarchyNodeToNode(this.m_atomicConceptHierarchy.getTopNode());
    }

    @Override
    public Node<OWLClass> getBottomClassNode() {
        this.classifyClasses();
        return this.atomicConceptHierarchyNodeToNode(this.m_atomicConceptHierarchy.getBottomNode());
    }

    @Override
    public boolean isSatisfiable(OWLClassExpression oWLClassExpression) {
        this.checkPreConditions(oWLClassExpression);
        if (!this.isConsistent()) {
            return false;
        }
        if (oWLClassExpression instanceof OWLClass && this.m_atomicConceptHierarchy != null) {
            AtomicConcept atomicConcept = Reasoner.H((OWLClass)oWLClassExpression);
            HierarchyNode<AtomicConcept> hierarchyNode = this.m_atomicConceptHierarchy.getNodeForElement(atomicConcept);
            return hierarchyNode != this.m_atomicConceptHierarchy.getBottomNode();
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual");
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLClassExpression, oWLAnonymousIndividual);
        Tableau tableau = this.getTableau(oWLClassAssertionAxiom);
        return tableau.isSatisfiable(true, null, null, null, null, null, ReasoningTaskDescription.isConceptSatisfiable(oWLClassExpression));
    }

    protected boolean isSubClassOf(OWLClassExpression oWLClassExpression, OWLClassExpression oWLClassExpression2) {
        this.checkPreConditions(oWLClassExpression, oWLClassExpression2);
        if (!this.isConsistent() || oWLClassExpression.isOWLNothing() || oWLClassExpression2.isOWLThing()) {
            return true;
        }
        if (oWLClassExpression instanceof OWLClass && oWLClassExpression2 instanceof OWLClass) {
            AtomicConcept atomicConcept = Reasoner.H((OWLClass)oWLClassExpression);
            AtomicConcept atomicConcept2 = Reasoner.H((OWLClass)oWLClassExpression2);
            if (this.m_atomicConceptHierarchy != null && !this.containsFreshEntities(oWLClassExpression, oWLClassExpression2)) {
                HierarchyNode<AtomicConcept> hierarchyNode = this.m_atomicConceptHierarchy.getNodeForElement(atomicConcept);
                return hierarchyNode.isEquivalentElement(atomicConcept2) || hierarchyNode.isAncestorElement(atomicConcept2);
            }
            Tableau tableau = this.getTableau();
            Individual individual = Individual.createAnonymous("fresh-individual");
            Atom atom2 = Atom.create(atomicConcept, individual);
            Atom atom3 = Atom.create(atomicConcept2, individual);
            return !tableau.isSatisfiable(true, Collections.singleton(atom2), Collections.singleton(atom3), null, null, null, ReasoningTaskDescription.isConceptSubsumedBy(atomicConcept, atomicConcept2));
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual");
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLClassExpression, oWLAnonymousIndividual);
        OWLClassAssertionAxiom oWLClassAssertionAxiom2 = oWLDataFactory.getOWLClassAssertionAxiom(oWLClassExpression2.getObjectComplementOf(), oWLAnonymousIndividual);
        Tableau tableau = this.getTableau(oWLClassAssertionAxiom, oWLClassAssertionAxiom2);
        boolean bl = tableau.isSatisfiable(true, null, null, null, null, null, ReasoningTaskDescription.isConceptSubsumedBy(oWLClassExpression, oWLClassExpression2));
        tableau.clearAdditionalDLOntology();
        return !bl;
    }

    @Override
    public Node<OWLClass> getEquivalentClasses(OWLClassExpression oWLClassExpression) {
        HierarchyNode<AtomicConcept> hierarchyNode = this.getHierarchyNode(oWLClassExpression);
        return this.atomicConceptHierarchyNodeToNode(hierarchyNode);
    }

    @Override
    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression oWLClassExpression, boolean bl) {
        Set<HierarchyNode<AtomicConcept>> set2;
        HierarchyNode<AtomicConcept> hierarchyNode = this.getHierarchyNode(oWLClassExpression);
        if (bl) {
            set2 = hierarchyNode.getParentNodes();
        } else {
            set2 = new HashSet<HierarchyNode<AtomicConcept>>(hierarchyNode.getAncestorNodes());
            set2.remove(hierarchyNode);
        }
        return this.atomicConceptHierarchyNodesToNodeSet(set2);
    }

    @Override
    public NodeSet<OWLClass> getSubClasses(OWLClassExpression oWLClassExpression, boolean bl) {
        Set<HierarchyNode<AtomicConcept>> set2;
        HierarchyNode<AtomicConcept> hierarchyNode = this.getHierarchyNode(oWLClassExpression);
        if (bl) {
            set2 = hierarchyNode.getChildNodes();
        } else {
            set2 = new HashSet<HierarchyNode<AtomicConcept>>(hierarchyNode.getDescendantNodes());
            set2.remove(hierarchyNode);
        }
        return this.atomicConceptHierarchyNodesToNodeSet(set2);
    }

    @Override
    public Node<OWLClass> getUnsatisfiableClasses() {
        this.classifyClasses();
        HierarchyNode<AtomicConcept> hierarchyNode = this.m_atomicConceptHierarchy.getBottomNode();
        return this.atomicConceptHierarchyNodeToNode(hierarchyNode);
    }

    @Override
    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression oWLClassExpression) {
        this.checkPreConditions(oWLClassExpression);
        this.classifyClasses();
        if (oWLClassExpression.isOWLNothing() || !this.m_isConsistent.booleanValue()) {
            HierarchyNode<AtomicConcept> hierarchyNode = this.m_atomicConceptHierarchy.getBottomNode();
            return this.atomicConceptHierarchyNodesToNodeSet(hierarchyNode.getAncestorNodes());
        }
        if (oWLClassExpression.isOWLThing()) {
            HierarchyNode<AtomicConcept> hierarchyNode = this.m_atomicConceptHierarchy.getBottomNode();
            return this.atomicConceptHierarchyNodesToNodeSet(Collections.singleton(hierarchyNode));
        }
        if (oWLClassExpression instanceof OWLClass) {
            HierarchyNode<AtomicConcept> hierarchyNode = this.getHierarchyNode(oWLClassExpression);
            if (hierarchyNode == null || hierarchyNode == this.m_atomicConceptHierarchy.getTopNode()) {
                return new OWLClassNodeSet(this.getDataFactory().getOWLNothing());
            }
            if (hierarchyNode == this.m_atomicConceptHierarchy.getBottomNode()) {
                return this.atomicConceptHierarchyNodesToNodeSet(hierarchyNode.getAncestorNodes());
            }
            Set<HierarchyNode<AtomicConcept>> set2 = this.getDisjointConceptNodes(hierarchyNode);
            HashSet<HierarchyNode<AtomicConcept>> hashSet = new HashSet<HierarchyNode<AtomicConcept>>();
            for (HierarchyNode<AtomicConcept> hierarchyNode2 : set2) {
                hashSet.addAll(hierarchyNode2.getDescendantNodes());
            }
            return this.atomicConceptHierarchyNodesToNodeSet(hashSet);
        }
        Node<OWLClass> node2 = this.getEquivalentClasses(oWLClassExpression.getObjectComplementOf());
        NodeSet<OWLClass> nodeSet = this.getSubClasses(oWLClassExpression.getObjectComplementOf(), false);
        HashSet<Node<OWLClass>> hashSet = new HashSet<Node<OWLClass>>();
        if (node2.getSize() > 0) {
            hashSet.add(node2);
        }
        hashSet.addAll(nodeSet.getNodes());
        return new OWLClassNodeSet((Set<Node<OWLClass>>)hashSet);
    }

    protected Set<HierarchyNode<AtomicConcept>> getDisjointConceptNodes(HierarchyNode<AtomicConcept> hierarchyNode) {
        if (this.m_directDisjointClasses.containsKey(hierarchyNode)) {
            return this.m_directDisjointClasses.get(hierarchyNode);
        }
        HashSet<HierarchyNode<AtomicConcept>> hashSet = new HashSet();
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLObjectComplementOf oWLObjectComplementOf = oWLDataFactory.getOWLObjectComplementOf(oWLDataFactory.getOWLClass(IRI.create(hierarchyNode.getRepresentative().getIRI())));
        HierarchyNode<AtomicConcept> hierarchyNode2 = this.getHierarchyNode(oWLObjectComplementOf);
        for (AtomicConcept atomicConcept : hierarchyNode2.getEquivalentElements()) {
            if (Prefixes.isInternalIRI(atomicConcept.getIRI())) continue;
            HierarchyNode<AtomicConcept> hierarchyNode3 = this.m_atomicConceptHierarchy.getNodeForElement(atomicConcept);
            hashSet = Collections.singleton(hierarchyNode3);
            this.m_directDisjointClasses.put(hierarchyNode, hashSet);
            return hashSet;
        }
        hashSet = hierarchyNode2.getChildNodes();
        this.m_directDisjointClasses.put(hierarchyNode, hashSet);
        return hashSet;
    }

    public void precomputeDisjointClasses() {
        this.checkPreConditions(new OWLObject[0]);
        if (!this.m_isConsistent.booleanValue()) {
            return;
        }
        if (this.m_atomicConceptHierarchy == null || this.m_directDisjointClasses.keySet().size() < this.m_atomicConceptHierarchy.getAllNodesSet().size() - 2) {
            this.classifyClasses();
            HashSet<HierarchyNode<AtomicConcept>> hashSet = new HashSet<HierarchyNode<AtomicConcept>>(this.m_atomicConceptHierarchy.getAllNodes());
            hashSet.remove(this.m_atomicConceptHierarchy.getTopNode());
            hashSet.remove(this.m_atomicConceptHierarchy.getBottomNode());
            hashSet.removeAll(this.m_directDisjointClasses.keySet());
            int n = hashSet.size();
            int n2 = 0;
            if (this.m_configuration.reasonerProgressMonitor != null) {
                this.m_configuration.reasonerProgressMonitor.reasonerTaskStarted("Compute disjoint classes");
            }
            for (HierarchyNode hierarchyNode : hashSet) {
                this.getDisjointConceptNodes(hierarchyNode);
                if (this.m_configuration.reasonerProgressMonitor == null) continue;
                this.m_configuration.reasonerProgressMonitor.reasonerTaskProgressChanged(++n2, n);
            }
            if (this.m_configuration.reasonerProgressMonitor != null) {
                this.m_configuration.reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
    }

    protected HierarchyNode<AtomicConcept> getHierarchyNode(OWLClassExpression oWLClassExpression) {
        this.checkPreConditions(oWLClassExpression);
        this.classifyClasses();
        if (!this.isConsistent()) {
            return this.m_atomicConceptHierarchy.getBottomNode();
        }
        if (oWLClassExpression instanceof OWLClass) {
            AtomicConcept atomicConcept = Reasoner.H((OWLClass)oWLClassExpression);
            HierarchyNode<AtomicConcept> hierarchyNode = this.m_atomicConceptHierarchy.getNodeForElement(atomicConcept);
            if (hierarchyNode == null) {
                hierarchyNode = new HierarchyNode<AtomicConcept>(atomicConcept, Collections.singleton(atomicConcept), Collections.singleton(this.m_atomicConceptHierarchy.getTopNode()), Collections.singleton(this.m_atomicConceptHierarchy.getBottomNode()));
            }
            return hierarchyNode;
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:query-concept"));
        OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom = oWLDataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)oWLClass, oWLClassExpression);
        final Tableau tableau = this.getTableau(oWLEquivalentClassesAxiom);
        HierarchySearch.Relation<AtomicConcept> relation = new HierarchySearch.Relation<AtomicConcept>(){

            @Override
            public boolean doesSubsume(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
                Individual individual = Individual.createAnonymous("fresh-individual");
                return !tableau.isSatisfiable(true, Collections.singleton(Atom.create(atomicConcept2, individual)), null, null, Collections.singleton(Atom.create(atomicConcept, individual)), null, ReasoningTaskDescription.isConceptSubsumedBy(atomicConcept2, atomicConcept));
            }
        };
        HierarchyNode<AtomicConcept> hierarchyNode = HierarchySearch.findPosition(relation, AtomicConcept.create("internal:query-concept"), this.m_atomicConceptHierarchy.getTopNode(), this.m_atomicConceptHierarchy.getBottomNode());
        tableau.clearAdditionalDLOntology();
        return hierarchyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classifyObjectProperties() {
        this.checkPreConditions(new OWLObject[0]);
        if (this.m_objectRoleHierarchy == null) {
            HashSet<Role> hashSet = new HashSet<Role>();
            for (AtomicRole serializable3 : this.m_dlOntology.getAllAtomicObjectRoles()) {
                if (serializable3 == AtomicRole.TOP_OBJECT_ROLE || serializable3 == AtomicRole.BOTTOM_OBJECT_ROLE) continue;
                hashSet.add(serializable3);
                if (!this.m_dlOntology.hasInverseRoles()) continue;
                hashSet.add(serializable3.getInverse());
            }
            if (!this.m_isConsistent.booleanValue()) {
                hashSet.add(AtomicRole.TOP_OBJECT_ROLE);
                hashSet.add(AtomicRole.BOTTOM_OBJECT_ROLE);
                this.m_objectRoleHierarchy = Hierarchy.emptyHierarchy(hashSet, AtomicRole.TOP_OBJECT_ROLE, AtomicRole.BOTTOM_OBJECT_ROLE);
            } else {
                Object object;
                Serializable serializable;
                OWLAxiom[] oWLAxiomArray;
                Serializable serializable22;
                HashMap hashMap = new HashMap();
                final HashMap<AtomicConcept, Role> hashMap2 = new HashMap<AtomicConcept, Role>();
                ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
                OWLDataFactory oWLDataFactory = this.getDataFactory();
                OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:fresh-concept"));
                for (Serializable serializable22 : hashSet) {
                    if (serializable22 instanceof AtomicRole) {
                        oWLAxiomArray = AtomicConcept.create("internal:prop#" + ((AtomicRole)serializable22).getIRI());
                        serializable = oWLDataFactory.getOWLObjectProperty(IRI.create(((AtomicRole)serializable22).getIRI()));
                    } else {
                        oWLAxiomArray = AtomicConcept.create("internal:prop#inv#" + ((InverseRole)serializable22).getInverseOf().getIRI());
                        serializable = oWLDataFactory.getOWLObjectInverseOf(oWLDataFactory.getOWLObjectProperty(IRI.create(((InverseRole)serializable22).getInverseOf().getIRI())));
                    }
                    object = oWLDataFactory.getOWLClass(IRI.create(oWLAxiomArray.getIRI()));
                    OWLEquivalentClassesAxiom n = oWLDataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)object, (OWLClassExpression)oWLDataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)serializable, oWLClass));
                    arrayList.add(n);
                    hashMap.put(serializable22, oWLAxiomArray);
                    hashMap2.put((AtomicConcept)oWLAxiomArray, (Role)serializable22);
                }
                hashMap.put(AtomicRole.TOP_OBJECT_ROLE, AtomicConcept.THING);
                hashMap2.put(AtomicConcept.THING, AtomicRole.TOP_OBJECT_ROLE);
                hashMap.put(AtomicRole.BOTTOM_OBJECT_ROLE, AtomicConcept.NOTHING);
                hashMap2.put(AtomicConcept.NOTHING, AtomicRole.BOTTOM_OBJECT_ROLE);
                OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual();
                serializable22 = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLAnonymousIndividual);
                arrayList.add(serializable22);
                oWLAxiomArray = new OWLAxiom[arrayList.size()];
                arrayList.toArray(oWLAxiomArray);
                serializable = this.getTableau(oWLAxiomArray);
                try {
                    final int n = hashSet.size();
                    if (this.m_configuration.reasonerProgressMonitor != null) {
                        this.m_configuration.reasonerProgressMonitor.reasonerTaskStarted("Classifying object properties...");
                    }
                    object = new ClassificationProgressMonitor(){
                        protected int m_processedRoles = 0;

                        public void elementClassified(AtomicConcept atomicConcept) {
                            ++this.m_processedRoles;
                            if (Reasoner.this.m_configuration.reasonerProgressMonitor != null) {
                                Reasoner.this.m_configuration.reasonerProgressMonitor.reasonerTaskProgressChanged(this.m_processedRoles, n);
                            }
                        }
                    };
                    Hierarchy<AtomicConcept> hierarchy = this.classifyAtomicConceptsForRoles((Tableau)serializable, (ClassificationProgressMonitor)object, (AtomicConcept)hashMap.get(AtomicRole.TOP_OBJECT_ROLE), (AtomicConcept)hashMap.get(AtomicRole.BOTTOM_OBJECT_ROLE), hashMap2.keySet(), this.m_dlOntology.hasInverseRoles(), hashMap, hashMap2, this.m_configuration.forceQuasiOrderClassification);
                    Hierarchy.Transformer<AtomicConcept, Role> transformer = new Hierarchy.Transformer<AtomicConcept, Role>(){

                        @Override
                        public Role transform(AtomicConcept atomicConcept) {
                            return (Role)hashMap2.get(atomicConcept);
                        }

                        @Override
                        public Role determineRepresentative(AtomicConcept atomicConcept, Set<Role> set2) {
                            return this.transform(atomicConcept);
                        }
                    };
                    this.m_objectRoleHierarchy = hierarchy.transform(transformer, null);
                    if (this.m_instanceManager != null) {
                        this.m_instanceManager.setToClassifiedRoleHierarchy(this.m_objectRoleHierarchy);
                    }
                }
                finally {
                    ((Tableau)serializable).clearAdditionalDLOntology();
                    if (this.m_configuration.reasonerProgressMonitor != null) {
                        this.m_configuration.reasonerProgressMonitor.reasonerTaskStopped();
                    }
                }
            }
        }
    }

    @Override
    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        this.classifyObjectProperties();
        return this.objectPropertyHierarchyNodeToNode(this.m_objectRoleHierarchy.getTopNode());
    }

    @Override
    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        this.classifyObjectProperties();
        return this.objectPropertyHierarchyNodeToNode(this.m_objectRoleHierarchy.getBottomNode());
    }

    protected boolean isSubObjectPropertyExpressionOf(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLObjectPropertyExpression oWLObjectPropertyExpression2) {
        this.checkPreConditions(oWLObjectPropertyExpression, oWLObjectPropertyExpression2);
        if (!this.m_isConsistent.booleanValue() || oWLObjectPropertyExpression.getNamedProperty().isOWLBottomObjectProperty() || oWLObjectPropertyExpression2.getNamedProperty().isOWLTopObjectProperty()) {
            return true;
        }
        Role role = Reasoner.H(oWLObjectPropertyExpression);
        Role role2 = Reasoner.H(oWLObjectPropertyExpression2);
        if (this.m_objectRoleHierarchy != null && !this.containsFreshEntities(oWLObjectPropertyExpression, oWLObjectPropertyExpression2)) {
            HierarchyNode<Role> hierarchyNode = this.m_objectRoleHierarchy.getNodeForElement(role);
            return hierarchyNode.isEquivalentElement(role2) || hierarchyNode.isAncestorElement(role2);
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:pseudo-nominal"));
        OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression2, oWLClass.getObjectComplementOf());
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-A");
        OWLAnonymousIndividual oWLAnonymousIndividual2 = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-B");
        OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom = oWLDataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression, oWLAnonymousIndividual, oWLAnonymousIndividual2);
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLAnonymousIndividual2);
        OWLClassAssertionAxiom oWLClassAssertionAxiom2 = oWLDataFactory.getOWLClassAssertionAxiom(oWLObjectAllValuesFrom, oWLAnonymousIndividual);
        Tableau tableau = this.getTableau(oWLObjectPropertyAssertionAxiom, oWLClassAssertionAxiom, oWLClassAssertionAxiom2);
        boolean bl = tableau.isSatisfiable(true, null, null, null, null, null, ReasoningTaskDescription.isRoleSubsumedBy(role, role2, true));
        tableau.clearAdditionalDLOntology();
        return !bl;
    }

    protected boolean isSubObjectPropertyExpressionOf(List<OWLObjectPropertyExpression> list, OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        Serializable serializable;
        OWLObject oWLObject2;
        OWLObject[] oWLObjectArray = new OWLObject[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            oWLObjectArray[i] = list.get(i);
        }
        oWLObjectArray[list.size()] = oWLObjectPropertyExpression;
        this.checkPreConditions(oWLObjectArray);
        if (!this.m_isConsistent.booleanValue() || oWLObjectPropertyExpression.getNamedProperty().isOWLTopObjectProperty()) {
            return true;
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:pseudo-nominal"));
        OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, oWLClass.getObjectComplementOf());
        OWLAxiom[] oWLAxiomArray = new OWLAxiom[list.size() + 2];
        int n = 0;
        for (OWLObject oWLObject2 : list) {
            serializable = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-" + n);
            OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-" + (n + 1));
            oWLAxiomArray[n++] = oWLDataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)oWLObject2, (OWLIndividual)serializable, oWLAnonymousIndividual);
        }
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-0");
        oWLObject2 = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-" + list.size());
        oWLAxiomArray[n++] = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, (OWLIndividual)oWLObject2);
        oWLAxiomArray[n++] = oWLDataFactory.getOWLClassAssertionAxiom(oWLObjectAllValuesFrom, oWLAnonymousIndividual);
        serializable = this.getTableau(oWLAxiomArray);
        return !((Tableau)serializable).isSatisfiable(true, null, null, null, null, null, new ReasoningTaskDescription(true, "subproperty chain subsumption", new Object[0]));
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) {
        HierarchyNode<Role> hierarchyNode = this.getHierarchyNode(oWLObjectPropertyExpression);
        Set<Object> set2 = new HashSet();
        if (bl) {
            for (HierarchyNode<Role> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                set2.add(hierarchyNode2);
            }
        } else {
            set2 = hierarchyNode.getAncestorNodes();
            set2.remove(hierarchyNode);
        }
        return this.objectPropertyHierarchyNodesToNodeSet(set2);
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) {
        HierarchyNode<Role> hierarchyNode = this.getHierarchyNode(oWLObjectPropertyExpression);
        Set<Object> set2 = new HashSet();
        if (bl) {
            for (HierarchyNode<Role> hierarchyNode2 : hierarchyNode.getChildNodes()) {
                set2.add(hierarchyNode2);
            }
        } else {
            set2 = hierarchyNode.getDescendantNodes();
            set2.remove(hierarchyNode);
        }
        return this.objectPropertyHierarchyNodesToNodeSet(set2);
    }

    @Override
    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return this.objectPropertyHierarchyNodeToNode(this.getHierarchyNode(oWLObjectPropertyExpression));
    }

    @Override
    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        this.classifyClasses();
        if (!this.isConsistent()) {
            return new OWLClassNodeSet(this.getBottomClassNode());
        }
        final Role role = Reasoner.H(oWLObjectPropertyExpression);
        Set<HierarchyNode<AtomicConcept>> set2 = this.m_directObjectRoleDomains.get(role);
        if (set2 == null) {
            final Individual individual = Individual.createAnonymous("fresh-individual-A");
            Individual individual2 = Individual.createAnonymous("fresh-individual-B");
            final Set<Atom> set3 = Collections.singleton(role.getRoleAssertion(individual, individual2));
            final Tableau tableau = this.getTableau();
            HierarchySearch.SearchPredicate<HierarchyNode<AtomicConcept>> searchPredicate = new HierarchySearch.SearchPredicate<HierarchyNode<AtomicConcept>>(){

                @Override
                public Set<HierarchyNode<AtomicConcept>> getSuccessorElements(HierarchyNode<AtomicConcept> hierarchyNode) {
                    return hierarchyNode.getChildNodes();
                }

                @Override
                public Set<HierarchyNode<AtomicConcept>> getPredecessorElements(HierarchyNode<AtomicConcept> hierarchyNode) {
                    return hierarchyNode.getParentNodes();
                }

                @Override
                public boolean trueOf(HierarchyNode<AtomicConcept> hierarchyNode) {
                    AtomicConcept atomicConcept = hierarchyNode.getRepresentative();
                    return !tableau.isSatisfiable(false, set3, Collections.singleton(Atom.create(atomicConcept, individual)), null, null, null, ReasoningTaskDescription.isDomainOf(atomicConcept, role));
                }
            };
            set2 = HierarchySearch.search(searchPredicate, Collections.singleton(this.m_atomicConceptHierarchy.getTopNode()), null);
            this.m_directObjectRoleDomains.put(role, set2);
        }
        if (!bl) {
            set2 = HierarchyNode.getAncestorNodes(set2);
        }
        return this.atomicConceptHierarchyNodesToNodeSet(set2);
    }

    @Override
    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        this.classifyClasses();
        if (!this.isConsistent()) {
            return new OWLClassNodeSet(this.getBottomClassNode());
        }
        final Role role = Reasoner.H(oWLObjectPropertyExpression);
        Set<HierarchyNode<AtomicConcept>> set2 = this.m_directObjectRoleRanges.get(role);
        if (set2 == null) {
            Individual individual = Individual.createAnonymous("fresh-individual-A");
            final Individual individual2 = Individual.createAnonymous("fresh-individual-B");
            final Set<Atom> set3 = Collections.singleton(role.getRoleAssertion(individual, individual2));
            final Tableau tableau = this.getTableau();
            HierarchySearch.SearchPredicate<HierarchyNode<AtomicConcept>> searchPredicate = new HierarchySearch.SearchPredicate<HierarchyNode<AtomicConcept>>(){

                @Override
                public Set<HierarchyNode<AtomicConcept>> getSuccessorElements(HierarchyNode<AtomicConcept> hierarchyNode) {
                    return hierarchyNode.getChildNodes();
                }

                @Override
                public Set<HierarchyNode<AtomicConcept>> getPredecessorElements(HierarchyNode<AtomicConcept> hierarchyNode) {
                    return hierarchyNode.getParentNodes();
                }

                @Override
                public boolean trueOf(HierarchyNode<AtomicConcept> hierarchyNode) {
                    AtomicConcept atomicConcept = hierarchyNode.getRepresentative();
                    return !tableau.isSatisfiable(false, set3, Collections.singleton(Atom.create(atomicConcept, individual2)), null, null, null, ReasoningTaskDescription.isRangeOf(atomicConcept, role));
                }
            };
            set2 = HierarchySearch.search(searchPredicate, Collections.singleton(this.m_atomicConceptHierarchy.getTopNode()), null);
            this.m_directObjectRoleRanges.put(role, set2);
        }
        if (!bl) {
            set2 = HierarchyNode.getAncestorNodes(set2);
        }
        return this.atomicConceptHierarchyNodesToNodeSet(set2);
    }

    @Override
    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        return this.getEquivalentObjectProperties(oWLObjectPropertyExpression.getSimplified().getInverseProperty());
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue()) {
            return new OWLObjectPropertyNodeSet();
        }
        this.classifyObjectProperties();
        HashSet<HierarchyNode<Role>> hashSet = new HashSet<HierarchyNode<Role>>();
        if (oWLObjectPropertyExpression.getNamedProperty().isOWLTopObjectProperty()) {
            hashSet.add(this.m_objectRoleHierarchy.getBottomNode());
            return this.objectPropertyHierarchyNodesToNodeSet(hashSet);
        }
        if (oWLObjectPropertyExpression.isOWLBottomObjectProperty()) {
            HierarchyNode<Role> hierarchyNode = this.m_objectRoleHierarchy.getTopNode();
            hashSet.add(hierarchyNode);
            hashSet.addAll(hierarchyNode.getDescendantNodes());
            return this.objectPropertyHierarchyNodesToNodeSet(hashSet);
        }
        Role role = Reasoner.H(oWLObjectPropertyExpression);
        Individual individual = Individual.createAnonymous("fresh-individual-A");
        Individual individual2 = Individual.createAnonymous("fresh-individual-B");
        Atom atom2 = role.getRoleAssertion(individual, individual2);
        Tableau tableau = this.getTableau();
        HashSet hashSet2 = new HashSet();
        hashSet2.addAll(this.m_objectRoleHierarchy.getTopNode().getChildNodes());
        while (!hashSet2.isEmpty()) {
            HierarchyNode hierarchyNode = (HierarchyNode)hashSet2.iterator().next();
            hashSet2.remove(hierarchyNode);
            Role role2 = (Role)hierarchyNode.getRepresentative();
            Atom atom3 = role2.getRoleAssertion(individual, individual2);
            HashSet<Atom> hashSet3 = new HashSet<Atom>(2);
            hashSet3.add(atom2);
            hashSet3.add(atom3);
            if (!tableau.isSatisfiable(false, hashSet3, null, null, null, null, new ReasoningTaskDescription(true, "disjointness of {0} and {1}", role, role2))) {
                hashSet.addAll(hierarchyNode.getDescendantNodes());
                continue;
            }
            hashSet2.addAll(hierarchyNode.getChildNodes());
        }
        if (hashSet.isEmpty()) {
            hashSet.add(this.m_objectRoleHierarchy.getBottomNode());
        }
        return this.objectPropertyHierarchyNodesToNodeSet(hashSet);
    }

    protected boolean isDisjointObjectProperty(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLObjectPropertyExpression oWLObjectPropertyExpression2) {
        this.checkPreConditions(oWLObjectPropertyExpression, oWLObjectPropertyExpression2);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        Role role = Reasoner.H(oWLObjectPropertyExpression);
        Role role2 = Reasoner.H(oWLObjectPropertyExpression2);
        Individual individual = Individual.createAnonymous("fresh-individual-A");
        Individual individual2 = Individual.createAnonymous("fresh-individual-B");
        Atom atom2 = role.getRoleAssertion(individual, individual2);
        Atom atom3 = role2.getRoleAssertion(individual, individual2);
        HashSet<Atom> hashSet = new HashSet<Atom>(2);
        hashSet.add(atom2);
        hashSet.add(atom3);
        return !this.getTableau().isSatisfiable(false, hashSet, null, null, null, null, new ReasoningTaskDescription(true, "disjointness of {0} and {1}", role, role2));
    }

    protected boolean isFunctional(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        Role role = Reasoner.H(oWLObjectPropertyExpression);
        Individual individual = Individual.createAnonymous("fresh-individual");
        Individual individual2 = Individual.createAnonymous("fresh-individual-A");
        Individual individual3 = Individual.createAnonymous("fresh-individual-B");
        HashSet<Atom> hashSet = new HashSet<Atom>();
        hashSet.add(role.getRoleAssertion(individual, individual2));
        hashSet.add(role.getRoleAssertion(individual, individual3));
        hashSet.add(Atom.create(Inequality.INSTANCE, individual2, individual3));
        return !this.getTableau().isSatisfiable(false, hashSet, null, null, null, null, new ReasoningTaskDescription(true, "functionality of {0}", role));
    }

    protected boolean isInverseFunctional(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        Role role = Reasoner.H(oWLObjectPropertyExpression);
        Individual individual = Individual.createAnonymous("fresh-individual");
        Individual individual2 = Individual.createAnonymous("fresh-individual-A");
        Individual individual3 = Individual.createAnonymous("fresh-individual-B");
        HashSet<Atom> hashSet = new HashSet<Atom>();
        hashSet.add(role.getRoleAssertion(individual2, individual));
        hashSet.add(role.getRoleAssertion(individual3, individual));
        hashSet.add(Atom.create(Inequality.INSTANCE, individual2, individual3));
        return !this.getTableau().isSatisfiable(false, hashSet, null, null, null, null, new ReasoningTaskDescription(true, "inverse-functionality of {0}", role));
    }

    protected boolean isIrreflexive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        Role role = Reasoner.H(oWLObjectPropertyExpression);
        Individual individual = Individual.createAnonymous("fresh-individual");
        return !this.getTableau().isSatisfiable(false, Collections.singleton(role.getRoleAssertion(individual, individual)), null, null, null, null, new ReasoningTaskDescription(true, "irreflexivity of {0}", role));
    }

    protected boolean isReflexive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:pseudo-nominal"));
        OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, oWLClass.getObjectComplementOf());
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual");
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLAnonymousIndividual);
        OWLClassAssertionAxiom oWLClassAssertionAxiom2 = oWLDataFactory.getOWLClassAssertionAxiom(oWLObjectAllValuesFrom, oWLAnonymousIndividual);
        Tableau tableau = this.getTableau(oWLClassAssertionAxiom, oWLClassAssertionAxiom2);
        boolean bl = tableau.isSatisfiable(true, null, null, null, null, null, new ReasoningTaskDescription(true, "symmetry of {0}", Reasoner.H(oWLObjectPropertyExpression)));
        tableau.clearAdditionalDLOntology();
        return !bl;
    }

    protected boolean isAsymmetric(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-A");
        OWLAnonymousIndividual oWLAnonymousIndividual2 = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-B");
        OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom = oWLDataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression, oWLAnonymousIndividual, oWLAnonymousIndividual2);
        OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom2 = oWLDataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression.getInverseProperty(), oWLAnonymousIndividual, oWLAnonymousIndividual2);
        Tableau tableau = this.getTableau(oWLObjectPropertyAssertionAxiom, oWLObjectPropertyAssertionAxiom2);
        boolean bl = tableau.isSatisfiable(true, null, null, null, null, null, new ReasoningTaskDescription(true, "asymmetry of {0}", Reasoner.H(oWLObjectPropertyExpression)));
        tableau.clearAdditionalDLOntology();
        return !bl;
    }

    protected boolean isSymmetric(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue() || oWLObjectPropertyExpression.getNamedProperty().isOWLTopObjectProperty()) {
            return true;
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:pseudo-nominal"));
        OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, oWLClass.getObjectComplementOf());
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-A");
        OWLAnonymousIndividual oWLAnonymousIndividual2 = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-B");
        OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom = oWLDataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression, oWLAnonymousIndividual, oWLAnonymousIndividual2);
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLObjectAllValuesFrom, oWLAnonymousIndividual2);
        OWLClassAssertionAxiom oWLClassAssertionAxiom2 = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLAnonymousIndividual);
        Tableau tableau = this.getTableau(oWLObjectPropertyAssertionAxiom, oWLClassAssertionAxiom, oWLClassAssertionAxiom2);
        boolean bl = tableau.isSatisfiable(true, null, null, null, null, null, new ReasoningTaskDescription(true, "symmetry of {0}", oWLObjectPropertyExpression));
        tableau.clearAdditionalDLOntology();
        return !bl;
    }

    protected boolean isTransitive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:pseudo-nominal"));
        OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, oWLClass.getObjectComplementOf());
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-A");
        OWLAnonymousIndividual oWLAnonymousIndividual2 = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-B");
        OWLAnonymousIndividual oWLAnonymousIndividual3 = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual-C");
        OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom = oWLDataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression, oWLAnonymousIndividual, oWLAnonymousIndividual2);
        OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom2 = oWLDataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectPropertyExpression, oWLAnonymousIndividual2, oWLAnonymousIndividual3);
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLObjectAllValuesFrom, oWLAnonymousIndividual);
        OWLClassAssertionAxiom oWLClassAssertionAxiom2 = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLAnonymousIndividual3);
        Tableau tableau = this.getTableau(oWLObjectPropertyAssertionAxiom, oWLObjectPropertyAssertionAxiom2, oWLClassAssertionAxiom, oWLClassAssertionAxiom2);
        boolean bl = tableau.isSatisfiable(true, null, null, null, null, null, new ReasoningTaskDescription(true, "transitivity of {0}", Reasoner.H(oWLObjectPropertyExpression)));
        tableau.clearAdditionalDLOntology();
        return !bl;
    }

    protected HierarchyNode<Role> getHierarchyNode(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLObjectPropertyExpression);
        this.classifyObjectProperties();
        if (!this.m_isConsistent.booleanValue()) {
            return this.m_objectRoleHierarchy.getBottomNode();
        }
        Role role = Reasoner.H(oWLObjectPropertyExpression);
        HierarchyNode<Role> hierarchyNode = this.m_objectRoleHierarchy.getNodeForElement(role);
        if (hierarchyNode == null) {
            hierarchyNode = new HierarchyNode<Role>(role, Collections.singleton(role), Collections.singleton(this.m_objectRoleHierarchy.getTopNode()), Collections.singleton(this.m_objectRoleHierarchy.getBottomNode()));
        }
        return hierarchyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classifyDataProperties() {
        this.checkPreConditions(new OWLObject[0]);
        if (this.m_dataRoleHierarchy == null) {
            HashSet<AtomicRole> hashSet = new HashSet<AtomicRole>();
            hashSet.add(AtomicRole.TOP_DATA_ROLE);
            hashSet.add(AtomicRole.BOTTOM_DATA_ROLE);
            hashSet.addAll(this.m_dlOntology.getAllAtomicDataRoles());
            if (!this.m_isConsistent.booleanValue()) {
                this.m_dataRoleHierarchy = Hierarchy.emptyHierarchy(hashSet, AtomicRole.TOP_DATA_ROLE, AtomicRole.BOTTOM_DATA_ROLE);
            } else if (this.m_dlOntology.hasDatatypes()) {
                Object object;
                Object object2;
                Object object3;
                HashMap<AtomicRole, AtomicConcept> hashMap = new HashMap<AtomicRole, AtomicConcept>();
                final HashMap<AtomicConcept, AtomicRole> hashMap2 = new HashMap<AtomicConcept, AtomicRole>();
                ArrayList<OWLEquivalentClassesAxiom> arrayList = new ArrayList<OWLEquivalentClassesAxiom>();
                OWLDataFactory oWLDataFactory = this.getDataFactory();
                OWLDatatype oWLDatatype = oWLDataFactory.getOWLDatatype(IRI.create("internal:unknown-datatype#A"));
                for (AtomicRole serializable2 : hashSet) {
                    AtomicConcept n;
                    if (AtomicRole.TOP_DATA_ROLE.equals(serializable2)) {
                        n = AtomicConcept.THING;
                    } else if (AtomicRole.BOTTOM_DATA_ROLE.equals(serializable2)) {
                        n = AtomicConcept.NOTHING;
                    } else {
                        n = AtomicConcept.create("internal:prop#" + serializable2.getIRI());
                        object3 = oWLDataFactory.getOWLClass(IRI.create(n.getIRI()));
                        object2 = oWLDataFactory.getOWLDataProperty(IRI.create(serializable2.getIRI()));
                        object = oWLDataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)object3, (OWLClassExpression)oWLDataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)object2, oWLDatatype));
                        arrayList.add((OWLEquivalentClassesAxiom)object);
                    }
                    hashMap.put(serializable2, n);
                    hashMap2.put(n, serializable2);
                }
                OWLAxiom[] oWLAxiomArray = new OWLAxiom[arrayList.size()];
                arrayList.toArray(oWLAxiomArray);
                Tableau tableau = this.getTableau(oWLAxiomArray);
                try {
                    final int n = hashSet.size();
                    if (this.m_configuration.reasonerProgressMonitor != null) {
                        this.m_configuration.reasonerProgressMonitor.reasonerTaskStarted("Classifying data properties...");
                    }
                    object3 = new ClassificationProgressMonitor(){
                        protected int m_processedRoles = 0;

                        public void elementClassified(AtomicConcept atomicConcept) {
                            ++this.m_processedRoles;
                            if (Reasoner.this.m_configuration.reasonerProgressMonitor != null) {
                                Reasoner.this.m_configuration.reasonerProgressMonitor.reasonerTaskProgressChanged(this.m_processedRoles, n);
                            }
                        }
                    };
                    object2 = this.classifyAtomicConcepts(tableau, (ClassificationProgressMonitor)object3, (AtomicConcept)hashMap.get(AtomicRole.TOP_DATA_ROLE), (AtomicConcept)hashMap.get(AtomicRole.BOTTOM_DATA_ROLE), hashMap2.keySet(), this.m_configuration.forceQuasiOrderClassification);
                    object = new Hierarchy.Transformer<AtomicConcept, AtomicRole>(){

                        @Override
                        public AtomicRole transform(AtomicConcept atomicConcept) {
                            return (AtomicRole)hashMap2.get(atomicConcept);
                        }

                        @Override
                        public AtomicRole determineRepresentative(AtomicConcept atomicConcept, Set<AtomicRole> set2) {
                            return this.transform(atomicConcept);
                        }
                    };
                    this.m_dataRoleHierarchy = ((Hierarchy)object2).transform(object, null);
                }
                finally {
                    tableau.clearAdditionalDLOntology();
                    if (this.m_configuration.reasonerProgressMonitor != null) {
                        this.m_configuration.reasonerProgressMonitor.reasonerTaskStopped();
                    }
                }
            } else {
                this.m_dataRoleHierarchy = Hierarchy.trivialHierarchy(AtomicRole.TOP_DATA_ROLE, AtomicRole.BOTTOM_DATA_ROLE);
            }
        }
    }

    @Override
    public Node<OWLDataProperty> getTopDataPropertyNode() {
        this.classifyDataProperties();
        return this.dataPropertyHierarchyNodeToNode(this.m_dataRoleHierarchy.getTopNode());
    }

    @Override
    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        this.classifyDataProperties();
        return this.dataPropertyHierarchyNodeToNode(this.m_dataRoleHierarchy.getBottomNode());
    }

    protected boolean isSubDataPropertyOf(OWLDataProperty oWLDataProperty, OWLDataProperty oWLDataProperty2) {
        this.checkPreConditions(oWLDataProperty, oWLDataProperty2);
        if (!this.m_isConsistent.booleanValue() || oWLDataProperty.isOWLBottomDataProperty() || oWLDataProperty2.isOWLTopDataProperty()) {
            return true;
        }
        AtomicRole atomicRole = Reasoner.H(oWLDataProperty);
        AtomicRole atomicRole2 = Reasoner.H(oWLDataProperty2);
        if (this.m_dataRoleHierarchy != null && !this.containsFreshEntities(oWLDataProperty, oWLDataProperty2)) {
            HierarchyNode<AtomicRole> hierarchyNode = this.m_dataRoleHierarchy.getNodeForElement(atomicRole);
            return hierarchyNode.isEquivalentElement(atomicRole2) || hierarchyNode.isAncestorElement(atomicRole2);
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLAnonymousIndividual oWLAnonymousIndividual = oWLDataFactory.getOWLAnonymousIndividual("fresh-individual");
        OWLLiteral oWLLiteral = oWLDataFactory.getOWLLiteral("internal:fresh-constant", oWLDataFactory.getOWLDatatype(IRI.create("internal:anonymous-constants")));
        OWLDataProperty oWLDataProperty3 = oWLDataFactory.getOWLDataProperty(IRI.create("internal:negated-superproperty"));
        OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom = oWLDataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLDataProperty, (OWLIndividual)oWLAnonymousIndividual, oWLLiteral);
        OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom2 = oWLDataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLDataProperty3, (OWLIndividual)oWLAnonymousIndividual, oWLLiteral);
        OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom = oWLDataFactory.getOWLDisjointDataPropertiesAxiom(oWLDataProperty2, oWLDataProperty3);
        Tableau tableau = this.getTableau(oWLDataPropertyAssertionAxiom, oWLDataPropertyAssertionAxiom2, oWLDisjointDataPropertiesAxiom);
        boolean bl = tableau.isSatisfiable(true, null, null, null, null, null, ReasoningTaskDescription.isRoleSubsumedBy(atomicRole, atomicRole2, false));
        tableau.clearAdditionalDLOntology();
        return !bl;
    }

    @Override
    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty oWLDataProperty, boolean bl) {
        Set<HierarchyNode<AtomicRole>> set2;
        HierarchyNode<AtomicRole> hierarchyNode = this.getHierarchyNode(oWLDataProperty);
        if (bl) {
            set2 = hierarchyNode.getParentNodes();
        } else {
            set2 = new HashSet<HierarchyNode<AtomicRole>>(hierarchyNode.getAncestorNodes());
            set2.remove(hierarchyNode);
        }
        return this.dataPropertyHierarchyNodesToNodeSet(set2);
    }

    @Override
    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty oWLDataProperty, boolean bl) {
        Set<HierarchyNode<AtomicRole>> set2;
        HierarchyNode<AtomicRole> hierarchyNode = this.getHierarchyNode(oWLDataProperty);
        if (bl) {
            set2 = hierarchyNode.getChildNodes();
        } else {
            set2 = new HashSet<HierarchyNode<AtomicRole>>(hierarchyNode.getDescendantNodes());
            set2.remove(hierarchyNode);
        }
        return this.dataPropertyHierarchyNodesToNodeSet(set2);
    }

    @Override
    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty oWLDataProperty) {
        return this.dataPropertyHierarchyNodeToNode(this.getHierarchyNode(oWLDataProperty));
    }

    @Override
    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty oWLDataProperty, boolean bl) {
        this.checkPreConditions(oWLDataProperty);
        this.classifyClasses();
        if (!this.m_isConsistent.booleanValue()) {
            return new OWLClassNodeSet(this.getBottomClassNode());
        }
        final AtomicRole atomicRole = Reasoner.H(oWLDataProperty);
        Set<HierarchyNode<AtomicConcept>> set2 = this.m_directDataRoleDomains.get(atomicRole);
        if (set2 == null) {
            final Individual individual = Individual.createAnonymous("fresh-individual");
            Constant constant = Constant.createAnonymous("fresh-constant");
            final Set<Atom> set3 = Collections.singleton(atomicRole.getRoleAssertion(individual, constant));
            final Tableau tableau = this.getTableau();
            HierarchySearch.SearchPredicate<HierarchyNode<AtomicConcept>> searchPredicate = new HierarchySearch.SearchPredicate<HierarchyNode<AtomicConcept>>(){

                @Override
                public Set<HierarchyNode<AtomicConcept>> getSuccessorElements(HierarchyNode<AtomicConcept> hierarchyNode) {
                    return hierarchyNode.getChildNodes();
                }

                @Override
                public Set<HierarchyNode<AtomicConcept>> getPredecessorElements(HierarchyNode<AtomicConcept> hierarchyNode) {
                    return hierarchyNode.getParentNodes();
                }

                @Override
                public boolean trueOf(HierarchyNode<AtomicConcept> hierarchyNode) {
                    AtomicConcept atomicConcept = hierarchyNode.getRepresentative();
                    return !tableau.isSatisfiable(false, set3, Collections.singleton(Atom.create(atomicConcept, individual)), null, null, null, ReasoningTaskDescription.isDomainOf(atomicConcept, atomicRole));
                }
            };
            set2 = HierarchySearch.search(searchPredicate, Collections.singleton(this.m_atomicConceptHierarchy.getTopNode()), null);
            this.m_directDataRoleDomains.put(atomicRole, set2);
        }
        if (!bl) {
            set2 = HierarchyNode.getAncestorNodes(set2);
        }
        return this.atomicConceptHierarchyNodesToNodeSet(set2);
    }

    @Override
    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression oWLDataPropertyExpression) {
        this.checkPreConditions(oWLDataPropertyExpression);
        if (this.m_dlOntology.hasDatatypes()) {
            this.classifyDataProperties();
            if (!this.m_isConsistent.booleanValue()) {
                return new OWLDataPropertyNodeSet();
            }
            HashSet<HierarchyNode<AtomicRole>> hashSet = new HashSet<HierarchyNode<AtomicRole>>();
            if (oWLDataPropertyExpression.isOWLTopDataProperty()) {
                hashSet.add(this.m_dataRoleHierarchy.getBottomNode());
                return this.dataPropertyHierarchyNodesToNodeSet(hashSet);
            }
            if (oWLDataPropertyExpression.isOWLBottomDataProperty()) {
                HierarchyNode<AtomicRole> hierarchyNode = this.m_dataRoleHierarchy.getTopNode();
                hashSet.add(hierarchyNode);
                hashSet.addAll(hierarchyNode.getDescendantNodes());
                return this.dataPropertyHierarchyNodesToNodeSet(hashSet);
            }
            AtomicRole atomicRole = Reasoner.H(oWLDataPropertyExpression.asOWLDataProperty());
            Individual individual = Individual.create("fresh-individual");
            Constant constant = Constant.createAnonymous("fresh-constant");
            Atom atom2 = atomicRole.getRoleAssertion(individual, constant);
            Tableau tableau = this.getTableau();
            HashSet hashSet2 = new HashSet();
            hashSet2.addAll(this.m_dataRoleHierarchy.getTopNode().getChildNodes());
            while (!hashSet2.isEmpty()) {
                HierarchyNode hierarchyNode = (HierarchyNode)hashSet2.iterator().next();
                hashSet2.remove(hierarchyNode);
                AtomicRole atomicRole2 = (AtomicRole)hierarchyNode.getRepresentative();
                Atom atom3 = atomicRole2.getRoleAssertion(individual, constant);
                HashSet<Atom> hashSet3 = new HashSet<Atom>(2);
                hashSet3.add(atom2);
                hashSet3.add(atom3);
                if (!tableau.isSatisfiable(false, hashSet3, null, null, null, null, new ReasoningTaskDescription(true, "disjointness of {0} and {1}", atomicRole, atomicRole2))) {
                    hashSet.addAll(hierarchyNode.getDescendantNodes());
                    continue;
                }
                hashSet2.addAll(hierarchyNode.getChildNodes());
            }
            if (hashSet.isEmpty()) {
                hashSet.add(this.m_dataRoleHierarchy.getBottomNode());
            }
            return this.dataPropertyHierarchyNodesToNodeSet(hashSet);
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        if (oWLDataPropertyExpression.isOWLTopDataProperty() && this.isConsistent()) {
            return new OWLDataPropertyNodeSet(new OWLDataPropertyNode(oWLDataFactory.getOWLBottomDataProperty()));
        }
        if (oWLDataPropertyExpression.isOWLBottomDataProperty() && this.isConsistent()) {
            return new OWLDataPropertyNodeSet(new OWLDataPropertyNode(oWLDataFactory.getOWLTopDataProperty()));
        }
        return new OWLDataPropertyNodeSet();
    }

    protected boolean isFunctional(OWLDataProperty oWLDataProperty) {
        this.checkPreConditions(oWLDataProperty);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        AtomicRole atomicRole = Reasoner.H(oWLDataProperty);
        Individual individual = Individual.createAnonymous("fresh-individual");
        Constant constant = Constant.createAnonymous("fresh-constant-A");
        Constant constant2 = Constant.createAnonymous("fresh-constant-B");
        HashSet<Atom> hashSet = new HashSet<Atom>();
        hashSet.add(atomicRole.getRoleAssertion(individual, constant));
        hashSet.add(atomicRole.getRoleAssertion(individual, constant2));
        hashSet.add(Atom.create(Inequality.INSTANCE, constant, constant2));
        return !this.getTableau().isSatisfiable(false, hashSet, null, null, null, null, new ReasoningTaskDescription(true, "functionality of {0}", atomicRole));
    }

    protected HierarchyNode<AtomicRole> getHierarchyNode(OWLDataProperty oWLDataProperty) {
        this.checkPreConditions(oWLDataProperty);
        this.classifyDataProperties();
        if (!this.m_isConsistent.booleanValue()) {
            return this.m_dataRoleHierarchy.getBottomNode();
        }
        AtomicRole atomicRole = Reasoner.H(oWLDataProperty);
        HierarchyNode<AtomicRole> hierarchyNode = this.m_dataRoleHierarchy.getNodeForElement(atomicRole);
        if (hierarchyNode == null) {
            hierarchyNode = new HierarchyNode<AtomicRole>(atomicRole, Collections.singleton(atomicRole), Collections.singleton(this.m_dataRoleHierarchy.getTopNode()), Collections.singleton(this.m_dataRoleHierarchy.getBottomNode()));
        }
        return hierarchyNode;
    }

    protected void realise() {
        this.checkPreConditions(new OWLObject[0]);
        if (this.m_dlOntology.getAllIndividuals().size() > 0) {
            this.classifyClasses();
            this.initialiseClassInstanceManager();
            this.m_instanceManager.realize(this.m_configuration.reasonerProgressMonitor);
        }
    }

    public void realiseObjectProperties() {
        this.checkPreConditions(new OWLObject[0]);
        if (this.m_dlOntology.getAllIndividuals().size() > 0) {
            this.classifyObjectProperties();
            this.initialisePropertiesInstanceManager();
            this.m_instanceManager.realizeObjectRoles(this.m_configuration.reasonerProgressMonitor);
        }
    }

    public void precomputeSameAsEquivalenceClasses() {
        this.checkPreConditions(new OWLObject[0]);
        if (this.m_dlOntology.getAllIndividuals().size() > 0) {
            this.initialiseClassInstanceManager();
            this.m_instanceManager.computeSameAsEquivalenceClasses(this.m_configuration.reasonerProgressMonitor);
        }
    }

    @Override
    public NodeSet<OWLClass> getTypes(OWLNamedIndividual oWLNamedIndividual, boolean bl) {
        HashSet<HierarchyNode<AtomicConcept>> hashSet;
        this.checkPreConditions(oWLNamedIndividual);
        if (!this.isDefined(oWLNamedIndividual)) {
            this.classifyClasses();
            hashSet = new HashSet<HierarchyNode<AtomicConcept>>();
            hashSet.add(this.m_atomicConceptHierarchy.getTopNode());
        } else {
            if (bl) {
                this.classifyClasses();
            }
            this.initialiseClassInstanceManager();
            if (bl) {
                this.m_instanceManager.setToClassifiedConceptHierarchy(this.m_atomicConceptHierarchy);
            }
            hashSet = this.m_instanceManager.getTypes(Reasoner.H(oWLNamedIndividual), bl);
        }
        return this.atomicConceptHierarchyNodesToNodeSet(hashSet);
    }

    public boolean hasType(OWLNamedIndividual oWLNamedIndividual, OWLClassExpression oWLClassExpression, boolean bl) {
        this.checkPreConditions(oWLNamedIndividual, oWLClassExpression);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        if (!this.isDefined(oWLNamedIndividual)) {
            return this.getEquivalentClasses(oWLClassExpression).contains(this.m_rootOntology.getOWLOntologyManager().getOWLDataFactory().getOWLThing());
        }
        if (oWLClassExpression instanceof OWLClass) {
            if (bl) {
                this.classifyClasses();
            }
            this.initialiseClassInstanceManager();
            if (bl) {
                this.m_instanceManager.setToClassifiedConceptHierarchy(this.m_atomicConceptHierarchy);
            }
            return this.m_instanceManager.hasType(Reasoner.H(oWLNamedIndividual), Reasoner.H((OWLClass)oWLClassExpression), bl);
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLClassExpression.getObjectComplementOf(), oWLNamedIndividual);
        Tableau tableau = this.getTableau(oWLClassAssertionAxiom);
        boolean bl2 = tableau.isSatisfiable(true, true, null, null, null, null, null, ReasoningTaskDescription.isInstanceOf(oWLNamedIndividual, oWLClassExpression));
        tableau.clearAdditionalDLOntology();
        return !bl2;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression oWLClassExpression, boolean bl) {
        if (this.m_dlOntology.getAllIndividuals().size() > 0) {
            this.checkPreConditions(oWLClassExpression);
            if (!this.m_isConsistent.booleanValue()) {
                OWLNamedIndividualNode oWLNamedIndividualNode = new OWLNamedIndividualNode(this.getAllNamedIndividuals());
                return new OWLNamedIndividualNodeSet(Collections.singleton(oWLNamedIndividualNode));
            }
            if (bl || !(oWLClassExpression instanceof OWLClass)) {
                this.classifyClasses();
            }
            this.initialiseClassInstanceManager();
            HashSet<Individual> hashSet = new HashSet();
            if (oWLClassExpression instanceof OWLClass) {
                hashSet = this.m_instanceManager.getInstances(Reasoner.H((OWLClass)oWLClassExpression), bl);
            } else {
                HierarchyNode<AtomicConcept> hierarchyNode = this.getHierarchyNode(oWLClassExpression);
                hashSet = this.m_instanceManager.getInstances(hierarchyNode, bl);
                OWLDataFactory oWLDataFactory = this.getDataFactory();
                OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:query-concept"));
                OWLSubClassOfAxiom oWLSubClassOfAxiom = oWLDataFactory.getOWLSubClassOfAxiom(oWLClass, oWLClassExpression.getObjectComplementOf());
                AtomicConcept atomicConcept = AtomicConcept.create("internal:query-concept");
                HashSet<HierarchyNode<AtomicConcept>> hashSet2 = new HashSet<HierarchyNode<AtomicConcept>>(hierarchyNode.getChildNodes());
                ArrayList<HierarchyNode<AtomicConcept>> arrayList = new ArrayList<HierarchyNode<AtomicConcept>>(hierarchyNode.getParentNodes());
                while (!arrayList.isEmpty()) {
                    HierarchyNode hierarchyNode2 = (HierarchyNode)arrayList.remove(arrayList.size() - 1);
                    if (!hashSet2.add(hierarchyNode2)) continue;
                    Set<Individual> set2 = this.m_instanceManager.getInstances(hierarchyNode2, true);
                    if (set2 != null) {
                        Tableau tableau = this.getTableau(oWLSubClassOfAxiom);
                        for (Individual individual : set2) {
                            if (!Reasoner.isResultRelevantIndividual(individual) || tableau.isSatisfiable(true, true, Collections.singleton(Atom.create(atomicConcept, individual)), null, null, null, null, ReasoningTaskDescription.isInstanceOf(individual, oWLClassExpression))) continue;
                            hashSet.add(individual);
                        }
                        tableau.clearAdditionalDLOntology();
                    }
                    arrayList.addAll(hierarchyNode2.getChildNodes());
                }
            }
            return this.sortBySameAsIfNecessary(hashSet);
        }
        return new OWLNamedIndividualNodeSet((Set<Node<OWLNamedIndividual>>)new HashSet<Node<OWLNamedIndividual>>());
    }

    public boolean isSameIndividual(OWLNamedIndividual oWLNamedIndividual, OWLNamedIndividual oWLNamedIndividual2) {
        this.checkPreConditions(oWLNamedIndividual, oWLNamedIndividual2);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        if (this.m_dlOntology.getAllIndividuals().size() == 0) {
            return false;
        }
        this.initialiseClassInstanceManager();
        this.m_instanceManager.computeSameAsEquivalenceClasses(this.m_configuration.reasonerProgressMonitor);
        return this.m_instanceManager.isSameIndividual(Reasoner.H(oWLNamedIndividual), Reasoner.H(oWLNamedIndividual2));
    }

    @Override
    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual oWLNamedIndividual) {
        this.checkPreConditions(oWLNamedIndividual);
        if (!this.m_isConsistent.booleanValue()) {
            return new OWLNamedIndividualNode(this.getAllNamedIndividuals());
        }
        if (this.m_dlOntology.getAllIndividuals().size() == 0 || !this.m_dlOntology.containsIndividual(Reasoner.H(oWLNamedIndividual))) {
            return new OWLNamedIndividualNode(oWLNamedIndividual);
        }
        this.initialiseClassInstanceManager();
        Set<Individual> set2 = this.m_instanceManager.getSameAsIndividuals(Reasoner.H(oWLNamedIndividual));
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        HashSet<OWLNamedIndividual> hashSet = new HashSet<OWLNamedIndividual>();
        for (Individual individual : set2) {
            hashSet.add(oWLDataFactory.getOWLNamedIndividual(IRI.create(individual.getIRI())));
        }
        return new OWLNamedIndividualNode((Set<OWLNamedIndividual>)hashSet);
    }

    @Override
    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual oWLNamedIndividual) {
        this.checkPreConditions(oWLNamedIndividual);
        if (!this.m_isConsistent.booleanValue()) {
            OWLNamedIndividualNode oWLNamedIndividualNode = new OWLNamedIndividualNode(this.getAllNamedIndividuals());
            return new OWLNamedIndividualNodeSet(Collections.singleton(oWLNamedIndividualNode));
        }
        Individual individual = Reasoner.H(oWLNamedIndividual);
        Tableau tableau = this.getTableau();
        HashSet<Individual> hashSet = new HashSet<Individual>();
        for (Individual individual2 : this.m_dlOntology.getAllIndividuals()) {
            if (!Reasoner.isResultRelevantIndividual(individual2) || individual.equals(individual2) || tableau.isSatisfiable(true, true, Collections.singleton(Atom.create(Equality.INSTANCE, individual, individual2)), null, null, null, null, new ReasoningTaskDescription(true, "is {0} different from {1}", individual, individual2))) continue;
            hashSet.add(individual2);
        }
        return this.sortBySameAsIfNecessary(hashSet);
    }

    @Override
    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.checkPreConditions(oWLNamedIndividual, oWLObjectPropertyExpression);
        if (!this.m_isConsistent.booleanValue()) {
            OWLNamedIndividualNode oWLNamedIndividualNode = new OWLNamedIndividualNode(this.getAllNamedIndividuals());
            return new OWLNamedIndividualNodeSet(Collections.singleton(oWLNamedIndividualNode));
        }
        AtomicRole atomicRole = Reasoner.H(oWLObjectPropertyExpression.getNamedProperty());
        if (!this.m_dlOntology.containsObjectRole(atomicRole)) {
            return new OWLNamedIndividualNodeSet();
        }
        this.initialisePropertiesInstanceManager();
        Individual individual = Reasoner.H(oWLNamedIndividual);
        Set<Individual> set2 = oWLObjectPropertyExpression.getSimplified().isAnonymous() ? this.m_instanceManager.getObjectPropertySubjects(atomicRole, individual) : this.m_instanceManager.getObjectPropertyValues(atomicRole, individual);
        return this.sortBySameAsIfNecessary(set2);
    }

    public Map<OWLNamedIndividual, Set<OWLNamedIndividual>> getObjectPropertyInstances(OWLObjectProperty oWLObjectProperty) {
        this.checkPreConditions(oWLObjectProperty);
        HashMap<OWLNamedIndividual, Set<OWLNamedIndividual>> hashMap = new HashMap<OWLNamedIndividual, Set<OWLNamedIndividual>>();
        if (!this.m_isConsistent.booleanValue()) {
            Set<OWLNamedIndividual> set2 = this.getAllNamedIndividuals();
            for (OWLNamedIndividual oWLNamedIndividual : set2) {
                hashMap.put(oWLNamedIndividual, set2);
            }
            return hashMap;
        }
        this.initialisePropertiesInstanceManager();
        AtomicRole atomicRole = Reasoner.H(oWLObjectProperty);
        Map<Individual, Set<Individual>> map2 = this.m_instanceManager.getObjectPropertyInstances(atomicRole);
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        for (Individual individual : map2.keySet()) {
            HashSet<OWLNamedIndividual> hashSet = new HashSet<OWLNamedIndividual>();
            hashMap.put(oWLDataFactory.getOWLNamedIndividual(IRI.create(individual.getIRI())), hashSet);
            for (Individual individual2 : map2.get(individual)) {
                hashSet.add(oWLDataFactory.getOWLNamedIndividual(IRI.create(individual2.getIRI())));
            }
        }
        return hashMap;
    }

    public boolean hasObjectPropertyRelationship(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLNamedIndividual oWLNamedIndividual2) {
        Serializable serializable;
        this.checkPreConditions(oWLNamedIndividual, oWLObjectPropertyExpression, oWLNamedIndividual2);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        this.initialisePropertiesInstanceManager();
        OWLObjectProperty oWLObjectProperty = oWLObjectPropertyExpression.getNamedProperty();
        if (oWLObjectPropertyExpression.getSimplified().isAnonymous()) {
            serializable = oWLNamedIndividual;
            oWLNamedIndividual = oWLNamedIndividual2;
            oWLNamedIndividual2 = serializable;
        }
        serializable = Reasoner.H(oWLObjectProperty);
        Individual individual = Reasoner.H(oWLNamedIndividual);
        Individual individual2 = Reasoner.H(oWLNamedIndividual2);
        return this.m_instanceManager.hasObjectRoleRelationship((AtomicRole)serializable, individual, individual2);
    }

    @Override
    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLDataProperty oWLDataProperty) {
        this.checkPreConditions(oWLNamedIndividual, oWLDataProperty);
        HashSet<OWLLiteral> hashSet = new HashSet<OWLLiteral>();
        if (this.m_dlOntology.hasDatatypes()) {
            OWLDataFactory oWLDataFactory = this.getDataFactory();
            Set<OWLDataProperty> set2 = this.getSubDataProperties(oWLDataProperty, false).getFlattened();
            set2.add(oWLDataProperty);
            Set<OWLNamedIndividual> set3 = this.getSameIndividuals(oWLNamedIndividual).getEntities();
            for (OWLDataProperty oWLDataProperty2 : set2) {
                if (oWLDataProperty2.isBottomEntity()) continue;
                AtomicRole atomicRole = Reasoner.H(oWLDataProperty2);
                Map<Individual, Set<Constant>> map2 = this.m_dlOntology.getDataPropertyAssertions().get(atomicRole);
                if (map2 == null) continue;
                for (OWLNamedIndividual oWLNamedIndividual2 : set3) {
                    Individual individual = Reasoner.H(oWLNamedIndividual2);
                    if (!map2.containsKey(individual)) continue;
                    for (Constant constant : map2.get(individual)) {
                        OWLLiteral oWLLiteral;
                        String string2 = constant.getLexicalForm();
                        String string3 = constant.getDatatypeURI();
                        if ((Prefixes.s_semanticWebPrefixes.get("rdf:") + "PlainLiteral").equals(string3)) {
                            int n = string2.lastIndexOf(64);
                            oWLLiteral = oWLDataFactory.getOWLLiteral(string2.substring(0, n), string2.substring(n + 1));
                        } else {
                            oWLLiteral = oWLDataFactory.getOWLLiteral(string2, oWLDataFactory.getOWLDatatype(IRI.create(string3)));
                        }
                        hashSet.add(oWLLiteral);
                    }
                }
            }
        }
        return hashSet;
    }

    public boolean hasDataPropertyRelationship(OWLNamedIndividual oWLNamedIndividual, OWLDataProperty oWLDataProperty, OWLLiteral oWLLiteral) {
        this.checkPreConditions(oWLNamedIndividual, oWLDataProperty);
        if (!this.m_isConsistent.booleanValue()) {
            return true;
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom = oWLDataFactory.getOWLNegativeDataPropertyAssertionAxiom(oWLDataProperty, oWLNamedIndividual, oWLLiteral);
        Tableau tableau = this.getTableau(oWLNegativeDataPropertyAssertionAxiom);
        boolean bl = tableau.isSatisfiable(true, true, null, null, null, null, null, new ReasoningTaskDescription(true, "is {0} connected to {1} via {2}", Reasoner.H(oWLNamedIndividual), oWLLiteral, Reasoner.H(oWLDataProperty)));
        tableau.clearAdditionalDLOntology();
        return !bl;
    }

    protected Set<HierarchyNode<AtomicConcept>> getDirectSuperConceptNodes(final Individual individual) {
        HierarchySearch.SearchPredicate<HierarchyNode<AtomicConcept>> searchPredicate = new HierarchySearch.SearchPredicate<HierarchyNode<AtomicConcept>>(){

            @Override
            public Set<HierarchyNode<AtomicConcept>> getSuccessorElements(HierarchyNode<AtomicConcept> hierarchyNode) {
                return hierarchyNode.getChildNodes();
            }

            @Override
            public Set<HierarchyNode<AtomicConcept>> getPredecessorElements(HierarchyNode<AtomicConcept> hierarchyNode) {
                return hierarchyNode.getParentNodes();
            }

            @Override
            public boolean trueOf(HierarchyNode<AtomicConcept> hierarchyNode) {
                AtomicConcept atomicConcept = hierarchyNode.getRepresentative();
                if (AtomicConcept.THING.equals(atomicConcept)) {
                    return true;
                }
                return !Reasoner.this.getTableau().isSatisfiable(true, true, null, Collections.singleton(Atom.create(atomicConcept, individual)), null, null, null, ReasoningTaskDescription.isInstanceOf(atomicConcept, individual));
            }
        };
        return HierarchySearch.search(searchPredicate, Collections.singleton(this.m_atomicConceptHierarchy.getTopNode()), null);
    }

    protected NodeSet<OWLNamedIndividual> sortBySameAsIfNecessary(Set<Individual> set2) {
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        HashSet<Node<OWLNamedIndividual>> hashSet = new HashSet<Node<OWLNamedIndividual>>();
        if (this.m_configuration.individualNodeSetPolicy == IndividualNodeSetPolicy.BY_SAME_AS) {
            while (!set2.isEmpty()) {
                this.initialiseClassInstanceManager();
                Individual individual = set2.iterator().next();
                Set<Individual> set3 = this.m_instanceManager.getSameAsIndividuals(individual);
                HashSet<OWLNamedIndividual> hashSet2 = new HashSet<OWLNamedIndividual>();
                for (Individual individual2 : set3) {
                    hashSet2.add(oWLDataFactory.getOWLNamedIndividual(IRI.create(individual2.getIRI())));
                }
                set2.removeAll(set3);
                hashSet.add(new OWLNamedIndividualNode((Set<OWLNamedIndividual>)hashSet2));
            }
        } else {
            for (Individual individual : set2) {
                hashSet.add(new OWLNamedIndividualNode(oWLDataFactory.getOWLNamedIndividual(IRI.create(individual.getIRI()))));
            }
        }
        return new OWLNamedIndividualNodeSet((Set<Node<OWLNamedIndividual>>)hashSet);
    }

    protected Set<OWLNamedIndividual> getAllNamedIndividuals() {
        HashSet<OWLNamedIndividual> hashSet = new HashSet<OWLNamedIndividual>();
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        for (Individual individual : this.m_dlOntology.getAllIndividuals()) {
            if (!Reasoner.isResultRelevantIndividual(individual)) continue;
            hashSet.add(oWLDataFactory.getOWLNamedIndividual(IRI.create(individual.getIRI())));
        }
        return hashSet;
    }

    protected static boolean isResultRelevantIndividual(Individual individual) {
        return !individual.isAnonymous() && !Prefixes.isInternalIRI(individual.getIRI());
    }

    public Tableau getTableau() {
        this.m_tableau.clearAdditionalDLOntology();
        return this.m_tableau;
    }

    public Tableau getTableau(OWLAxiom ... oWLAxiomArray) throws IllegalArgumentException {
        if (oWLAxiomArray == null || oWLAxiomArray.length == 0) {
            return this.getTableau();
        }
        DLOntology dLOntology = this.createDeltaDLOntology(this.m_configuration, this.m_dlOntology, oWLAxiomArray);
        if (this.m_tableau.supportsAdditionalDLOntology(dLOntology)) {
            this.m_tableau.setAdditionalDLOntology(dLOntology);
            return this.m_tableau;
        }
        return Reasoner.createTableau(this.m_interruptFlag, this.m_configuration, this.m_dlOntology, dLOntology, this.m_prefixes);
    }

    protected static Tableau createTableau(InterruptFlag interruptFlag, Configuration configuration, DLOntology dLOntology, DLOntology dLOntology2, Prefixes prefixes) throws IllegalArgumentException {
        boolean bl = dLOntology.hasInverseRoles() || dLOntology2 != null && dLOntology2.hasInverseRoles();
        boolean bl2 = dLOntology.hasNominals() || dLOntology2 != null && dLOntology2.hasNominals();
        TableauMonitor tableauMonitor = null;
        switch (configuration.tableauMonitorType) {
            case NONE: {
                tableauMonitor = null;
                break;
            }
            case TIMING: {
                tableauMonitor = new Timer();
                break;
            }
            case TIMING_WITH_PAUSE: {
                tableauMonitor = new TimerWithPause();
                break;
            }
            case DEBUGGER_HISTORY_ON: {
                tableauMonitor = new Debugger(prefixes, true);
                break;
            }
            case DEBUGGER_NO_HISTORY: {
                tableauMonitor = new Debugger(prefixes, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown monitor type");
            }
        }
        TableauMonitor tableauMonitor2 = null;
        tableauMonitor2 = configuration.monitor == null ? tableauMonitor : (tableauMonitor == null ? configuration.monitor : new TableauMonitorFork(tableauMonitor, configuration.monitor));
        DirectBlockingChecker directBlockingChecker = null;
        switch (configuration.directBlockingType) {
            case OPTIMAL: {
                if (configuration.blockingStrategyType == Configuration.BlockingStrategyType.SIMPLE_CORE || configuration.blockingStrategyType == Configuration.BlockingStrategyType.COMPLEX_CORE) {
                    directBlockingChecker = new ValidatedSingleDirectBlockingChecker(bl);
                    break;
                }
                if (bl) {
                    directBlockingChecker = new PairWiseDirectBlockingChecker();
                    break;
                }
                directBlockingChecker = new SingleDirectBlockingChecker();
                break;
            }
            case SINGLE: {
                if (configuration.blockingStrategyType == Configuration.BlockingStrategyType.SIMPLE_CORE || configuration.blockingStrategyType == Configuration.BlockingStrategyType.COMPLEX_CORE) {
                    directBlockingChecker = new ValidatedSingleDirectBlockingChecker(bl);
                    break;
                }
                directBlockingChecker = new SingleDirectBlockingChecker();
                break;
            }
            case PAIR_WISE: {
                if (configuration.blockingStrategyType == Configuration.BlockingStrategyType.SIMPLE_CORE || configuration.blockingStrategyType == Configuration.BlockingStrategyType.COMPLEX_CORE) {
                    directBlockingChecker = new ValidatedPairwiseDirectBlockingChecker(bl);
                    break;
                }
                directBlockingChecker = new PairWiseDirectBlockingChecker();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direct blocking type.");
            }
        }
        BlockingSignatureCache blockingSignatureCache = null;
        if (!bl2 && configuration.blockingStrategyType != Configuration.BlockingStrategyType.SIMPLE_CORE && configuration.blockingStrategyType != Configuration.BlockingStrategyType.COMPLEX_CORE) {
            switch (configuration.blockingSignatureCacheType) {
                case CACHED: {
                    blockingSignatureCache = new BlockingSignatureCache(directBlockingChecker);
                    break;
                }
                case NOT_CACHED: {
                    blockingSignatureCache = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown blocking cache type.");
                }
            }
        }
        BlockingStrategy blockingStrategy = null;
        switch (configuration.blockingStrategyType) {
            case ANCESTOR: {
                blockingStrategy = new AncestorBlocking(directBlockingChecker, blockingSignatureCache);
                break;
            }
            case ANYWHERE: {
                blockingStrategy = new AnywhereBlocking(directBlockingChecker, blockingSignatureCache);
                break;
            }
            case SIMPLE_CORE: {
                blockingStrategy = new AnywhereValidatedBlocking(directBlockingChecker, bl, true);
                break;
            }
            case COMPLEX_CORE: {
                blockingStrategy = new AnywhereValidatedBlocking(directBlockingChecker, bl, false);
                break;
            }
            case OPTIMAL: {
                blockingStrategy = new AnywhereBlocking(directBlockingChecker, blockingSignatureCache);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown blocking strategy type.");
            }
        }
        AbstractExpansionStrategy abstractExpansionStrategy = null;
        switch (configuration.existentialStrategyType) {
            case CREATION_ORDER: {
                abstractExpansionStrategy = new CreationOrderStrategy(blockingStrategy);
                break;
            }
            case EL: {
                abstractExpansionStrategy = new IndividualReuseStrategy(blockingStrategy, true);
                break;
            }
            case INDIVIDUAL_REUSE: {
                abstractExpansionStrategy = new IndividualReuseStrategy(blockingStrategy, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown expansion strategy type.");
            }
        }
        return new Tableau(interruptFlag, tableauMonitor2, abstractExpansionStrategy, configuration.useDisjunctionLearning, dLOntology, dLOntology2, configuration.parameters);
    }

    protected Hierarchy<AtomicConcept> classifyAtomicConcepts(Tableau tableau, ClassificationProgressMonitor classificationProgressMonitor, AtomicConcept atomicConcept, AtomicConcept atomicConcept2, Set<AtomicConcept> set2, boolean bl) {
        if (tableau.isDeterministic() && !bl) {
            return new DeterministicClassification(tableau, classificationProgressMonitor, atomicConcept, atomicConcept2, set2).classify();
        }
        return new QuasiOrderClassification(tableau, classificationProgressMonitor, atomicConcept, atomicConcept2, set2).classify();
    }

    protected Hierarchy<AtomicConcept> classifyAtomicConceptsForRoles(Tableau tableau, ClassificationProgressMonitor classificationProgressMonitor, AtomicConcept atomicConcept, AtomicConcept atomicConcept2, Set<AtomicConcept> set2, boolean bl, Map<Role, AtomicConcept> map2, Map<AtomicConcept, Role> map3, boolean bl2) {
        if (tableau.isDeterministic() && !bl2) {
            return new DeterministicClassification(tableau, classificationProgressMonitor, atomicConcept, atomicConcept2, set2).classify();
        }
        return new QuasiOrderClassificationForRoles(tableau, classificationProgressMonitor, atomicConcept, atomicConcept2, set2, bl, map2, map3).classify();
    }

    protected DLOntology createDeltaDLOntology(Configuration configuration, DLOntology dLOntology, OWLAxiom ... oWLAxiomArray) throws IllegalArgumentException {
        HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
        for (OWLAxiom oWLAxiom : oWLAxiomArray) {
            if (Reasoner.isUnsupportedExtensionAxiom(oWLAxiom)) {
                throw new IllegalArgumentException("Internal error: unsupported extension axiom type.");
            }
            hashSet.add(oWLAxiom);
        }
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        OWLAxioms oWLAxioms = new OWLAxioms();
        oWLAxioms.m_definedDatatypesIRIs.addAll(dLOntology.getDefinedDatatypeIRIs());
        OWLNormalization oWLNormalization = new OWLNormalization(oWLDataFactory, oWLAxioms, dLOntology.getAllAtomicConcepts().size());
        oWLNormalization.processAxioms(hashSet);
        BuiltInPropertyManager builtInPropertyManager = new BuiltInPropertyManager(oWLDataFactory);
        builtInPropertyManager.axiomatizeBuiltInPropertiesAsNeeded(oWLAxioms, dLOntology.getAllAtomicObjectRoles().contains(AtomicRole.TOP_OBJECT_ROLE), dLOntology.getAllAtomicObjectRoles().contains(AtomicRole.BOTTOM_OBJECT_ROLE), dLOntology.getAllAtomicObjectRoles().contains(AtomicRole.TOP_DATA_ROLE), dLOntology.getAllAtomicObjectRoles().contains(AtomicRole.BOTTOM_DATA_ROLE));
        int n = this.m_objectPropertyInclusionManager.rewriteNegativeObjectPropertyAssertions(oWLDataFactory, oWLAxioms, dLOntology.getAllAtomicConcepts().size());
        this.m_objectPropertyInclusionManager.rewriteAxioms(oWLDataFactory, oWLAxioms, n);
        OWLAxiomsExpressivity oWLAxiomsExpressivity = new OWLAxiomsExpressivity(oWLAxioms);
        oWLAxiomsExpressivity.m_hasAtMostRestrictions |= dLOntology.hasAtMostRestrictions();
        oWLAxiomsExpressivity.m_hasInverseRoles |= dLOntology.hasInverseRoles();
        oWLAxiomsExpressivity.m_hasNominals |= dLOntology.hasNominals();
        oWLAxiomsExpressivity.m_hasDatatypes |= dLOntology.hasDatatypes();
        OWLClausification oWLClausification = new OWLClausification(configuration);
        Set<DescriptionGraph> set2 = Collections.emptySet();
        return oWLClausification.clausify(oWLDataFactory, "uri:urn:internal-kb", oWLAxioms, oWLAxiomsExpressivity, set2);
    }

    protected static boolean isUnsupportedExtensionAxiom(OWLAxiom oWLAxiom) {
        return oWLAxiom instanceof OWLSubObjectPropertyOfAxiom || oWLAxiom instanceof OWLTransitiveObjectPropertyAxiom || oWLAxiom instanceof OWLSubPropertyChainOfAxiom || oWLAxiom instanceof OWLFunctionalObjectPropertyAxiom || oWLAxiom instanceof OWLInverseFunctionalObjectPropertyAxiom || oWLAxiom instanceof SWRLRule;
    }

    public void dumpHierarchies(PrintWriter printWriter, boolean bl, boolean bl2, boolean bl3) {
        HierarchyDumperFSS hierarchyDumperFSS = new HierarchyDumperFSS(printWriter);
        if (bl) {
            this.classifyClasses();
            hierarchyDumperFSS.printAtomicConceptHierarchy(this.m_atomicConceptHierarchy);
        }
        if (bl2) {
            this.classifyObjectProperties();
            hierarchyDumperFSS.printObjectPropertyHierarchy(this.m_objectRoleHierarchy);
        }
        if (bl3) {
            this.classifyDataProperties();
            hierarchyDumperFSS.printDataPropertyHierarchy(this.m_dataRoleHierarchy);
        }
    }

    public void printHierarchies(PrintWriter printWriter, boolean bl, boolean bl2, boolean bl3) {
        HierarchyPrinterFSS hierarchyPrinterFSS = new HierarchyPrinterFSS(printWriter, this.m_dlOntology.getOntologyIRI() + "#");
        if (bl) {
            this.classifyClasses();
            hierarchyPrinterFSS.loadAtomicConceptPrefixIRIs(this.m_atomicConceptHierarchy.getAllElements());
        }
        if (bl2) {
            this.classifyObjectProperties();
            hierarchyPrinterFSS.loadAtomicRolePrefixIRIs(this.m_dlOntology.getAllAtomicObjectRoles());
        }
        if (bl3) {
            this.classifyDataProperties();
            hierarchyPrinterFSS.loadAtomicRolePrefixIRIs(this.m_dlOntology.getAllAtomicDataRoles());
        }
        hierarchyPrinterFSS.startPrinting();
        boolean bl4 = true;
        if (bl && !this.m_atomicConceptHierarchy.isEmpty()) {
            hierarchyPrinterFSS.printAtomicConceptHierarchy(this.m_atomicConceptHierarchy);
            bl4 = false;
        }
        if (bl2 && !this.m_objectRoleHierarchy.isEmpty()) {
            if (!bl4) {
                printWriter.println();
            }
            hierarchyPrinterFSS.printRoleHierarchy(this.m_objectRoleHierarchy, true);
            bl4 = false;
        }
        if (bl3 && !this.m_dataRoleHierarchy.isEmpty()) {
            if (!bl4) {
                printWriter.println();
            }
            hierarchyPrinterFSS.printRoleHierarchy(this.m_dataRoleHierarchy, false);
            bl4 = false;
        }
        hierarchyPrinterFSS.endPrinting();
    }

    protected void checkPreConditions(OWLObject ... oWLObjectArray) {
        this.flushChangesIfRequired();
        if (oWLObjectArray != null && oWLObjectArray.length > 0) {
            this.throwFreshEntityExceptionIfNecessary(oWLObjectArray);
        }
        this.throwInconsistentOntologyExceptionIfNecessary();
    }

    protected void flushChangesIfRequired() {
        if (!this.m_configuration.bufferChanges && !this.m_pendingChanges.isEmpty()) {
            this.flush();
        }
    }

    protected void throwInconsistentOntologyExceptionIfNecessary() {
        if (!this.isConsistent() && this.m_configuration.throwInconsistentOntologyException) {
            throw new InconsistentOntologyException();
        }
    }

    protected void throwFreshEntityExceptionIfNecessary(OWLObject ... oWLObjectArray) {
        if (this.m_configuration.freshEntityPolicy == FreshEntityPolicy.DISALLOW) {
            HashSet<OWLEntity> hashSet = new HashSet<OWLEntity>();
            for (OWLObject oWLObject : oWLObjectArray) {
                if (oWLObject instanceof OWLEntity && ((OWLEntity)oWLObject).isBuiltIn()) continue;
                for (OWLDataProperty oWLDataProperty : oWLObject.getDataPropertiesInSignature()) {
                    if (this.isDefined(oWLDataProperty) || Prefixes.isInternalIRI(oWLDataProperty.getIRI().toString())) continue;
                    hashSet.add(oWLDataProperty);
                }
                for (OWLObjectProperty oWLObjectProperty : oWLObject.getObjectPropertiesInSignature()) {
                    if (this.isDefined(oWLObjectProperty) || Prefixes.isInternalIRI(oWLObjectProperty.getIRI().toString())) continue;
                    hashSet.add(oWLObjectProperty);
                }
                for (OWLNamedIndividual oWLNamedIndividual : oWLObject.getIndividualsInSignature()) {
                    if (this.isDefined(oWLNamedIndividual) || Prefixes.isInternalIRI(oWLNamedIndividual.getIRI().toString())) continue;
                    hashSet.add(oWLNamedIndividual);
                }
                for (OWLClass oWLClass : oWLObject.getClassesInSignature()) {
                    if (this.isDefined(oWLClass) || Prefixes.isInternalIRI(oWLClass.getIRI().toString())) continue;
                    hashSet.add(oWLClass);
                }
            }
            if (!hashSet.isEmpty()) {
                throw new FreshEntitiesException((Set<OWLEntity>)hashSet);
            }
        }
    }

    protected boolean containsFreshEntities(OWLObject ... oWLObjectArray) {
        for (OWLObject oWLObject : oWLObjectArray) {
            if (oWLObject instanceof OWLEntity && ((OWLEntity)oWLObject).isBuiltIn()) continue;
            for (OWLDataProperty oWLDataProperty : oWLObject.getDataPropertiesInSignature()) {
                if (this.isDefined(oWLDataProperty) || Prefixes.isInternalIRI(oWLDataProperty.getIRI().toString())) continue;
                return true;
            }
            for (OWLObjectProperty oWLObjectProperty : oWLObject.getObjectPropertiesInSignature()) {
                if (this.isDefined(oWLObjectProperty) || Prefixes.isInternalIRI(oWLObjectProperty.getIRI().toString())) continue;
                return true;
            }
            for (OWLNamedIndividual oWLNamedIndividual : oWLObject.getIndividualsInSignature()) {
                if (this.isDefined(oWLNamedIndividual) || Prefixes.isInternalIRI(oWLNamedIndividual.getIRI().toString())) continue;
                return true;
            }
            for (OWLClass oWLClass : oWLObject.getClassesInSignature()) {
                if (this.isDefined(oWLClass) || Prefixes.isInternalIRI(oWLClass.getIRI().toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected static AtomicConcept H(OWLClass oWLClass) {
        return AtomicConcept.create(oWLClass.getIRI().toString());
    }

    protected static AtomicRole H(OWLObjectProperty oWLObjectProperty) {
        return AtomicRole.create(oWLObjectProperty.getIRI().toString());
    }

    protected static Role H(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        if ((oWLObjectPropertyExpression = oWLObjectPropertyExpression.getSimplified()) instanceof OWLObjectProperty) {
            return Reasoner.H((OWLObjectProperty)oWLObjectPropertyExpression);
        }
        return Reasoner.H(oWLObjectPropertyExpression.getNamedProperty()).getInverse();
    }

    protected static AtomicRole H(OWLDataProperty oWLDataProperty) {
        return AtomicRole.create(oWLDataProperty.getIRI().toString());
    }

    protected static Role H(OWLDataPropertyExpression oWLDataPropertyExpression) {
        return Reasoner.H((OWLDataProperty)oWLDataPropertyExpression);
    }

    protected static Individual H(OWLNamedIndividual oWLNamedIndividual) {
        return Individual.create(oWLNamedIndividual.getIRI().toString());
    }

    protected static Individual H(OWLAnonymousIndividual oWLAnonymousIndividual) {
        return Individual.createAnonymous(((Object)oWLAnonymousIndividual.getID()).toString());
    }

    protected static Individual H(OWLIndividual oWLIndividual) {
        if (oWLIndividual.isAnonymous()) {
            return Reasoner.H((OWLAnonymousIndividual)oWLIndividual);
        }
        return Reasoner.H((OWLNamedIndividual)oWLIndividual);
    }

    protected Node<OWLClass> atomicConceptHierarchyNodeToNode(HierarchyNode<AtomicConcept> hierarchyNode) {
        HashSet<OWLClass> hashSet = new HashSet<OWLClass>();
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        for (AtomicConcept atomicConcept : hierarchyNode.getEquivalentElements()) {
            if (Prefixes.isInternalIRI(atomicConcept.getIRI())) continue;
            hashSet.add(oWLDataFactory.getOWLClass(IRI.create(atomicConcept.getIRI())));
        }
        return new OWLClassNode((Set<OWLClass>)hashSet);
    }

    protected NodeSet<OWLClass> atomicConceptHierarchyNodesToNodeSet(Collection<HierarchyNode<AtomicConcept>> collection) {
        HashSet<Node<OWLClass>> hashSet = new HashSet<Node<OWLClass>>();
        for (HierarchyNode<AtomicConcept> hierarchyNode : collection) {
            Node<OWLClass> node2 = this.atomicConceptHierarchyNodeToNode(hierarchyNode);
            if (node2.getSize() == 0) continue;
            hashSet.add(node2);
        }
        return new OWLClassNodeSet((Set<Node<OWLClass>>)hashSet);
    }

    protected Node<OWLObjectPropertyExpression> objectPropertyHierarchyNodeToNode(HierarchyNode<Role> hierarchyNode) {
        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        for (Role role : hierarchyNode.getEquivalentElements()) {
            if (role instanceof AtomicRole) {
                hashSet.add(oWLDataFactory.getOWLObjectProperty(IRI.create(((AtomicRole)role).getIRI())));
                continue;
            }
            OWLObjectProperty oWLObjectProperty = oWLDataFactory.getOWLObjectProperty(IRI.create(((InverseRole)role).getInverseOf().getIRI()));
            hashSet.add(oWLDataFactory.getOWLObjectInverseOf(oWLObjectProperty));
        }
        return new OWLObjectPropertyNode((Set<OWLObjectPropertyExpression>)hashSet);
    }

    protected NodeSet<OWLObjectPropertyExpression> objectPropertyHierarchyNodesToNodeSet(Collection<HierarchyNode<Role>> collection) {
        HashSet<Node<OWLObjectPropertyExpression>> hashSet = new HashSet<Node<OWLObjectPropertyExpression>>();
        for (HierarchyNode<Role> hierarchyNode : collection) {
            hashSet.add(this.objectPropertyHierarchyNodeToNode(hierarchyNode));
        }
        return new OWLObjectPropertyNodeSet((Set<Node<OWLObjectPropertyExpression>>)hashSet);
    }

    protected Node<OWLDataProperty> dataPropertyHierarchyNodeToNode(HierarchyNode<AtomicRole> hierarchyNode) {
        HashSet<OWLDataProperty> hashSet = new HashSet<OWLDataProperty>();
        OWLDataFactory oWLDataFactory = this.getDataFactory();
        for (AtomicRole atomicRole : hierarchyNode.getEquivalentElements()) {
            hashSet.add(oWLDataFactory.getOWLDataProperty(IRI.create(atomicRole.getIRI())));
        }
        return new OWLDataPropertyNode((Set<OWLDataProperty>)hashSet);
    }

    protected NodeSet<OWLDataProperty> dataPropertyHierarchyNodesToNodeSet(Collection<HierarchyNode<AtomicRole>> collection) {
        HashSet<Node<OWLDataProperty>> hashSet = new HashSet<Node<OWLDataProperty>>();
        for (HierarchyNode<AtomicRole> hierarchyNode : collection) {
            hashSet.add(this.dataPropertyHierarchyNodeToNode(hierarchyNode));
        }
        return new OWLDataPropertyNodeSet((Set<Node<OWLDataProperty>>)hashSet);
    }

    public static class ReasonerFactory
    implements OWLReasonerFactory {
        public String getReasonerName() {
            return this.getClass().getPackage().getImplementationTitle();
        }

        public OWLReasoner createReasoner(OWLOntology oWLOntology) {
            return this.createReasoner(oWLOntology, null);
        }

        public OWLReasoner createReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) {
            return this.createHermiTOWLReasoner(this.getProtegeConfiguration(oWLReasonerConfiguration), oWLOntology);
        }

        public OWLReasoner createNonBufferingReasoner(OWLOntology oWLOntology) {
            return this.createNonBufferingReasoner(oWLOntology, null);
        }

        public OWLReasoner createNonBufferingReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration) {
            Configuration configuration = this.getProtegeConfiguration(oWLReasonerConfiguration);
            configuration.bufferChanges = false;
            return this.createHermiTOWLReasoner(configuration, oWLOntology);
        }

        protected Configuration getProtegeConfiguration(OWLReasonerConfiguration oWLReasonerConfiguration) {
            Configuration configuration;
            if (oWLReasonerConfiguration != null) {
                if (oWLReasonerConfiguration instanceof Configuration) {
                    configuration = (Configuration)oWLReasonerConfiguration;
                } else {
                    configuration = new Configuration();
                    configuration.freshEntityPolicy = oWLReasonerConfiguration.getFreshEntityPolicy();
                    configuration.individualNodeSetPolicy = oWLReasonerConfiguration.getIndividualNodeSetPolicy();
                    configuration.reasonerProgressMonitor = oWLReasonerConfiguration.getProgressMonitor();
                    configuration.individualTaskTimeout = oWLReasonerConfiguration.getTimeOut();
                }
            } else {
                configuration = new Configuration();
                configuration.ignoreUnsupportedDatatypes = true;
            }
            return configuration;
        }

        protected OWLReasoner createHermiTOWLReasoner(Configuration configuration, OWLOntology oWLOntology) {
            return new Reasoner(configuration, oWLOntology);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OntologyChangeListener
    implements OWLOntologyChangeListener {
        protected OntologyChangeListener() {
        }

        @Override
        public void ontologiesChanged(List<? extends OWLOntologyChange> list) throws OWLException {
            for (OWLOntologyChange oWLOntologyChange : list) {
                if (oWLOntologyChange instanceof RemoveOntologyAnnotation || oWLOntologyChange instanceof AddOntologyAnnotation) continue;
                Reasoner.this.m_pendingChanges.add(oWLOntologyChange);
            }
        }
    }
}

