/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.List;
import org.semanticweb.HermiT.blocking.BlockersCache;
import org.semanticweb.HermiT.blocking.BlockingSignatureCache;
import org.semanticweb.HermiT.blocking.BlockingStrategy;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnywhereBlocking
implements BlockingStrategy,
Serializable {
    private static final long serialVersionUID = -2959900333817197464L;
    protected final DirectBlockingChecker m_directBlockingChecker;
    protected final BlockersCache m_currentBlockersCache;
    protected final BlockingSignatureCache m_blockingSignatureCache;
    protected Tableau m_tableau;
    protected boolean m_useBlockingSignatureCache;
    protected Node m_firstChangedNode;

    public AnywhereBlocking(DirectBlockingChecker directBlockingChecker, BlockingSignatureCache blockingSignatureCache) {
        this.m_directBlockingChecker = directBlockingChecker;
        this.m_currentBlockersCache = new BlockersCache(this.m_directBlockingChecker);
        this.m_blockingSignatureCache = blockingSignatureCache;
    }

    @Override
    public void initialize(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_directBlockingChecker.initialize(tableau);
        this.updateBlockingSignatureCacheUsage();
    }

    @Override
    public void additionalDLOntologySet(DLOntology dLOntology) {
        this.updateBlockingSignatureCacheUsage();
    }

    @Override
    public void additionalDLOntologyCleared() {
        this.updateBlockingSignatureCacheUsage();
    }

    protected void updateBlockingSignatureCacheUsage() {
        this.m_useBlockingSignatureCache = this.m_tableau.getAdditionalHyperresolutionManager() == null;
    }

    @Override
    public void clear() {
        this.m_currentBlockersCache.clear();
        this.m_firstChangedNode = null;
        this.m_directBlockingChecker.clear();
    }

    @Override
    public void computeBlocking(boolean bl) {
        if (this.m_firstChangedNode != null) {
            boolean bl2;
            Node node2;
            for (node2 = this.m_firstChangedNode; node2 != null; node2 = node2.getNextTableauNode()) {
                this.m_currentBlockersCache.removeNode(node2);
            }
            boolean bl3 = bl2 = this.m_useBlockingSignatureCache && this.m_blockingSignatureCache != null && !this.m_blockingSignatureCache.isEmpty();
            for (node2 = this.m_firstChangedNode; node2 != null; node2 = node2.getNextTableauNode()) {
                if (!node2.isActive() || !this.m_directBlockingChecker.canBeBlocked(node2) && !this.m_directBlockingChecker.canBeBlocker(node2)) continue;
                if (this.m_directBlockingChecker.hasBlockingInfoChanged(node2) || !node2.isDirectlyBlocked() || node2.getBlocker().getNodeID() >= this.m_firstChangedNode.getNodeID()) {
                    Node node3;
                    Node node4 = node2.getParent();
                    if (node4 == null) {
                        node2.setBlocked(null, false);
                    } else if (node4.isBlocked()) {
                        node2.setBlocked(node4, false);
                    } else if (bl2) {
                        if (this.m_blockingSignatureCache.containsSignature(node2)) {
                            node2.setBlocked(Node.SIGNATURE_CACHE_BLOCKER, true);
                        } else {
                            node2.setBlocked(node3, (node3 = this.m_currentBlockersCache.getBlocker(node2)) != null);
                        }
                    } else {
                        node2.setBlocked(node3, (node3 = this.m_currentBlockersCache.getBlocker(node2)) != null);
                    }
                    if (!node2.isBlocked() && this.m_directBlockingChecker.canBeBlocker(node2)) {
                        this.m_currentBlockersCache.addNode(node2);
                    }
                }
                this.m_directBlockingChecker.clearBlockingInfoChanged(node2);
            }
            this.m_firstChangedNode = null;
        }
    }

    @Override
    public boolean isPermanentAssertion(Concept concept, Node node2) {
        return true;
    }

    @Override
    public boolean isPermanentAssertion(DataRange dataRange, Node node2) {
        return true;
    }

    @Override
    public void assertionAdded(Concept concept, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(concept, node2, bl));
    }

    @Override
    public void assertionCoreSet(Concept concept, Node node2) {
    }

    @Override
    public void assertionRemoved(Concept concept, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(concept, node2, bl));
    }

    @Override
    public void assertionAdded(DataRange dataRange, Node node2, boolean bl) {
        this.m_directBlockingChecker.assertionAdded(dataRange, node2, bl);
    }

    @Override
    public void assertionCoreSet(DataRange dataRange, Node node2) {
    }

    @Override
    public void assertionRemoved(DataRange dataRange, Node node2, boolean bl) {
        this.m_directBlockingChecker.assertionRemoved(dataRange, node2, bl);
    }

    @Override
    public void assertionAdded(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(atomicRole, node2, node3, bl));
    }

    @Override
    public void nodesMerged(Node node2, Node node3) {
        this.updateNodeChange(this.m_directBlockingChecker.nodesMerged(node2, node3));
    }

    @Override
    public void nodesUnmerged(Node node2, Node node3) {
        this.updateNodeChange(this.m_directBlockingChecker.nodesUnmerged(node2, node3));
    }

    @Override
    public void assertionCoreSet(AtomicRole atomicRole, Node node2, Node node3) {
    }

    @Override
    public void assertionRemoved(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(atomicRole, node2, node3, bl));
    }

    @Override
    public void nodeStatusChanged(Node node2) {
        this.updateNodeChange(node2);
    }

    protected final void updateNodeChange(Node node2) {
        if (node2 != null && (this.m_firstChangedNode == null || node2.getNodeID() < this.m_firstChangedNode.getNodeID())) {
            this.m_firstChangedNode = node2;
        }
    }

    @Override
    public void nodeInitialized(Node node2) {
        this.m_directBlockingChecker.nodeInitialized(node2);
    }

    @Override
    public void nodeDestroyed(Node node2) {
        this.m_currentBlockersCache.removeNode(node2);
        this.m_directBlockingChecker.nodeDestroyed(node2);
        if (this.m_firstChangedNode != null && this.m_firstChangedNode.getNodeID() >= node2.getNodeID()) {
            this.m_firstChangedNode = null;
        }
    }

    @Override
    public void modelFound() {
        if (this.m_useBlockingSignatureCache && this.m_blockingSignatureCache != null) {
            assert (this.m_firstChangedNode == null);
            for (Node node2 = this.m_tableau.getFirstTableauNode(); node2 != null; node2 = node2.getNextTableauNode()) {
                if (!node2.isActive() || node2.isBlocked() || !this.m_directBlockingChecker.canBeBlocker(node2)) continue;
                this.m_blockingSignatureCache.addNode(node2);
            }
        }
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public void dlClauseBodyCompiled(List<DLClauseEvaluator.Worker> list, DLClause dLClause, List<Variable> list2, Object[] objectArray, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
    }
}

