/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.List;
import org.semanticweb.HermiT.blocking.BlockingStrategy;
import org.semanticweb.HermiT.blocking.BlockingValidator;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.blocking.ValidatedBlockersCache;
import org.semanticweb.HermiT.blocking.ValidatedSingleDirectBlockingChecker;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.NodeType;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnywhereValidatedBlocking
implements BlockingStrategy {
    protected final DirectBlockingChecker m_directBlockingChecker;
    protected final ValidatedBlockersCache m_currentBlockersCache;
    protected BlockingValidator m_permanentBlockingValidator;
    protected BlockingValidator m_additionalBlockingValidator;
    protected Tableau m_tableau;
    protected ExtensionManager m_extensionManager;
    protected Node m_firstChangedNode;
    protected Node m_lastValidatedUnchangedNode;
    protected boolean m_useSimpleCore;
    protected final boolean m_hasInverses;

    public AnywhereValidatedBlocking(DirectBlockingChecker directBlockingChecker, boolean bl, boolean bl2) {
        this.m_directBlockingChecker = directBlockingChecker;
        this.m_currentBlockersCache = new ValidatedBlockersCache(this.m_directBlockingChecker);
        this.m_hasInverses = bl;
        this.m_useSimpleCore = bl2;
    }

    @Override
    public void initialize(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_directBlockingChecker.initialize(tableau);
        this.m_extensionManager = this.m_tableau.getExtensionManager();
        this.m_permanentBlockingValidator = new BlockingValidator(this.m_tableau, this.m_tableau.getPermanentDLOntology().getDLClauses());
        this.updateAdditionalBlockingValidator();
    }

    @Override
    public void additionalDLOntologySet(DLOntology dLOntology) {
        this.updateAdditionalBlockingValidator();
    }

    @Override
    public void additionalDLOntologyCleared() {
        this.updateAdditionalBlockingValidator();
    }

    protected void updateAdditionalBlockingValidator() {
        this.m_additionalBlockingValidator = this.m_tableau.getAdditionalHyperresolutionManager() == null ? null : new BlockingValidator(this.m_tableau, this.m_tableau.getAdditionalDLOntology().getDLClauses());
    }

    @Override
    public void clear() {
        this.m_currentBlockersCache.clear();
        this.m_firstChangedNode = null;
        this.m_directBlockingChecker.clear();
        this.m_lastValidatedUnchangedNode = null;
        this.m_permanentBlockingValidator.clear();
        if (this.m_additionalBlockingValidator != null) {
            this.m_additionalBlockingValidator.clear();
        }
    }

    @Override
    public void computeBlocking(boolean bl) {
        if (bl) {
            this.validateBlocks();
        } else {
            this.computePreBlocking();
        }
    }

    public void computePreBlocking() {
        if (this.m_firstChangedNode != null) {
            Node node2;
            for (node2 = this.m_firstChangedNode; node2 != null; node2 = node2.getNextTableauNode()) {
                this.m_currentBlockersCache.removeNode(node2);
            }
            for (node2 = this.m_firstChangedNode; node2 != null; node2 = node2.getNextTableauNode()) {
                if (node2.isActive() && (this.m_directBlockingChecker.canBeBlocked(node2) || this.m_directBlockingChecker.canBeBlocker(node2))) {
                    if (this.m_directBlockingChecker.hasBlockingInfoChanged(node2) || !node2.isDirectlyBlocked() || node2.getBlocker().getNodeID() >= this.m_firstChangedNode.getNodeID()) {
                        Node node3 = node2.getParent();
                        if (node3 == null) {
                            node2.setBlocked(null, false);
                        } else if (node3.isBlocked()) {
                            node2.setBlocked(node3, false);
                        } else {
                            Node node4 = null;
                            if (this.m_lastValidatedUnchangedNode == null) {
                                node4 = this.m_currentBlockersCache.getBlocker(node2);
                            } else {
                                Node node5 = node2.getBlocker();
                                boolean bl = this.m_directBlockingChecker.hasChangedSinceValidation(node2);
                                for (Node node6 : this.m_currentBlockersCache.getPossibleBlockers(node2)) {
                                    if (!bl && !this.m_directBlockingChecker.hasChangedSinceValidation(node6) && node5 != node6) continue;
                                    node4 = node6;
                                    break;
                                }
                            }
                            node2.setBlocked(node4, node4 != null);
                        }
                    }
                    if (!node2.isBlocked() && this.m_directBlockingChecker.canBeBlocker(node2)) {
                        this.m_currentBlockersCache.addNode(node2);
                    }
                }
                this.m_directBlockingChecker.clearBlockingInfoChanged(node2);
            }
            this.m_firstChangedNode = null;
        }
    }

    public void validateBlocks() {
        Object object;
        Node node2;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        TableauMonitor tableauMonitor = this.m_tableau.getTableauMonitor();
        if (tableauMonitor != null) {
            tableauMonitor.blockingValidationStarted();
        }
        Node node3 = node2 = this.m_lastValidatedUnchangedNode == null ? this.m_tableau.getFirstTableauNode() : this.m_lastValidatedUnchangedNode;
        while (node2 != null) {
            this.m_currentBlockersCache.removeNode(node2);
            node2 = node2.getNextTableauNode();
        }
        node2 = node3;
        if (bl) {
            System.out.print("Model size: " + (this.m_tableau.getNumberOfNodesInTableau() - this.m_tableau.getNumberOfMergedOrPrunedNodes()) + " Current ID:");
        }
        Node node4 = null;
        while (node2 != null) {
            if (node2.isActive()) {
                if (node2.isBlocked()) {
                    ++n;
                    if (node2.isDirectlyBlocked() && (this.m_directBlockingChecker.hasChangedSinceValidation(node2) || this.m_directBlockingChecker.hasChangedSinceValidation(node2.getParent()) || this.m_directBlockingChecker.hasChangedSinceValidation(node2.getBlocker())) || !node2.getParent().isBlocked()) {
                        object = null;
                        Node node5 = node2.getBlocker();
                        if (node2.isDirectlyBlocked() && node5 != null && this.isBlockValid(node2)) {
                            object = node5;
                        }
                        if (object == null) {
                            for (Node node6 : this.m_currentBlockersCache.getPossibleBlockers(node2)) {
                                if (node6 == node5) continue;
                                node2.setBlocked(node6, true);
                                this.m_permanentBlockingValidator.blockerChanged(node2);
                                if (this.m_additionalBlockingValidator != null) {
                                    this.m_additionalBlockingValidator.blockerChanged(node2);
                                }
                                if (!this.isBlockValid(node2)) continue;
                                object = node6;
                                break;
                            }
                        }
                        if (object == null && node2.hasUnprocessedExistentials()) {
                            ++n2;
                            if (node4 == null) {
                                node4 = node2;
                            }
                        }
                        node2.setBlocked((Node)object, object != null);
                    }
                }
                this.m_lastValidatedUnchangedNode = node2;
                if (!node2.isBlocked() && this.m_directBlockingChecker.canBeBlocker(node2)) {
                    this.m_currentBlockersCache.addNode(node2);
                }
            }
            node2 = node2.getNextTableauNode();
        }
        for (node2 = node3; node2 != null; node2 = node2.getNextTableauNode()) {
            if (!node2.isActive()) continue;
            this.m_directBlockingChecker.setHasChangedSinceValidation(node2, false);
            object = (ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node2.getBlockingObject();
            object.setBlockViolatesParentConstraints(false);
            object.setHasAlreadyBeenChecked(false);
        }
        this.m_firstChangedNode = node4;
        if (tableauMonitor != null) {
            tableauMonitor.blockingValidationFinished(n2);
        }
        if (bl) {
            System.out.println("");
            System.out.println("Checked " + n + " blocked nodes of which " + n2 + " were invalid.");
        }
    }

    protected boolean isBlockValid(Node node2) {
        if (this.m_permanentBlockingValidator.isBlockValid(node2)) {
            if (this.m_additionalBlockingValidator != null) {
                return this.m_additionalBlockingValidator.isBlockValid(node2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isPermanentAssertion(Concept concept, Node node2) {
        return true;
    }

    @Override
    public boolean isPermanentAssertion(DataRange dataRange, Node node2) {
        return true;
    }

    protected void validationInfoChanged(Node node2) {
        if (node2 != null) {
            if (this.m_lastValidatedUnchangedNode != null && node2.getNodeID() < this.m_lastValidatedUnchangedNode.getNodeID()) {
                this.m_lastValidatedUnchangedNode = node2;
            }
            this.m_directBlockingChecker.setHasChangedSinceValidation(node2, true);
        }
    }

    @Override
    public void assertionAdded(Concept concept, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(concept, node2, bl));
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node2.getParent());
    }

    @Override
    public void assertionCoreSet(Concept concept, Node node2) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(concept, node2, true));
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node2.getParent());
    }

    @Override
    public void assertionRemoved(Concept concept, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(concept, node2, bl));
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node2.getParent());
    }

    @Override
    public void assertionAdded(DataRange dataRange, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(dataRange, node2, bl));
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node2.getParent());
    }

    @Override
    public void assertionCoreSet(DataRange dataRange, Node node2) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(dataRange, node2, true));
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node2.getParent());
    }

    @Override
    public void assertionRemoved(DataRange dataRange, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(dataRange, node2, bl));
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node2.getParent());
    }

    @Override
    public void assertionAdded(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        if (bl) {
            this.updateNodeChange(node2);
        }
        if (bl) {
            this.updateNodeChange(node3);
        }
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node3);
    }

    @Override
    public void assertionCoreSet(AtomicRole atomicRole, Node node2, Node node3) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(atomicRole, node2, node3, true));
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node3);
    }

    @Override
    public void assertionRemoved(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(atomicRole, node2, node3, true));
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node3);
    }

    @Override
    public void nodesMerged(Node node2, Node node3) {
        Node node4 = node2.getParent();
        if (node4 != null && (this.m_directBlockingChecker.canBeBlocker(node4) || this.m_directBlockingChecker.canBeBlocked(node4))) {
            this.validationInfoChanged(node4);
        }
    }

    @Override
    public void nodesUnmerged(Node node2, Node node3) {
        Node node4 = node2.getParent();
        if (node4 != null && (this.m_directBlockingChecker.canBeBlocker(node4) || this.m_directBlockingChecker.canBeBlocked(node4))) {
            this.validationInfoChanged(node4);
        }
    }

    @Override
    public void nodeStatusChanged(Node node2) {
        this.updateNodeChange(node2);
        this.validationInfoChanged(node2);
        this.validationInfoChanged(node2.getParent());
    }

    protected final void updateNodeChange(Node node2) {
        if (node2 != null && (this.m_firstChangedNode == null || node2.getNodeID() < this.m_firstChangedNode.getNodeID())) {
            this.m_firstChangedNode = node2;
        }
    }

    @Override
    public void nodeInitialized(Node node2) {
        this.m_directBlockingChecker.nodeInitialized(node2);
    }

    @Override
    public void nodeDestroyed(Node node2) {
        this.m_currentBlockersCache.removeNode(node2);
        this.m_directBlockingChecker.nodeDestroyed(node2);
        if (this.m_firstChangedNode != null && this.m_firstChangedNode.getNodeID() >= node2.getNodeID()) {
            this.m_firstChangedNode = null;
        }
        if (this.m_lastValidatedUnchangedNode != null && node2.getNodeID() < this.m_lastValidatedUnchangedNode.getNodeID()) {
            this.m_lastValidatedUnchangedNode = node2;
        }
    }

    @Override
    public void modelFound() {
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public void dlClauseBodyCompiled(List<DLClauseEvaluator.Worker> list, DLClause dLClause, List<Variable> list2, Object[] objectArray, boolean[] blArray) {
        if (this.m_useSimpleCore) {
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
        } else {
            if (dLClause.getHeadLength() == 0) {
                return;
            }
            if (dLClause.getHeadLength() > 1) {
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = true;
                }
            } else {
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = false;
                }
                if (dLClause.isAtomicConceptInclusion() && list2.size() > 1) {
                    list.add(new ComputeCoreVariables(dLClause, list2, objectArray, blArray));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ComputeCoreVariables
    implements DLClauseEvaluator.Worker,
    Serializable {
        private static final long serialVersionUID = 899293772370136783L;
        protected final DLClause m_dlClause;
        protected final List<Variable> m_variables;
        protected final Object[] m_valuesBuffer;
        protected final boolean[] m_coreVariables;

        public ComputeCoreVariables(DLClause dLClause, List<Variable> list, Object[] objectArray, boolean[] blArray) {
            this.m_dlClause = dLClause;
            this.m_variables = list;
            this.m_valuesBuffer = objectArray;
            this.m_coreVariables = blArray;
        }

        public void clear() {
        }

        @Override
        public int execute(int n) {
            Node node2;
            int n2;
            Node node3 = null;
            for (n2 = this.m_coreVariables.length - 1; n2 >= 0; --n2) {
                node2 = (Node)this.m_valuesBuffer[n2];
                if (node2.getNodeType() != NodeType.TREE_NODE || node3 != null && node2.getTreeDepth() >= node3.getTreeDepth()) continue;
                node3 = node2;
            }
            if (node3 != null) {
                for (n2 = this.m_coreVariables.length - 1; n2 >= 0; --n2) {
                    node2 = (Node)this.m_valuesBuffer[n2];
                    if (node2.isRootNode() || node3 == node2 || node3.getTreeDepth() >= node2.getTreeDepth()) continue;
                    this.m_coreVariables[n2] = true;
                }
            }
            return n + 1;
        }

        public String toString() {
            return "Compute core variables";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ViolationStatistic
    implements Comparable<ViolationStatistic> {
        public final String m_violatedConstraint;
        public final Integer m_numberOfViolations;

        public ViolationStatistic(String string2, Integer n) {
            this.m_violatedConstraint = string2;
            this.m_numberOfViolations = n;
        }

        @Override
        public int compareTo(ViolationStatistic violationStatistic) {
            if (this == violationStatistic) {
                return 0;
            }
            if (violationStatistic == null) {
                throw new NullPointerException("Comparing to a null object is illegal. ");
            }
            if (this.m_numberOfViolations == violationStatistic.m_numberOfViolations) {
                return this.m_violatedConstraint.compareTo(violationStatistic.m_violatedConstraint);
            }
            return violationStatistic.m_numberOfViolations - this.m_numberOfViolations;
        }

        public String toString() {
            return this.m_numberOfViolations + ": " + this.m_violatedConstraint.replaceAll("http://www.co-ode.org/ontologies/galen#", "");
        }
    }
}

