/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;

class BlockersCache
implements Serializable {
    private static final long serialVersionUID = -7692825443489644667L;
    protected Tableau m_tableau;
    protected final DirectBlockingChecker m_directBlockingChecker;
    protected CacheEntry[] m_buckets;
    protected int m_numberOfElements;
    protected int m_threshold;
    protected CacheEntry m_emptyEntries;

    public BlockersCache(DirectBlockingChecker directBlockingChecker) {
        this.m_directBlockingChecker = directBlockingChecker;
        this.clear();
    }

    public boolean isEmpty() {
        return this.m_numberOfElements == 0;
    }

    public void clear() {
        this.m_buckets = new CacheEntry[1024];
        this.m_threshold = (int)((double)this.m_buckets.length * 0.75);
        this.m_numberOfElements = 0;
        this.m_emptyEntries = null;
    }

    public void removeNode(Node node2) {
        CacheEntry cacheEntry = (CacheEntry)node2.getBlockingCargo();
        if (cacheEntry != null) {
            int n = BlockersCache.getIndexFor(cacheEntry.m_hashCode, this.m_buckets.length);
            CacheEntry cacheEntry2 = null;
            CacheEntry cacheEntry3 = this.m_buckets[n];
            while (cacheEntry3 != null) {
                if (cacheEntry3 == cacheEntry) {
                    if (cacheEntry2 == null) {
                        this.m_buckets[n] = cacheEntry3.m_nextEntry;
                    } else {
                        cacheEntry2.m_nextEntry = cacheEntry3.m_nextEntry;
                    }
                    cacheEntry3.m_nextEntry = this.m_emptyEntries;
                    cacheEntry3.m_node = null;
                    cacheEntry3.m_hashCode = 0;
                    this.m_emptyEntries = cacheEntry3;
                    --this.m_numberOfElements;
                    node2.setBlockingCargo(null);
                    return;
                }
                cacheEntry2 = cacheEntry3;
                cacheEntry3 = cacheEntry3.m_nextEntry;
            }
            throw new IllegalStateException("Internal error: entry not in cache!");
        }
    }

    public void addNode(Node node2) {
        int n = this.m_directBlockingChecker.blockingHashCode(node2);
        int n2 = BlockersCache.getIndexFor(n, this.m_buckets.length);
        CacheEntry cacheEntry = this.m_buckets[n2];
        while (cacheEntry != null) {
            if (n == cacheEntry.m_hashCode && this.m_directBlockingChecker.isBlockedBy(cacheEntry.m_node, node2)) {
                throw new IllegalStateException("Internal error: node already in the cache!");
            }
            cacheEntry = cacheEntry.m_nextEntry;
        }
        if (this.m_emptyEntries == null) {
            cacheEntry = new CacheEntry();
        } else {
            cacheEntry = this.m_emptyEntries;
            this.m_emptyEntries = this.m_emptyEntries.m_nextEntry;
        }
        cacheEntry.initialize(node2, n, this.m_buckets[n2]);
        this.m_buckets[n2] = cacheEntry;
        node2.setBlockingCargo(cacheEntry);
        ++this.m_numberOfElements;
        if (this.m_numberOfElements >= this.m_threshold) {
            this.resize(this.m_buckets.length * 2);
        }
    }

    protected void resize(int n) {
        CacheEntry[] cacheEntryArray = new CacheEntry[n];
        for (int i = 0; i < this.m_buckets.length; ++i) {
            CacheEntry cacheEntry = this.m_buckets[i];
            while (cacheEntry != null) {
                CacheEntry cacheEntry2 = cacheEntry.m_nextEntry;
                int n2 = BlockersCache.getIndexFor(cacheEntry.m_hashCode, n);
                cacheEntry.m_nextEntry = cacheEntryArray[n2];
                cacheEntryArray[n2] = cacheEntry;
                cacheEntry = cacheEntry2;
            }
        }
        this.m_buckets = cacheEntryArray;
        this.m_threshold = (int)((double)n * 0.75);
    }

    public Node getBlocker(Node node2) {
        if (this.m_directBlockingChecker.canBeBlocked(node2)) {
            int n = this.m_directBlockingChecker.blockingHashCode(node2);
            int n2 = BlockersCache.getIndexFor(n, this.m_buckets.length);
            CacheEntry cacheEntry = this.m_buckets[n2];
            while (cacheEntry != null) {
                if (n == cacheEntry.m_hashCode && this.m_directBlockingChecker.isBlockedBy(cacheEntry.m_node, node2)) {
                    return cacheEntry.m_node;
                }
                cacheEntry = cacheEntry.m_nextEntry;
            }
        }
        return null;
    }

    protected static int getIndexFor(int n, int n2) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n & n2 - 1;
    }

    public static class CacheEntry
    implements Serializable {
        private static final long serialVersionUID = -7047487963170250200L;
        protected Node m_node;
        protected int m_hashCode;
        protected CacheEntry m_nextEntry;

        public void initialize(Node node2, int n, CacheEntry cacheEntry) {
            this.m_node = node2;
            this.m_hashCode = n;
            this.m_nextEntry = cacheEntry;
        }
    }
}

