/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import org.semanticweb.HermiT.blocking.BlockingSignature;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.tableau.Node;

public class BlockingSignatureCache
implements Serializable {
    private static final long serialVersionUID = -7692825443489644667L;
    protected final DirectBlockingChecker m_directBlockingChecker;
    protected BlockingSignature[] m_buckets;
    protected int m_numberOfElements;
    protected int m_threshold;

    public BlockingSignatureCache(DirectBlockingChecker directBlockingChecker) {
        this.m_directBlockingChecker = directBlockingChecker;
        this.m_buckets = new BlockingSignature[1024];
        this.m_threshold = (int)((double)this.m_buckets.length * 0.75);
        this.m_numberOfElements = 0;
    }

    public boolean isEmpty() {
        return this.m_numberOfElements == 0;
    }

    public boolean addNode(Node node2) {
        int n = this.m_directBlockingChecker.blockingHashCode(node2);
        int n2 = BlockingSignatureCache.getIndexFor(n, this.m_buckets.length);
        BlockingSignature blockingSignature = this.m_buckets[n2];
        while (blockingSignature != null) {
            if (n == blockingSignature.hashCode() && blockingSignature.blocksNode(node2)) {
                return false;
            }
            blockingSignature = blockingSignature.m_nextEntry;
        }
        blockingSignature = this.m_directBlockingChecker.getBlockingSignatureFor(node2);
        blockingSignature.m_nextEntry = this.m_buckets[n2];
        this.m_buckets[n2] = blockingSignature;
        ++this.m_numberOfElements;
        if (this.m_numberOfElements >= this.m_threshold) {
            this.resize(this.m_buckets.length * 2);
        }
        return true;
    }

    protected void resize(int n) {
        BlockingSignature[] blockingSignatureArray = new BlockingSignature[n];
        for (int i = 0; i < this.m_buckets.length; ++i) {
            BlockingSignature blockingSignature = this.m_buckets[i];
            while (blockingSignature != null) {
                BlockingSignature blockingSignature2 = blockingSignature.m_nextEntry;
                int n2 = BlockingSignatureCache.getIndexFor(blockingSignature.hashCode(), n);
                blockingSignature.m_nextEntry = blockingSignatureArray[n2];
                blockingSignatureArray[n2] = blockingSignature;
                blockingSignature = blockingSignature2;
            }
        }
        this.m_buckets = blockingSignatureArray;
        this.m_threshold = (int)((double)n * 0.75);
    }

    public boolean containsSignature(Node node2) {
        if (this.m_directBlockingChecker.canBeBlocked(node2)) {
            int n = this.m_directBlockingChecker.blockingHashCode(node2);
            int n2 = BlockingSignatureCache.getIndexFor(n, this.m_buckets.length);
            BlockingSignature blockingSignature = this.m_buckets[n2];
            while (blockingSignature != null) {
                if (n == blockingSignature.hashCode() && blockingSignature.blocksNode(node2)) {
                    return true;
                }
                blockingSignature = blockingSignature.m_nextEntry;
            }
        }
        return false;
    }

    protected static int getIndexFor(int n, int n2) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n & n2 - 1;
    }
}

