/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.blocking.ValidatedSingleDirectBlockingChecker;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.AtLeast;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.LiteralConcept;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingValidator {
    protected final ExtensionManager m_extensionManager;
    protected final ExtensionTable.Retrieval m_binaryRetrieval1Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval01Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval02Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval1Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval2Bound;
    protected final List<DLClauseInfo> m_dlClauseInfos;
    protected final Map<AtomicConcept, List<DLClauseInfo>> m_dlClauseInfosByXConcepts;
    protected final List<DLClauseInfo> m_dlClauseInfosWithoutXConcepts;
    public Map<AtLeastConcept, Node> inValidAtleastForBlockedParent = new HashMap<AtLeastConcept, Node>();
    public Map<DLClauseInfo, Node> inValidClausesForBlockedParent = new HashMap<DLClauseInfo, Node>();
    public Map<AtLeastConcept, Node> inValidAtleastForBlocker = new HashMap<AtLeastConcept, Node>();
    public Map<DLClauseInfo, Node> inValidClausesForBlocker = new HashMap<DLClauseInfo, Node>();
    protected final boolean debuggingMode = false;

    public BlockingValidator(Tableau tableau, Set<DLClause> set2) {
        this.m_extensionManager = tableau.getExtensionManager();
        this.m_binaryRetrieval1Bound = this.m_extensionManager.getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
        this.m_ternaryRetrieval01Bound = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, true, false}, ExtensionTable.View.TOTAL);
        this.m_ternaryRetrieval02Bound = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, false, true}, ExtensionTable.View.TOTAL);
        this.m_ternaryRetrieval1Bound = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{false, true, false}, ExtensionTable.View.TOTAL);
        this.m_ternaryRetrieval2Bound = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{false, false, true}, ExtensionTable.View.TOTAL);
        this.m_dlClauseInfos = new ArrayList<DLClauseInfo>();
        for (DLClause object : set2) {
            if (!object.isGeneralConceptInclusion()) continue;
            AtomicConcept[] atomicConceptArray = new DLClauseInfo(object, this.m_extensionManager);
            if (atomicConceptArray.m_yNodes.length <= 0 && atomicConceptArray.m_zConcepts.length <= 0) continue;
            this.m_dlClauseInfos.add((DLClauseInfo)atomicConceptArray);
        }
        this.m_dlClauseInfosByXConcepts = new HashMap<AtomicConcept, List<DLClauseInfo>>();
        this.m_dlClauseInfosWithoutXConcepts = new ArrayList<DLClauseInfo>();
        for (DLClauseInfo dLClauseInfo : this.m_dlClauseInfos) {
            if (dLClauseInfo.m_xConcepts.length == 0) {
                this.m_dlClauseInfosWithoutXConcepts.add(dLClauseInfo);
                continue;
            }
            for (AtomicConcept atomicConcept : dLClauseInfo.m_xConcepts) {
                List<DLClauseInfo> list = this.m_dlClauseInfosByXConcepts.get(atomicConcept);
                if (list == null) {
                    list = new ArrayList<DLClauseInfo>();
                    this.m_dlClauseInfosByXConcepts.put(atomicConcept, list);
                }
                list.add(dLClauseInfo);
            }
        }
    }

    public void clear() {
        this.m_binaryRetrieval1Bound.clear();
        this.m_ternaryRetrieval01Bound.clear();
        this.m_ternaryRetrieval02Bound.clear();
        this.m_ternaryRetrieval1Bound.clear();
        this.m_ternaryRetrieval2Bound.clear();
        for (int i = this.m_dlClauseInfos.size() - 1; i >= 0; --i) {
            this.m_dlClauseInfos.get(i).clear();
        }
    }

    public void clearInvalids() {
    }

    public boolean hasViolation() {
        return !this.inValidAtleastForBlocker.isEmpty() || !this.inValidClausesForBlocker.isEmpty() || !this.inValidAtleastForBlockedParent.isEmpty() || !this.inValidClausesForBlockedParent.isEmpty();
    }

    public void blockerChanged(Node node2) {
        Node node3 = node2.getParent();
        ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).setHasAlreadyBeenChecked(false);
    }

    public boolean isBlockValid(Node node2) {
        Node node3 = node2.getParent();
        if (!((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).hasAlreadyBeenChecked()) {
            this.resetChildFlags(node3);
            this.checkConstraintsForNonblockedX(node3);
            ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).setHasAlreadyBeenChecked(true);
        }
        if (((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node2.getBlockingObject()).blockViolatesParentConstraints()) {
            return false;
        }
        return this.satisfiesConstraintsForBlockedX(node2);
    }

    protected void resetChildFlags(Node node2) {
        Node node3;
        this.m_ternaryRetrieval1Bound.getBindingsBuffer()[1] = node2;
        this.m_ternaryRetrieval1Bound.open();
        Object[] objectArray = this.m_ternaryRetrieval1Bound.getTupleBuffer();
        while (!this.m_ternaryRetrieval1Bound.afterLast()) {
            node3 = (Node)objectArray[2];
            if (!node3.isAncestorOf(node2)) {
                ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).setBlockViolatesParentConstraints(false);
            }
            this.m_ternaryRetrieval1Bound.next();
        }
        this.m_ternaryRetrieval2Bound.getBindingsBuffer()[2] = node2;
        this.m_ternaryRetrieval2Bound.open();
        objectArray = this.m_ternaryRetrieval2Bound.getTupleBuffer();
        while (!this.m_ternaryRetrieval2Bound.afterLast()) {
            node3 = (Node)objectArray[1];
            if (!node3.isAncestorOf(node2)) {
                ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).setBlockViolatesParentConstraints(false);
            }
            this.m_ternaryRetrieval2Bound.next();
        }
    }

    protected boolean satisfiesConstraintsForBlockedX(Node node2) {
        Node node3 = node2.getBlocker();
        Node node4 = node3.getParent();
        this.m_binaryRetrieval1Bound.getBindingsBuffer()[1] = node3;
        this.m_binaryRetrieval1Bound.open();
        Object[] objectArray = this.m_binaryRetrieval1Bound.getTupleBuffer();
        while (!this.m_binaryRetrieval1Bound.afterLast()) {
            Object object;
            if (objectArray[0] instanceof AtomicConcept) {
                object = (AtomicConcept)objectArray[0];
                List<DLClauseInfo> object2 = this.m_dlClauseInfosByXConcepts.get(object);
                if (object2 != null) {
                    for (DLClauseInfo dLClauseInfo : object2) {
                        if (this.satisfiesDLClauseForBlockedX(dLClauseInfo, node2)) continue;
                        return false;
                    }
                }
            } else if (objectArray[0] instanceof AtLeastConcept && this.m_extensionManager.containsRoleAssertion(((AtLeast)(object = (AtLeastConcept)objectArray[0])).getOnRole(), node3, node4) && this.m_extensionManager.containsConceptAssertion(((AtLeastConcept)object).getToConcept(), node4) && !this.isSatisfiedAtLeastForBlocked((AtLeastConcept)object, node2, node3, node4)) {
                return false;
            }
            this.m_binaryRetrieval1Bound.next();
        }
        for (DLClauseInfo dLClauseInfo : this.m_dlClauseInfosWithoutXConcepts) {
            if (this.satisfiesDLClauseForBlockedX(dLClauseInfo, node2)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSatisfiedAtLeastForBlocked(AtLeastConcept atLeastConcept, Node node2, Node node3, Node node4) {
        int n;
        ExtensionTable.Retrieval retrieval;
        Role role = atLeastConcept.getOnRole();
        LiteralConcept literalConcept = atLeastConcept.getToConcept();
        Node node5 = node2.getParent();
        if (this.m_extensionManager.containsRoleAssertion(role, node2, node5) && this.m_extensionManager.containsConceptAssertion(literalConcept, node5)) {
            return true;
        }
        if (role instanceof AtomicRole) {
            retrieval = this.m_ternaryRetrieval01Bound;
            retrieval.getBindingsBuffer()[0] = role;
            retrieval.getBindingsBuffer()[1] = node3;
            n = 2;
        } else {
            retrieval = this.m_ternaryRetrieval02Bound;
            retrieval.getBindingsBuffer()[0] = ((InverseRole)role).getInverseOf();
            retrieval.getBindingsBuffer()[2] = node3;
            n = 1;
        }
        retrieval.open();
        Object[] objectArray = retrieval.getTupleBuffer();
        int n2 = 0;
        int n3 = atLeastConcept.getNumber();
        while (!retrieval.afterLast() && n2 < n3) {
            Node node6 = (Node)objectArray[n];
            if (node6 != node4 && this.m_extensionManager.containsConceptAssertion(literalConcept, node6)) {
                ++n2;
            }
            retrieval.next();
        }
        return n2 >= n3;
    }

    protected boolean satisfiesDLClauseForBlockedX(DLClauseInfo dLClauseInfo, Node node2) {
        assert (node2.isDirectlyBlocked());
        Node node3 = node2.getParent();
        Node node4 = node2.getBlocker();
        for (DLPredicate dLPredicate : dLClauseInfo.m_xConcepts) {
            if (this.m_extensionManager.containsAssertion(dLPredicate, node4)) continue;
            return true;
        }
        DLPredicate[] dLPredicateArray = dLClauseInfo.m_x2xRoles;
        int n = dLPredicateArray.length;
        for (int i = 0; i < n; i += 1) {
            DLPredicate dLPredicate;
            dLPredicate = dLPredicateArray[i];
            if (this.m_extensionManager.containsAssertion(dLPredicate, node4, node4)) continue;
            return true;
        }
        int n2 = -1;
        for (n = 0; n2 == -1 && n < dLClauseInfo.m_yConstraints.length; n += 1) {
            if (!dLClauseInfo.m_yConstraints[n].isSatisfiedExplicitly(this.m_extensionManager, node2, node3)) continue;
            n2 = n;
        }
        if (n2 == -1) {
            return true;
        }
        dLClauseInfo.m_xNode = node4;
        dLClauseInfo.m_yNodes[n2] = node3;
        n = this.satisfiesDLClauseForBlockedXAndAnyZ(dLClauseInfo, node2, n2, 0) ? 1 : 0;
        dLClauseInfo.m_xNode = null;
        dLClauseInfo.m_yNodes[n2] = null;
        return n != 0;
    }

    protected boolean satisfiesDLClauseForBlockedXAndAnyZ(DLClauseInfo dLClauseInfo, Node node2, int n, int n2) {
        if (n2 == dLClauseInfo.m_zNodes.length) {
            return this.satisfiesDLClauseForBlockedXAnyZAndAnyY(dLClauseInfo, node2, n, 0, 0);
        }
        AtomicConcept[] atomicConceptArray = dLClauseInfo.m_zConcepts[n2];
        ExtensionTable.Retrieval retrieval = dLClauseInfo.m_zRetrievals[n2];
        retrieval.getBindingsBuffer()[0] = atomicConceptArray[0];
        retrieval.open();
        Object[] objectArray = retrieval.getTupleBuffer();
        while (!retrieval.afterLast()) {
            int n3;
            Node node3 = (Node)objectArray[1];
            boolean bl = true;
            for (n3 = 1; n3 < atomicConceptArray.length; ++n3) {
                if (this.m_extensionManager.containsAssertion(atomicConceptArray[n3], node3)) continue;
                bl = false;
                break;
            }
            if (bl) {
                dLClauseInfo.m_zNodes[n2] = node3;
                n3 = this.satisfiesDLClauseForBlockedXAndAnyZ(dLClauseInfo, node2, n, n2 + 1) ? 1 : 0;
                dLClauseInfo.m_zNodes[n2] = null;
                if (n3 == 0) {
                    return false;
                }
            }
            retrieval.next();
        }
        return true;
    }

    protected boolean satisfiesDLClauseForBlockedXAnyZAndAnyY(DLClauseInfo dLClauseInfo, Node node2, int n, int n2, int n3) {
        int n4;
        ExtensionTable.Retrieval retrieval;
        if (n2 + n3 == n) {
            if (dLClauseInfo.m_yConstraints[n].m_x2yRoles.length != 0) {
                return this.satisfiesDLClauseForBlockedXAnyZAndAnyY(dLClauseInfo, node2, n, n2 + 1, n3);
            }
            return this.satisfiesDLClauseForBlockedXAnyZAndAnyY(dLClauseInfo, node2, n, n2, n3 + 1);
        }
        if (n2 + n3 == dLClauseInfo.m_yConstraints.length) {
            return this.satisfiesDLClauseForBlockedXAndMatchedNodes(dLClauseInfo, node2, n);
        }
        int n5 = 0;
        int n6 = 0;
        Node node3 = node2.getBlocker();
        Node node4 = node3.getParent();
        YConstraint yConstraint = dLClauseInfo.m_yConstraints[n2 + n3];
        assert (yConstraint.m_x2yRoles.length != 0 || yConstraint.m_y2xRoles.length != 0);
        if (yConstraint.m_x2yRoles.length != 0) {
            retrieval = dLClauseInfo.m_x2yRetrievals[n2];
            retrieval.getBindingsBuffer()[0] = dLClauseInfo.m_x2yRoles[n2];
            retrieval.getBindingsBuffer()[1] = node3;
            n4 = 2;
            n5 = 1;
        } else {
            retrieval = dLClauseInfo.m_y2xRetrievals[n3];
            retrieval.getBindingsBuffer()[0] = dLClauseInfo.m_y2xRoles[n3];
            retrieval.getBindingsBuffer()[2] = node3;
            n4 = 1;
            n6 = 1;
        }
        retrieval.open();
        Object[] objectArray = retrieval.getTupleBuffer();
        while (!retrieval.afterLast()) {
            Node node5 = (Node)objectArray[n4];
            if (node5 != node4 && yConstraint.isSatisfiedExplicitly(this.m_extensionManager, node3, node5)) {
                dLClauseInfo.m_yNodes[n2 + n3] = node5;
                boolean bl = this.satisfiesDLClauseForBlockedXAnyZAndAnyY(dLClauseInfo, node2, n, n2 + n5, n3 + n6);
                dLClauseInfo.m_yNodes[n2 + n3] = null;
                if (!bl) {
                    return false;
                }
            }
            retrieval.next();
        }
        return true;
    }

    protected boolean satisfiesDLClauseForBlockedXAndMatchedNodes(DLClauseInfo dLClauseInfo, Node node2, int n) {
        for (ConsequenceAtom consequenceAtom : dLClauseInfo.m_consequencesForBlockedX) {
            if (!consequenceAtom.isSatisfied(this.m_extensionManager, dLClauseInfo, node2)) continue;
            return true;
        }
        return false;
    }

    protected void checkConstraintsForNonblockedX(Node node2) {
        this.m_binaryRetrieval1Bound.getBindingsBuffer()[1] = node2;
        this.m_binaryRetrieval1Bound.open();
        Object[] objectArray = this.m_binaryRetrieval1Bound.getTupleBuffer();
        while (!this.m_binaryRetrieval1Bound.afterLast()) {
            if (objectArray[0] instanceof AtLeastConcept) {
                AtLeastConcept atLeastConcept = (AtLeastConcept)objectArray[0];
                this.checkAtLeastForNonblocked(atLeastConcept, node2);
            }
            this.m_binaryRetrieval1Bound.next();
        }
        for (DLClauseInfo dLClauseInfo : this.m_dlClauseInfos) {
            this.checkDLClauseForNonblockedX(dLClauseInfo, node2);
        }
    }

    protected void checkAtLeastForNonblocked(AtLeastConcept atLeastConcept, Node node2) {
        int n;
        ExtensionTable.Retrieval retrieval;
        int n2 = 0;
        int n3 = atLeastConcept.getNumber();
        Role role = atLeastConcept.getOnRole();
        LiteralConcept literalConcept = atLeastConcept.getToConcept();
        if (role instanceof AtomicRole) {
            retrieval = this.m_ternaryRetrieval01Bound;
            retrieval.getBindingsBuffer()[0] = role;
            retrieval.getBindingsBuffer()[1] = node2;
            n = 2;
        } else {
            retrieval = this.m_ternaryRetrieval02Bound;
            retrieval.getBindingsBuffer()[0] = ((InverseRole)role).getInverseOf();
            retrieval.getBindingsBuffer()[2] = node2;
            n = 1;
        }
        retrieval.open();
        Object[] objectArray = retrieval.getTupleBuffer();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (!retrieval.afterLast() && n2 < n3) {
            Node node3 = (Node)objectArray[n];
            if (node3.isBlocked() && !((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).blockViolatesParentConstraints()) {
                if (this.m_extensionManager.containsConceptAssertion(literalConcept, node3.getBlocker())) {
                    ++n2;
                } else {
                    arrayList.add(node3);
                }
            } else if (this.m_extensionManager.containsConceptAssertion(literalConcept, node3)) {
                ++n2;
            }
            retrieval.next();
        }
        for (int i = 0; i < arrayList.size() && n2 < n3; ++i) {
            Node node4 = (Node)arrayList.get(i);
            if (!this.m_extensionManager.containsConceptAssertion(literalConcept, node4)) continue;
            ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node4.getBlockingObject()).setBlockViolatesParentConstraints(true);
            ++n2;
        }
    }

    protected void checkDLClauseForNonblockedX(DLClauseInfo dLClauseInfo, Node node2) {
        for (AtomicConcept dLPredicate : dLClauseInfo.m_xConcepts) {
            if (this.m_extensionManager.containsAssertion(dLPredicate, node2)) continue;
            return;
        }
        for (DLPredicate dLPredicate : dLClauseInfo.m_x2xRoles) {
            if (this.m_extensionManager.containsAssertion(dLPredicate, node2, node2)) continue;
            return;
        }
        dLClauseInfo.m_xNode = node2;
        this.checkDLClauseForNonblockedXAndAnyZ(dLClauseInfo, node2, 0);
        dLClauseInfo.m_xNode = null;
    }

    protected void checkDLClauseForNonblockedXAndAnyZ(DLClauseInfo dLClauseInfo, Node node2, int n) {
        if (n != dLClauseInfo.m_zNodes.length) {
            AtomicConcept[] atomicConceptArray = dLClauseInfo.m_zConcepts[n];
            ExtensionTable.Retrieval retrieval = dLClauseInfo.m_zRetrievals[n];
            retrieval.getBindingsBuffer()[0] = atomicConceptArray[0];
            retrieval.open();
            Object[] objectArray = retrieval.getTupleBuffer();
            while (!retrieval.afterLast()) {
                Node node3 = (Node)objectArray[1];
                boolean bl = true;
                for (int i = 1; i < atomicConceptArray.length; ++i) {
                    if (this.m_extensionManager.containsAssertion(atomicConceptArray[i], node3)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    dLClauseInfo.m_zNodes[n] = node3;
                    this.checkDLClauseForNonblockedXAndAnyZ(dLClauseInfo, node2, n + 1);
                    dLClauseInfo.m_zNodes[n] = null;
                    return;
                }
                retrieval.next();
            }
            return;
        }
        this.checkDLClauseForNonblockedXAnyZAndAnyY(dLClauseInfo, node2, 0, 0);
    }

    protected void checkDLClauseForNonblockedXAnyZAndAnyY(DLClauseInfo dLClauseInfo, Node node2, int n, int n2) {
        if (n + n2 == dLClauseInfo.m_yConstraints.length) {
            this.checkDLClauseForNonblockedXAndMatchedNodes(dLClauseInfo, node2);
        } else {
            int n3;
            ExtensionTable.Retrieval retrieval;
            YConstraint yConstraint = dLClauseInfo.m_yConstraints[n + n2];
            assert (yConstraint.m_x2yRoles.length != 0 || yConstraint.m_y2xRoles.length != 0);
            int n4 = 0;
            int n5 = 0;
            if (yConstraint.m_x2yRoles.length != 0) {
                n4 = 1;
                retrieval = dLClauseInfo.m_x2yRetrievals[n];
                retrieval.getBindingsBuffer()[0] = dLClauseInfo.m_x2yRoles[n];
                retrieval.getBindingsBuffer()[1] = node2;
                n3 = 2;
            } else {
                n5 = 1;
                retrieval = dLClauseInfo.m_y2xRetrievals[n2];
                retrieval.getBindingsBuffer()[0] = dLClauseInfo.m_y2xRoles[n2];
                retrieval.getBindingsBuffer()[2] = node2;
                n3 = 1;
            }
            retrieval.open();
            Object[] objectArray = retrieval.getTupleBuffer();
            while (!retrieval.afterLast()) {
                Node node3 = (Node)objectArray[n3];
                if (yConstraint.isSatisfiedViaMirroringY(this.m_extensionManager, node2, node3)) {
                    dLClauseInfo.m_yNodes[n + n2] = node3;
                    this.checkDLClauseForNonblockedXAnyZAndAnyY(dLClauseInfo, node2, n + n4, n2 + n5);
                    dLClauseInfo.m_yNodes[n + n2] = null;
                }
                retrieval.next();
            }
        }
    }

    protected void checkDLClauseForNonblockedXAndMatchedNodes(DLClauseInfo dLClauseInfo, Node node2) {
        boolean bl = false;
        for (Node object : dLClauseInfo.m_yNodes) {
            if (!object.isBlocked() || ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)object.getBlockingObject()).blockViolatesParentConstraints()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        for (ConsequenceAtom consequenceAtom : dLClauseInfo.m_consequencesForNonblockedX) {
            if (!consequenceAtom.isSatisfied(this.m_extensionManager, dLClauseInfo, node2)) continue;
            return;
        }
        for (int i = dLClauseInfo.m_yConstraints.length - 1; i >= 0; --i) {
            YConstraint yConstraint = dLClauseInfo.m_yConstraints[i];
            Node node3 = dLClauseInfo.m_yNodes[i];
            for (AtomicConcept atomicConcept : yConstraint.m_yConcepts) {
                if (!node3.isBlocked() || ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).blockViolatesParentConstraints() || this.m_extensionManager.containsAssertion(atomicConcept, node3) || !this.m_extensionManager.containsAssertion(atomicConcept, node3.getBlocker())) continue;
                ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).setBlockViolatesParentConstraints(true);
                return;
            }
        }
        for (ConsequenceAtom consequenceAtom : dLClauseInfo.m_consequencesForNonblockedX) {
            MirroredYConsequenceAtom mirroredYConsequenceAtom;
            if (!(consequenceAtom instanceof MirroredYConsequenceAtom) || !(mirroredYConsequenceAtom = (MirroredYConsequenceAtom)consequenceAtom).isSatisfiedNonMirrored(this.m_extensionManager, dLClauseInfo)) continue;
            Node node3 = dLClauseInfo.m_yNodes[mirroredYConsequenceAtom.m_yArgumentIndex];
            ((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).setBlockViolatesParentConstraints(true);
            return;
        }
        assert (false);
    }

    protected static class MirroredYConsequenceAtom
    implements ConsequenceAtom {
        protected final AtomicConcept m_atomicConcept;
        public final int m_yArgumentIndex;

        public MirroredYConsequenceAtom(AtomicConcept atomicConcept, int n) {
            this.m_atomicConcept = atomicConcept;
            this.m_yArgumentIndex = n;
        }

        public boolean isSatisfied(ExtensionManager extensionManager, DLClauseInfo dLClauseInfo, Node node2) {
            Node node3 = dLClauseInfo.m_yNodes[this.m_yArgumentIndex];
            Node node4 = node3.isBlocked() ? node3.getBlocker() : node3;
            return extensionManager.containsAssertion(this.m_atomicConcept, node4);
        }

        public boolean isSatisfiedNonMirrored(ExtensionManager extensionManager, DLClauseInfo dLClauseInfo) {
            return extensionManager.containsAssertion(this.m_atomicConcept, dLClauseInfo.m_yNodes[this.m_yArgumentIndex]);
        }

        public String toString() {
            return this.m_atomicConcept + "(y_i)";
        }
    }

    protected static class X2YOrY2XConsequenceAtom
    implements ConsequenceAtom {
        protected final AtomicRole m_atomicRole;
        protected final int m_yArgumentIndex;
        protected final boolean m_isX2Y;

        public X2YOrY2XConsequenceAtom(AtomicRole atomicRole, int n, boolean bl) {
            this.m_atomicRole = atomicRole;
            this.m_yArgumentIndex = n;
            this.m_isX2Y = bl;
        }

        public boolean isSatisfied(ExtensionManager extensionManager, DLClauseInfo dLClauseInfo, Node node2) {
            Node node3 = dLClauseInfo.m_yNodes[this.m_yArgumentIndex];
            Node node4 = node3 == node2.getParent() ? node2 : dLClauseInfo.m_xNode;
            if (this.m_isX2Y) {
                return extensionManager.containsAssertion(this.m_atomicRole, node4, node3);
            }
            return extensionManager.containsAssertion(this.m_atomicRole, node3, node4);
        }

        public String toString() {
            return this.m_atomicRole + "(" + (this.m_isX2Y ? "x,yi" : "y_i,x") + ")";
        }
    }

    protected static class SimpleConsequenceAtom
    implements ConsequenceAtom {
        protected final Object[] m_assertionBuffer;
        protected final ArgumentType[] m_argumentTypes;
        protected final int[] m_argumentIndexes;

        public SimpleConsequenceAtom(DLPredicate dLPredicate, ArgumentType[] argumentTypeArray, int[] nArray) {
            this.m_assertionBuffer = new Object[nArray.length + 1];
            this.m_assertionBuffer[0] = dLPredicate;
            this.m_argumentTypes = argumentTypeArray;
            this.m_argumentIndexes = nArray;
        }

        public boolean isSatisfied(ExtensionManager extensionManager, DLClauseInfo dLClauseInfo, Node node2) {
            block5: for (int i = this.m_argumentIndexes.length - 1; i >= 0; --i) {
                switch (this.m_argumentTypes[i]) {
                    case XVAR: {
                        this.m_assertionBuffer[i + 1] = dLClauseInfo.m_xNode;
                        continue block5;
                    }
                    case YVAR: {
                        this.m_assertionBuffer[i + 1] = dLClauseInfo.m_yNodes[this.m_argumentIndexes[i]];
                        continue block5;
                    }
                    case ZVAR: {
                        this.m_assertionBuffer[i + 1] = dLClauseInfo.m_zNodes[this.m_argumentIndexes[i]];
                    }
                }
            }
            if (this.m_assertionBuffer[0] instanceof AnnotatedEquality) {
                return this.m_assertionBuffer[1] == this.m_assertionBuffer[2];
            }
            return extensionManager.containsTuple(this.m_assertionBuffer);
        }

        public String toString() {
            String string2 = "";
            for (Object object : this.m_assertionBuffer) {
                string2 = string2 + " " + object.toString();
            }
            return string2;
        }
    }

    protected static interface ConsequenceAtom {
        public boolean isSatisfied(ExtensionManager var1, DLClauseInfo var2, Node var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ArgumentType {
        XVAR,
        YVAR,
        ZVAR;

    }

    protected static class YConstraint {
        protected final AtomicConcept[] m_yConcepts;
        protected final AtomicRole[] m_x2yRoles;
        protected final AtomicRole[] m_y2xRoles;

        public YConstraint(AtomicConcept[] atomicConceptArray, AtomicRole[] atomicRoleArray, AtomicRole[] atomicRoleArray2) {
            this.m_yConcepts = atomicConceptArray;
            this.m_x2yRoles = atomicRoleArray;
            this.m_y2xRoles = atomicRoleArray2;
        }

        public boolean isSatisfiedExplicitly(ExtensionManager extensionManager, Node node2, Node node3) {
            for (AtomicRole dLPredicate : this.m_x2yRoles) {
                if (extensionManager.containsAssertion(dLPredicate, node2, node3)) continue;
                return false;
            }
            for (AtomicRole atomicRole : this.m_y2xRoles) {
                if (extensionManager.containsAssertion(atomicRole, node3, node2)) continue;
                return false;
            }
            for (DLPredicate dLPredicate : this.m_yConcepts) {
                if (extensionManager.containsAssertion(dLPredicate, node3)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public boolean isSatisfiedViaMirroringY(ExtensionManager extensionManager, Node node2, Node node3) {
            for (AtomicRole atomicRole : this.m_x2yRoles) {
                if (extensionManager.containsAssertion(atomicRole, node2, node3)) continue;
                return false;
            }
            for (AtomicRole atomicRole : this.m_y2xRoles) {
                if (extensionManager.containsAssertion(atomicRole, node3, node2)) continue;
                return false;
            }
            if (node3.isBlocked() && !((ValidatedSingleDirectBlockingChecker.ValidatedBlockingObject)node3.getBlockingObject()).blockViolatesParentConstraints()) {
                Node node4 = node3.getBlocker();
            } else {
                Node node5 = node3;
            }
            for (AtomicConcept atomicConcept : this.m_yConcepts) {
                void var4_8;
                if (extensionManager.containsAssertion(atomicConcept, (Node)var4_8)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class DLClauseInfo {
        protected final AtomicConcept[] m_xConcepts;
        protected final AtomicRole[] m_x2xRoles;
        protected final YConstraint[] m_yConstraints;
        protected final AtomicConcept[][] m_zConcepts;
        protected final ExtensionTable.Retrieval[] m_x2yRetrievals;
        protected final AtomicRole[] m_x2yRoles;
        protected final ExtensionTable.Retrieval[] m_y2xRetrievals;
        protected final AtomicRole[] m_y2xRoles;
        protected final ExtensionTable.Retrieval[] m_zRetrievals;
        protected final ConsequenceAtom[] m_consequencesForBlockedX;
        protected final ConsequenceAtom[] m_consequencesForNonblockedX;
        protected final DLClause m_dlClause;
        protected Node m_xNode;
        protected Node[] m_yNodes;
        protected Variable[] m_yVariables;
        protected Node[] m_zNodes;
        protected Variable[] m_zVariables;

        public DLClauseInfo(DLClause dLClause, ExtensionManager extensionManager) {
            Object object;
            Object object2;
            Object object3;
            Serializable serializable;
            Variable[] variableArray;
            AtomicRole[] atomicRoleArray;
            this.m_dlClause = dLClause;
            Variable variable = Variable.create("X");
            HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>();
            HashSet<AtomicRole> hashSet2 = new HashSet<AtomicRole>();
            HashSet<Serializable> hashSet3 = new HashSet<Serializable>();
            HashMap<Variable, Object> hashMap = new HashMap<Variable, Object>();
            HashMap<Variable, Object> hashMap2 = new HashMap<Variable, Object>();
            HashMap hashMap3 = new HashMap();
            HashMap hashMap4 = new HashMap();
            for (int i = 0; i < dLClause.getBodyLength(); ++i) {
                Object object4;
                atomicRoleArray = dLClause.getBodyAtom(i);
                variableArray = atomicRoleArray.getDLPredicate();
                Variable variable2 = atomicRoleArray.getArgumentVariable(0);
                if (variableArray instanceof AtomicConcept) {
                    if (variable2 == variable) {
                        hashSet.add((AtomicConcept)variableArray);
                        continue;
                    }
                    if (variable2.getName().startsWith("Y")) {
                        hashSet3.add(variable2);
                        if (hashMap.containsKey(variable2)) {
                            ((Set)hashMap.get(variable2)).add((AtomicConcept)variableArray);
                            continue;
                        }
                        object4 = new HashSet();
                        object4.add((AtomicConcept)variableArray);
                        hashMap.put(variable2, object4);
                        continue;
                    }
                    if (variable2.getName().startsWith("Z")) {
                        if (hashMap2.containsKey(variable2)) {
                            object4 = (Set)hashMap2.get(variable2);
                            object4.add((AtomicConcept)variableArray);
                            continue;
                        }
                        object4 = new HashSet();
                        object4.add((AtomicConcept)variableArray);
                        hashMap2.put(variable2, object4);
                        continue;
                    }
                    throw new IllegalStateException("Internal error: Clause premise contained variables other than X, Yi, and Zi in a concept atom. ");
                }
                if (!(variableArray instanceof AtomicRole)) continue;
                object4 = atomicRoleArray.getArgumentVariable(1);
                if (variable2 == variable) {
                    if (object4 == variable) {
                        hashSet2.add((AtomicRole)atomicRoleArray.getDLPredicate());
                        continue;
                    }
                    if (((Variable)object4).getName().startsWith("Y")) {
                        hashSet3.add((Serializable)object4);
                        if (hashMap3.containsKey(object4)) {
                            ((Set)hashMap3.get(object4)).add((AtomicRole)variableArray);
                            continue;
                        }
                        serializable = new HashSet<AtomicRole>();
                        serializable.add((AtomicRole)variableArray);
                        hashMap3.put(object4, serializable);
                        continue;
                    }
                    throw new IllegalStateException("Internal error: Clause premise contains a role atom with virales other than X and Yi. ");
                }
                if (object4 == variable) {
                    if (variable2.getName().startsWith("Y")) {
                        hashSet3.add(variable2);
                        if (hashMap4.containsKey(variable2)) {
                            ((Set)hashMap4.get(variable2)).add((AtomicRole)variableArray);
                            continue;
                        }
                        serializable = new HashSet();
                        serializable.add((AtomicRole)variableArray);
                        hashMap4.put(variable2, serializable);
                        continue;
                    }
                    throw new IllegalStateException("Internal error: Clause premise contains a role atom with virales other than X and Yi. ");
                }
                throw new IllegalStateException("Internal error: Clause premise contained variables other than X and Yi in a role atom. ");
            }
            AtomicConcept[] atomicConceptArray = new AtomicConcept[]{};
            atomicRoleArray = new AtomicRole[]{};
            variableArray = new Variable[]{};
            this.m_xNode = null;
            this.m_xConcepts = hashSet.toArray(atomicConceptArray);
            this.m_x2xRoles = hashSet2.toArray(atomicRoleArray);
            this.m_yVariables = hashSet3.toArray(variableArray);
            this.m_yNodes = new Node[this.m_yVariables.length];
            this.m_yConstraints = new YConstraint[this.m_yVariables.length];
            this.m_x2yRetrievals = new ExtensionTable.Retrieval[hashMap3.size()];
            this.m_x2yRoles = new AtomicRole[hashMap3.size()];
            this.m_y2xRetrievals = new ExtensionTable.Retrieval[hashMap4.size()];
            this.m_y2xRoles = new AtomicRole[hashMap4.size()];
            int n = 0;
            int n2 = 0;
            for (n = 0; n < this.m_yVariables.length; ++n) {
                serializable = this.m_yVariables[n];
                object3 = (Set)hashMap.get(serializable);
                object2 = (Set)hashMap3.get(serializable);
                if (object2 != null) {
                    assert (object2.size() == 1);
                    assert (this.m_y2xRetrievals.length < this.m_x2yRetrievals.length);
                    this.m_x2yRetrievals[n2] = extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, true, false}, ExtensionTable.View.TOTAL);
                    this.m_x2yRoles[n2] = (AtomicRole)object2.iterator().next();
                    ++n2;
                }
                if ((object = (Set)hashMap4.get(serializable)) != null) {
                    assert (object.size() == 1);
                    assert (n - n2 >= 0);
                    assert (n - n2 < this.m_y2xRetrievals.length);
                    this.m_y2xRetrievals[n - n2] = extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, false, true}, ExtensionTable.View.TOTAL);
                    this.m_y2xRoles[n - n2] = (AtomicRole)object.iterator().next();
                }
                this.m_yConstraints[n] = new YConstraint(object3 != null ? object3.toArray(atomicConceptArray) : atomicConceptArray, object2 != null ? object2.toArray(atomicRoleArray) : atomicRoleArray, object != null ? object.toArray(atomicRoleArray) : atomicRoleArray);
            }
            this.m_zVariables = hashMap2.keySet().toArray(variableArray);
            this.m_zNodes = new Node[this.m_zVariables.length];
            this.m_zConcepts = new AtomicConcept[this.m_zNodes.length][];
            for (int i = 0; i < this.m_zVariables.length; ++i) {
                this.m_zConcepts[i] = ((Set)hashMap2.get(this.m_zVariables[i])).toArray(atomicConceptArray);
            }
            this.m_zRetrievals = new ExtensionTable.Retrieval[this.m_zNodes.length];
            for (n = 0; n < this.m_zRetrievals.length; ++n) {
                this.m_zRetrievals[n] = extensionManager.getBinaryExtensionTable().createRetrieval(new boolean[]{true, false}, ExtensionTable.View.TOTAL);
            }
            this.m_consequencesForBlockedX = new ConsequenceAtom[dLClause.getHeadLength()];
            this.m_consequencesForNonblockedX = new ConsequenceAtom[dLClause.getHeadLength()];
            for (n = 0; n < dLClause.getHeadLength(); ++n) {
                int n3;
                Atom atom2 = dLClause.getHeadAtom(n);
                object3 = atom2.getDLPredicate();
                object2 = atom2.getArgumentVariable(0);
                object = null;
                if (object3.getArity() == 2) {
                    object = atom2.getArgumentVariable(1);
                }
                if (object3 instanceof AtomicConcept) {
                    ArgumentType argumentType = ArgumentType.YVAR;
                    n3 = this.getIndexFor(this.m_yVariables, (Variable)object2);
                    if (n3 == -1) {
                        assert (object2 == variable);
                        n3 = 0;
                        argumentType = ArgumentType.XVAR;
                    }
                    this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{argumentType}, new int[]{n3});
                    if (argumentType == ArgumentType.XVAR) {
                        this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                        continue;
                    }
                    this.m_consequencesForNonblockedX[n] = new MirroredYConsequenceAtom((AtomicConcept)object3, n3);
                    continue;
                }
                if (object3 instanceof AtLeastConcept) {
                    assert (object2 == variable);
                    this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.XVAR}, new int[]{0});
                    this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                    continue;
                }
                if (object3 == Equality.INSTANCE) {
                    if (object2 == variable || object == variable) {
                        if (object == variable) {
                            Object object5 = object2;
                            object2 = object;
                            object = object5;
                        }
                        assert (((Variable)object).getName().startsWith("Z"));
                        int n4 = this.getIndexFor(this.m_zVariables, (Variable)object);
                        assert (object2 == variable && n4 != -1);
                        this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.XVAR, ArgumentType.ZVAR}, new int[]{0, n4});
                        this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                        continue;
                    }
                    if (((Variable)object2).getName().startsWith("Z") || ((Variable)object).getName().startsWith("Z")) {
                        if (((Variable)object).getName().startsWith("Y")) {
                            Object object6 = object2;
                            object2 = object;
                            object = object6;
                        }
                        assert (((Variable)object).getName().startsWith("Z"));
                        int n5 = this.getIndexFor(this.m_zVariables, (Variable)object);
                        n3 = this.getIndexFor(this.m_yVariables, (Variable)object2);
                        assert (n3 > -1 && n5 > -1);
                        this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.YVAR, ArgumentType.ZVAR}, new int[]{n3, n5});
                        this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                        continue;
                    }
                    if (((Variable)object2).getName().startsWith("Y") && ((Variable)object).getName().startsWith("Y")) {
                        int n6 = this.getIndexFor(this.m_yVariables, (Variable)object2);
                        n3 = this.getIndexFor(this.m_yVariables, (Variable)object);
                        assert (n6 > -1 && n3 > -1);
                        this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.YVAR, ArgumentType.YVAR}, new int[]{n6, n3});
                        this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                        continue;
                    }
                    throw new IllegalArgumentException("Internal error: The clause " + dLClause + " is not an HT clause. ");
                }
                if (object3 instanceof AnnotatedEquality) {
                    object2 = atom2.getArgumentVariable(0);
                    object = atom2.getArgumentVariable(1);
                    int n7 = this.getIndexFor(this.m_yVariables, (Variable)object2);
                    n3 = this.getIndexFor(this.m_yVariables, (Variable)object);
                    assert (n7 != -1 && n3 != -1);
                    this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.YVAR, ArgumentType.YVAR, ArgumentType.XVAR}, new int[]{n7, n3, 0});
                    this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                    continue;
                }
                if (!(object3 instanceof AtomicRole)) continue;
                assert (object3 instanceof AtomicRole);
                AtomicRole atomicRole = (AtomicRole)object3;
                if (variable == object2 && variable == object) {
                    this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.XVAR, ArgumentType.XVAR}, new int[]{0, 0});
                    this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                    continue;
                }
                assert (object2 == variable || object == variable);
                n3 = -1;
                if (object2 == variable) {
                    n3 = this.getIndexFor(this.m_yVariables, (Variable)object);
                    if (n3 == -1) {
                        n3 = this.getIndexFor(this.m_zVariables, (Variable)object);
                        assert (n3 > -1);
                        this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.XVAR, ArgumentType.ZVAR}, new int[]{0, n3});
                        this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                        continue;
                    }
                    this.m_consequencesForBlockedX[n] = new X2YOrY2XConsequenceAtom(atomicRole, n3, true);
                    this.m_consequencesForNonblockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.XVAR, ArgumentType.YVAR}, new int[]{0, n3});
                    continue;
                }
                n3 = this.getIndexFor(this.m_yVariables, (Variable)object2);
                if (n3 == -1) {
                    n3 = this.getIndexFor(this.m_zVariables, (Variable)object2);
                    assert (n3 > -1);
                    this.m_consequencesForBlockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.ZVAR, ArgumentType.XVAR}, new int[]{n3, 0});
                    this.m_consequencesForNonblockedX[n] = this.m_consequencesForBlockedX[n];
                    continue;
                }
                this.m_consequencesForBlockedX[n] = new X2YOrY2XConsequenceAtom(atomicRole, n3, false);
                this.m_consequencesForNonblockedX[n] = new SimpleConsequenceAtom((DLPredicate)object3, new ArgumentType[]{ArgumentType.YVAR, ArgumentType.XVAR}, new int[]{n3, 0});
            }
        }

        public void clear() {
            for (ExtensionTable.Retrieval retrieval : this.m_x2yRetrievals) {
                retrieval.clear();
            }
            for (ExtensionTable.Retrieval retrieval : this.m_y2xRetrievals) {
                retrieval.clear();
            }
            for (ExtensionTable.Retrieval retrieval : this.m_zRetrievals) {
                retrieval.clear();
            }
        }

        protected int getIndexFor(Variable[] variableArray, Variable variable) {
            for (int i = 0; i < variableArray.length; ++i) {
                if (variableArray[i] != variable) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            return this.m_dlClause.toString();
        }
    }
}

