/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.HermiT.blocking.BlockingSignature;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.blocking.SetFactory;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.NodeType;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairWiseDirectBlockingChecker
implements DirectBlockingChecker,
Serializable {
    private static final long serialVersionUID = -8296420442452625109L;
    protected final SetFactory<AtomicConcept> m_atomicConceptsSetFactory = new SetFactory();
    protected final SetFactory<AtomicRole> m_atomicRolesSetFactory = new SetFactory();
    protected final List<AtomicConcept> m_atomicConceptsBuffer = new ArrayList<AtomicConcept>();
    protected final List<AtomicRole> m_atomicRolesBuffer = new ArrayList<AtomicRole>();
    protected Tableau m_tableau;
    protected ExtensionTable.Retrieval m_binaryTableSearch1Bound;
    protected ExtensionTable.Retrieval m_ternaryTableSearch12Bound;

    @Override
    public void initialize(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_binaryTableSearch1Bound = tableau.getExtensionManager().getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
        this.m_ternaryTableSearch12Bound = tableau.getExtensionManager().getTernaryExtensionTable().createRetrieval(new boolean[]{false, true, true}, ExtensionTable.View.TOTAL);
    }

    @Override
    public void clear() {
        this.m_atomicConceptsSetFactory.clearNonpermanent();
        this.m_atomicRolesSetFactory.clearNonpermanent();
        this.m_binaryTableSearch1Bound.clear();
        this.m_ternaryTableSearch12Bound.clear();
    }

    @Override
    public boolean isBlockedBy(Node node2, Node node3) {
        PairWiseBlockingObject pairWiseBlockingObject = (PairWiseBlockingObject)node2.getBlockingObject();
        PairWiseBlockingObject pairWiseBlockingObject2 = (PairWiseBlockingObject)node3.getBlockingObject();
        return !node2.isBlocked() && node2.getNodeType() == NodeType.TREE_NODE && node3.getNodeType() == NodeType.TREE_NODE && pairWiseBlockingObject.getAtomicConceptsLabel() == pairWiseBlockingObject2.getAtomicConceptsLabel() && ((PairWiseBlockingObject)node2.getParent().getBlockingObject()).getAtomicConceptsLabel() == ((PairWiseBlockingObject)node3.getParent().getBlockingObject()).getAtomicConceptsLabel() && pairWiseBlockingObject.getFromParentLabel() == pairWiseBlockingObject2.getFromParentLabel() && pairWiseBlockingObject.getToParentLabel() == pairWiseBlockingObject2.getToParentLabel();
    }

    @Override
    public int blockingHashCode(Node node2) {
        PairWiseBlockingObject pairWiseBlockingObject = (PairWiseBlockingObject)node2.getBlockingObject();
        return pairWiseBlockingObject.m_atomicConceptsLabelHashCode + ((PairWiseBlockingObject)node2.getParent().getBlockingObject()).m_atomicConceptsLabelHashCode + pairWiseBlockingObject.m_fromParentLabelHashCode + pairWiseBlockingObject.m_toParentLabelHashCode;
    }

    @Override
    public boolean canBeBlocker(Node node2) {
        Node node3 = node2.getParent();
        return node2.getNodeType() == NodeType.TREE_NODE && (node3.getNodeType() == NodeType.TREE_NODE || node3.getNodeType() == NodeType.GRAPH_NODE);
    }

    @Override
    public boolean canBeBlocked(Node node2) {
        Node node3 = node2.getParent();
        return node2.getNodeType() == NodeType.TREE_NODE && (node3.getNodeType() == NodeType.TREE_NODE || node3.getNodeType() == NodeType.GRAPH_NODE);
    }

    @Override
    public boolean hasBlockingInfoChanged(Node node2) {
        return ((PairWiseBlockingObject)node2.getBlockingObject()).m_hasChanged;
    }

    @Override
    public void clearBlockingInfoChanged(Node node2) {
        ((PairWiseBlockingObject)node2.getBlockingObject()).m_hasChanged = false;
    }

    @Override
    public void nodeInitialized(Node node2) {
        if (node2.getBlockingObject() == null) {
            node2.setBlockingObject(new PairWiseBlockingObject(node2));
        }
        ((PairWiseBlockingObject)node2.getBlockingObject()).initialize();
    }

    @Override
    public void nodeDestroyed(Node node2) {
        ((PairWiseBlockingObject)node2.getBlockingObject()).destroy();
    }

    @Override
    public Node assertionAdded(Concept concept, Node node2, boolean bl) {
        if (concept instanceof AtomicConcept) {
            ((PairWiseBlockingObject)node2.getBlockingObject()).addAtomicConcept((AtomicConcept)concept);
            return node2;
        }
        return null;
    }

    @Override
    public Node assertionRemoved(Concept concept, Node node2, boolean bl) {
        if (concept instanceof AtomicConcept) {
            ((PairWiseBlockingObject)node2.getBlockingObject()).removeAtomicConcept((AtomicConcept)concept);
            return node2;
        }
        return null;
    }

    @Override
    public Node assertionAdded(DataRange dataRange, Node node2, boolean bl) {
        return null;
    }

    @Override
    public Node assertionRemoved(DataRange dataRange, Node node2, boolean bl) {
        return null;
    }

    @Override
    public Node assertionAdded(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        if (node2.isParentOf(node3)) {
            ((PairWiseBlockingObject)node3.getBlockingObject()).addToFromParentLabel(atomicRole);
            return node3;
        }
        if (node3.isParentOf(node2)) {
            ((PairWiseBlockingObject)node2.getBlockingObject()).addToToParentLabel(atomicRole);
            return node2;
        }
        return null;
    }

    @Override
    public Node assertionRemoved(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        if (node2.isParentOf(node3)) {
            ((PairWiseBlockingObject)node3.getBlockingObject()).removeFromFromParentLabel(atomicRole);
            return node3;
        }
        if (node3.isParentOf(node2)) {
            ((PairWiseBlockingObject)node2.getBlockingObject()).removeFromToParentLabel(atomicRole);
            return node2;
        }
        return null;
    }

    @Override
    public Node nodesMerged(Node node2, Node node3) {
        return null;
    }

    @Override
    public Node nodesUnmerged(Node node2, Node node3) {
        return null;
    }

    @Override
    public BlockingSignature getBlockingSignatureFor(Node node2) {
        return new PairWiseBlockingSignature(this, node2);
    }

    protected Set<AtomicConcept> fetchAtomicConceptsLabel(Node node2) {
        Set<AtomicConcept> set2;
        this.m_atomicConceptsBuffer.clear();
        this.m_binaryTableSearch1Bound.getBindingsBuffer()[1] = node2;
        this.m_binaryTableSearch1Bound.open();
        Object[] objectArray = this.m_binaryTableSearch1Bound.getTupleBuffer();
        while (!this.m_binaryTableSearch1Bound.afterLast()) {
            set2 = objectArray[0];
            if (set2 instanceof AtomicConcept) {
                this.m_atomicConceptsBuffer.add((AtomicConcept)((Object)set2));
            }
            this.m_binaryTableSearch1Bound.next();
        }
        set2 = this.m_atomicConceptsSetFactory.getSet(this.m_atomicConceptsBuffer);
        this.m_atomicConceptsBuffer.clear();
        return set2;
    }

    public Set<AtomicRole> fetchEdgeLabel(Node node2, Node node3) {
        Set<AtomicRole> set2;
        this.m_atomicRolesBuffer.clear();
        this.m_ternaryTableSearch12Bound.getBindingsBuffer()[1] = node2;
        this.m_ternaryTableSearch12Bound.getBindingsBuffer()[2] = node3;
        this.m_ternaryTableSearch12Bound.open();
        Object[] objectArray = this.m_ternaryTableSearch12Bound.getTupleBuffer();
        while (!this.m_ternaryTableSearch12Bound.afterLast()) {
            set2 = objectArray[0];
            if (set2 instanceof AtomicRole) {
                this.m_atomicRolesBuffer.add((AtomicRole)((Object)set2));
            }
            this.m_ternaryTableSearch12Bound.next();
        }
        set2 = this.m_atomicRolesSetFactory.getSet(this.m_atomicRolesBuffer);
        this.m_atomicRolesBuffer.clear();
        return set2;
    }

    @Override
    public boolean hasChangedSinceValidation(Node node2) {
        return false;
    }

    @Override
    public void setHasChangedSinceValidation(Node node2, boolean bl) {
    }

    protected static class PairWiseBlockingSignature
    extends BlockingSignature
    implements Serializable {
        private static final long serialVersionUID = 4697990424058632618L;
        protected final Set<AtomicConcept> m_atomicConceptLabel;
        protected final Set<AtomicConcept> m_parentAtomicConceptLabel;
        protected final Set<AtomicRole> m_fromParentLabel;
        protected final Set<AtomicRole> m_toParentLabel;
        protected final int m_hashCode;

        public PairWiseBlockingSignature(PairWiseDirectBlockingChecker pairWiseDirectBlockingChecker, Node node2) {
            PairWiseBlockingObject pairWiseBlockingObject = (PairWiseBlockingObject)node2.getBlockingObject();
            this.m_atomicConceptLabel = pairWiseBlockingObject.getAtomicConceptsLabel();
            this.m_parentAtomicConceptLabel = ((PairWiseBlockingObject)node2.getParent().getBlockingObject()).getAtomicConceptsLabel();
            this.m_fromParentLabel = pairWiseBlockingObject.getFromParentLabel();
            this.m_toParentLabel = pairWiseBlockingObject.getToParentLabel();
            this.m_hashCode = ((Object)this.m_atomicConceptLabel).hashCode() + ((Object)this.m_parentAtomicConceptLabel).hashCode() + ((Object)this.m_fromParentLabel).hashCode() + ((Object)this.m_toParentLabel).hashCode();
            pairWiseDirectBlockingChecker.m_atomicConceptsSetFactory.makePermanent(this.m_atomicConceptLabel);
            pairWiseDirectBlockingChecker.m_atomicConceptsSetFactory.makePermanent(this.m_parentAtomicConceptLabel);
            pairWiseDirectBlockingChecker.m_atomicRolesSetFactory.makePermanent(this.m_fromParentLabel);
            pairWiseDirectBlockingChecker.m_atomicRolesSetFactory.makePermanent(this.m_toParentLabel);
        }

        public boolean blocksNode(Node node2) {
            PairWiseBlockingObject pairWiseBlockingObject = (PairWiseBlockingObject)node2.getBlockingObject();
            return pairWiseBlockingObject.getAtomicConceptsLabel() == this.m_atomicConceptLabel && ((PairWiseBlockingObject)node2.getParent().getBlockingObject()).getAtomicConceptsLabel() == this.m_parentAtomicConceptLabel && pairWiseBlockingObject.getFromParentLabel() == this.m_fromParentLabel && pairWiseBlockingObject.getToParentLabel() == this.m_toParentLabel;
        }

        public int hashCode() {
            return this.m_hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PairWiseBlockingSignature)) {
                return false;
            }
            PairWiseBlockingSignature pairWiseBlockingSignature = (PairWiseBlockingSignature)object;
            return this.m_atomicConceptLabel == pairWiseBlockingSignature.m_atomicConceptLabel && this.m_parentAtomicConceptLabel == pairWiseBlockingSignature.m_parentAtomicConceptLabel && this.m_fromParentLabel == pairWiseBlockingSignature.m_fromParentLabel && this.m_toParentLabel == pairWiseBlockingSignature.m_toParentLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class PairWiseBlockingObject
    implements Serializable {
        private static final long serialVersionUID = -5439737072100509531L;
        protected final Node m_node;
        protected boolean m_hasChanged;
        protected Set<AtomicConcept> m_atomicConceptsLabel;
        protected int m_atomicConceptsLabelHashCode;
        protected Set<AtomicRole> m_fromParentLabel;
        protected int m_fromParentLabelHashCode;
        protected Set<AtomicRole> m_toParentLabel;
        protected int m_toParentLabelHashCode;

        public PairWiseBlockingObject(Node node2) {
            this.m_node = node2;
        }

        public void initialize() {
            this.m_atomicConceptsLabel = null;
            this.m_atomicConceptsLabelHashCode = 0;
            this.m_fromParentLabel = null;
            this.m_fromParentLabelHashCode = 0;
            this.m_toParentLabel = null;
            this.m_toParentLabelHashCode = 0;
            this.m_hasChanged = true;
        }

        public void destroy() {
            if (this.m_atomicConceptsLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_atomicConceptsLabel);
                this.m_atomicConceptsLabel = null;
            }
            if (this.m_fromParentLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicRolesSetFactory.removeReference(this.m_fromParentLabel);
                this.m_fromParentLabel = null;
            }
            if (this.m_toParentLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicRolesSetFactory.removeReference(this.m_toParentLabel);
                this.m_toParentLabel = null;
            }
        }

        public Set<AtomicConcept> getAtomicConceptsLabel() {
            if (this.m_atomicConceptsLabel == null) {
                this.m_atomicConceptsLabel = PairWiseDirectBlockingChecker.this.fetchAtomicConceptsLabel(this.m_node);
                PairWiseDirectBlockingChecker.this.m_atomicConceptsSetFactory.addReference(this.m_atomicConceptsLabel);
            }
            return this.m_atomicConceptsLabel;
        }

        public void addAtomicConcept(AtomicConcept atomicConcept) {
            if (this.m_atomicConceptsLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_atomicConceptsLabel);
                this.m_atomicConceptsLabel = null;
            }
            this.m_atomicConceptsLabelHashCode += atomicConcept.hashCode();
            this.m_hasChanged = true;
        }

        public void removeAtomicConcept(AtomicConcept atomicConcept) {
            if (this.m_atomicConceptsLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicConceptsSetFactory.removeReference(this.m_atomicConceptsLabel);
                this.m_atomicConceptsLabel = null;
            }
            this.m_atomicConceptsLabelHashCode -= atomicConcept.hashCode();
            this.m_hasChanged = true;
        }

        public Set<AtomicRole> getFromParentLabel() {
            if (this.m_fromParentLabel == null) {
                this.m_fromParentLabel = PairWiseDirectBlockingChecker.this.fetchEdgeLabel(this.m_node.getParent(), this.m_node);
                PairWiseDirectBlockingChecker.this.m_atomicRolesSetFactory.addReference(this.m_fromParentLabel);
            }
            return this.m_fromParentLabel;
        }

        protected void addToFromParentLabel(AtomicRole atomicRole) {
            if (this.m_fromParentLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicRolesSetFactory.removeReference(this.m_fromParentLabel);
                this.m_fromParentLabel = null;
            }
            this.m_fromParentLabelHashCode += atomicRole.hashCode();
            this.m_hasChanged = true;
        }

        protected void removeFromFromParentLabel(AtomicRole atomicRole) {
            if (this.m_fromParentLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicRolesSetFactory.removeReference(this.m_fromParentLabel);
                this.m_fromParentLabel = null;
            }
            this.m_fromParentLabelHashCode -= atomicRole.hashCode();
            this.m_hasChanged = true;
        }

        public Set<AtomicRole> getToParentLabel() {
            if (this.m_toParentLabel == null) {
                this.m_toParentLabel = PairWiseDirectBlockingChecker.this.fetchEdgeLabel(this.m_node, this.m_node.getParent());
                PairWiseDirectBlockingChecker.this.m_atomicRolesSetFactory.addReference(this.m_toParentLabel);
            }
            return this.m_toParentLabel;
        }

        protected void addToToParentLabel(AtomicRole atomicRole) {
            if (this.m_toParentLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicRolesSetFactory.removeReference(this.m_toParentLabel);
                this.m_toParentLabel = null;
            }
            this.m_toParentLabelHashCode += atomicRole.hashCode();
            this.m_hasChanged = true;
        }

        protected void removeFromToParentLabel(AtomicRole atomicRole) {
            if (this.m_toParentLabel != null) {
                PairWiseDirectBlockingChecker.this.m_atomicRolesSetFactory.removeReference(this.m_toParentLabel);
                this.m_toParentLabel = null;
            }
            this.m_toParentLabelHashCode -= atomicRole.hashCode();
            this.m_hasChanged = true;
        }
    }
}

