/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.cli;

import gnu.getopt.LongOpt;
import java.text.BreakIterator;
import org.semanticweb.HermiT.cli.Arg;

class Option {
    protected int optChar;
    protected String longStr;
    protected String group;
    protected Arg arg;
    protected String metavar;
    protected String help;

    public Option(int n, String string2, String string3, String string4) {
        this.optChar = n;
        this.longStr = string2;
        this.group = string3;
        this.arg = Arg.NONE;
        this.help = string4;
    }

    public Option(int n, String string2, String string3, boolean bl, String string4, String string5) {
        this.optChar = n;
        this.longStr = string2;
        this.group = string3;
        this.arg = bl ? Arg.REQUIRED : Arg.OPTIONAL;
        this.metavar = string4;
        this.help = string5;
    }

    public static LongOpt[] createLongOpts(Option[] optionArray) {
        LongOpt[] longOptArray = new LongOpt[optionArray.length];
        for (int i = 0; i < optionArray.length; ++i) {
            longOptArray[i] = new LongOpt(optionArray[i].longStr, optionArray[i].arg == Arg.NONE ? 0 : (optionArray[i].arg == Arg.OPTIONAL ? 2 : 1), null, optionArray[i].optChar);
        }
        return longOptArray;
    }

    public String getLongOptExampleStr() {
        if (this.longStr == null || this.longStr.equals("")) {
            return "";
        }
        return new String("--" + this.longStr + (this.arg == Arg.NONE ? "" : (this.arg == Arg.OPTIONAL ? "[=" + this.metavar + "]" : "=" + this.metavar)));
    }

    /*
     * WARNING - void declaration
     */
    public static String formatOptionHelp(Option[] optionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Option option : optionArray) {
            int n2 = option.getLongOptExampleStr().length();
            if (n2 <= n) continue;
            n = n2;
        }
        Object var3_4 = null;
        for (Option option : optionArray) {
            void var3_5;
            if (option.group != var3_5) {
                String string2 = option.group;
                stringBuffer.append(System.getProperty("line.separator"));
                if (option.group != null) {
                    stringBuffer.append(string2 + ":");
                    stringBuffer.append(System.getProperty("line.separator"));
                }
            }
            if (option.optChar < 256) {
                stringBuffer.append("  -");
                stringBuffer.appendCodePoint(option.optChar);
                if (option.longStr != null && option.longStr != "") {
                    stringBuffer.append(", ");
                } else {
                    stringBuffer.append("  ");
                }
            } else {
                stringBuffer.append("      ");
            }
            int n3 = n + 1;
            if (option.longStr != null && option.longStr != "") {
                String string3 = option.getLongOptExampleStr();
                stringBuffer.append(string3);
                n3 -= string3.length();
            }
            while (n3 > 0) {
                stringBuffer.append(' ');
                --n3;
            }
            stringBuffer.append(Option.breakLines(option.help, 80, 6 + n + 1));
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public static String formatOptionsString(Option[] optionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (Option option : optionArray) {
            if (option.optChar >= 256) continue;
            stringBuffer.appendCodePoint(option.optChar);
            switch (option.arg) {
                case REQUIRED: {
                    stringBuffer.append(":");
                    continue block4;
                }
                case OPTIONAL: {
                    stringBuffer.append("::");
                    continue block4;
                }
            }
        }
        return stringBuffer.toString();
    }

    protected static String breakLines(String string2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string2);
        int n3 = 0;
        int n4 = n2;
        int n5 = breakIterator.first();
        while (n5 != -1) {
            String string3 = string2.substring(n3, n5);
            if (n4 + string3.length() > n) {
                stringBuffer.append(System.getProperty("line.separator"));
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(" ");
                }
                n4 = n2;
            }
            stringBuffer.append(string3);
            n4 += string3.length();
            n3 = n5;
            n5 = breakIterator.next();
        }
        return stringBuffer.toString();
    }
}

