/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.semanticweb.HermiT.datalog.DatalogEngine;
import org.semanticweb.HermiT.datalog.QueryResultCollector;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.HyperresolutionManager;
import org.semanticweb.HermiT.tableau.Node;

public class ConjunctiveQuery {
    protected final DatalogEngine m_datalogEngine;
    protected final Atom[] m_queryAtoms;
    protected final Term[] m_answerTerms;
    protected final Term[] m_resultBuffer;
    protected final OneEmptyTupleRetrieval m_firstRetrieval;
    protected final QueryResultCollector[] m_queryResultCollector;
    protected final DLClauseEvaluator.Worker[] m_workers;

    public ConjunctiveQuery(DatalogEngine datalogEngine, Atom[] atomArray, Term[] termArray) {
        if (!datalogEngine.materialize()) {
            throw new IllegalStateException("The supplied DL ontology is unsatisfiable.");
        }
        this.m_datalogEngine = datalogEngine;
        this.m_queryAtoms = atomArray;
        this.m_answerTerms = termArray;
        this.m_resultBuffer = (Term[])termArray.clone();
        this.m_firstRetrieval = new OneEmptyTupleRetrieval();
        this.m_queryResultCollector = new QueryResultCollector[1];
        HyperresolutionManager.BodyAtomsSwapper bodyAtomsSwapper = new HyperresolutionManager.BodyAtomsSwapper(DLClause.create(new Atom[0], atomArray));
        DLClause dLClause = bodyAtomsSwapper.getSwappedDLClause(0);
        QueryCompiler queryCompiler = new QueryCompiler(this, dLClause, termArray, datalogEngine.m_termsToNodes, datalogEngine.m_nodesToTerms, this.m_resultBuffer, this.m_queryResultCollector, this.m_firstRetrieval);
        this.m_workers = new DLClauseEvaluator.Worker[queryCompiler.m_workers.size()];
        queryCompiler.m_workers.toArray(this.m_workers);
    }

    public DatalogEngine getDatalogEngine() {
        return this.m_datalogEngine;
    }

    public int getNumberOfQUeryAtoms() {
        return this.m_queryAtoms.length;
    }

    public Atom getQueryAtom(int n) {
        return this.m_queryAtoms[n];
    }

    public int getNumberOfAnswerTerms() {
        return this.m_answerTerms.length;
    }

    public Term getAnswerTerm(int n) {
        return this.m_answerTerms[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(QueryResultCollector queryResultCollector) {
        try {
            this.m_queryResultCollector[0] = queryResultCollector;
            this.m_firstRetrieval.open();
            int n = 0;
            while (n < this.m_workers.length) {
                n = this.m_workers[n].execute(n);
            }
        }
        finally {
            this.m_queryResultCollector[0] = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class QueryCompiler
    extends DLClauseEvaluator.ConjunctionCompiler {
        protected final ConjunctiveQuery m_conjunctiveQuery;
        protected final Term[] m_answerTerms;
        protected final Map<Node, Term> m_nodesToTerms;
        protected final Term[] m_resultBuffer;
        protected final QueryResultCollector[] m_queryResultCollector;

        public QueryCompiler(ConjunctiveQuery conjunctiveQuery, DLClause dLClause, Term[] termArray, Map<Term, Node> map2, Map<Node, Term> map3, Term[] termArray2, QueryResultCollector[] queryResultCollectorArray, ExtensionTable.Retrieval retrieval) {
            super(new DLClauseEvaluator.BufferSupply(), new DLClauseEvaluator.ValuesBufferManager(Collections.singleton(dLClause), map2), null, conjunctiveQuery.m_datalogEngine.m_extensionManager, dLClause.getBodyAtoms(), QueryCompiler.getAnswerVariables(termArray));
            this.m_conjunctiveQuery = conjunctiveQuery;
            this.m_answerTerms = termArray;
            this.m_nodesToTerms = map3;
            this.m_resultBuffer = termArray2;
            this.m_queryResultCollector = queryResultCollectorArray;
            this.generateCode(0, retrieval);
        }

        @Override
        protected void compileHeads() {
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            for (int i = 0; i < this.m_answerTerms.length; ++i) {
                Term term = this.m_answerTerms[i];
                if (!(term instanceof Variable)) continue;
                int n = this.m_variables.indexOf(term);
                arrayList.add(new int[]{n, i});
            }
            this.m_workers.add(new QueryAnswerCallback(this.m_conjunctiveQuery, this.m_nodesToTerms, this.m_resultBuffer, this.m_queryResultCollector, (int[][])arrayList.toArray((T[])new int[arrayList.size()][]), this.m_valuesBufferManager.m_valuesBuffer));
        }

        protected static List<Variable> getAnswerVariables(Term[] termArray) {
            ArrayList<Variable> arrayList = new ArrayList<Variable>();
            for (Term term : termArray) {
                if (!(term instanceof Variable)) continue;
                arrayList.add((Variable)term);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryAnswerCallback
    implements DLClauseEvaluator.Worker {
        protected final ConjunctiveQuery m_conjunctiveQuery;
        protected final Map<Node, Term> m_nodesToTerms;
        protected final Term[] m_resultBuffer;
        protected final QueryResultCollector[] m_queryResultCollector;
        protected final int[][] m_copyAnswers;
        protected final Object[] m_valuesBuffer;

        public QueryAnswerCallback(ConjunctiveQuery conjunctiveQuery, Map<Node, Term> map2, Term[] termArray, QueryResultCollector[] queryResultCollectorArray, int[][] nArray, Object[] objectArray) {
            this.m_conjunctiveQuery = conjunctiveQuery;
            this.m_nodesToTerms = map2;
            this.m_resultBuffer = termArray;
            this.m_queryResultCollector = queryResultCollectorArray;
            this.m_copyAnswers = nArray;
            this.m_valuesBuffer = objectArray;
        }

        @Override
        public int execute(int n) {
            for (int i = this.m_copyAnswers.length - 1; i >= 0; --i) {
                this.m_resultBuffer[this.m_copyAnswers[i][1]] = this.m_nodesToTerms.get((Node)this.m_valuesBuffer[this.m_copyAnswers[i][0]]);
            }
            this.m_queryResultCollector[0].processResult(this.m_conjunctiveQuery, this.m_resultBuffer);
            return n + 1;
        }

        public String toString() {
            return "Call query consumer";
        }
    }

    protected static final class OneEmptyTupleRetrieval
    implements ExtensionTable.Retrieval {
        protected static final int[] s_noBindings = new int[0];
        protected static final Object[] s_noObjects = new Object[0];
        protected boolean m_afterLast = true;

        public ExtensionTable getExtensionTable() {
            throw new UnsupportedOperationException();
        }

        public ExtensionTable.View getExtensionView() {
            return ExtensionTable.View.TOTAL;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public int[] getBindingPositions() {
            return s_noBindings;
        }

        public Object[] getBindingsBuffer() {
            return s_noObjects;
        }

        public Object[] getTupleBuffer() {
            return s_noObjects;
        }

        public DependencySet getDependencySet() {
            throw new UnsupportedOperationException();
        }

        public boolean isCore() {
            return false;
        }

        public void open() {
            this.m_afterLast = false;
        }

        public boolean afterLast() {
            return this.m_afterLast;
        }

        public int getCurrentTupleIndex() {
            return this.m_afterLast ? -1 : 0;
        }

        public void next() {
            this.m_afterLast = true;
        }
    }
}

