/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.existentials.ExistentialExpansionStrategy;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatalogEngine {
    protected final InterruptFlag m_interruptFlag;
    protected final DLOntology m_dlOntology;
    protected final Map<Term, Node> m_termsToNodes;
    protected final Map<Node, Term> m_nodesToTerms;
    protected final Map<Term, Set<Term>> m_termsToEquivalenceClasses;
    protected final Map<Term, Term> m_termsToRepresentatives;
    protected ExtensionManager m_extensionManager;

    public DatalogEngine(DLOntology dLOntology) {
        for (DLClause dLClause : dLOntology.getDLClauses()) {
            if (dLClause.getHeadLength() <= 1) continue;
            throw new IllegalArgumentException("The supplied DL ontology contains rules with disjunctive heads.");
        }
        this.m_interruptFlag = new InterruptFlag(0L);
        this.m_dlOntology = dLOntology;
        this.m_termsToNodes = new HashMap<Term, Node>();
        this.m_nodesToTerms = new HashMap<Node, Term>();
        this.m_termsToEquivalenceClasses = new HashMap<Term, Set<Term>>();
        this.m_termsToRepresentatives = new HashMap<Term, Term>();
    }

    public void interrupt() {
        this.m_interruptFlag.interrupt();
    }

    public boolean materialize() {
        if (this.m_extensionManager == null) {
            Object object;
            this.m_termsToNodes.clear();
            this.m_nodesToTerms.clear();
            this.m_termsToEquivalenceClasses.clear();
            this.m_termsToRepresentatives.clear();
            Tableau tableau = new Tableau(this.m_interruptFlag, null, NullExistentialExpansionStrategy.INSTANCE, false, this.m_dlOntology, null, new HashMap<String, Object>());
            Set<Atom> set2 = Collections.emptySet();
            tableau.isSatisfiable(true, false, set2, set2, set2, set2, this.m_termsToNodes, null, null);
            Object object2 = this.m_termsToNodes.entrySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                this.m_nodesToTerms.put(object.getValue(), object.getKey());
            }
            this.m_extensionManager = tableau.getExtensionManager();
            for (object2 = tableau.getFirstTableauNode(); object2 != null; object2 = ((Node)object2).getNextTableauNode()) {
                object = this.m_nodesToTerms.get(object2);
                Term term = this.m_nodesToTerms.get(((Node)object2).getCanonicalNode());
                Set<Term> set3 = this.m_termsToEquivalenceClasses.get(term);
                if (set3 == null) {
                    set3 = new HashSet<Term>();
                    this.m_termsToEquivalenceClasses.put(term, set3);
                }
                if (!object.equals(term)) {
                    this.m_termsToEquivalenceClasses.put((Term)object, set3);
                }
                set3.add((Term)object);
                this.m_termsToRepresentatives.put((Term)object, term);
            }
        }
        return !this.m_extensionManager.containsClash();
    }

    public DLOntology getDLOntology() {
        return this.m_dlOntology;
    }

    public Set<Term> getEquivalenceClass(Term term) {
        return this.m_termsToEquivalenceClasses.get(term);
    }

    public Term getRepresentative(Term term) {
        return this.m_termsToRepresentatives.get(term);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NullExistentialExpansionStrategy
    implements ExistentialExpansionStrategy {
        public static final ExistentialExpansionStrategy INSTANCE = new NullExistentialExpansionStrategy();

        protected NullExistentialExpansionStrategy() {
        }

        @Override
        public void initialize(Tableau tableau) {
        }

        @Override
        public void additionalDLOntologySet(DLOntology dLOntology) {
        }

        @Override
        public void additionalDLOntologyCleared() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean expandExistentials(boolean bl) {
            return false;
        }

        @Override
        public void assertionAdded(Concept concept, Node node2, boolean bl) {
        }

        @Override
        public void assertionAdded(DataRange dataRange, Node node2, boolean bl) {
        }

        @Override
        public void assertionCoreSet(Concept concept, Node node2) {
        }

        @Override
        public void assertionCoreSet(DataRange dataRange, Node node2) {
        }

        @Override
        public void assertionRemoved(Concept concept, Node node2, boolean bl) {
        }

        @Override
        public void assertionRemoved(DataRange dataRange, Node node2, boolean bl) {
        }

        @Override
        public void assertionAdded(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        }

        @Override
        public void assertionCoreSet(AtomicRole atomicRole, Node node2, Node node3) {
        }

        @Override
        public void assertionRemoved(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        }

        @Override
        public void nodesMerged(Node node2, Node node3) {
        }

        @Override
        public void nodesUnmerged(Node node2, Node node3) {
        }

        @Override
        public void nodeStatusChanged(Node node2) {
        }

        @Override
        public void nodeInitialized(Node node2) {
        }

        @Override
        public void nodeDestroyed(Node node2) {
        }

        @Override
        public void branchingPointPushed() {
        }

        @Override
        public void backtrack() {
        }

        @Override
        public void modelFound() {
        }

        @Override
        public boolean isDeterministic() {
            return true;
        }

        @Override
        public boolean isExact() {
            return true;
        }

        @Override
        public void dlClauseBodyCompiled(List<DLClauseEvaluator.Worker> list, DLClause dLClause, List<Variable> list2, Object[] objectArray, boolean[] blArray) {
        }
    }
}

