/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedDatatypeException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.anyuri.AnyURIDatatypeHandler;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryDataDatatypeHandler;
import org.semanticweb.HermiT.datatypes.bool.BooleanDatatypeHandler;
import org.semanticweb.HermiT.datatypes.datetime.DateTimeDatatypeHandler;
import org.semanticweb.HermiT.datatypes.doublenum.DoubleDatatypeHandler;
import org.semanticweb.HermiT.datatypes.floatnum.FloatDatatypeHandler;
import org.semanticweb.HermiT.datatypes.owlreal.OWLRealDatatypeHandler;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralDatatypeHandler;
import org.semanticweb.HermiT.datatypes.xmlliteral.XMLLiteralDatatypeHandler;
import org.semanticweb.HermiT.model.DatatypeRestriction;

public class DatatypeRegistry {
    protected static final Map<String, DatatypeHandler> s_handlersByDatatypeURI = new HashMap<String, DatatypeHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDatatypeHandler(DatatypeHandler datatypeHandler) {
        Map<String, DatatypeHandler> map2 = s_handlersByDatatypeURI;
        synchronized (map2) {
            for (String string2 : datatypeHandler.getManagedDatatypeURIs()) {
                if (!s_handlersByDatatypeURI.containsKey(string2)) continue;
                throw new IllegalArgumentException("Datatype handler for datatype '" + string2 + "' has already been registed.");
            }
            for (String string2 : datatypeHandler.getManagedDatatypeURIs()) {
                s_handlersByDatatypeURI.put(string2, datatypeHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DatatypeHandler getDatatypeHandlerFor(String string2) throws UnsupportedDatatypeException {
        DatatypeHandler datatypeHandler;
        Object object = s_handlersByDatatypeURI;
        synchronized (object) {
            datatypeHandler = s_handlersByDatatypeURI.get(string2);
        }
        if (datatypeHandler == null) {
            object = System.getProperty("line.separator");
            String string3 = "HermiT supports all and only the datatypes of the OWL 2 datatype map, see " + (String)object + "http://www.w3.org/TR/owl2-syntax/#Datatype_Maps. " + (String)object + "The datatype '" + string2 + "' is not part of the OWL 2 datatype map and " + (String)object + "no custom datatype definition is given; " + (String)object + "therefore, HermiT cannot handle this datatype.";
            throw new UnsupportedDatatypeException(string3);
        }
        return datatypeHandler;
    }

    protected static DatatypeHandler getDatatypeHandlerFor(DatatypeRestriction datatypeRestriction) throws UnsupportedDatatypeException {
        return DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction.getDatatypeURI());
    }

    public static Object parseLiteral(String string2, String string3) throws MalformedLiteralException, UnsupportedDatatypeException {
        DatatypeHandler datatypeHandler;
        try {
            datatypeHandler = DatatypeRegistry.getDatatypeHandlerFor(string3);
        }
        catch (UnsupportedDatatypeException unsupportedDatatypeException) {
            String string4 = System.getProperty("line.separator");
            String string5 = "Literals can only use the datatypes from the OWL 2 datatype map, see " + string4 + "http://www.w3.org/TR/owl2-syntax/#Datatype_Maps. " + string4 + "The datatype '" + string3 + "' is not part of the OWL 2 datatype map and " + string4 + "HermiT cannot parse this literal.";
            throw new UnsupportedDatatypeException(string5);
        }
        return datatypeHandler.parseLiteral(string2, string3);
    }

    public static void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedDatatypeException, UnsupportedFacetException {
        DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction).validateDatatypeRestriction(datatypeRestriction);
    }

    public static ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        return DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction).createValueSpaceSubset(datatypeRestriction);
    }

    public static ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        return DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction).conjoinWithDR(valueSpaceSubset, datatypeRestriction);
    }

    public static ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        return DatatypeRegistry.getDatatypeHandlerFor(datatypeRestriction).conjoinWithDRNegation(valueSpaceSubset, datatypeRestriction);
    }

    public static boolean isSubsetOf(String string2, String string3) {
        DatatypeHandler datatypeHandler = DatatypeRegistry.getDatatypeHandlerFor(string2);
        if (datatypeHandler.getManagedDatatypeURIs().contains(string3)) {
            return datatypeHandler.isSubsetOf(string2, string3);
        }
        return false;
    }

    public static boolean isDisjointWith(String string2, String string3) {
        DatatypeHandler datatypeHandler = DatatypeRegistry.getDatatypeHandlerFor(string2);
        if (datatypeHandler.getManagedDatatypeURIs().contains(string3)) {
            return datatypeHandler.isDisjointWith(string2, string3);
        }
        return true;
    }

    static {
        DatatypeRegistry.registerDatatypeHandler(new AnonymousConstantsDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new BooleanDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new RDFPlainLiteralDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new OWLRealDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new DoubleDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new FloatDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new DateTimeDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new BinaryDataDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new AnyURIDatatypeHandler());
        DatatypeRegistry.registerDatatypeHandler(new XMLLiteralDatatypeHandler());
    }

    public static class AnonymousConstantValue {
        protected final String m_name;

        public AnonymousConstantValue(String string2) {
            this.m_name = string2;
        }

        public String getName() {
            return this.m_name;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AnonymousConstantValue)) {
                return false;
            }
            return ((AnonymousConstantValue)object).m_name.equals(this.m_name);
        }

        public static AnonymousConstantValue create(String string2) {
            return new AnonymousConstantValue(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AnonymousConstantsDatatypeHandler
    implements DatatypeHandler {
        protected static final String ANONYMOUS_CONSTANTS = "internal:anonymous-constants";
        protected static final Set<String> s_managedDatatypeURIs = Collections.singleton("internal:anonymous-constants");

        protected AnonymousConstantsDatatypeHandler() {
        }

        @Override
        public Set<String> getManagedDatatypeURIs() {
            return s_managedDatatypeURIs;
        }

        @Override
        public Object parseLiteral(String string2, String string3) throws MalformedLiteralException {
            assert (ANONYMOUS_CONSTANTS.equals(string3));
            return new AnonymousConstantValue(string2.trim());
        }

        @Override
        public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public boolean isSubsetOf(String string2, String string3) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }

        @Override
        public boolean isDisjointWith(String string2, String string3) {
            throw new IllegalStateException("Internal error: anonymous constants datatype should not occur in datatype restrictions.");
        }
    }
}

