/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.binarydata;

import java.io.ByteArrayOutputStream;
import org.semanticweb.HermiT.datatypes.binarydata.Base64;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryDataType;

public class BinaryData {
    protected static final char[] INT_TO_HEX;
    protected static final int[] HEX_TO_INT;
    protected final BinaryDataType m_binaryDataType;
    protected final byte[] m_data;
    protected final int m_hashCode;

    public BinaryData(BinaryDataType binaryDataType, byte[] byArray) {
        this.m_binaryDataType = binaryDataType;
        this.m_data = byArray;
        int n = binaryDataType.hashCode();
        for (int i = 0; i < this.m_data.length; ++i) {
            n = n * 3 + this.m_data[i];
        }
        this.m_hashCode = n;
    }

    public BinaryDataType getBinaryDataType() {
        return this.m_binaryDataType;
    }

    public int getNumberOfBytes() {
        return this.m_data.length;
    }

    public byte getByte(int n) {
        return this.m_data[n];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BinaryData)) {
            return false;
        }
        BinaryData binaryData = (BinaryData)object;
        if (this.m_hashCode != binaryData.m_hashCode || this.m_data.length != binaryData.m_data.length || this.m_binaryDataType != binaryData.m_binaryDataType) {
            return false;
        }
        for (int i = this.m_data.length - 1; i >= 0; --i) {
            if (this.m_data[i] == binaryData.m_data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        switch (this.m_binaryDataType) {
            case HEX_BINARY: {
                return this.toHexBinary();
            }
            case BASE_64_BINARY: {
                return Base64.base64Encode(this.m_data);
            }
        }
        throw new IllegalStateException("Internal error: invalid binary data type.");
    }

    protected String toHexBinary() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_data.length; ++i) {
            int n = this.m_data[i] & 0xFF;
            int n2 = n / 16;
            int n3 = n % 16;
            stringBuffer.append(INT_TO_HEX[n2]);
            stringBuffer.append(INT_TO_HEX[n3]);
        }
        return stringBuffer.toString();
    }

    public static BinaryData parseHexBinary(String string2) {
        try {
            if (string2.length() % 2 != 0) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while (n < string2.length()) {
                char c;
                int n2;
                char c2;
                int n3;
                if ((n3 = HEX_TO_INT[c2 = string2.charAt(n++)]) < 0) {
                    return null;
                }
                if ((n2 = HEX_TO_INT[c = string2.charAt(n++)]) < 0) {
                    return null;
                }
                int n4 = n3 * 16 + n2;
                byteArrayOutputStream.write(n4);
            }
            return new BinaryData(BinaryDataType.HEX_BINARY, byteArrayOutputStream.toByteArray());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static BinaryData parseBase64Binary(String string2) {
        string2 = BinaryData.removeWhitespace(string2);
        try {
            byte[] byArray = Base64.decodeBase64(string2);
            return new BinaryData(BinaryDataType.HEX_BINARY, byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    protected static String removeWhitespace(String string2) {
        string2 = string2.trim();
        for (int i = string2.length() - 1; i >= 0; --i) {
            if (!Character.isWhitespace(string2.charAt(i))) continue;
            int n = i;
            while (Character.isWhitespace(string2.charAt(i))) {
                --i;
            }
            string2 = string2.substring(0, i + 1) + string2.substring(n + 1);
        }
        return string2;
    }

    static {
        int n;
        INT_TO_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        HEX_TO_INT = new int[127];
        for (n = 0; n < HEX_TO_INT.length; ++n) {
            BinaryData.HEX_TO_INT[n] = -1;
        }
        for (n = 48; n <= 57; ++n) {
            BinaryData.HEX_TO_INT[n] = n - 48;
        }
        for (n = 65; n <= 70; ++n) {
            BinaryData.HEX_TO_INT[n] = n - 65 + 10;
        }
        for (n = 97; n <= 102; ++n) {
            BinaryData.HEX_TO_INT[n] = n - 97 + 10;
        }
    }
}

