/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.binarydata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryData;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryDataLengthInterval;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryDataType;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryDataValueSpaceSubset;
import org.semanticweb.HermiT.model.DatatypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryDataDatatypeHandler
implements DatatypeHandler {
    protected static final String XSD_NS = Prefixes.s_semanticWebPrefixes.get("xsd:");
    protected static final String XSD_HEX_BINARY = XSD_NS + "hexBinary";
    protected static final String XSD_BASE_64_BINARY = XSD_NS + "base64Binary";
    protected static final ValueSpaceSubset HEX_BINARY_ALL = new BinaryDataValueSpaceSubset(new BinaryDataLengthInterval(BinaryDataType.HEX_BINARY, 0, Integer.MAX_VALUE));
    protected static final ValueSpaceSubset BASE_64_BINARY_ALL = new BinaryDataValueSpaceSubset(new BinaryDataLengthInterval(BinaryDataType.BASE_64_BINARY, 0, Integer.MAX_VALUE));
    protected static final ValueSpaceSubset EMPTY = new BinaryDataValueSpaceSubset();
    protected static final Set<String> s_managedDatatypeURIs = new HashSet<String>();
    protected static final Set<String> s_supportedFacetURIs;

    @Override
    public Set<String> getManagedDatatypeURIs() {
        return s_managedDatatypeURIs;
    }

    @Override
    public Object parseLiteral(String string2, String string3) throws MalformedLiteralException {
        assert (s_managedDatatypeURIs.contains(string3));
        BinaryData binaryData = XSD_HEX_BINARY.equals(string3) ? BinaryData.parseHexBinary(string2) : BinaryData.parseBase64Binary(string2);
        if (binaryData == null) {
            throw new MalformedLiteralException(string2, string3);
        }
        return binaryData;
    }

    @Override
    public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
        String string2 = datatypeRestriction.getDatatypeURI();
        assert (s_managedDatatypeURIs.contains(string2));
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string3 = datatypeRestriction.getFacetURI(i);
            if (!s_supportedFacetURIs.contains(string3)) {
                throw new UnsupportedFacetException("Facet with URI '" + string3 + "' is not supported on binary datatypes; only xsd:minLength, xsd:maxLength, and xsd:length are supported, but the ontology contains the restriction: " + this.toString());
            }
            Object object = datatypeRestriction.getFacetValue(i).getDataValue();
            if (!(object instanceof Integer)) {
                throw new UnsupportedFacetException("The binary datatypes accept only integers as facet values, but for the facet with URI '" + string3 + "' there is a non-integer value " + object + " in the datatype restriction " + this.toString() + ". ");
            }
            int n = (Integer)object;
            if (n >= 0 && n != Integer.MAX_VALUE) continue;
            throw new UnsupportedFacetException("The datatype restriction " + this.toString() + " cannot be handled. The facet with URI '" + string3 + "' does not support integer " + n + " as value. " + (n < 0 ? "The value should not be negative. " : "The value is outside of the supported integer range, i.e., it is larger than 2147483647"));
        }
    }

    @Override
    public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        String string2 = datatypeRestriction.getDatatypeURI();
        assert (s_managedDatatypeURIs.contains(string2));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            if (XSD_HEX_BINARY.equals(string2)) {
                return HEX_BINARY_ALL;
            }
            return BASE_64_BINARY_ALL;
        }
        BinaryDataLengthInterval binaryDataLengthInterval = this.getIntervalFor(datatypeRestriction);
        if (binaryDataLengthInterval == null) {
            return EMPTY;
        }
        return new BinaryDataValueSpaceSubset(binaryDataLengthInterval);
    }

    @Override
    public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0 || valueSpaceSubset == EMPTY) {
            return valueSpaceSubset;
        }
        BinaryDataLengthInterval binaryDataLengthInterval = this.getIntervalFor(datatypeRestriction);
        if (binaryDataLengthInterval == null) {
            return EMPTY;
        }
        BinaryDataValueSpaceSubset binaryDataValueSpaceSubset = (BinaryDataValueSpaceSubset)valueSpaceSubset;
        List<BinaryDataLengthInterval> list = binaryDataValueSpaceSubset.m_intervals;
        ArrayList<BinaryDataLengthInterval> arrayList = new ArrayList<BinaryDataLengthInterval>();
        for (int i = 0; i < list.size(); ++i) {
            BinaryDataLengthInterval binaryDataLengthInterval2 = list.get(i);
            BinaryDataLengthInterval binaryDataLengthInterval3 = binaryDataLengthInterval2.intersectWith(binaryDataLengthInterval);
            if (binaryDataLengthInterval3 == null) continue;
            arrayList.add(binaryDataLengthInterval3);
        }
        if (arrayList.isEmpty()) {
            return EMPTY;
        }
        return new BinaryDataValueSpaceSubset(arrayList);
    }

    @Override
    public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        String string2 = datatypeRestriction.getDatatypeURI();
        assert (datatypeRestriction.getNumberOfFacetRestrictions() != 0);
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0 || valueSpaceSubset == EMPTY) {
            return EMPTY;
        }
        BinaryDataLengthInterval binaryDataLengthInterval = this.getIntervalFor(datatypeRestriction);
        if (binaryDataLengthInterval == null) {
            return valueSpaceSubset;
        }
        BinaryDataType binaryDataType = XSD_HEX_BINARY.equals(string2) ? BinaryDataType.HEX_BINARY : BinaryDataType.BASE_64_BINARY;
        BinaryDataValueSpaceSubset binaryDataValueSpaceSubset = (BinaryDataValueSpaceSubset)valueSpaceSubset;
        BinaryDataLengthInterval binaryDataLengthInterval2 = null;
        if (binaryDataLengthInterval.m_minLength != 0) {
            binaryDataLengthInterval2 = new BinaryDataLengthInterval(binaryDataType, 0, binaryDataLengthInterval.m_minLength - 1);
        }
        BinaryDataLengthInterval binaryDataLengthInterval3 = null;
        if (binaryDataLengthInterval.m_maxLength != Integer.MAX_VALUE) {
            binaryDataLengthInterval3 = new BinaryDataLengthInterval(binaryDataType, binaryDataLengthInterval.m_maxLength + 1, Integer.MAX_VALUE);
        }
        List<BinaryDataLengthInterval> list = binaryDataValueSpaceSubset.m_intervals;
        ArrayList<BinaryDataLengthInterval> arrayList = new ArrayList<BinaryDataLengthInterval>();
        for (int i = 0; i < list.size(); ++i) {
            BinaryDataLengthInterval binaryDataLengthInterval4;
            BinaryDataLengthInterval binaryDataLengthInterval5 = list.get(i);
            if (binaryDataLengthInterval2 != null && (binaryDataLengthInterval4 = binaryDataLengthInterval5.intersectWith(binaryDataLengthInterval2)) != null) {
                arrayList.add(binaryDataLengthInterval4);
            }
            if (binaryDataLengthInterval3 == null || (binaryDataLengthInterval4 = binaryDataLengthInterval5.intersectWith(binaryDataLengthInterval3)) == null) continue;
            arrayList.add(binaryDataLengthInterval4);
        }
        if (arrayList.isEmpty()) {
            return EMPTY;
        }
        return new BinaryDataValueSpaceSubset(arrayList);
    }

    protected BinaryDataLengthInterval getIntervalFor(DatatypeRestriction datatypeRestriction) {
        BinaryDataType binaryDataType;
        String string2 = datatypeRestriction.getDatatypeURI();
        assert (datatypeRestriction.getNumberOfFacetRestrictions() != 0);
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string3 = datatypeRestriction.getFacetURI(i);
            int n3 = (Integer)datatypeRestriction.getFacetValue(i).getDataValue();
            if ((XSD_NS + "minLength").equals(string3)) {
                n = Math.max(n, n3);
                continue;
            }
            if ((XSD_NS + "maxLength").equals(string3)) {
                n2 = Math.min(n2, n3);
                continue;
            }
            if ((XSD_NS + "length").equals(string3)) {
                n = Math.max(n, n3);
                n2 = Math.min(n2, n3);
                continue;
            }
            throw new IllegalStateException("Internal error: facet '" + string3 + "' is not supported by " + Prefixes.STANDARD_PREFIXES.abbreviateIRI(string2) + ".");
        }
        BinaryDataType binaryDataType2 = binaryDataType = XSD_HEX_BINARY.equals(string2) ? BinaryDataType.HEX_BINARY : BinaryDataType.BASE_64_BINARY;
        if (BinaryDataLengthInterval.isIntervalEmpty(binaryDataType, n, n2)) {
            return null;
        }
        return new BinaryDataLengthInterval(binaryDataType, n, n2);
    }

    @Override
    public boolean isSubsetOf(String string2, String string3) {
        return string2.equals(string3);
    }

    @Override
    public boolean isDisjointWith(String string2, String string3) {
        return !string2.equals(string3);
    }

    static {
        s_managedDatatypeURIs.add(XSD_HEX_BINARY);
        s_managedDatatypeURIs.add(XSD_BASE_64_BINARY);
        s_supportedFacetURIs = new HashSet<String>();
        s_supportedFacetURIs.add(XSD_NS + "minLength");
        s_supportedFacetURIs.add(XSD_NS + "maxLength");
        s_supportedFacetURIs.add(XSD_NS + "length");
    }
}

