/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.binarydata;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryData;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryDataLengthInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryDataValueSpaceSubset
implements ValueSpaceSubset {
    protected final List<BinaryDataLengthInterval> m_intervals;

    public BinaryDataValueSpaceSubset() {
        this.m_intervals = Collections.emptyList();
    }

    public BinaryDataValueSpaceSubset(BinaryDataLengthInterval binaryDataLengthInterval) {
        this.m_intervals = Collections.singletonList(binaryDataLengthInterval);
    }

    public BinaryDataValueSpaceSubset(List<BinaryDataLengthInterval> list) {
        this.m_intervals = list;
    }

    @Override
    public boolean hasCardinalityAtLeast(int n) {
        int n2 = n;
        for (int i = this.m_intervals.size() - 1; n2 > 0 && i >= 0; --i) {
            n2 = this.m_intervals.get(i).subtractSizeFrom(n2);
        }
        return n2 == 0;
    }

    @Override
    public boolean containsDataValue(Object object) {
        if (object instanceof BinaryData) {
            BinaryData binaryData = (BinaryData)object;
            for (int i = this.m_intervals.size() - 1; i >= 0; --i) {
                if (!this.m_intervals.get(i).contains(binaryData)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void enumerateDataValues(Collection<Object> collection) {
        for (int i = this.m_intervals.size() - 1; i >= 0; --i) {
            this.m_intervals.get(i).enumerateValues(collection);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("binaryData{");
        for (int i = 0; i < this.m_intervals.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(" + ");
            }
            stringBuffer.append(this.m_intervals.get(i).toString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

