/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.bool;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.model.DatatypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanDatatypeHandler
implements DatatypeHandler {
    protected static final String XSD_BOOLEAN = Prefixes.s_semanticWebPrefixes.get("xsd:") + "boolean";
    protected static final ValueSpaceSubset BOOLEAN_ALL = new BooleanAll();
    protected static final ValueSpaceSubset EMPTY = new BooleanNone();
    protected static final Set<String> s_managedDatatypeURIs = Collections.singleton(XSD_BOOLEAN);

    @Override
    public Set<String> getManagedDatatypeURIs() {
        return s_managedDatatypeURIs;
    }

    @Override
    public Object parseLiteral(String string2, String string3) throws MalformedLiteralException {
        assert (XSD_BOOLEAN.equals(string3));
        if ("false".equalsIgnoreCase(string2 = string2.trim()) || "0".equals(string2)) {
            return Boolean.FALSE;
        }
        if ("true".equalsIgnoreCase(string2) || "1".equals(string2)) {
            return Boolean.TRUE;
        }
        throw new MalformedLiteralException(string2, string3);
    }

    @Override
    public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
        assert (XSD_BOOLEAN.equals(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() > 0) {
            throw new UnsupportedFacetException("The xsd:boolean datatype does not provide any facets, but the ontology contains a restriction on boolean with facets: " + this.toString());
        }
    }

    @Override
    public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        assert (XSD_BOOLEAN.equals(datatypeRestriction.getDatatypeURI()));
        assert (datatypeRestriction.getNumberOfFacetRestrictions() == 0);
        return BOOLEAN_ALL;
    }

    @Override
    public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (XSD_BOOLEAN.equals(datatypeRestriction.getDatatypeURI()));
        assert (datatypeRestriction.getNumberOfFacetRestrictions() == 0);
        return BOOLEAN_ALL;
    }

    @Override
    public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (XSD_BOOLEAN.equals(datatypeRestriction.getDatatypeURI()));
        assert (datatypeRestriction.getNumberOfFacetRestrictions() == 0);
        return EMPTY;
    }

    @Override
    public boolean isSubsetOf(String string2, String string3) {
        assert (XSD_BOOLEAN.equals(string2));
        assert (XSD_BOOLEAN.equals(string3));
        return true;
    }

    @Override
    public boolean isDisjointWith(String string2, String string3) {
        assert (XSD_BOOLEAN.equals(string2));
        assert (XSD_BOOLEAN.equals(string3));
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BooleanNone
    implements ValueSpaceSubset {
        protected BooleanNone() {
        }

        @Override
        public boolean hasCardinalityAtLeast(int n) {
            return n <= 0;
        }

        @Override
        public boolean containsDataValue(Object object) {
            return false;
        }

        @Override
        public void enumerateDataValues(Collection<Object> collection) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BooleanAll
    implements ValueSpaceSubset {
        protected BooleanAll() {
        }

        @Override
        public boolean hasCardinalityAtLeast(int n) {
            return n <= 2;
        }

        @Override
        public boolean containsDataValue(Object object) {
            return Boolean.FALSE.equals(object) || Boolean.TRUE.equals(object);
        }

        @Override
        public void enumerateDataValues(Collection<Object> collection) {
            collection.add(Boolean.FALSE);
            collection.add(Boolean.TRUE);
        }
    }
}

