/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.datetime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.datetime.BoundType;
import org.semanticweb.HermiT.datatypes.datetime.DateTime;
import org.semanticweb.HermiT.datatypes.datetime.DateTimeInterval;
import org.semanticweb.HermiT.datatypes.datetime.DateTimeValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.datetime.IntervalType;
import org.semanticweb.HermiT.model.DatatypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeDatatypeHandler
implements DatatypeHandler {
    protected static final String XSD_NS = Prefixes.s_semanticWebPrefixes.get("xsd:");
    protected static final String XSD_DATE_TIME = XSD_NS + "dateTime";
    protected static final String XSD_DATE_TIME_STAMP = XSD_NS + "dateTimeStamp";
    protected static final DateTimeInterval INTERVAL_ALL_WITH_TIMEZONE = new DateTimeInterval(IntervalType.WITH_TIMEZONE, Long.MIN_VALUE, BoundType.EXCLUSIVE, Long.MAX_VALUE, BoundType.EXCLUSIVE);
    protected static final DateTimeInterval INTERVAL_ALL_WITHOUT_TIMEZONE = new DateTimeInterval(IntervalType.WITHOUT_TIMEZONE, Long.MIN_VALUE, BoundType.EXCLUSIVE, Long.MAX_VALUE, BoundType.EXCLUSIVE);
    protected static final DateTimeValueSpaceSubset ENTIRE_SUBSET = new DateTimeValueSpaceSubset(INTERVAL_ALL_WITH_TIMEZONE, INTERVAL_ALL_WITHOUT_TIMEZONE);
    protected static final DateTimeValueSpaceSubset WITH_TIMEZONE_SUBSET = new DateTimeValueSpaceSubset(INTERVAL_ALL_WITH_TIMEZONE, null);
    protected static final DateTimeValueSpaceSubset EMPTY_SUBSET = new DateTimeValueSpaceSubset();
    protected static final Set<String> s_managedDatatypeURIs = new HashSet<String>();
    protected static final Set<String> s_supportedFacetURIs;

    @Override
    public Set<String> getManagedDatatypeURIs() {
        return s_managedDatatypeURIs;
    }

    @Override
    public Object parseLiteral(String string2, String string3) throws MalformedLiteralException {
        assert (s_managedDatatypeURIs.contains(string3));
        DateTime dateTime = DateTime.parse(string2);
        if (dateTime == null || XSD_DATE_TIME_STAMP.equals(string3) && !dateTime.hasTimeZoneOffset()) {
            throw new MalformedLiteralException(string2, string3);
        }
        return dateTime;
    }

    @Override
    public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string2 = datatypeRestriction.getFacetURI(i);
            if (!s_supportedFacetURIs.contains(string2)) {
                throw new UnsupportedFacetException("Facet with URI '" + string2 + "' is not supported on datatypes derived from xsd:dateTime; only xsd:minInclusive, xsd:maxInclusive, xsd:minExclusive, and xsd:maxExclusive are supported, but the ontology contains the datatype restriction " + this.toString());
            }
            Object object = datatypeRestriction.getFacetValue(i).getDataValue();
            if (object instanceof DateTime) continue;
            throw new UnsupportedFacetException("Facet with URI '" + string2 + "' supports only date/time values, but " + object + " is not a date/time instance in the restriction " + this.toString() + ".");
        }
    }

    @Override
    public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            if (XSD_DATE_TIME.equals(datatypeRestriction.getDatatypeURI())) {
                return ENTIRE_SUBSET;
            }
            return WITH_TIMEZONE_SUBSET;
        }
        DateTimeInterval[] dateTimeIntervalArray = this.getIntervalsFor(datatypeRestriction);
        if (dateTimeIntervalArray[0] == null && dateTimeIntervalArray[1] == null) {
            return EMPTY_SUBSET;
        }
        return new DateTimeValueSpaceSubset(dateTimeIntervalArray[0], dateTimeIntervalArray[1]);
    }

    @Override
    public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        DateTimeInterval[] dateTimeIntervalArray = this.getIntervalsFor(datatypeRestriction);
        if (dateTimeIntervalArray[0] == null && dateTimeIntervalArray[1] == null) {
            return EMPTY_SUBSET;
        }
        DateTimeValueSpaceSubset dateTimeValueSpaceSubset = (DateTimeValueSpaceSubset)valueSpaceSubset;
        List<DateTimeInterval> list = dateTimeValueSpaceSubset.m_intervals;
        ArrayList<DateTimeInterval> arrayList = new ArrayList<DateTimeInterval>();
        for (int i = 0; i < list.size(); ++i) {
            DateTimeInterval dateTimeInterval;
            DateTimeInterval dateTimeInterval2 = list.get(i);
            if (dateTimeIntervalArray[0] != null && (dateTimeInterval = dateTimeInterval2.intersectWith(dateTimeIntervalArray[0])) != null) {
                arrayList.add(dateTimeInterval);
            }
            if (dateTimeIntervalArray[1] == null || (dateTimeInterval = dateTimeInterval2.intersectWith(dateTimeIntervalArray[1])) == null) continue;
            arrayList.add(dateTimeInterval);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new DateTimeValueSpaceSubset(arrayList);
    }

    @Override
    public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (s_managedDatatypeURIs.contains(datatypeRestriction.getDatatypeURI()));
        DateTimeInterval[] dateTimeIntervalArray = this.getIntervalsFor(datatypeRestriction);
        if (dateTimeIntervalArray[0] == null && dateTimeIntervalArray[1] == null) {
            return valueSpaceSubset;
        }
        ArrayList<DateTimeInterval> arrayList = new ArrayList<DateTimeInterval>(4);
        if (dateTimeIntervalArray[0] == null) {
            arrayList.add(INTERVAL_ALL_WITH_TIMEZONE);
        } else {
            if (dateTimeIntervalArray[0].m_lowerBound != Long.MIN_VALUE) {
                arrayList.add(new DateTimeInterval(IntervalType.WITH_TIMEZONE, Long.MIN_VALUE, BoundType.EXCLUSIVE, dateTimeIntervalArray[0].m_lowerBound, dateTimeIntervalArray[0].m_lowerBoundType.getComplement()));
            }
            if (dateTimeIntervalArray[0].m_upperBound != Long.MAX_VALUE) {
                arrayList.add(new DateTimeInterval(IntervalType.WITH_TIMEZONE, dateTimeIntervalArray[0].m_upperBound, dateTimeIntervalArray[0].m_upperBoundType.getComplement(), Long.MAX_VALUE, BoundType.EXCLUSIVE));
            }
        }
        if (dateTimeIntervalArray[1] == null) {
            arrayList.add(INTERVAL_ALL_WITHOUT_TIMEZONE);
        } else {
            if (dateTimeIntervalArray[1].m_lowerBound != Long.MIN_VALUE) {
                arrayList.add(new DateTimeInterval(IntervalType.WITHOUT_TIMEZONE, Long.MIN_VALUE, BoundType.EXCLUSIVE, dateTimeIntervalArray[1].m_lowerBound, dateTimeIntervalArray[1].m_lowerBoundType.getComplement()));
            }
            if (dateTimeIntervalArray[1].m_upperBound != Long.MAX_VALUE) {
                arrayList.add(new DateTimeInterval(IntervalType.WITHOUT_TIMEZONE, dateTimeIntervalArray[1].m_upperBound, dateTimeIntervalArray[1].m_upperBoundType.getComplement(), Long.MAX_VALUE, BoundType.EXCLUSIVE));
            }
        }
        DateTimeValueSpaceSubset dateTimeValueSpaceSubset = (DateTimeValueSpaceSubset)valueSpaceSubset;
        List<DateTimeInterval> list = dateTimeValueSpaceSubset.m_intervals;
        ArrayList<DateTimeInterval> arrayList2 = new ArrayList<DateTimeInterval>();
        for (int i = 0; i < list.size(); ++i) {
            DateTimeInterval dateTimeInterval = list.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                DateTimeInterval dateTimeInterval2 = (DateTimeInterval)arrayList.get(j);
                DateTimeInterval dateTimeInterval3 = dateTimeInterval.intersectWith(dateTimeInterval2);
                if (dateTimeInterval3 == null) continue;
                arrayList2.add(dateTimeInterval3);
            }
        }
        if (arrayList2.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new DateTimeValueSpaceSubset(arrayList2);
    }

    protected DateTimeInterval[] getIntervalsFor(DatatypeRestriction datatypeRestriction) {
        DateTimeInterval[] dateTimeIntervalArray = new DateTimeInterval[2];
        dateTimeIntervalArray[0] = INTERVAL_ALL_WITH_TIMEZONE;
        if (XSD_DATE_TIME.equals(datatypeRestriction.getDatatypeURI())) {
            dateTimeIntervalArray[1] = INTERVAL_ALL_WITHOUT_TIMEZONE;
        }
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return dateTimeIntervalArray;
        }
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            BoundType boundType;
            String string2 = datatypeRestriction.getFacetURI(i);
            DateTime dateTime = (DateTime)datatypeRestriction.getFacetValue(i).getDataValue();
            if ((XSD_NS + "minInclusive").equals(string2) || (XSD_NS + "minExclusive").equals(string2)) {
                BoundType boundType2 = boundType = (XSD_NS + "minInclusive").equals(string2) ? BoundType.INCLUSIVE : BoundType.EXCLUSIVE;
                if (dateTime.hasTimeZoneOffset()) {
                    if (dateTimeIntervalArray[0] != null) {
                        dateTimeIntervalArray[0] = dateTimeIntervalArray[0].intersectWith(new DateTimeInterval(IntervalType.WITH_TIMEZONE, dateTime.getTimeOnTimeline(), boundType, Long.MAX_VALUE, BoundType.EXCLUSIVE));
                    }
                    if (dateTimeIntervalArray[1] == null) continue;
                    dateTimeIntervalArray[1] = dateTimeIntervalArray[1].intersectWith(new DateTimeInterval(IntervalType.WITHOUT_TIMEZONE, dateTime.getTimeOnTimeline() + 50400000L, BoundType.EXCLUSIVE, Long.MAX_VALUE, BoundType.EXCLUSIVE));
                    continue;
                }
                if (dateTimeIntervalArray[0] != null) {
                    dateTimeIntervalArray[0] = dateTimeIntervalArray[0].intersectWith(new DateTimeInterval(IntervalType.WITH_TIMEZONE, dateTime.getTimeOnTimeline() + 50400000L, BoundType.EXCLUSIVE, Long.MAX_VALUE, BoundType.EXCLUSIVE));
                }
                if (dateTimeIntervalArray[1] == null) continue;
                dateTimeIntervalArray[1] = dateTimeIntervalArray[1].intersectWith(new DateTimeInterval(IntervalType.WITHOUT_TIMEZONE, dateTime.getTimeOnTimeline(), boundType, Long.MAX_VALUE, BoundType.EXCLUSIVE));
                continue;
            }
            if ((XSD_NS + "maxInclusive").equals(string2) || (XSD_NS + "maxExclusive").equals(string2)) {
                BoundType boundType3 = boundType = (XSD_NS + "maxInclusive").equals(string2) ? BoundType.INCLUSIVE : BoundType.EXCLUSIVE;
                if (dateTime.hasTimeZoneOffset()) {
                    if (dateTimeIntervalArray[0] != null) {
                        dateTimeIntervalArray[0] = dateTimeIntervalArray[0].intersectWith(new DateTimeInterval(IntervalType.WITH_TIMEZONE, Long.MIN_VALUE, BoundType.EXCLUSIVE, dateTime.getTimeOnTimeline(), boundType));
                    }
                    if (dateTimeIntervalArray[1] == null) continue;
                    dateTimeIntervalArray[1] = dateTimeIntervalArray[1].intersectWith(new DateTimeInterval(IntervalType.WITHOUT_TIMEZONE, Long.MIN_VALUE, BoundType.EXCLUSIVE, dateTime.getTimeOnTimeline() - 50400000L, BoundType.EXCLUSIVE));
                    continue;
                }
                if (dateTimeIntervalArray[0] != null) {
                    dateTimeIntervalArray[0] = dateTimeIntervalArray[0].intersectWith(new DateTimeInterval(IntervalType.WITH_TIMEZONE, Long.MIN_VALUE, BoundType.EXCLUSIVE, dateTime.getTimeOnTimeline() - 50400000L, BoundType.EXCLUSIVE));
                }
                if (dateTimeIntervalArray[1] == null) continue;
                dateTimeIntervalArray[1] = dateTimeIntervalArray[1].intersectWith(new DateTimeInterval(IntervalType.WITHOUT_TIMEZONE, Long.MIN_VALUE, BoundType.EXCLUSIVE, dateTime.getTimeOnTimeline(), boundType));
                continue;
            }
            throw new IllegalStateException("Internal error: facet '" + string2 + "' is not supported by xsd:dateTime.");
        }
        return dateTimeIntervalArray;
    }

    @Override
    public boolean isSubsetOf(String string2, String string3) {
        assert (XSD_DATE_TIME_STAMP.equals(string2) || XSD_DATE_TIME.equals(string2));
        assert (XSD_DATE_TIME_STAMP.equals(string3) || XSD_DATE_TIME.equals(string3));
        if (XSD_DATE_TIME.equals(string2)) {
            return XSD_DATE_TIME.equals(string3);
        }
        return true;
    }

    @Override
    public boolean isDisjointWith(String string2, String string3) {
        assert (XSD_DATE_TIME_STAMP.equals(string2) || XSD_DATE_TIME.equals(string2));
        assert (XSD_DATE_TIME_STAMP.equals(string3) || XSD_DATE_TIME.equals(string3));
        return false;
    }

    static {
        s_managedDatatypeURIs.add(XSD_DATE_TIME);
        s_managedDatatypeURIs.add(XSD_DATE_TIME_STAMP);
        s_supportedFacetURIs = new HashSet<String>();
        s_supportedFacetURIs.add(XSD_NS + "minInclusive");
        s_supportedFacetURIs.add(XSD_NS + "minExclusive");
        s_supportedFacetURIs.add(XSD_NS + "maxInclusive");
        s_supportedFacetURIs.add(XSD_NS + "maxExclusive");
    }
}

