/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.owlreal;

import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigRational
extends Number
implements Comparable<BigRational> {
    private static final long serialVersionUID = 3883936594384307950L;
    private final BigInteger m_numerator;
    private final BigInteger m_denominator;

    public BigRational(BigInteger bigInteger, BigInteger bigInteger2) {
        this.m_numerator = bigInteger;
        this.m_denominator = bigInteger2;
    }

    public BigInteger getNumerator() {
        return this.m_numerator;
    }

    public BigInteger getDenominator() {
        return this.m_denominator;
    }

    public boolean isFinitelyRepresentable() {
        try {
            new BigDecimal(this.m_numerator).divide(new BigDecimal(this.m_denominator)).doubleValue();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    @Override
    public int compareTo(BigRational bigRational) {
        return this.m_numerator.multiply(bigRational.m_denominator).compareTo(this.m_denominator.multiply(bigRational.m_numerator));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigRational) || object == null) {
            return false;
        }
        BigRational bigRational = (BigRational)object;
        return this.m_numerator.equals(bigRational.m_numerator) && this.m_denominator.equals(bigRational.m_denominator);
    }

    public int hashCode() {
        return this.m_numerator.hashCode() * 3 + this.m_denominator.hashCode();
    }

    public String toString() {
        return this.m_numerator.toString() + "/" + this.m_denominator.toString();
    }

    @Override
    public double doubleValue() {
        return this.m_numerator.divide(this.m_denominator).doubleValue();
    }

    @Override
    public float floatValue() {
        return this.m_numerator.divide(this.m_denominator).floatValue();
    }

    @Override
    public int intValue() {
        return this.m_numerator.divide(this.m_denominator).intValue();
    }

    @Override
    public long longValue() {
        return this.m_numerator.divide(this.m_denominator).longValue();
    }
}

