/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.owlreal;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.owlreal.BoundType;
import org.semanticweb.HermiT.datatypes.owlreal.MinusInfinity;
import org.semanticweb.HermiT.datatypes.owlreal.NumberInterval;
import org.semanticweb.HermiT.datatypes.owlreal.NumberRange;
import org.semanticweb.HermiT.datatypes.owlreal.Numbers;
import org.semanticweb.HermiT.datatypes.owlreal.OWLRealValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.owlreal.PlusInfinity;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.DatatypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLRealDatatypeHandler
implements DatatypeHandler {
    protected static final String OWL_NS;
    protected static final String XSD_NS;
    protected static final Map<String, NumberInterval> s_intervalsByDatatype;
    protected static final Map<String, ValueSpaceSubset> s_subsetsByDatatype;
    protected static final ValueSpaceSubset EMPTY_SUBSET;
    protected static final Set<String> s_supportedFacetURIs;
    protected static final Map<String, Set<String>> s_datatypeSupersets;
    protected static final Map<String, Set<String>> s_datatypeDisjoints;

    @Override
    public Set<String> getManagedDatatypeURIs() {
        return s_intervalsByDatatype.keySet();
    }

    @Override
    public Object parseLiteral(String string2, String string3) throws MalformedLiteralException {
        assert (s_intervalsByDatatype.keySet().contains(string3));
        try {
            if ((OWL_NS + "real").equals(string3)) {
                throw new MalformedLiteralException(string2, string3);
            }
            if ((OWL_NS + "rational").equals(string3)) {
                return Numbers.parseRational(string2);
            }
            if ((XSD_NS + "decimal").equals(string3)) {
                return Numbers.parseDecimal(string2);
            }
            return Numbers.parseInteger(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedLiteralException(string2, string3);
        }
    }

    @Override
    public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
        assert (s_intervalsByDatatype.keySet().contains(datatypeRestriction.getDatatypeURI()));
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string2 = datatypeRestriction.getFacetURI(i);
            if (!s_supportedFacetURIs.contains(string2)) {
                throw new UnsupportedFacetException("A facet with URI '" + string2 + "' is not supported on datatypes derived from owl:real. The owl:real derived datatypes support only xsd:minInclusive, xsd:maxInclusive, xsd:minExclusive, and xsd:maxExclusive, but the ontology contains a datatype restriction " + this.toString());
            }
            Constant constant = datatypeRestriction.getFacetValue(i);
            Object object = constant.getDataValue();
            if (!(object instanceof Number)) {
                throw new UnsupportedFacetException("The '" + string2 + "' facet takes only numbers as values when used on a datatype derived from owl:real, but the ontology contains a datatype restriction " + this.toString() + " where " + object + " is not a number. ");
            }
            if (Numbers.isValidNumber((Number)object)) continue;
            throw new UnsupportedFacetException("The facet with URI '" + string2 + "' does not support '" + constant.toString() + "' as value. The value should be an integer, a decimal, or a rational, but this seems not to be the case in the datatype restriction " + this.toString());
        }
    }

    @Override
    public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        assert (s_intervalsByDatatype.keySet().contains(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return s_subsetsByDatatype.get(datatypeRestriction.getDatatypeURI());
        }
        NumberInterval numberInterval = this.getIntervalFor(datatypeRestriction);
        if (numberInterval == null) {
            return EMPTY_SUBSET;
        }
        return new OWLRealValueSpaceSubset(numberInterval);
    }

    @Override
    public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (s_intervalsByDatatype.keySet().contains(datatypeRestriction.getDatatypeURI()));
        NumberInterval numberInterval = this.getIntervalFor(datatypeRestriction);
        if (numberInterval == null) {
            return EMPTY_SUBSET;
        }
        OWLRealValueSpaceSubset oWLRealValueSpaceSubset = (OWLRealValueSpaceSubset)valueSpaceSubset;
        List<NumberInterval> list = oWLRealValueSpaceSubset.m_intervals;
        ArrayList<NumberInterval> arrayList = new ArrayList<NumberInterval>();
        for (int i = 0; i < list.size(); ++i) {
            NumberInterval numberInterval2 = list.get(i);
            NumberInterval numberInterval3 = numberInterval2.intersectWith(numberInterval);
            if (numberInterval3 == null) continue;
            arrayList.add(numberInterval3);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new OWLRealValueSpaceSubset(arrayList);
    }

    @Override
    public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (s_intervalsByDatatype.keySet().contains(datatypeRestriction.getDatatypeURI()));
        NumberInterval numberInterval = this.getIntervalFor(datatypeRestriction);
        if (numberInterval == null) {
            return valueSpaceSubset;
        }
        NumberInterval numberInterval2 = null;
        if (!numberInterval.m_lowerBound.equals(MinusInfinity.INSTANCE)) {
            numberInterval2 = new NumberInterval(NumberRange.REAL, NumberRange.NOTHING, MinusInfinity.INSTANCE, BoundType.EXCLUSIVE, numberInterval.m_lowerBound, numberInterval.m_lowerBoundType.getComplement());
        }
        NumberInterval numberInterval3 = null;
        if (!numberInterval.m_baseRange.equals((Object)NumberRange.REAL)) {
            numberInterval3 = new NumberInterval(NumberRange.REAL, numberInterval.m_baseRange, numberInterval.m_lowerBound, numberInterval.m_lowerBoundType, numberInterval.m_upperBound, numberInterval.m_upperBoundType);
        }
        NumberInterval numberInterval4 = null;
        if (!numberInterval.m_upperBound.equals(PlusInfinity.INSTANCE)) {
            numberInterval4 = new NumberInterval(NumberRange.REAL, NumberRange.NOTHING, numberInterval.m_upperBound, numberInterval.m_upperBoundType.getComplement(), PlusInfinity.INSTANCE, BoundType.EXCLUSIVE);
        }
        OWLRealValueSpaceSubset oWLRealValueSpaceSubset = (OWLRealValueSpaceSubset)valueSpaceSubset;
        List<NumberInterval> list = oWLRealValueSpaceSubset.m_intervals;
        ArrayList<NumberInterval> arrayList = new ArrayList<NumberInterval>();
        for (int i = 0; i < list.size(); ++i) {
            NumberInterval numberInterval5;
            NumberInterval numberInterval6 = list.get(i);
            if (numberInterval2 != null && (numberInterval5 = numberInterval6.intersectWith(numberInterval2)) != null) {
                arrayList.add(numberInterval5);
            }
            if (numberInterval3 != null && (numberInterval5 = numberInterval6.intersectWith(numberInterval3)) != null) {
                arrayList.add(numberInterval5);
            }
            if (numberInterval4 == null || (numberInterval5 = numberInterval6.intersectWith(numberInterval4)) == null) continue;
            arrayList.add(numberInterval5);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new OWLRealValueSpaceSubset(arrayList);
    }

    protected NumberInterval getIntervalFor(DatatypeRestriction datatypeRestriction) {
        NumberInterval numberInterval = s_intervalsByDatatype.get(datatypeRestriction.getDatatypeURI());
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return numberInterval;
        }
        NumberRange numberRange = numberInterval.m_baseRange;
        NumberRange numberRange2 = numberInterval.m_excludedRange;
        Number number = numberInterval.m_lowerBound;
        BoundType boundType = numberInterval.m_lowerBoundType;
        Number number2 = numberInterval.m_upperBound;
        BoundType boundType2 = numberInterval.m_upperBoundType;
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            int n;
            String string2 = datatypeRestriction.getFacetURI(i);
            Number number3 = (Number)datatypeRestriction.getFacetValue(i).getDataValue();
            if ((XSD_NS + "minInclusive").equals(string2)) {
                n = Numbers.compare(number3, number);
                if (n <= 0) continue;
                number = number3;
                boundType = BoundType.INCLUSIVE;
                continue;
            }
            if ((XSD_NS + "minExclusive").equals(string2)) {
                n = Numbers.compare(number3, number);
                if (n > 0) {
                    number = number3;
                    boundType = BoundType.EXCLUSIVE;
                    continue;
                }
                if (n != 0) continue;
                boundType = BoundType.EXCLUSIVE;
                continue;
            }
            if ((XSD_NS + "maxInclusive").equals(string2)) {
                n = Numbers.compare(number3, number2);
                if (n >= 0) continue;
                number2 = number3;
                boundType2 = BoundType.INCLUSIVE;
                continue;
            }
            if ((XSD_NS + "maxExclusive").equals(string2)) {
                n = Numbers.compare(number3, number2);
                if (n < 0) {
                    number2 = number3;
                    boundType2 = BoundType.EXCLUSIVE;
                    continue;
                }
                if (n != 0) continue;
                boundType2 = BoundType.EXCLUSIVE;
                continue;
            }
            throw new IllegalStateException("Internal error: facet '" + string2 + "' is not supported by owl:real.");
        }
        if (NumberInterval.isIntervalEmpty(numberRange, numberRange2, number, boundType, number2, boundType2)) {
            return null;
        }
        return new NumberInterval(numberRange, numberRange2, number, boundType, number2, boundType2);
    }

    @Override
    public boolean isSubsetOf(String string2, String string3) {
        assert (s_intervalsByDatatype.keySet().contains(string2));
        assert (s_intervalsByDatatype.keySet().contains(string3));
        return s_datatypeSupersets.get(string2).contains(string3);
    }

    @Override
    public boolean isDisjointWith(String string2, String string3) {
        assert (s_intervalsByDatatype.keySet().contains(string2));
        assert (s_intervalsByDatatype.keySet().contains(string3));
        return s_datatypeDisjoints.get(string2).contains(string3);
    }

    static {
        Object object;
        OWL_NS = Prefixes.s_semanticWebPrefixes.get("owl:");
        XSD_NS = Prefixes.s_semanticWebPrefixes.get("xsd:");
        s_intervalsByDatatype = new HashMap<String, NumberInterval>();
        s_subsetsByDatatype = new HashMap<String, ValueSpaceSubset>();
        Object[][] object2 = new Object[][]{{OWL_NS + "real", NumberRange.REAL, MinusInfinity.INSTANCE, BoundType.EXCLUSIVE, PlusInfinity.INSTANCE, BoundType.EXCLUSIVE}, {OWL_NS + "rational", NumberRange.RATIONAL, MinusInfinity.INSTANCE, BoundType.EXCLUSIVE, PlusInfinity.INSTANCE, BoundType.EXCLUSIVE}, {XSD_NS + "decimal", NumberRange.DECIMAL, MinusInfinity.INSTANCE, BoundType.EXCLUSIVE, PlusInfinity.INSTANCE, BoundType.EXCLUSIVE}, {XSD_NS + "integer", NumberRange.INTEGER, MinusInfinity.INSTANCE, BoundType.EXCLUSIVE, PlusInfinity.INSTANCE, BoundType.EXCLUSIVE}, {XSD_NS + "nonNegativeInteger", NumberRange.INTEGER, 0, BoundType.INCLUSIVE, PlusInfinity.INSTANCE, BoundType.EXCLUSIVE}, {XSD_NS + "positiveInteger", NumberRange.INTEGER, 0, BoundType.EXCLUSIVE, PlusInfinity.INSTANCE, BoundType.EXCLUSIVE}, {XSD_NS + "nonPositiveInteger", NumberRange.INTEGER, MinusInfinity.INSTANCE, BoundType.EXCLUSIVE, 0, BoundType.INCLUSIVE}, {XSD_NS + "negativeInteger", NumberRange.INTEGER, MinusInfinity.INSTANCE, BoundType.EXCLUSIVE, 0, BoundType.EXCLUSIVE}, {XSD_NS + "long", NumberRange.INTEGER, Long.MIN_VALUE, BoundType.INCLUSIVE, Long.MAX_VALUE, BoundType.INCLUSIVE}, {XSD_NS + "int", NumberRange.INTEGER, Integer.MIN_VALUE, BoundType.INCLUSIVE, Integer.MAX_VALUE, BoundType.INCLUSIVE}, {XSD_NS + "short", NumberRange.INTEGER, Short.MIN_VALUE, BoundType.INCLUSIVE, Short.MAX_VALUE, BoundType.INCLUSIVE}, {XSD_NS + "byte", NumberRange.INTEGER, -128, BoundType.INCLUSIVE, 127, BoundType.INCLUSIVE}, {XSD_NS + "unsignedLong", NumberRange.INTEGER, 0, BoundType.INCLUSIVE, new BigInteger("18446744073709551615"), BoundType.INCLUSIVE}, {XSD_NS + "unsignedInt", NumberRange.INTEGER, 0, BoundType.INCLUSIVE, 0xFFFFFFFFL, BoundType.INCLUSIVE}, {XSD_NS + "unsignedShort", NumberRange.INTEGER, 0, BoundType.INCLUSIVE, 65535, BoundType.INCLUSIVE}, {XSD_NS + "unsignedByte", NumberRange.INTEGER, 0, BoundType.INCLUSIVE, 255, BoundType.INCLUSIVE}};
        for (Object object3 : object2) {
            String string2 = (String)object3[0];
            object = new NumberInterval((NumberRange)((Object)object3[1]), NumberRange.NOTHING, (Number)object3[2], (BoundType)((Object)object3[3]), (Number)object3[4], (BoundType)((Object)object3[5]));
            s_intervalsByDatatype.put(string2, (NumberInterval)object);
            s_subsetsByDatatype.put(string2, new OWLRealValueSpaceSubset((NumberInterval)object));
        }
        EMPTY_SUBSET = new OWLRealValueSpaceSubset();
        s_supportedFacetURIs = new HashSet<String>();
        s_supportedFacetURIs.add(XSD_NS + "minInclusive");
        s_supportedFacetURIs.add(XSD_NS + "minExclusive");
        s_supportedFacetURIs.add(XSD_NS + "maxInclusive");
        s_supportedFacetURIs.add(XSD_NS + "maxExclusive");
        s_datatypeSupersets = new HashMap<String, Set<String>>();
        s_datatypeDisjoints = new HashMap<String, Set<String>>();
        for (String string3 : s_intervalsByDatatype.keySet()) {
            s_datatypeSupersets.put(string3, new HashSet());
            s_datatypeDisjoints.put(string3, new HashSet());
        }
        for (Map.Entry entry : s_intervalsByDatatype.entrySet()) {
            String string4 = (String)entry.getKey();
            NumberInterval numberInterval = (NumberInterval)entry.getValue();
            for (Map.Entry entry2 : s_intervalsByDatatype.entrySet()) {
                object = (String)entry2.getKey();
                NumberInterval numberInterval2 = (NumberInterval)entry2.getValue();
                NumberInterval numberInterval3 = numberInterval.intersectWith(numberInterval2);
                if (numberInterval3 == null) {
                    s_datatypeDisjoints.get(string4).add((String)object);
                    continue;
                }
                if (numberInterval3 != numberInterval) continue;
                s_datatypeSupersets.get(string4).add((String)object);
            }
        }
    }
}

