/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.rdfplainliteral;

import java.util.Collection;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralDataValue;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralPatternValueSpaceSubset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFPlainLiteralLengthInterval {
    public static final int CHARACTER_COUNT = 1112033;
    protected final LanguageTagMode m_languageTagMode;
    protected final int m_minLength;
    protected final int m_maxLength;

    public RDFPlainLiteralLengthInterval(LanguageTagMode languageTagMode, int n, int n2) {
        assert (!RDFPlainLiteralLengthInterval.isIntervalEmpty(languageTagMode, n, n2));
        this.m_languageTagMode = languageTagMode;
        this.m_minLength = n;
        this.m_maxLength = n2;
    }

    public RDFPlainLiteralLengthInterval intersectWith(RDFPlainLiteralLengthInterval rDFPlainLiteralLengthInterval) {
        int n;
        if (this.m_languageTagMode != rDFPlainLiteralLengthInterval.m_languageTagMode) {
            return null;
        }
        int n2 = Math.max(this.m_minLength, rDFPlainLiteralLengthInterval.m_minLength);
        if (RDFPlainLiteralLengthInterval.isIntervalEmpty(this.m_languageTagMode, n2, n = Math.min(this.m_maxLength, rDFPlainLiteralLengthInterval.m_maxLength))) {
            return null;
        }
        if (this.isEqual(this.m_languageTagMode, n2, n)) {
            return this;
        }
        if (rDFPlainLiteralLengthInterval.isEqual(this.m_languageTagMode, n2, n)) {
            return rDFPlainLiteralLengthInterval;
        }
        return new RDFPlainLiteralLengthInterval(this.m_languageTagMode, n2, n);
    }

    protected boolean isEqual(LanguageTagMode languageTagMode, int n, int n2) {
        return this.m_languageTagMode == languageTagMode && this.m_minLength == n && this.m_maxLength == n2;
    }

    public int subtractSizeFrom(int n) {
        if (n <= 0 || this.m_maxLength == Integer.MAX_VALUE || this.m_languageTagMode == LanguageTagMode.PRESENT) {
            return 0;
        }
        if (this.m_minLength >= 4 || this.m_maxLength >= 4) {
            return 0;
        }
        long l = this.getNumberOfValuesOfLength(this.m_maxLength) - this.getNumberOfValuesOfLength(this.m_minLength - 1);
        return (int)Math.max((long)n - l, 0L);
    }

    protected long getNumberOfValuesOfLength(int n) {
        if (n < 0) {
            return 0L;
        }
        long l = 1L;
        long l2 = 1L;
        for (int i = 1; i <= n; ++i) {
            l2 += (l *= 1112033L);
        }
        return l2;
    }

    public boolean contains(String string2) {
        return this.m_languageTagMode == LanguageTagMode.ABSENT && this.m_minLength <= string2.length() && string2.length() <= this.m_maxLength && RDFPlainLiteralPatternValueSpaceSubset.s_xsdString.run(string2);
    }

    public boolean contains(RDFPlainLiteralDataValue rDFPlainLiteralDataValue) {
        String string2 = rDFPlainLiteralDataValue.getString();
        String string3 = rDFPlainLiteralDataValue.getLanguageTag();
        return this.m_languageTagMode == LanguageTagMode.PRESENT && this.m_minLength <= string2.length() && string2.length() <= this.m_maxLength && RDFPlainLiteralPatternValueSpaceSubset.s_xsdString.run(string2) && RDFPlainLiteralPatternValueSpaceSubset.s_languageTag.run(string3);
    }

    public void enumerateValues(Collection<Object> collection) {
        if (this.m_maxLength == Integer.MAX_VALUE || this.m_languageTagMode == LanguageTagMode.PRESENT) {
            throw new IllegalStateException("Internal error: the data range is infinite!");
        }
        if (this.m_minLength == 0) {
            collection.add("");
        }
        char[] cArray = new char[this.m_maxLength];
        this.processPosition(cArray, collection, 0);
    }

    protected void processPosition(char[] cArray, Collection<Object> collection, int n) {
        if (n < this.m_maxLength) {
            for (int i = 0; i <= 65535; ++i) {
                if (!RDFPlainLiteralLengthInterval.isRDFPlainLiteralCharacter((char)i)) continue;
                cArray[n] = (char)i;
                if (this.m_minLength <= n + 1) {
                    collection.add(new String(cArray, 0, n + 1));
                }
                this.processPosition(cArray, collection, n + 1);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(this.m_minLength);
        stringBuffer.append("..");
        if (this.m_maxLength == Integer.MAX_VALUE) {
            stringBuffer.append("+INF");
        } else {
            stringBuffer.append(this.m_maxLength);
        }
        stringBuffer.append(']');
        if (this.m_languageTagMode == LanguageTagMode.ABSENT) {
            stringBuffer.append("@<none>");
        } else {
            stringBuffer.append("@<lt>");
        }
        return stringBuffer.toString();
    }

    protected static boolean isIntervalEmpty(LanguageTagMode languageTagMode, int n, int n2) {
        return n > n2;
    }

    protected static boolean isRDFPlainLiteralCharacter(char c) {
        return c == '\t' || c == '\n' || c == '\r' || ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LanguageTagMode {
        PRESENT,
        ABSENT;

    }
}

