/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicNegationConcept;
import org.semanticweb.HermiT.model.AtomicNegationDataRange;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.ConstantEnumeration;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.DatatypeRestriction;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.model.ExistsDescriptionGraph;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Printing {
    public static void printPadded(PrintWriter printWriter, int n, int n2) {
        Printing.printPadded(printWriter, String.valueOf(n), n2);
    }

    public static void printPadded(PrintWriter printWriter, String string2, int n) {
        for (int i = n - string2.length(); i >= 0; --i) {
            printWriter.print(' ');
        }
        printWriter.print(string2);
    }

    public static <T> void printCollection(Collection<T> collection, PrintWriter printWriter) {
        for (T t : collection) {
            printWriter.print("    ");
            printWriter.print(t.toString());
            printWriter.println();
        }
    }

    public static <T> void diffCollections(String string2, String string3, PrintWriter printWriter, Collection<T> collection, Collection<T> collection2) {
        boolean bl = false;
        for (Object object : collection) {
            if (collection2.contains(object)) continue;
            if (!bl) {
                printWriter.println("<<<  " + string2 + ":");
                bl = true;
            }
            printWriter.print("    ");
            printWriter.print(object.toString());
            printWriter.println();
        }
        if (bl) {
            printWriter.println("--------------------------------------------");
        }
        boolean bl2 = false;
        for (Object e2 : collection2) {
            if (collection.contains(e2)) continue;
            if (!bl2) {
                printWriter.println(">>>  " + string3 + ":");
                bl2 = true;
            }
            printWriter.print("    ");
            printWriter.print(e2.toString());
            printWriter.println();
        }
        if (bl) {
            printWriter.println("--------------------------------------------");
        }
    }

    public static void printNodeData(Debugger debugger, Node node2, PrintWriter printWriter) {
        Object object;
        printWriter.print("Node ID:    ");
        printWriter.println(node2.getNodeID());
        printWriter.print("Node Type:  ");
        printWriter.println((Object)node2.getNodeType());
        printWriter.print("Parent ID:  ");
        printWriter.println(node2.getParent() == null ? "(root node)" : Integer.valueOf(node2.getParent().getNodeID()));
        printWriter.print("Depth:      ");
        printWriter.println(node2.getTreeDepth());
        printWriter.print("Status:     ");
        if (node2.isActive()) {
            printWriter.println("active");
        } else if (node2.isMerged()) {
            for (object = node2.getMergedInto(); object != null; object = ((Node)object).getMergedInto()) {
                printWriter.print(" --> ");
                printWriter.print(((Node)object).getNodeID());
            }
            printWriter.println();
        } else {
            printWriter.println("pruned");
        }
        printWriter.print("Blocked:    ");
        printWriter.println(Printing.formatBlockingStatus(node2));
        printWriter.print("Created as: ");
        object = debugger.getNodeCreationInfo(node2);
        ExistentialConcept existentialConcept = ((Debugger.NodeCreationInfo)object).m_createdByExistential;
        if (!(existentialConcept instanceof AtLeastConcept)) {
            printWriter.println("(root)");
        } else {
            printWriter.println(((AtLeastConcept)existentialConcept).getToConcept().toString(debugger.getPrefixes()));
        }
        Printing.printConceptLabel(debugger, node2, printWriter);
        Printing.printEdges(debugger, node2, printWriter);
    }

    protected static String formatBlockingStatus(Node node2) {
        if (!node2.isBlocked()) {
            return "no";
        }
        if (node2.isDirectlyBlocked()) {
            return "directly by " + (node2.getBlocker() == Node.SIGNATURE_CACHE_BLOCKER ? "signature in cache" : Integer.valueOf(node2.getBlocker().getNodeID()));
        }
        return "indirectly by " + (node2.getBlocker() == Node.SIGNATURE_CACHE_BLOCKER ? "signature in cache" : Integer.valueOf(node2.getBlocker().getNodeID()));
    }

    protected static void printConceptLabel(Debugger debugger, Node node2, PrintWriter printWriter) {
        Object object;
        TreeSet<Concept> treeSet = new TreeSet<Concept>(ConceptComparator.INSTANCE);
        TreeSet<Concept> treeSet2 = new TreeSet<Concept>(ConceptComparator.INSTANCE);
        TreeSet<Concept> treeSet3 = new TreeSet<Concept>(ConceptComparator.INSTANCE);
        TreeSet<Concept> treeSet4 = new TreeSet<Concept>(ConceptComparator.INSTANCE);
        TreeSet<DataRange> treeSet5 = new TreeSet<DataRange>(DataRangeComparator.INSTANCE);
        ExtensionTable.Retrieval retrieval = debugger.getTableau().getExtensionManager().getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
        retrieval.getBindingsBuffer()[1] = node2;
        retrieval.open();
        while (!retrieval.afterLast()) {
            object = retrieval.getTupleBuffer()[0];
            if (object instanceof AtomicNegationConcept) {
                treeSet4.add((AtomicNegationConcept)object);
            } else if (object instanceof AtomicConcept) {
                if (retrieval.isCore()) {
                    treeSet.add((AtomicConcept)object);
                } else {
                    treeSet2.add((AtomicConcept)object);
                }
            } else if (object instanceof ExistentialConcept) {
                treeSet3.add((ExistentialConcept)object);
            } else if (object instanceof DataRange) {
                treeSet5.add((DataRange)object);
            } else if (!(object instanceof DescriptionGraph)) {
                throw new IllegalStateException("Found something in the label that is not a known type!");
            }
            retrieval.next();
        }
        object = Collections.emptySet();
        if (!treeSet.isEmpty()) {
            printWriter.print("-- Positive concept label (core part) -------");
            Printing.printConcepts(debugger, treeSet, (Collection<? extends Concept>)object, printWriter, 3);
        }
        if (!treeSet2.isEmpty() || !treeSet3.isEmpty()) {
            printWriter.print("-- Positive concept label (noncore part) ----");
            Printing.printConcepts(debugger, treeSet2, (Collection<? extends Concept>)object, printWriter, 3);
            Printing.printConcepts(debugger, treeSet3, node2.getUnprocessedExistentials(), printWriter, 1);
        }
        if (!treeSet4.isEmpty()) {
            printWriter.print("-- Negative concept label -------------------");
            Printing.printConcepts(debugger, treeSet4, (Collection<? extends Concept>)object, printWriter, 3);
        }
        if (!treeSet5.isEmpty()) {
            printWriter.print("-- Data ranges label ------------------------");
            Printing.printDataRanges(debugger, treeSet5, printWriter, 1);
        }
    }

    protected static void printEdges(Debugger debugger, Node node2, PrintWriter printWriter) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        TreeMap<Node, Set<AtomicRole>> treeMap;
        TreeMap<Node, Set<AtomicRole>> treeMap2 = new TreeMap<Node, Set<AtomicRole>>(NodeComparator.INSTANCE);
        ExtensionTable.Retrieval retrieval = debugger.getTableau().getExtensionManager().getTernaryExtensionTable().createRetrieval(new boolean[]{false, true, false}, ExtensionTable.View.TOTAL);
        retrieval.getBindingsBuffer()[1] = node2;
        retrieval.open();
        while (!retrieval.afterLast()) {
            treeMap = retrieval.getTupleBuffer()[0];
            if (treeMap instanceof AtomicRole) {
                object = (AtomicRole)retrieval.getTupleBuffer()[0];
                serializable2 = (Node)retrieval.getTupleBuffer()[2];
                serializable = (TreeSet<Role>)treeMap2.get(serializable2);
                if (serializable == null) {
                    serializable = new TreeSet<Role>(RoleComparator.INSTANCE);
                    treeMap2.put((Node)serializable2, (Set<AtomicRole>)((Object)serializable));
                }
                serializable.add((Role)object);
            }
            retrieval.next();
        }
        if (!treeMap2.isEmpty()) {
            printWriter.println("-- Outgoing edges --------------------------------");
            Printing.printEdgeMap(debugger, treeMap2, printWriter);
        }
        treeMap = new TreeMap<Node, Set<AtomicRole>>(NodeComparator.INSTANCE);
        retrieval = debugger.getTableau().getExtensionManager().getTernaryExtensionTable().createRetrieval(new boolean[]{false, false, true}, ExtensionTable.View.TOTAL);
        retrieval.getBindingsBuffer()[2] = node2;
        retrieval.open();
        while (!retrieval.afterLast()) {
            object = retrieval.getTupleBuffer()[0];
            if (object instanceof AtomicRole) {
                serializable2 = (AtomicRole)retrieval.getTupleBuffer()[0];
                serializable = (Node)retrieval.getTupleBuffer()[1];
                TreeSet<Role> treeSet = (TreeSet<Role>)treeMap.get(serializable);
                if (treeSet == null) {
                    treeSet = new TreeSet<Role>(RoleComparator.INSTANCE);
                    treeMap.put((Node)serializable, (Set<AtomicRole>)treeSet);
                }
                treeSet.add((Role)serializable2);
            }
            retrieval.next();
        }
        if (!treeMap.isEmpty()) {
            printWriter.println("-- Incoming edges --------------------------------");
            Printing.printEdgeMap(debugger, treeMap, printWriter);
        }
    }

    protected static void printConcepts(Debugger debugger, Set<? extends Concept> set2, Collection<? extends Concept> collection, PrintWriter printWriter, int n) {
        int n2 = 0;
        for (Concept concept : set2) {
            if (n2 != 0) {
                printWriter.print(", ");
            }
            if (n2 % n == 0) {
                printWriter.println();
                printWriter.print("    ");
            }
            printWriter.print(concept.toString(debugger.getPrefixes()));
            if (collection.contains(concept)) {
                printWriter.print(" (*)");
            }
            ++n2;
        }
        printWriter.println();
    }

    protected static void printDataRanges(Debugger debugger, Set<? extends DataRange> set2, PrintWriter printWriter, int n) {
        int n2 = 0;
        for (DataRange dataRange : set2) {
            if (n2 != 0) {
                printWriter.print(", ");
            }
            if (n2 % n == 0) {
                printWriter.println();
                printWriter.print("    ");
            }
            printWriter.print(dataRange.toString(debugger.getPrefixes()));
            ++n2;
        }
        printWriter.println();
    }

    protected static void printEdgeMap(Debugger debugger, Map<Node, Set<AtomicRole>> map2, PrintWriter printWriter) {
        for (Map.Entry<Node, Set<AtomicRole>> entry : map2.entrySet()) {
            printWriter.print("    ");
            printWriter.print(entry.getKey().getNodeID());
            printWriter.print(" -->");
            int n = 0;
            for (AtomicRole atomicRole : entry.getValue()) {
                if (n != 0) {
                    printWriter.print(", ");
                }
                if (n % 3 == 0) {
                    printWriter.println();
                    printWriter.print("        ");
                }
                printWriter.print(atomicRole.toString(debugger.getPrefixes()));
                ++n;
            }
            printWriter.println();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FactComparator
    implements Comparator<Object[]> {
        public static final FactComparator INSTANCE = new FactComparator();

        @Override
        public int compare(Object[] objectArray, Object[] objectArray2) {
            int n = objectArray.length - objectArray2.length;
            if (n != 0) {
                return n;
            }
            n = objectArray[0].toString().compareTo(objectArray2[0].toString());
            if (n != 0) {
                return n;
            }
            for (int i = 1; i < objectArray.length; ++i) {
                n = ((Node)objectArray[i]).getNodeID() - ((Node)objectArray2[i]).getNodeID();
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NodeComparator
    implements Comparator<Node> {
        public static final NodeComparator INSTANCE = new NodeComparator();

        protected NodeComparator() {
        }

        @Override
        public int compare(Node node2, Node node3) {
            return node2.getNodeID() - node3.getNodeID();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RoleComparator
    implements Comparator<Role> {
        public static final RoleComparator INSTANCE = new RoleComparator();

        protected RoleComparator() {
        }

        @Override
        public int compare(Role role, Role role2) {
            int n;
            int n2 = this.getRoleType(role);
            if (n2 != (n = this.getRoleType(role2))) {
                return n2 - n;
            }
            if (n2 == 0) {
                return ((AtomicRole)role).getIRI().compareTo(((AtomicRole)role2).getIRI());
            }
            return ((InverseRole)role).getInverseOf().getIRI().compareTo(((InverseRole)role2).getInverseOf().getIRI());
        }

        protected int getRoleType(Role role) {
            if (role instanceof AtomicRole) {
                return 0;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataRangeComparator
    implements Comparator<DataRange> {
        public static final DataRangeComparator INSTANCE = new DataRangeComparator();

        @Override
        public int compare(DataRange dataRange, DataRange dataRange2) {
            DataRangeType dataRangeType;
            DataRangeType dataRangeType2 = this.getDataRangeType(dataRange);
            if (dataRangeType2 != (dataRangeType = this.getDataRangeType(dataRange2))) {
                return dataRangeType2.getTypeIndex() - dataRangeType.getTypeIndex();
            }
            switch (dataRangeType2) {
                case DatatypeRestriction: {
                    return this.compareDatatypeRestrictions((DatatypeRestriction)dataRange, (DatatypeRestriction)dataRange2);
                }
                case ConstantEnumeration: {
                    return this.compareConstantEnumerations((ConstantEnumeration)dataRange, (ConstantEnumeration)dataRange2);
                }
                case AtomicNegationDataRange: {
                    AtomicNegationDataRange atomicNegationDataRange = (AtomicNegationDataRange)dataRange;
                    AtomicNegationDataRange atomicNegationDataRange2 = (AtomicNegationDataRange)dataRange2;
                    return this.compare(atomicNegationDataRange.getNegatedDataRange(), atomicNegationDataRange2.getNegatedDataRange());
                }
                case InternalDatatype: {
                    return ((InternalDatatype)dataRange).getIRI().compareTo(((InternalDatatype)dataRange2).getIRI());
                }
            }
            throw new IllegalArgumentException();
        }

        protected DataRangeType getDataRangeType(DataRange dataRange) {
            if (dataRange instanceof DatatypeRestriction) {
                return DataRangeType.DatatypeRestriction;
            }
            if (dataRange instanceof InternalDatatype) {
                return DataRangeType.InternalDatatype;
            }
            if (dataRange instanceof ConstantEnumeration) {
                return DataRangeType.ConstantEnumeration;
            }
            if (dataRange instanceof AtomicNegationDataRange) {
                return DataRangeType.AtomicNegationDataRange;
            }
            throw new IllegalArgumentException();
        }

        protected int compareDatatypeRestrictions(DatatypeRestriction datatypeRestriction, DatatypeRestriction datatypeRestriction2) {
            int n = datatypeRestriction.getDatatypeURI().compareTo(datatypeRestriction2.getDatatypeURI());
            if (n != 0) {
                return n;
            }
            n = datatypeRestriction.getNumberOfFacetRestrictions() - datatypeRestriction2.getNumberOfFacetRestrictions();
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < datatypeRestriction.getNumberOfFacetRestrictions(); ++i) {
                n = datatypeRestriction.getFacetURI(i).compareTo(datatypeRestriction2.getFacetURI(i));
                if (n != 0) {
                    return n;
                }
                n = this.compareConstants(datatypeRestriction.getFacetValue(i), datatypeRestriction2.getFacetValue(i));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        protected int compareConstantEnumerations(ConstantEnumeration constantEnumeration, ConstantEnumeration constantEnumeration2) {
            int n = constantEnumeration.getNumberOfConstants() - constantEnumeration2.getNumberOfConstants();
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < constantEnumeration.getNumberOfConstants(); ++i) {
                n = this.compareConstants(constantEnumeration.getConstant(i), constantEnumeration2.getConstant(i));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        protected int compareConstants(Constant constant, Constant constant2) {
            int n = constant.getDatatypeURI().compareTo(constant2.getDatatypeURI());
            if (n != 0) {
                return n;
            }
            return constant.getLexicalForm().compareTo(constant2.getLexicalForm());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum DataRangeType {
            DatatypeRestriction(0),
            ConstantEnumeration(1),
            AtomicNegationDataRange(2),
            InternalDatatype(3);

            private final int m_typeIndex;

            private DataRangeType(int n2) {
                this.m_typeIndex = n2;
            }

            final int getTypeIndex() {
                return this.m_typeIndex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConceptComparator
    implements Comparator<Concept> {
        public static final ConceptComparator INSTANCE = new ConceptComparator();

        @Override
        public int compare(Concept concept, Concept concept2) {
            ConceptType conceptType;
            ConceptType conceptType2 = this.getConceptType(concept);
            if (conceptType2 != (conceptType = this.getConceptType(concept2))) {
                return conceptType2.getTypeIndex() - conceptType.getTypeIndex();
            }
            switch (conceptType2) {
                case AtomicConcept: {
                    return ((AtomicConcept)concept).getIRI().compareTo(((AtomicConcept)concept2).getIRI());
                }
                case AtLeastConcept: {
                    AtLeastConcept atLeastConcept = (AtLeastConcept)concept;
                    AtLeastConcept atLeastConcept2 = (AtLeastConcept)concept2;
                    int n = RoleComparator.INSTANCE.compare(atLeastConcept.getOnRole(), atLeastConcept2.getOnRole());
                    if (n != 0) {
                        return n;
                    }
                    return this.compare(atLeastConcept.getToConcept(), atLeastConcept2.getToConcept());
                }
                case ExistsDescriptionGraph: {
                    ExistsDescriptionGraph existsDescriptionGraph = (ExistsDescriptionGraph)concept;
                    ExistsDescriptionGraph existsDescriptionGraph2 = (ExistsDescriptionGraph)concept2;
                    return existsDescriptionGraph.getDescriptionGraph().getName().compareTo(existsDescriptionGraph2.getDescriptionGraph().getName());
                }
                case AtomicNegationConcept: {
                    return ((AtomicNegationConcept)concept).getNegatedAtomicConcept().getIRI().compareTo(((AtomicNegationConcept)concept2).getNegatedAtomicConcept().getIRI());
                }
            }
            throw new IllegalArgumentException();
        }

        protected ConceptType getConceptType(Concept concept) {
            if (concept instanceof AtomicConcept) {
                return ConceptType.AtomicConcept;
            }
            if (concept instanceof AtLeastConcept) {
                return ConceptType.AtLeastConcept;
            }
            if (concept instanceof ExistsDescriptionGraph) {
                return ConceptType.ExistsDescriptionGraph;
            }
            if (concept instanceof AtomicNegationConcept) {
                return ConceptType.AtomicNegationConcept;
            }
            throw new IllegalArgumentException();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum ConceptType {
            AtomicConcept(0),
            AtLeastConcept(1),
            ExistsDescriptionGraph(2),
            AtomicNegationConcept(3);

            private final int m_typeIndex;

            private ConceptType(int n2) {
                this.m_typeIndex = n2;
            }

            final int getTypeIndex() {
                return this.m_typeIndex;
            }
        }
    }
}

