/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.tableau.Node;

public class ActiveNodesCommand
extends AbstractCommand {
    public ActiveNodesCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "activeNodes";
    }

    public String[] getDescription() {
        return new String[]{"", "shows all active nodes"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: activeNodes");
        printWriter.println("    Prints list of all active (non-blocked) nodes in the current model.");
    }

    public void execute(String[] stringArray) {
        int n = 0;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.println("===========================================");
        printWriter.println("      ID");
        printWriter.println("===========================================");
        for (Node node2 = this.m_debugger.getTableau().getFirstTableauNode(); node2 != null; node2 = node2.getNextTableauNode()) {
            if (node2.isBlocked()) continue;
            ++n;
            printWriter.print("  ");
            printWriter.println(node2.getNodeID());
        }
        printWriter.flush();
        this.showTextInWindow("Active nodes (" + n + "):" + charArrayWriter.toString(), "Active nodes");
        this.selectConsoleWindow();
    }
}

