/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.TreeSet;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.Printing;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;

public class QueryCommand
extends AbstractCommand {
    public QueryCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "query";
    }

    public String[] getDescription() {
        return new String[]{"", "prints whether there is a clash", "?|predicate [?|nodeID]+", "prints all facts matching the query; ? is a joker"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: query");
        printWriter.println("    Prints whether the model contains a clash.");
        printWriter.println("usage: ?|predicate [?|nodeID]+");
        printWriter.println("    Prints all facts matching the query, which is a partially specified atom.");
        printWriter.println("    Parts of the atom are either specified fully, or by using ? as a joker.");
    }

    public void execute(String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length - 1];
        if (objectArray.length == 0) {
            if (this.m_debugger.getTableau().getExtensionManager().containsClash()) {
                this.m_debugger.getOutput().println("The model currently contains a clash.");
            } else {
                this.m_debugger.getOutput().println("The modelcurrently does not contain a clash.");
            }
        } else {
            if ("?".equals(stringArray[1])) {
                objectArray[0] = null;
            } else {
                try {
                    objectArray[0] = this.getDLPredicate(stringArray[1]);
                }
                catch (Exception exception) {
                    this.m_debugger.getOutput().println("Invalid predicate '" + stringArray[1] + "':" + exception.getMessage());
                }
                if (objectArray[0] == null) {
                    this.m_debugger.getOutput().println("Invalid predicate '" + stringArray[1] + "'.");
                    return;
                }
            }
            for (int i = 1; i < objectArray.length; ++i) {
                int n;
                String string2 = stringArray[i + 1];
                if ("?".equals(string2)) {
                    objectArray[i] = null;
                    continue;
                }
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_debugger.getOutput().println("Invalid node ID.");
                    return;
                }
                objectArray[i] = this.m_debugger.getTableau().getNode(n);
                if (objectArray[i] != null) continue;
                this.m_debugger.getOutput().println("Node with ID '" + n + "' not found.");
                return;
            }
            boolean[] blArray = new boolean[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                blArray[i] = true;
            }
            ExtensionTable extensionTable = this.m_debugger.getTableau().getExtensionManager().getExtensionTable(objectArray.length);
            ExtensionTable.Retrieval retrieval = extensionTable.createRetrieval(blArray, ExtensionTable.View.TOTAL);
            System.arraycopy(objectArray, 0, retrieval.getBindingsBuffer(), 0, objectArray.length);
            retrieval.open();
            TreeSet<Object[]> treeSet = new TreeSet<Object[]>(Printing.FactComparator.INSTANCE);
            Object[] objectArray2 = retrieval.getTupleBuffer();
            while (!retrieval.afterLast()) {
                treeSet.add((Object[])objectArray2.clone());
                retrieval.next();
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charArrayWriter);
            printWriter.println("===========================================");
            StringBuffer stringBuffer = new StringBuffer("Query:");
            printWriter.print("Query:");
            for (int i = 1; i < stringArray.length; ++i) {
                printWriter.print(' ');
                printWriter.print(stringArray[i]);
                stringBuffer.append(' ');
                stringBuffer.append(stringArray[i]);
            }
            printWriter.println();
            printWriter.println("===========================================");
            for (Object[] objectArray3 : treeSet) {
                printWriter.print(' ');
                this.printFact(objectArray3, printWriter);
                printWriter.println();
            }
            printWriter.println("===========================================");
            printWriter.flush();
            this.showTextInWindow(charArrayWriter.toString(), stringBuffer.toString());
            this.selectConsoleWindow();
        }
    }

    protected void printFact(Object[] objectArray, PrintWriter printWriter) {
        Object object = objectArray[0];
        if (object instanceof Concept) {
            printWriter.print(((Concept)object).toString(this.m_debugger.getPrefixes()));
        } else if (object instanceof DLPredicate) {
            printWriter.print(((DLPredicate)object).toString(this.m_debugger.getPrefixes()));
        } else {
            throw new IllegalStateException("Internal error: invalid predicate.");
        }
        printWriter.print('[');
        for (int i = 1; i < objectArray.length; ++i) {
            if (i != 1) {
                printWriter.print(',');
            }
            printWriter.print(((Node)objectArray[i]).getNodeID());
        }
        printWriter.print(']');
    }
}

