/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.Printing;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.tableau.Node;

public class ShowExistsCommand
extends AbstractCommand {
    public ShowExistsCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "showExists";
    }

    public String[] getDescription() {
        return new String[]{"", "prints nodes with unprocessed existentials"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: showExists");
        printWriter.println("    Prints a list of nodes that have unprocessed existentials, together with information that generated these nodes.");
    }

    public void execute(String[] stringArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.println("Nodes with existentials");
        printWriter.println("================================================================================");
        printWriter.println("      ID    # Existentials    Start Existential");
        printWriter.println("================================================================================");
        for (Node node2 = this.m_debugger.getTableau().getFirstTableauNode(); node2 != null; node2 = node2.getNextTableauNode()) {
            if (!node2.isActive() || node2.isBlocked() || !node2.hasUnprocessedExistentials()) continue;
            printWriter.print("  ");
            Printing.printPadded(printWriter, node2.getNodeID(), 6);
            printWriter.print("      ");
            Printing.printPadded(printWriter, node2.getUnprocessedExistentials().size(), 6);
            printWriter.print("        ");
            this.printStartExistential(node2, printWriter);
            printWriter.println();
        }
        printWriter.println("===========================================");
        printWriter.flush();
        this.showTextInWindow(charArrayWriter.toString(), "Nodes with existentials");
        this.selectConsoleWindow();
    }

    protected void printStartExistential(Node node2, PrintWriter printWriter) {
        Debugger.NodeCreationInfo nodeCreationInfo = this.m_debugger.getNodeCreationInfo(node2);
        ExistentialConcept existentialConcept = nodeCreationInfo.m_createdByExistential;
        if (existentialConcept == null) {
            printWriter.print("(root)");
        } else {
            printWriter.print(existentialConcept.toString(this.m_debugger.getPrefixes()));
        }
    }
}

