/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.Printing;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.tableau.Node;

public class ShowNodeCommand
extends AbstractCommand {
    public ShowNodeCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "showNode";
    }

    public String[] getDescription() {
        return new String[]{"nodeID", "prints information about the given node"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: showNode nodeID");
        printWriter.println("    Prints information about the node for the given node ID.");
    }

    public void execute(String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            this.m_debugger.getOutput().println("Node ID is missing.");
            return;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_debugger.getOutput().println("Invalid ID of the first node.");
            return;
        }
        Node node2 = this.m_debugger.getTableau().getNode(n);
        if (node2 == null) {
            this.m_debugger.getOutput().println("Node with ID '" + n + "' not found.");
            return;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        Printing.printNodeData(this.m_debugger, node2, printWriter);
        printWriter.flush();
        this.showTextInWindow(charArrayWriter.toString(), "Node '" + node2.getNodeID() + "'");
        this.selectConsoleWindow();
    }
}

