/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;

public class SingleStepCommand
extends AbstractCommand {
    public SingleStepCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "singleStep";
    }

    public String[] getDescription() {
        return new String[]{"on|off", "step-by-step mode on or off"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: singleStep on|off");
        printWriter.println("    If on, the debugger will return control to the user after each step.");
        printWriter.println("    If off, the debugger will run until a breakpoint is reached.");
    }

    public void execute(String[] stringArray) {
        if (stringArray.length < 2) {
            this.m_debugger.getOutput().println("The status is missing.");
            return;
        }
        String string2 = stringArray[1].toLowerCase();
        if ("on".equals(string2)) {
            this.m_debugger.setSinglestep(true);
            this.m_debugger.getOutput().println("Single step mode on.");
        } else if ("off".equals(string2)) {
            this.m_debugger.setSinglestep(false);
            this.m_debugger.getOutput().println("Single step mode off.");
        } else {
            this.m_debugger.getOutput().println("Incorrect single step mode '" + string2 + "'.");
        }
    }
}

