/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.examples;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import java.io.File;
import java.util.Set;
import org.semanticweb.HermiT.Configuration;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class Explanations {
    public static void main(String[] stringArray) throws Exception {
        OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
        OWLDataFactory oWLDataFactory = oWLOntologyManager.getOWLDataFactory();
        File file2 = new File("examples/ontologies/pizza.owl");
        OWLOntology oWLOntology = oWLOntologyManager.loadOntologyFromOntologyDocument(file2);
        IRI iRI = IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl#IceCream");
        OWLClass oWLClass = oWLDataFactory.getOWLClass(iRI);
        Reasoner.ReasonerFactory reasonerFactory = new Reasoner.ReasonerFactory();
        Configuration configuration = new Configuration();
        configuration.throwInconsistentOntologyException = false;
        OWLReasoner oWLReasoner = reasonerFactory.createReasoner(oWLOntology, configuration);
        System.out.println("Is icecream satisfiable? " + oWLReasoner.isSatisfiable(oWLClass));
        System.out.println("Computing explanations...");
        BlackBoxExplanation blackBoxExplanation = new BlackBoxExplanation(oWLOntology, reasonerFactory, oWLReasoner);
        HSTExplanationGenerator hSTExplanationGenerator = new HSTExplanationGenerator(blackBoxExplanation);
        Set<Set<OWLAxiom>> set2 = hSTExplanationGenerator.getExplanations(oWLClass);
        for (Set<OWLAxiom> object2 : set2) {
            System.out.println("------------------");
            System.out.println("Axioms causing the unsatisfiability: ");
            for (Object object : object2) {
                System.out.println(object);
            }
            System.out.println("------------------");
        }
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLDataFactory.getOWLNamedIndividual(IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl#dummyIndividual")));
        oWLOntologyManager.addAxiom(oWLOntology, oWLClassAssertionAxiom);
        oWLReasoner = reasonerFactory.createReasoner(oWLOntology, configuration);
        System.out.println("Is the changed ontology consistent? " + oWLReasoner.isConsistent());
        System.out.println("Computing explanations for the inconsistency...");
        reasonerFactory = new Reasoner.ReasonerFactory(){

            protected OWLReasoner createHermiTOWLReasoner(Configuration configuration, OWLOntology oWLOntology) {
                configuration.throwInconsistentOntologyException = false;
                return new Reasoner(configuration, oWLOntology);
            }
        };
        blackBoxExplanation = new BlackBoxExplanation(oWLOntology, reasonerFactory, oWLReasoner);
        hSTExplanationGenerator = new HSTExplanationGenerator(blackBoxExplanation);
        set2 = hSTExplanationGenerator.getExplanations(oWLDataFactory.getOWLThing());
        for (Set<OWLAxiom> set3 : set2) {
            System.out.println("------------------");
            System.out.println("Axioms causing the inconsistency: ");
            for (OWLAxiom oWLAxiom : set3) {
                System.out.println(oWLAxiom);
            }
            System.out.println("------------------");
        }
    }
}

