/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.examples;

import java.io.File;
import org.semanticweb.HermiT.Configuration;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.HermiT.monitor.CountingMonitor;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.InferenceType;

public class HermiTConfigurations {
    public static void main(String[] stringArray) throws Exception {
        OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
        File file2 = new File("examples/ontologies/pizza.owl");
        OWLOntology oWLOntology = oWLOntologyManager.loadOntologyFromOntologyDocument(file2);
        Configuration configuration = new Configuration();
        configuration.tableauMonitorType = Configuration.TableauMonitorType.TIMING;
        Reasoner reasoner = new Reasoner(configuration, oWLOntology);
        IRI iRI = IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl#IceCream");
        OWLClass oWLClass = oWLOntologyManager.getOWLDataFactory().getOWLClass(iRI);
        System.out.println("Is the icecream class satisfiable? " + reasoner.isSatisfiable(oWLClass));
        System.out.println("--------------------------");
        configuration = new Configuration();
        CountingMonitor countingMonitor = new CountingMonitor();
        configuration.monitor = countingMonitor;
        reasoner = new Reasoner(configuration, oWLOntology);
        reasoner.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        System.out.println("HermiT did " + countingMonitor.getOverallNumberOfTests() + " tests. ");
        System.out.println("This took " + countingMonitor.getOverallTime() + " ms. ");
        System.out.println("The last test took " + countingMonitor.getTime() + " ms. ");
        System.out.println("The last model contained " + countingMonitor.getNumberOfNodes() + " nodes/individuals. ");
        System.out.println("The 2 hardest satisfiability tests were:");
        for (CountingMonitor.TestRecord testRecord : countingMonitor.getTimeSortedTestRecords(2, ReasoningTaskDescription.StandardTestType.CONCEPT_SATISFIABILITY)) {
            System.out.println(testRecord.toString());
        }
        System.out.println("The 2 hardest subsumption tests were:");
        for (CountingMonitor.TestRecord testRecord : countingMonitor.getTimeSortedTestRecords(2, ReasoningTaskDescription.StandardTestType.CONCEPT_SUBSUMPTION)) {
            System.out.println(testRecord.toString());
        }
    }
}

