/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.existentials;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.HermiT.blocking.BlockingStrategy;
import org.semanticweb.HermiT.existentials.ExistentialExpansionStrategy;
import org.semanticweb.HermiT.model.AtLeast;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.AtLeastDataRange;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.model.ExistsDescriptionGraph;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.DescriptionGraphManager;
import org.semanticweb.HermiT.tableau.ExistentialExpansionManager;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpansionStrategy
implements ExistentialExpansionStrategy,
Serializable {
    private static final long serialVersionUID = 2831957929321676444L;
    protected final BlockingStrategy m_blockingStrategy;
    protected final boolean m_expandNodeAtATime;
    protected final List<ExistentialConcept> m_processedExistentials;
    protected final List<Node> m_auxiliaryNodes1;
    protected final List<Node> m_auxiliaryNodes2;
    protected Tableau m_tableau;
    protected InterruptFlag m_interruptFlag;
    protected ExtensionManager m_extensionManager;
    protected ExtensionTable.Retrieval m_ternaryExtensionTableSearch01Bound;
    protected ExtensionTable.Retrieval m_ternaryExtensionTableSearch02Bound;
    protected ExistentialExpansionManager m_existentialExpansionManager;
    protected DescriptionGraphManager m_descriptionGraphManager;

    public AbstractExpansionStrategy(BlockingStrategy blockingStrategy, boolean bl) {
        this.m_blockingStrategy = blockingStrategy;
        this.m_expandNodeAtATime = bl;
        this.m_processedExistentials = new ArrayList<ExistentialConcept>();
        this.m_auxiliaryNodes1 = new ArrayList<Node>();
        this.m_auxiliaryNodes2 = new ArrayList<Node>();
    }

    @Override
    public void initialize(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_interruptFlag = this.m_tableau.getInterruptFlag();
        this.m_extensionManager = this.m_tableau.getExtensionManager();
        this.m_ternaryExtensionTableSearch01Bound = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, true, false}, ExtensionTable.View.TOTAL);
        this.m_ternaryExtensionTableSearch02Bound = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, false, true}, ExtensionTable.View.TOTAL);
        this.m_existentialExpansionManager = this.m_tableau.getExistentialExpansionManager();
        this.m_descriptionGraphManager = this.m_tableau.getDescriptionGraphManager();
        this.m_blockingStrategy.initialize(this.m_tableau);
    }

    @Override
    public void additionalDLOntologySet(DLOntology dLOntology) {
        this.m_blockingStrategy.additionalDLOntologySet(dLOntology);
    }

    @Override
    public void additionalDLOntologyCleared() {
        this.m_blockingStrategy.additionalDLOntologyCleared();
    }

    @Override
    public void clear() {
        this.m_blockingStrategy.clear();
        this.m_processedExistentials.clear();
        this.m_ternaryExtensionTableSearch01Bound.clear();
        this.m_ternaryExtensionTableSearch02Bound.clear();
    }

    @Override
    public boolean expandExistentials(boolean bl) {
        TableauMonitor tableauMonitor = this.m_tableau.getTableauMonitor();
        this.m_blockingStrategy.computeBlocking(bl);
        boolean bl2 = false;
        for (Node node2 = this.m_tableau.getFirstTableauNode(); !(node2 == null || bl2 && this.m_expandNodeAtATime); node2 = node2.getNextTableauNode()) {
            if (node2.isActive() && !node2.isBlocked() && node2.hasUnprocessedExistentials()) {
                this.m_processedExistentials.clear();
                this.m_processedExistentials.addAll(node2.getUnprocessedExistentials());
                for (int i = this.m_processedExistentials.size() - 1; i >= 0; --i) {
                    ExistentialConcept existentialConcept;
                    ExistentialConcept existentialConcept2 = this.m_processedExistentials.get(i);
                    if (existentialConcept2 instanceof AtLeast) {
                        existentialConcept = (AtLeast)existentialConcept2;
                        switch (this.isSatisfied((AtLeast)existentialConcept, node2)) {
                            case NOT_SATISFIED: {
                                this.expandExistential((AtLeast)existentialConcept, node2);
                                bl2 = true;
                                break;
                            }
                            case PERMANENTLY_SATISFIED: {
                                this.m_existentialExpansionManager.markExistentialProcessed(existentialConcept2, node2);
                                if (tableauMonitor == null) break;
                                tableauMonitor.existentialSatisfied(existentialConcept2, node2);
                                break;
                            }
                            case CURRENTLY_SATISFIED: {
                                if (tableauMonitor == null) break;
                                tableauMonitor.existentialSatisfied(existentialConcept2, node2);
                            }
                        }
                    } else if (existentialConcept2 instanceof ExistsDescriptionGraph) {
                        existentialConcept = (ExistsDescriptionGraph)existentialConcept2;
                        if (!this.m_descriptionGraphManager.isSatisfied((ExistsDescriptionGraph)existentialConcept, node2)) {
                            this.m_descriptionGraphManager.expand((ExistsDescriptionGraph)existentialConcept, node2);
                            bl2 = true;
                        } else if (tableauMonitor != null) {
                            tableauMonitor.existentialSatisfied(existentialConcept, node2);
                        }
                        this.m_existentialExpansionManager.markExistentialProcessed(existentialConcept2, node2);
                    } else {
                        throw new IllegalStateException("Unsupported type of existential.");
                    }
                    this.m_interruptFlag.checkInterrupt();
                }
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return bl2;
    }

    @Override
    public void assertionAdded(Concept concept, Node node2, boolean bl) {
        this.m_blockingStrategy.assertionAdded(concept, node2, bl);
    }

    @Override
    public void assertionCoreSet(Concept concept, Node node2) {
        this.m_blockingStrategy.assertionCoreSet(concept, node2);
    }

    @Override
    public void assertionRemoved(Concept concept, Node node2, boolean bl) {
        this.m_blockingStrategy.assertionRemoved(concept, node2, bl);
    }

    @Override
    public void assertionAdded(DataRange dataRange, Node node2, boolean bl) {
        this.m_blockingStrategy.assertionAdded(dataRange, node2, bl);
    }

    @Override
    public void assertionCoreSet(DataRange dataRange, Node node2) {
        this.m_blockingStrategy.assertionCoreSet(dataRange, node2);
    }

    @Override
    public void assertionRemoved(DataRange dataRange, Node node2, boolean bl) {
        this.m_blockingStrategy.assertionRemoved(dataRange, node2, bl);
    }

    @Override
    public void assertionAdded(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        this.m_blockingStrategy.assertionAdded(atomicRole, node2, node3, bl);
    }

    @Override
    public void assertionCoreSet(AtomicRole atomicRole, Node node2, Node node3) {
        this.m_blockingStrategy.assertionCoreSet(atomicRole, node2, node3);
    }

    @Override
    public void assertionRemoved(AtomicRole atomicRole, Node node2, Node node3, boolean bl) {
        this.m_blockingStrategy.assertionRemoved(atomicRole, node2, node3, bl);
    }

    @Override
    public void nodesMerged(Node node2, Node node3) {
        this.m_blockingStrategy.nodesMerged(node2, node3);
    }

    @Override
    public void nodesUnmerged(Node node2, Node node3) {
        this.m_blockingStrategy.nodesUnmerged(node2, node3);
    }

    @Override
    public void nodeStatusChanged(Node node2) {
        this.m_blockingStrategy.nodeStatusChanged(node2);
    }

    @Override
    public void nodeInitialized(Node node2) {
        this.m_blockingStrategy.nodeInitialized(node2);
    }

    @Override
    public void nodeDestroyed(Node node2) {
        this.m_blockingStrategy.nodeDestroyed(node2);
    }

    @Override
    public void branchingPointPushed() {
    }

    @Override
    public void backtrack() {
    }

    @Override
    public void modelFound() {
        this.m_blockingStrategy.modelFound();
    }

    @Override
    public boolean isExact() {
        return this.m_blockingStrategy.isExact();
    }

    @Override
    public void dlClauseBodyCompiled(List<DLClauseEvaluator.Worker> list, DLClause dLClause, List<Variable> list2, Object[] objectArray, boolean[] blArray) {
        this.m_blockingStrategy.dlClauseBodyCompiled(list, dLClause, list2, objectArray, blArray);
    }

    protected SatType isSatisfied(AtLeast atLeast, Node node2) {
        int n;
        ExtensionTable.Retrieval retrieval;
        int n2 = atLeast.getNumber();
        if (n2 <= 0) {
            return SatType.PERMANENTLY_SATISFIED;
        }
        Role role = atLeast.getOnRole();
        if (role instanceof AtomicRole) {
            retrieval = this.m_ternaryExtensionTableSearch01Bound;
            retrieval.getBindingsBuffer()[0] = role;
            retrieval.getBindingsBuffer()[1] = node2;
            n = 2;
        } else {
            retrieval = this.m_ternaryExtensionTableSearch02Bound;
            retrieval.getBindingsBuffer()[0] = ((InverseRole)role).getInverseOf();
            retrieval.getBindingsBuffer()[2] = node2;
            n = 1;
        }
        if (n2 == 1) {
            retrieval.open();
            Object[] objectArray = retrieval.getTupleBuffer();
            while (!retrieval.afterLast()) {
                Serializable serializable;
                Node node3 = (Node)objectArray[n];
                if (atLeast instanceof AtLeastDataRange) {
                    serializable = ((AtLeastDataRange)atLeast).getToDataRange();
                    if (this.m_extensionManager.containsDataRangeAssertion((DataRange)serializable, node3)) {
                        if (this.isPermanentSatisfier(node2, node3) && this.m_blockingStrategy.isPermanentAssertion((DataRange)serializable, node3)) {
                            return SatType.PERMANENTLY_SATISFIED;
                        }
                        return SatType.CURRENTLY_SATISFIED;
                    }
                } else {
                    serializable = ((AtLeastConcept)atLeast).getToConcept();
                    if ((!node3.isBlocked() || node2.isParentOf(node3)) && this.m_extensionManager.containsConceptAssertion((Concept)serializable, node3)) {
                        if (this.isPermanentSatisfier(node2, node3) && this.m_blockingStrategy.isPermanentAssertion((Concept)serializable, node3)) {
                            return SatType.PERMANENTLY_SATISFIED;
                        }
                        return SatType.CURRENTLY_SATISFIED;
                    }
                }
                retrieval.next();
            }
            return SatType.NOT_SATISFIED;
        }
        this.m_auxiliaryNodes1.clear();
        retrieval.open();
        Object[] objectArray = retrieval.getTupleBuffer();
        boolean bl = true;
        while (!retrieval.afterLast()) {
            Serializable serializable;
            Node node4 = (Node)objectArray[n];
            if (atLeast instanceof AtLeastDataRange) {
                serializable = ((AtLeastDataRange)atLeast).getToDataRange();
                if (this.m_extensionManager.containsDataRangeAssertion((DataRange)serializable, node4)) {
                    if (!this.isPermanentSatisfier(node2, node4) || !this.m_blockingStrategy.isPermanentAssertion((DataRange)serializable, node4)) {
                        bl = false;
                    }
                    this.m_auxiliaryNodes1.add(node4);
                }
            } else {
                serializable = ((AtLeastConcept)atLeast).getToConcept();
                if ((!node4.isBlocked() || node2.isParentOf(node4)) && this.m_extensionManager.containsConceptAssertion((Concept)serializable, node4)) {
                    if (!this.isPermanentSatisfier(node2, node4) || !this.m_blockingStrategy.isPermanentAssertion((Concept)serializable, node4)) {
                        bl = false;
                    }
                    this.m_auxiliaryNodes1.add(node4);
                }
            }
            retrieval.next();
        }
        if (this.m_auxiliaryNodes1.size() >= n2) {
            this.m_auxiliaryNodes2.clear();
            if (this.containsSubsetOfNUnequalNodes(node2, this.m_auxiliaryNodes1, 0, this.m_auxiliaryNodes2, n2)) {
                return bl ? SatType.PERMANENTLY_SATISFIED : SatType.CURRENTLY_SATISFIED;
            }
        }
        return SatType.NOT_SATISFIED;
    }

    protected boolean isPermanentSatisfier(Node node2, Node node3) {
        return node2 == node3 || node2.getParent() == node3 || node3.getParent() == node2 || node3.isRootNode();
    }

    protected boolean containsSubsetOfNUnequalNodes(Node node2, List<Node> list, int n, List<Node> list2, int n2) {
        if (list2.size() == n2) {
            return true;
        }
        block0: for (int i = n; i < list.size(); ++i) {
            Node node3 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                Node node4 = list2.get(j);
                if (!this.m_extensionManager.containsAssertion(Inequality.INSTANCE, node3, node4) && !this.m_extensionManager.containsAssertion(Inequality.INSTANCE, node4, node3)) continue block0;
            }
            list2.add(node3);
            if (this.containsSubsetOfNUnequalNodes(node2, list, i + 1, list2, n2)) {
                return true;
            }
            list2.remove(list2.size() - 1);
        }
        return false;
    }

    protected abstract void expandExistential(AtLeast var1, Node var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SatType {
        NOT_SATISFIED,
        PERMANENTLY_SATISFIED,
        CURRENTLY_SATISFIED;

    }
}

