/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.existentials;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.blocking.BlockingStrategy;
import org.semanticweb.HermiT.existentials.AbstractExpansionStrategy;
import org.semanticweb.HermiT.model.AtLeast;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.AtLeastDataRange;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.tableau.BranchingPoint;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.PermanentDependencySet;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.TupleTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividualReuseStrategy
extends AbstractExpansionStrategy
implements Serializable {
    private static final long serialVersionUID = -7373787507623860081L;
    protected final boolean m_isDeterministic;
    protected final Map<AtomicConcept, NodeBranchingPointPair> m_reusedNodes;
    protected final Set<AtomicConcept> m_doReuseConceptsAlways;
    protected final Set<AtomicConcept> m_dontReuseConceptsThisRun;
    protected final Set<AtomicConcept> m_dontReuseConceptsEver;
    protected final TupleTable m_reuseBacktrackingTable;
    protected final Object[] m_auxiliaryBuffer;
    protected int[] m_indicesByBranchingPoint;

    public IndividualReuseStrategy(BlockingStrategy blockingStrategy, boolean bl) {
        super(blockingStrategy, true);
        this.m_isDeterministic = bl;
        this.m_reusedNodes = new HashMap<AtomicConcept, NodeBranchingPointPair>();
        this.m_doReuseConceptsAlways = new HashSet<AtomicConcept>();
        this.m_dontReuseConceptsThisRun = new HashSet<AtomicConcept>();
        this.m_dontReuseConceptsEver = new HashSet<AtomicConcept>();
        this.m_reuseBacktrackingTable = new TupleTable(1);
        this.m_auxiliaryBuffer = new Object[1];
        this.m_indicesByBranchingPoint = new int[10];
    }

    @Override
    public void initialize(Tableau tableau) {
        super.initialize(tableau);
        this.m_doReuseConceptsAlways.clear();
        this.m_dontReuseConceptsEver.clear();
        Object object = tableau.getParameters().get("IndividualReuseStrategy.reuseAlways");
        if (object instanceof Set) {
            this.m_doReuseConceptsAlways.addAll((Set)object);
        }
        if ((object = tableau.getParameters().get("IndividualReuseStrategy.reuseNever")) instanceof Set) {
            this.m_dontReuseConceptsEver.addAll((Set)object);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.m_reusedNodes.clear();
        this.m_reuseBacktrackingTable.clear();
        this.m_dontReuseConceptsThisRun.clear();
        this.m_dontReuseConceptsThisRun.addAll(this.m_dontReuseConceptsEver);
    }

    @Override
    public void branchingPointPushed() {
        int n = this.m_tableau.getCurrentBranchingPoint().getLevel();
        int n2 = n + 1;
        if (n2 > this.m_indicesByBranchingPoint.length) {
            int n3 = this.m_indicesByBranchingPoint.length * 3 / 2;
            while (n2 > n3) {
                n3 = n3 * 3 / 2;
            }
            int[] nArray = new int[n3];
            System.arraycopy(this.m_indicesByBranchingPoint, 0, nArray, 0, this.m_indicesByBranchingPoint.length);
            this.m_indicesByBranchingPoint = nArray;
        }
        this.m_indicesByBranchingPoint[n] = this.m_reuseBacktrackingTable.getFirstFreeTupleIndex();
    }

    @Override
    public void backtrack() {
        int n = this.m_indicesByBranchingPoint[this.m_tableau.getCurrentBranchingPoint().getLevel()];
        for (int i = this.m_reuseBacktrackingTable.getFirstFreeTupleIndex() - 1; i >= n; --i) {
            AtomicConcept atomicConcept = (AtomicConcept)this.m_reuseBacktrackingTable.getTupleObject(i, 0);
            NodeBranchingPointPair nodeBranchingPointPair = this.m_reusedNodes.remove(atomicConcept);
            assert (nodeBranchingPointPair != null);
        }
        this.m_reuseBacktrackingTable.truncate(n);
    }

    @Override
    public void modelFound() {
        this.m_dontReuseConceptsEver.addAll(this.m_dontReuseConceptsThisRun);
    }

    @Override
    public boolean isDeterministic() {
        return this.m_isDeterministic;
    }

    public AtomicConcept getConceptForNode(Node node2) {
        for (Map.Entry<AtomicConcept, NodeBranchingPointPair> entry : this.m_reusedNodes.entrySet()) {
            if (entry.getValue().m_node != node2) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<AtomicConcept> getDontReuseConceptsEver() {
        return this.m_dontReuseConceptsEver;
    }

    @Override
    protected void expandExistential(AtLeast atLeast, Node node2) {
        this.m_existentialExpansionManager.markExistentialProcessed(atLeast, node2);
        if (!this.m_existentialExpansionManager.tryFunctionalExpansion(atLeast, node2)) {
            if (atLeast instanceof AtLeastDataRange) {
                this.m_existentialExpansionManager.doNormalExpansion((AtLeastDataRange)atLeast, node2);
            } else {
                AtLeastConcept atLeastConcept = (AtLeastConcept)atLeast;
                if (!this.tryParentReuse(atLeastConcept, node2) && !this.expandWithModelReuse(atLeastConcept, node2)) {
                    this.m_existentialExpansionManager.doNormalExpansion(atLeastConcept, node2);
                }
            }
        }
    }

    protected boolean tryParentReuse(AtLeastConcept atLeastConcept, Node node2) {
        Node node3;
        if (atLeastConcept.getNumber() == 1 && (node3 = node2.getParent()) != null && this.m_extensionManager.containsConceptAssertion(atLeastConcept.getToConcept(), node3)) {
            DependencySet dependencySet = this.m_extensionManager.getConceptAssertionDependencySet(atLeastConcept, node2);
            if (!this.m_isDeterministic) {
                IndividualReuseBranchingPoint individualReuseBranchingPoint = new IndividualReuseBranchingPoint(this.m_tableau, atLeastConcept, node2, true);
                this.m_tableau.pushBranchingPoint(individualReuseBranchingPoint);
                dependencySet = this.m_tableau.getDependencySetFactory().addBranchingPoint(dependencySet, individualReuseBranchingPoint.getLevel());
            }
            this.m_extensionManager.addRoleAssertion(atLeastConcept.getOnRole(), node2, node3, dependencySet, true);
            return true;
        }
        return false;
    }

    protected boolean expandWithModelReuse(AtLeastConcept atLeastConcept, Node node2) {
        if (!(atLeastConcept.getToConcept() instanceof AtomicConcept)) {
            return false;
        }
        AtomicConcept atomicConcept = (AtomicConcept)atLeastConcept.getToConcept();
        if (Prefixes.isInternalIRI(atomicConcept.getIRI())) {
            return false;
        }
        if (atLeastConcept.getNumber() == 1 && (this.m_doReuseConceptsAlways.contains(atomicConcept) || !this.m_dontReuseConceptsThisRun.contains(atomicConcept))) {
            Node node3;
            if (this.m_tableau.getTableauMonitor() != null) {
                this.m_tableau.getTableauMonitor().existentialExpansionStarted(atLeastConcept, node2);
            }
            DependencySet dependencySet = this.m_extensionManager.getConceptAssertionDependencySet(atLeastConcept, node2);
            NodeBranchingPointPair nodeBranchingPointPair = this.m_reusedNodes.get(atomicConcept);
            if (nodeBranchingPointPair == null) {
                if (!this.m_isDeterministic) {
                    IndividualReuseBranchingPoint individualReuseBranchingPoint = new IndividualReuseBranchingPoint(this.m_tableau, atLeastConcept, node2, false);
                    this.m_tableau.pushBranchingPoint(individualReuseBranchingPoint);
                    dependencySet = this.m_tableau.getDependencySetFactory().addBranchingPoint(dependencySet, individualReuseBranchingPoint.getLevel());
                }
                node3 = this.m_tableau.createNewNINode(dependencySet);
                nodeBranchingPointPair = new NodeBranchingPointPair(node3, this.m_tableau.getCurrentBranchingPointLevel());
                this.m_reusedNodes.put(atomicConcept, nodeBranchingPointPair);
                this.m_extensionManager.addConceptAssertion(atomicConcept, node3, dependencySet, true);
                this.m_auxiliaryBuffer[0] = atomicConcept;
                this.m_reuseBacktrackingTable.addTuple(this.m_auxiliaryBuffer);
            } else {
                dependencySet = nodeBranchingPointPair.m_node.addCanonicalNodeDependencySet(dependencySet);
                node3 = nodeBranchingPointPair.m_node.getCanonicalNode();
                if (!this.m_isDeterministic) {
                    dependencySet = this.m_tableau.getDependencySetFactory().addBranchingPoint(dependencySet, nodeBranchingPointPair.m_branchingPoint);
                }
            }
            this.m_extensionManager.addRoleAssertion(atLeastConcept.getOnRole(), node2, node3, dependencySet, true);
            if (this.m_tableau.getTableauMonitor() != null) {
                this.m_tableau.getTableauMonitor().existentialExpansionFinished(atLeastConcept, node2);
            }
            return true;
        }
        return false;
    }

    protected static class NodeBranchingPointPair
    implements Serializable {
        private static final long serialVersionUID = 427963701900451471L;
        protected final Node m_node;
        protected final int m_branchingPoint;

        public NodeBranchingPointPair(Node node2, int n) {
            this.m_node = node2;
            this.m_branchingPoint = n;
        }
    }

    protected class IndividualReuseBranchingPoint
    extends BranchingPoint {
        private static final long serialVersionUID = -5715836252258022216L;
        protected final AtLeastConcept m_existential;
        protected final Node m_node;
        protected final boolean m_wasParentReuse;

        public IndividualReuseBranchingPoint(Tableau tableau, AtLeastConcept atLeastConcept, Node node2, boolean bl) {
            super(tableau);
            this.m_existential = atLeastConcept;
            this.m_node = node2;
            this.m_wasParentReuse = bl;
        }

        public void startNextChoice(Tableau tableau, DependencySet dependencySet) {
            if (!this.m_wasParentReuse) {
                IndividualReuseStrategy.this.m_dontReuseConceptsThisRun.add((AtomicConcept)this.m_existential.getToConcept());
            }
            PermanentDependencySet permanentDependencySet = tableau.getDependencySetFactory().removeBranchingPoint(dependencySet, this.m_level);
            if (tableau.getTableauMonitor() != null) {
                tableau.getTableauMonitor().existentialExpansionStarted(this.m_existential, this.m_node);
            }
            Node node2 = tableau.createNewTreeNode(permanentDependencySet, this.m_node);
            IndividualReuseStrategy.this.m_extensionManager.addConceptAssertion(this.m_existential.getToConcept(), node2, permanentDependencySet, true);
            IndividualReuseStrategy.this.m_extensionManager.addRoleAssertion(this.m_existential.getOnRole(), this.m_node, node2, permanentDependencySet, true);
            if (tableau.getTableauMonitor() != null) {
                tableau.getTableauMonitor().existentialExpansionFinished(this.m_existential, this.m_node);
            }
        }
    }
}

