/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T>
implements Serializable {
    private static final long serialVersionUID = 5372948202031042380L;
    protected final Set<T> m_elements = new HashSet<T>();
    protected final Map<T, Set<T>> m_successorsByNodes = new HashMap<T, Set<T>>();

    public void addEdge(T t, T t2) {
        Set<T> set2 = this.m_successorsByNodes.get(t);
        if (set2 == null) {
            set2 = new HashSet<T>();
            this.m_successorsByNodes.put(t, set2);
        }
        set2.add(t2);
        this.m_elements.add(t);
        this.m_elements.add(t2);
    }

    public void addEdges(T t, Set<T> set2) {
        Set<T> set3 = this.m_successorsByNodes.get(t);
        if (set3 == null) {
            set3 = new HashSet<T>();
            this.m_successorsByNodes.put(t, set3);
        }
        set3.addAll(set2);
        this.m_elements.add(t);
        this.m_elements.addAll(set2);
    }

    public Set<T> getElements() {
        return this.m_elements;
    }

    public Set<T> getSuccessors(T t) {
        Set<T> set2 = this.m_successorsByNodes.get(t);
        if (set2 == null) {
            set2 = Collections.emptySet();
        }
        return set2;
    }

    public void transitivelyClose() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Set<T> set2 : this.m_successorsByNodes.values()) {
            arrayList.clear();
            arrayList.addAll(set2);
            while (!arrayList.isEmpty()) {
                Object e2 = arrayList.remove(arrayList.size() - 1);
                Set<T> set3 = this.m_successorsByNodes.get(e2);
                if (set3 == null) continue;
                for (T t : set3) {
                    if (!set2.add(t)) continue;
                    arrayList.add(t);
                }
            }
        }
    }

    public Graph<T> getInverse() {
        Graph<T> graph = new Graph<T>();
        for (Map.Entry<T, Set<T>> entry : this.m_successorsByNodes.entrySet()) {
            T t = entry.getKey();
            for (T t2 : entry.getValue()) {
                graph.addEdge(t2, t);
            }
        }
        return graph;
    }

    public Graph<T> clone() {
        Graph<T> graph = new Graph<T>();
        graph.m_elements.addAll(this.m_elements);
        for (Map.Entry<T, Set<T>> entry : this.m_successorsByNodes.entrySet()) {
            T t = entry.getKey();
            for (T t2 : entry.getValue()) {
                graph.addEdge(t, t2);
            }
        }
        return graph;
    }

    public void removeElements(Set<T> set2) {
        for (T t : set2) {
            this.m_elements.remove(t);
            this.m_successorsByNodes.remove(t);
        }
    }

    public boolean isReachableSuccessor(T t, T t2) {
        if (t.equals(t2)) {
            return true;
        }
        HashSet hashSet = new HashSet();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(t);
        while (!linkedList.isEmpty()) {
            Object e2 = linkedList.poll();
            Set set2 = this.getSuccessors(e2);
            if (set2.contains(t2)) {
                return true;
            }
            if (!hashSet.add(e2)) continue;
            linkedList.addAll(set2);
        }
        return false;
    }

    public Set<T> getReachableSuccessors(T t) {
        HashSet hashSet = new HashSet();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(t);
        while (!linkedList.isEmpty()) {
            Object e2 = linkedList.poll();
            if (!hashSet.add(e2)) continue;
            linkedList.addAll(this.getSuccessors(e2));
        }
        return hashSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (T t : this.m_elements) {
            stringBuffer.append(t.toString());
            stringBuffer.append(" -> { ");
            boolean bl = true;
            Set<T> set2 = this.m_successorsByNodes.get(t);
            if (set2 != null) {
                for (T t2 : set2) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(t2.toString());
                }
            }
            stringBuffer.append(" }");
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }
}

